--
-- PostgreSQL database dump
--

SET search_path = public, pg_catalog;

--
-- TOC entry 2 (OID 17023)
-- Name: tbl_item_item_id_seq; Type: SEQUENCE; Schema: public; Owner: sino
--

CREATE SEQUENCE tbl_item_item_id_seq
    START 1
    INCREMENT 1
    MAXVALUE 2147483647
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 4 (OID 17025)
-- Name: tbl_item; Type: TABLE; Schema: public; Owner: sino
--

CREATE TABLE tbl_item (
    item_id integer DEFAULT nextval('"tbl_item_item_id_seq"'::text) NOT NULL,
    item_name text,
    price integer,
    maker text,
    barcode text
);


--
-- TOC entry 5 (OID 17031)
-- Name: tbl_log; Type: TABLE; Schema: public; Owner: sino
--

CREATE TABLE tbl_log (
    kouri_id integer,
    item_id integer,
    price integer,
    num integer,
    regist_time timestamp with time zone DEFAULT now()
);


--
-- TOC entry 3 (OID 17034)
-- Name: kouri_seq; Type: SEQUENCE; Schema: public; Owner: sino
--

CREATE SEQUENCE kouri_seq
    START 1
    INCREMENT 1
    MAXVALUE 2147483647
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 6 (OID 17317)
-- Name: idx_barcode; Type: INDEX; Schema: public; Owner: sino
--

CREATE UNIQUE INDEX idx_barcode ON tbl_item USING btree (barcode);


--
-- TOC entry 7 (OID 17318)
-- Name: tbl_item_pkey; Type: CONSTRAINT; Schema: public; Owner: sino
--

ALTER TABLE ONLY tbl_item
    ADD CONSTRAINT tbl_item_pkey PRIMARY KEY (item_id);


