require 'gtk'
require 'dbi'
require 'socket'

class PosDialog < Gtk::Dialog
  def initialize
    super()
    border_width = 10
    set_position(Gtk::WIN_POS_CENTER)
    signal_connect("key_press_event") do |w,e|
      if Gdk::GDK_Escape == e.keyval then
	destroy
      end
    end
  end
  def get_item_info(id, dbh)
    sql = "select item_id, item_name, maker, barcode, price from tbl_item " +
    " where item_id = #{id}"
    sth = dbh.prepare(sql) 
    sth.execute
    sth.fetch
  end
end

class ConfigDialog < PosDialog
  def initialize(conf)
    super()
    @conf = conf
    set_title("opossum ꥦɥ")
    table = Gtk::Table.new(2, 5, false)
    table.set_col_spacings 10
    table.set_row_spacings 10
    vbox.border_width = 10
    vbox.add table
    label1 = Gtk::Label.new("posmaster.rb ưƤۥ:")
    label1.set_alignment(1, 0.5)
    hbox = Gtk::HBox.new(false, 10)
    
    entry_arr = []
    entry = Gtk::Entry.new
    entry.set_text(conf['posmasterhost'])
    entry_arr.push entry
    label2 = Gtk::Label.new("Port:")
    label2.set_alignment(1, 0.5)
    entry2 = Gtk::Entry.new
    size = entry2.size_request.to_s
    size.gsub!(/[\(\) ]/, '')
    w, h = size.split(/\,/).collect do |i| i.to_i end
    entry2.set_usize(60, h)
    entry2.set_text(conf['port'])
    entry_arr.push entry2
    hbox.add entry
    hbox.add label2
    hbox.add entry2
    table.attach(label1, 0, 1, 0, 1)
    table.attach(hbox,   1, 2, 0, 1)
    label1 = Gtk::Label.new("DBI DRIVER :")
    label1.set_alignment(1, 0.5)
    entry = Gtk::Entry.new
    entry.set_text(conf['dbidriver'])
    entry_arr.push entry
    table.attach(label1,  0, 1, 1, 2)
    table.attach(entry,   1, 2, 1, 2)
    label1 = Gtk::Label.new("DB 桼̾ :")
    label1.set_alignment(1, 0.5)
    entry = Gtk::Entry.new
    entry.set_text(conf['dbiuser'])
    entry_arr.push entry
    table.attach(label1,  0, 1, 2, 3)
    table.attach(entry,   1, 2, 2, 3)
    label1 = Gtk::Label.new("DB ѥ :")
    label1.set_alignment(1, 0.5)
    entry = Gtk::Entry.new
    entry.set_text(conf['dbipass'])
    entry_arr.push entry
    table.attach(label1,  0, 1, 3, 4)
    table.attach(entry,   1, 2, 3, 4)
    button_ok     = Gtk::Button.new(" OK ")
    button_cancel = Gtk::Button.new(" 󥻥 ")
    action_area.add button_ok
    action_area.add button_cancel
    button_cancel.signal_connect('clicked') do
      destroy
    end
    button_ok.signal_connect('clicked') do
      opt_arr = entry_arr.collect do |e| e.get_text end
      conf.write(opt_arr)
      destroy
    end
    show_all
  end
end

class DeleteItemDialog < PosDialog
  def initialize(id, dbh, sock, search_win)
    super()
    set_title("ǧ")
    set_modal(true)
    table = Gtk::Table.new(2, 5, false)
    vbox.border_width = 10
    label1 = Gtk::Label.new("ʲξʤޤ\nǤ?")
    vbox.pack_start(label1, true, true, 0)
    vbox.pack_start(table, true, true, 0)
    item_id, item_name, maker,  barcode, price = get_item_info(id, dbh)
    
    label1 = Gtk::Label.new("ID")
    label1.set_alignment(1, 0.5)
    label2 = Gtk::Label.new(item_id.to_s)
    label2.set_alignment(0, 0.5)
    table.attach(label1, 0, 1, 0, 1)
    table.attach(label2, 1, 2, 0, 1)
    
    label1 = Gtk::Label.new("̾")
    label1.set_alignment(1, 0.5)
    label2 = Gtk::Label.new(item_name)
    label2.set_alignment(0, 0.5)
    table.attach(label1, 0, 1, 1, 2)
    table.attach(label2, 1, 2, 1, 2)
    
    label1 = Gtk::Label.new("᡼")
    label1.set_alignment(1, 0.5)
    label2 = Gtk::Label.new(maker)
    label2.set_alignment(0, 0.5)
    table.attach(label1, 0, 1, 2, 3)
    table.attach(label2, 1, 2, 2, 3)
    
    label1 = Gtk::Label.new("Сɡ")
    label1.set_alignment(1, 0.5)
    label2 = Gtk::Label.new(barcode)
    label2.set_alignment(0, 0.5)
    table.attach(label1, 0, 1, 3, 4)
    table.attach(label2, 1, 2, 3, 4)

    label1 = Gtk::Label.new("ʡ")
    label1.set_alignment(1, 0.5)
    label2 = Gtk::Label.new(price.to_s + " ")
    label2.set_alignment(0, 0.5)
    table.attach(label1, 0, 1, 4, 5)
    table.attach(label2, 1, 2, 4, 5)
    ok_button = Gtk::Button.new("OK")
    ok_button.signal_connect("clicked") do
      packet = Packet.new(sock, "delete_item", id)
      packet.send
      $item_list_updated = false
      while $item_list_updated != true do
      end
      $item_list_updated = false
      search_win.update_item_list
      destroy
    end
    cancel_button = Gtk::Button.new(" 󥻥 ")
    cancel_button.signal_connect("clicked") do
      destroy
    end
    action_area.pack_start(ok_button)
    action_area.pack_start(cancel_button)
    self.show_all
  end
end

class EditItemDialog < PosDialog
  def initialize(id, dbh, sock, search_win)
    super()
#    p get_item_info(id, dbh)
    set_title("ʥǡԽ")
    set_modal(true)
    table = Gtk::Table.new(2, 5, false)
    vbox.border_width = 10
    label1 = Gtk::Label.new("ʥǡԽ OK ܥ򲡤Ƥ")
    vbox.pack_start(label1, true, true, 0)
    vbox.pack_start(table, true, true, 0)
    item_id, item_name, maker,  barcode, price = get_item_info(id, dbh)
    entry_arr = []
    label1 = Gtk::Label.new("ID")
    label1.set_alignment(1, 0.5)
    entry2 = Gtk::Entry.new()
    entry2.set_text(item_id.to_s)
    entry2.set_editable(false)
    entry_arr.push entry2
    table.attach(label1, 0, 1, 0, 1)
    table.attach(entry2, 1, 2, 0, 1)
    
    label1 = Gtk::Label.new("̾")
    label1.set_alignment(1, 0.5)
    entry2 = Gtk::Entry.new()
    entry2.set_text(item_name.to_s)
    entry_arr.push entry2
    table.attach(label1, 0, 1, 1, 2)
    table.attach(entry2, 1, 2, 1, 2)
    
    label1 = Gtk::Label.new("᡼")
    label1.set_alignment(1, 0.5)
    entry2 = Gtk::Entry.new()
    entry2.set_text(maker.to_s)
    entry_arr.push entry2
    table.attach(label1, 0, 1, 2, 3)
    table.attach(entry2, 1, 2, 2, 3)
    
    label1 = Gtk::Label.new("Сɡ")
    label1.set_alignment(1, 0.5)
    entry2 = Gtk::Entry.new()
    entry2.set_text(barcode.to_s)
    entry_arr.push entry2
    table.attach(label1, 0, 1, 3, 4)
    table.attach(entry2, 1, 2, 3, 4)

    label1 = Gtk::Label.new("ʡ")
    label1.set_alignment(1, 0.5)
    hbox = Gtk::HBox.new
    entry2 = Gtk::Entry.new()
    size = entry2.size_request.to_s
    size.gsub!(/[\(\) ]/, '')
    w, h = size.split(/\,/).collect do |i| i.to_i end
    entry2.set_usize(60, h)
    entry2.set_text(price.to_s)
    entry_arr.push entry2
    hbox.add entry2
    label_yen = Gtk::Label.new("")
    label_yen.set_alignment(0, 0.5)
    hbox.add label_yen
    
    table.attach(label1, 0, 1, 4, 5)
    table.attach(hbox, 1, 2, 4, 5)
    ok_button = Gtk::Button.new("OK")
    ok_button.signal_connect("clicked") do
      arr = entry_arr.collect{|i| i.get_text}
      packet = Packet.new(sock, "update_item", *arr)
      packet.send
      $item_list_updated = false
      while $item_list_updated != true do
      end
      $item_list_updated = false
      search_win.update_item_list
      destroy
    end
    cancel_button = Gtk::Button.new(" 󥻥 ")
    cancel_button.signal_connect("clicked") do
      destroy
    end
    action_area.pack_start(ok_button)
    action_area.pack_start(cancel_button)
    self.show_all
  end
end

class SearchItemWin < Gtk::Window
  def initialize(dbh, sock)
    super()
    @dbh = dbh
    set_title("ʸɥ")
    set_modal(true)
    set_default_size(500, 300)
    vbox = Gtk::VBox.new(false, 10)
    vbox.border_width = 10    
    add vbox
    hbox = Gtk::HBox.new(false, 5)
    vbox.pack_start(hbox, false)
    item_name_label = Gtk::Label.new("̾:")
    hbox.pack_start(item_name_label, false)
    item_name_entry = Gtk::Entry.new
    hbox.pack_start(item_name_entry, false)
    barcode_label = Gtk::Label.new("С:")
    hbox.pack_start(barcode_label, false)
    barcode_entry = Gtk::Entry.new
    barcode_entry.signal_connect('activate')do |w|
      buff = w.get_text
      buff.gsub!(/^[dD]/, '')
      w.set_text(buff)
    end
    hbox.pack_start(barcode_entry, false)
    price_label = Gtk::Label.new(":")
    hbox.pack_start(price_label, false)
    price_entry = Gtk::Entry.new
    size = price_entry.size_request.to_s
    size.gsub!(/[\(\) ]/, '')
    w, h = size.split(/\,/).collect do |i| i.to_i end
    price_entry.set_usize(50, h)
    hbox.pack_start(price_entry, false)
    
    @search_button = Gtk::Button.new("  ")
    size = @search_button.size_request.to_s
    size.gsub!(/[\(\) ]/, '')
    w, h = size.split(/\,/).collect do |i| i.to_i end
    @search_button.set_usize(60, h)
    hbox.pack_start(@search_button, true)
    item_list = Gtk::CList.new(["ID",  "̾", "᡼", "С", "ñ"])
    @item_list = item_list
    item_list.set_column_justification(0, Gtk::JUSTIFY_RIGHT)
    item_list.set_column_justification(4, Gtk::JUSTIFY_RIGHT)
    item_list.set_column_width(0, 50);
    item_list.set_column_width(1, 200);
    item_list.set_column_width(2, 100);
    item_list.set_column_width(3, 100);
    item_list.set_column_width(4, 30);
    scrolled_win = Gtk::ScrolledWindow.new()
    scrolled_win.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_ALWAYS)
    scrolled_win.add(item_list)
    vbox.pack_start(scrolled_win, true)
#    accel = Gtk::AccelGroup.new
#    accel.attach(self)
    edit_call = Proc.new do |id|  EditItemDialog.new(id, dbh, sock, self) end
    delete_call = Proc.new do |id| DeleteItemDialog.new(id, dbh, sock, self)  end
    item_list.set_selection_mode(Gtk::SELECTION_SINGLE)
    item_list.signal_connect('button_press_event') do |w,e|
      if e.button == 3
	selected_id = nil
	item_list.each_selection do |selected_row|
	  selected_id = item_list.get_text(selected_row, 0)
	end
	ifp = Gtk::ItemFactory.new(Gtk::ItemFactory::TYPE_MENU, "<main>", nil)
	ifp.create_items(
	  [["/ʤ", nil, Gtk::ItemFactory::ITEM, edit_call, selected_id],
	   ["/ʤ", nil, Gtk::ItemFactory::ITEM, delete_call, selected_id]])
	menu = ifp.get_widget("<main>")
	menu.popup(nil, nil, nil, e.button, e.time)
      end
    end
    @search_button.signal_connect('clicked') do |w|
      item_list.clear
      sql = "select item_id, item_name, maker, barcode, price from tbl_item "
      item_name_text = item_name_entry.get_text
      barcode_text = barcode_entry.get_text
      price_text = price_entry.get_text
      if ((item_name_text + barcode_text + price_text).length > 0) then
	sql += " where "
	where_clause = []
	if item_name_text.length > 0 then
	  where_clause.push "item_name like '%#{item_name_text}%'"
	end
	if barcode_text.length > 0 then
	  where_clause.push "barcode = '#{barcode_text}'"
	end
	if price_text.length > 0 then
	  where_clause.push "price = #{price_text}"
	end
	sql += where_clause.join(" and ")
	sql += " order by item_id "
      end
      @sql = sql
      update_item_list
    end
    close_button = Gtk::Button.new("Ĥ")
    close_button.signal_connect('clicked') do |w|
      destroy
    end
    vbox.pack_start(close_button, false)
    self.show_all
  end
  def update_item_list
    sth = @dbh.prepare(@sql)
    sth.execute
    @item_list.clear
    while row = sth.fetch do
      arr = row.collect do |i| "#{i}" end
      # puts row
      # p arr
      @item_list.append arr
    end
  end
end

class NewItemDialog < PosDialog
  def initialize(keydecoder)
    super()
    vbox.border_width = 10
    @register = keydecoder.register
    set_title("")
    set_modal(true)
    table = Gtk::Table.new(2, 4, false)
    vbox.border_width = 10
    label1 = Gtk::Label.new("ʥǡϤOK ܥ򲡤Ƥ")
    vbox.pack_start(label1, true, true, 0)
    vbox.pack_start(table, true, true, 0)
    barcode_label = Gtk::Label.new("Сɡ")
    barcode_label.set_alignment(1, 0.5)
    barcode_ent   = Gtk::Entry.new()
    barcode_ent.signal_connect('activate') do |w|
      buff = w.get_text
      buff.gsub!(/^[dD]/, '')
      w.set_text(buff)
    end
    
    itemname_label = Gtk::Label.new("̾")
    itemname_label.set_alignment(1, 0.5)
    itemname_ent   = Gtk::Entry.new()
    price_label = Gtk::Label.new("ñ")
    price_label.set_alignment(1, 0.5)
    price_ent   = Gtk::Entry.new()

    maker_label = Gtk::Label.new("᡼")
    maker_label.set_alignment(1, 0.5)
    maker_ent   = Gtk::Entry.new()
    table.attach(barcode_label , 0, 1, 0, 1)
    table.attach(barcode_ent   , 1, 2, 0, 1)
    table.attach(itemname_label, 0, 1, 1, 2)
    table.attach(itemname_ent,   1, 2, 1, 2)
    table.attach(price_label,    0, 1, 2, 3)
    table.attach(price_ent  ,    1, 2, 2, 3)
    table.attach(maker_label,    0, 1, 3, 4)
    table.attach(maker_ent  ,    1, 2, 3, 4)
    table.set_row_spacings 10
    table.set_col_spacings 10
    
    ok_button     = Gtk::Button.new("OK")
    ok_button.signal_connect("clicked") do
      @register.insert_item(itemname_ent.get_text, price_ent.get_text, 
			    barcode_ent.get_text, maker_ent.get_text)
      destroy
    end
    cancel_button = Gtk::Button.new("󥻥")
    cancel_button.signal_connect("clicked") do
      destroy
    end
    action_area.pack_start(ok_button)
    action_area.pack_start(cancel_button)
    self.show_all
  end
end

class NumberDialog < PosDialog
  def initialize(title, poswin, register)
    super()
    set_title(title)
    set_modal(true)
    label_setumei = Gtk::Label.new("ĿϤƤ")
    vbox.add(label_setumei)
    num_ent = Gtk::Entry.new
    vbox.add(num_ent)
    
    set_focus(num_ent)
    num_ent.signal_connect('activate') do |w|
      num = num_ent.get_text.to_i
      register.update_last_num(poswin, num)
      destroy
    end
    self.show_all
  end
end


class PaymentDialog < PosDialog
  def initialize(title, poswin, register)
    super()
    set_title(title)
    set_modal(true)
    label_setumei = Gtk::Label.new("¤ۤϤƤ")
    vbox.add(label_setumei)
    depo_ent = Gtk::Entry.new
    vbox.add(depo_ent)
    
    set_focus(depo_ent)
    depo_ent.signal_connect('activate') do |w|
      poswin.update_depo(depo_ent.get_text.to_i)
      #	register.update_last_num(poswin, num)
      destroy
    end
    self.show_all
  end
end

class UnknownDialog < PosDialog
  def initialize(title, poswin, register)
    super()
    set_title(title)
    set_modal(true)
    label_setumei = Gtk::Label.new("̤ϿʤǤ\nۤϤƤ")
    vbox.add(label_setumei)
    price_ent = Gtk::Entry.new
    vbox.add(price_ent)
    
    set_focus(price_ent)
    price_ent.signal_connect('activate') do |w|
      register.item_name_stack.push("̤Ͽ")
      register.num_stack.push(1)
      register.price_stack.push(price_ent.get_text.to_i)
      register.item_id_stack.push(nil)
      register.sum_stack.push(price_ent.get_text.to_i)
      poswin.update_sum(register.sum_up)
      poswin.add_row("̤Ͽ", price_ent.get_text.to_i, 1, price_ent.get_text.to_i)
      #	poswin.update_depo(depo_ent.get_text.to_i)
      #	register.update_last_num(poswin, num)
      destroy
    end
    self.show_all
  end
end


class Register
  attr_accessor :sum_stack, :item_name_stack, :num_stack, :price_stack, :item_id_stack, :sock, :dbh
  def initialize(conf)
    @sum_stack       = []
    @item_name_stack = []
    @num_stack       = []
    @price_stack     = []
    @item_id_stack   = []
    @conf = conf
    @dbh = DBI.connect(conf['dbidriver'], conf['dbiuser'], conf['dbipass'])
    begin
      connect_posmaster
=begin      
      s = TCPSocket.open(conf['posmasterhost'], conf['port'])
      @sock = s
      #    dbh = DBI.connect('DBI:Pg:pos', 'sino', '')
      @thread = Thread.start(s, @dbh) do |sock, dbh|
	PacketListener.new(sock, dbh)
      end
=end      
    rescue
      @connection = false
    end
  end
  def connect_posmaster
    @thread.exit if @thread 
    s = TCPSocket.open(@conf['posmasterhost'], @conf['port'].to_i)
    @sock = s
    #    dbh = DBI.connect('DBI:Pg:pos', 'sino', '')
    @thread = Thread.start(s, @dbh) do |sock, dbh|
      listener = PacketListener.new(sock, dbh)
    end
  end
  def add_item(poswin, barcode)
    sth = @dbh.prepare("select item_id, item_name, price from tbl_item " +
		       " where barcode = '#{barcode}'")
    sth.execute
    row = sth.fetch
    if row then
      @item_id_stack.push(row[0])
      @item_name_stack.push(row[1])
      @num_stack.push(1)
      @price_stack.push(row[2].to_i)
      @sum_stack.push(row[2].to_i)
      poswin.add_row(row[1], row[2], 1, row[2].to_i * 1)
      poswin.update_sum(sum_up)
    else
      unknown_dialog = UnknownDialog.new("̤Ͽʲ", poswin, self)
    end
  end
  def sum_up
    sum = 0
    @sum_stack.each do |price|
      sum += price
    end
    sum
  end
  def update_last_num(poswin, num)
    num = num.to_i
    item  = @item_name_stack.pop
    price = @price_stack.pop.to_i
    @num_stack.pop
    @sum_stack.pop
    subtotal = price * num
    poswin.update_last(item, price, num, subtotal)
    @item_name_stack.push item
    @sum_stack.push subtotal
    @price_stack.push price
    @num_stack.push num
    poswin.update_sum(sum_up)
  end
  def insert_log
    sth = @dbh.prepare("select nextval('kouri_seq')")
    sth.execute
    kouri_id = (sth.fetch)[0]
    for i in 0 ... @item_id_stack.length do
      @dbh.do("begin")
      sql = "insert into tbl_log(kouri_id, item_id, price, num) " +
	    "values (?, ?, ?, ?) "
      @dbh.do(sql, kouri_id, @item_id_stack[i], @price_stack[i], @num_stack[i])
      @dbh.do("end")
    end
  end
  def clear_all
    @item_id_stack = []
    @sum_stack       = []
    @item_name_stack = []
    @num_stack       = []
    @price_stack     = []
  end
  def insert_item(item_name, price, barcode, maker)
    packet = Packet.new(@sock, "insert_item", item_name, price, barcode, maker)
    packet.send
  end
end

class Keydecoder
  attr_reader :register
  def initialize(register)
    @register = register
#    @item_list = item_list
    @barcode_reading = false
    @fix_payment = false
    @buff = ''
  end
  def get_char(poswin, event)
    c = event.keyval
    case c
    when Gdk::GDK_d, Gdk::GDK_D
      @barcode_reading = true
    when Gdk::GDK_asterisk, Gdk::GDK_KP_Multiply
      input_win = NumberDialog.new("Ŀ", poswin, @register)
    when Gdk::GDK_space
      if @fix_payment == false then
        input_win = PaymentDialog.new("¤", poswin, @register)
	@register.insert_log
	@fix_payment = true
      end
    when Gdk::GDK_Escape
	@register.clear_all
	poswin.clear_all
	@fix_payment = false
    else
      if @barcode_reading then
	if c == Gdk::GDK_Return and @buff.length > 0 then
	  @register.add_item(poswin, @buff)
	  @barcode_reading = false
	  @buff = ''
	else
	  @buff +=event.string
	end
      end
    end
  end
end

class PosConfig
  def initialize(file_name)
    @file_name = file_name
    file = File.new(file_name)
    @doc = REXML::Document.new file
    file.close
  end
  def [](opt)
    str = @doc.elements["/config/#{opt}"].text
    (str ? str : '')
  end
  def write(opt_arr)
    count = 0
    @doc.elements.each("/config/*") do |e|
      e.text = opt_arr[count]
      count += 1
    end
    file = File.open(@file_name, "w")
    @doc.write file
    file.close
  end
end
