using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using Microsoft.Win32;
using System.Data.Common;
using System.Configuration;
using System.Threading;

namespace Oratorio
{
	public partial class ConnectListForm : Form
	{
		protected ConnectSettingStore _settings = new ConnectSettingStore();

        private DatabaseContextCommon _database;

        public DatabaseContextCommon Database
        {
            get { return _database; }
            set { _database = value; }
        }


		public ConnectListForm()
		{
			InitializeComponent();
		}

		private void ConnectListForm_Load(object sender, EventArgs e)
		{
			Control[] children = 
			{
                this,
				_newButton,
				_editButton,
				_deleteButton,
				_settingNameLabel,
				_userIdLabel,
				_passwordLabel,
				_donotSaveCertCheck,
				_loginButton,
				_cancelButton,
			};
			ProgramUtility.LoadControlStringsFromResource(children, GetType().FullName);
            _nameColumn.Text = ProgramUtility.LoadStringsFromResource(GetType(), "_nameColumn", _nameColumn.Text);
//			_settingList.Columns.Add("Name", 200);
			if (File.Exists(_settings.SettingPath))
			{
				_settings.Load();
				for (int index = 0; index < _settings.Count; index++)
				{
					ConnectSettingData data = _settings[index];
					ListViewItem viewItem = _settingList.Items.Add(data.SettingName);
					viewItem.Tag = data;
				}
			}
            int latestIndex = Properties.Settings.Default.LatestSettingIndex;
            if (_settingList.Items.Count > latestIndex)
            {
                _settingList.SelectedIndices.Add(latestIndex);
            }
            RefreshButtonEnable();
        }

		private void _newButton_Click(object sender, EventArgs e)
		{
			ConnectDetailForm form = new ConnectDetailForm();
			if (form.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}
            ConnectSettingData data = form.Setting;
            ListViewItem viewItem = _settingList.Items.Add(data.SettingName);
            viewItem.Tag = data;

            _settings.Add(data);
            _settings.Save();
            _settingList.SelectedItems.Clear();
            viewItem.Selected = true;
        }

		private void _editButton_Click(object sender, EventArgs e)
		{
			if(_settingList.SelectedIndices.Count != 1)
			{
				return;
			}
			ConnectDetailForm form = new ConnectDetailForm();
			form.Setting = (ConnectSettingData)_settingList.SelectedItems[0].Tag;
            form.Setting = new ConnectSettingData(form.Setting);
			if (form.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}
            ListViewItem viewItem = _settingList.SelectedItems[0];
			viewItem.Tag = form.Setting;
			viewItem.Text = form.Setting.SettingName;
            _settings[_settingList.SelectedIndices[0]] = form.Setting;
            _settings.Save();

            _settingList.SelectedItems.Clear();
            viewItem.Selected = true;
        }

		private void _settingList_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left)
			{
//				_editButton_Click(sender, e);
                _loginButton_Click(sender, e);
			}
		}

        private void _settingList_SelectedIndexChanged(object sender, EventArgs e)
        {
            RefreshButtonEnable();
        }

        protected void RefreshButtonEnable()
        {
			if (_connectThread != null)
			{
				_loginButton.Enabled = false;
				_deleteButton.Enabled = false;
				_editButton.Enabled = false;
				_newButton.Enabled = false;
				return;
			}
			_newButton.Enabled = true;
			_loginButton.Enabled = (_settingList.SelectedIndices.Count == 1);
            _deleteButton.Enabled = (_settingList.SelectedIndices.Count >= 1);
            _editButton.Enabled = (_settingList.SelectedIndices.Count == 1);
            if (_settingList.SelectedIndices.Count == 1)
            {
                _donotSaveCertCheck.Enabled = true;
                ConnectSettingData settingData = (ConnectSettingData)_settingList.SelectedItems[0].Tag;
                if (settingData.IsUnsaveCert())
                {
                    settingData.Uid = "";
                    settingData.Pwd = "";
//                    _userIdText.Enabled = false;
//                    _passwordText.Enabled = false;
                }
                else
                {
                    _userIdText.Enabled = true;
                    _passwordText.Enabled = true;
                }
                _userIdText.Enabled = true;
                _passwordText.Enabled = true;
                _userIdText.Text = settingData.Uid;
                _passwordText.Text = settingData.Pwd;
                _donotSaveCertCheck.Checked = settingData.IsUnsaveCert();
                _settingName.Text = settingData.SettingName;
            }
            else
            {
                _userIdText.Enabled = false;
                _passwordText.Enabled = false;
                _donotSaveCertCheck.Enabled = false;
                _userIdText.Text = "";
                _passwordText.Text = "";
                _donotSaveCertCheck.Checked = false;
                _settingName.Text = "";
            }
        }

		protected delegate void ConnectResultDelegate(Exception ex);

		protected ConnectSettingData _trySettingData;
		protected string _tryConnectString;
		protected ConnectResultDelegate _connectSuccessDelegate;
		protected ConnectResultDelegate _connectFailDelegate;

		protected void _connectThread_ConnectSuccess(Exception ex)
		{
			DialogResult = DialogResult.OK;
			Close();
		}

		protected void _connectThread_ConnectFail(Exception ex)
		{
//			_loginButton.Enabled = true;
			_connectThread = null;
			ProgramUtility.ShowError(this, "Database Connect failed.", ex);
			RefreshButtonEnable();
		}

		private void _connectThread_Start()
		{
			try
			{
				if (_trySettingData.SettingMethod == ConnectSettingData.METHOD_ODBC_GENERAL)
				{
					DatabaseContextOdbc database = DatabaseContextOdbc.Connect(_tryConnectString);
					_database = database;
				}
				else if (_trySettingData.SettingMethod == ConnectSettingData.METHOD_ODBC_ORACLE)
				{
					DatabaseContextOdbc database = DatabaseContextOdbc.Connect(_tryConnectString);
					_database = database;
				}
                else if (_trySettingData.SettingMethod == ConnectSettingData.METHOD_ODBC_SQL_SERVER)
                {
                    DatabaseContextOdbc database = DatabaseContextOdbc.Connect(_tryConnectString);
                    _database = database;
                }
                else if (_trySettingData.SettingMethod == ConnectSettingData.METHOD_ODBC_MY_SQL)
                {
                    DatabaseContextOdbc database = DatabaseContextOdbc.Connect(_tryConnectString);
                    _database = database;
                }
                else
				{
					System.Diagnostics.Debug.Assert(false);
					throw new NotSupportedException();
				}
				this.Invoke(_connectSuccessDelegate, new object[] { null });
			}
			catch (DatabaseContextException pe)
			{
//				ProgramUtility.ShowError(this, "Database Connect failed.", pe);
				if (this.Visible)
				{
					this.Invoke(_connectFailDelegate, new object[] { pe });
				}
			}
		}

		private Thread _connectThread;

		private void _loginButton_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Debug.Assert(_settingList.SelectedItems.Count == 1);

            ConnectSettingData settingData = (ConnectSettingData)_settingList.SelectedItems[0].Tag;
            settingData.Uid = _userIdText.Text;
            settingData.Pwd = _passwordText.Text;
			settingData.SettingUnsaveCert = (_donotSaveCertCheck.Checked ? "1" : "0");
            string connectString = "";
            if (settingData.Driver.Length > 0)
            {
                connectString += "DRIVER={" + settingData.Driver + "};";
            }

            DbConnectionStringBuilder connStrBuilder = new DbConnectionStringBuilder();
            foreach (KeyValuePair<string, string> keyValue in settingData)
            {
                if (keyValue.Key.StartsWith(ConnectSettingData.SUFFIX_KEY_SETTING))
                {
                    continue;
                }
                if (keyValue.Key.Equals("DRIVER", StringComparison.OrdinalIgnoreCase))
                {
                    continue;
                }
                if (keyValue.Value.Length == 0)
                {
                    continue;
                }
                connStrBuilder.Add(keyValue.Key.ToUpper(), keyValue.Value);
            }

            connectString += connStrBuilder.ToString();
            if (settingData.SettingOptions.Length > 0)
            {
                if (connectString.Length > 0)
                {
                    connectString += ";";
                }
                connectString += settingData.SettingOptions;
            }
            if (connectString.Length == 0)
            {
                MessageBox.Show(this, "Setting option not inputed.");
                return;
            }

            if (settingData.SettingMethod == ConnectSettingData.METHOD_ODBC_GENERAL)
            {
            }
            else if (settingData.SettingMethod == ConnectSettingData.METHOD_ODBC_ORACLE)
            {
            }
            else if (settingData.SettingMethod == ConnectSettingData.METHOD_ODBC_SQL_SERVER)
            {
            }
            else if (settingData.SettingMethod == ConnectSettingData.METHOD_ODBC_MY_SQL)
            {
            }
            else
            {
                ProgramUtility.ShowError("Connect method not supported.");
                return;
            }

            //save connect setting index
            int currentIndex = _settingList.SelectedIndices[0];
            _settings[currentIndex] = settingData;
            _settings.Save();

            //save setting index
            Properties.Settings.Default.LatestSettingIndex = currentIndex;
            try
            {
                Properties.Settings.Default.Save();
            }
            catch (ConfigurationException ce)
            {
                ProgramUtility.ShowError(ce);
                return;
            }

			_trySettingData = settingData;
			_tryConnectString = connectString;

			_loginButton.Enabled = false;

			if (_connectSuccessDelegate == null)
			{
				_connectSuccessDelegate += _connectThread_ConnectSuccess;
			}
			if (_connectFailDelegate == null)
			{
				_connectFailDelegate += _connectThread_ConnectFail;
			}

            
            _connectThread = new Thread(_connectThread_Start);
			RefreshButtonEnable();
			_connectThread.Start();
/*
			try
            {
                _loginButton.Enabled = false;
                if (settingData.SettingMethod == ConnectSettingData.METHOD_ODBC_GENERAL)
                {
                    DatabaseContextOdbc database = DatabaseContextOdbc.Connect(connectString);
                    _database = database;
                }
                else if (settingData.SettingMethod == ConnectSettingData.METHOD_ODBC_ORACLE)
                {
                    DatabaseContextOdbc database = DatabaseContextOdbc.Connect(connectString);
                    _database = database;
                }
                else
                {
                    System.Diagnostics.Debug.Assert(false);
                    throw new NotSupportedException();
                }
 
            }
            catch (DatabaseContextException pe)
            {
                ProgramUtility.ShowError(pe);
                return;
            }
            finally
            {
                _loginButton.Enabled = true;
            }

            DialogResult = DialogResult.OK;
            Close();
 */
        }

        private void _deleteButton_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show(this, "Delete setting?", Application.ProductName, MessageBoxButtons.YesNo) != DialogResult.Yes)
            {
                return;
            }
            List<int> indexList = new List<int>();
            foreach (int index in _settingList.SelectedIndices)
            {
                indexList.Add(index);
            }
            for (int num = indexList.Count - 1; num >= 0; num--)
            {
                _settingList.Items.RemoveAt(indexList[num]);
                _settings.RemoveAt(indexList[num]);
            }
            _settings.Save();
        }

		private void _cancelButton_Click(object sender, EventArgs e)
		{
			DialogResult = DialogResult.Cancel;
			Close();
			//if (_connectThread != null)
			//{
			//    _connectThread.Abort();
			//}
		}
    }
}