using System;
using System.Collections.Generic;
using System.Text;

namespace Oratorio
{
    public class ConnectSettingData : Dictionary<string, string>
    {
        public enum ConnectTypes
        {
            OdbcGeneral,
            OdbcOracle,
            //OracleProvider,
            //Oracle9,
            //SqlServer2005,
        }

        public const string SUFFIX_KEY_SETTING = "__setting";

        public const string KEY_SETTING_NAME = "__setting_name";
        public const string KEY_SETTING_METHOD = "__setting_method";
        public const string KEY_SETTING_UNSAVE_CERT = "__setting_unsave_cert";
        public const string KEY_SETTING_OPTIONS = "__setting_options";

        public const string KEY_UID = "uid";
        public const string KEY_PWD = "pwd";
        public const string KEY_DRIVER = "driver";
        public const string KEY_DATABASE = "database";
        public const string KEY_SERVER = "server";
        public const string KEY_DBQ = "dbq";
        public const string KEY_DSN = "dsn";
        public const string KEY_PORT = "port";

        public const string METHOD_ODBC_GENERAL = "ODBC(General)";
        public const string METHOD_ODBC_ORACLE = "ODBC(Oracle)";
        public const string METHOD_ODBC_SQL_SERVER = "ODBC(SQL Server)";
        public const string METHOD_ODBC_MY_SQL = "ODBC(MySQL)";

        public static string[] GetKeyArray()
        {
            string[] keys = {
                KEY_SETTING_NAME,
                KEY_SETTING_METHOD,
                KEY_SETTING_OPTIONS,
                KEY_SETTING_UNSAVE_CERT,
                KEY_UID,
                KEY_PWD,
                KEY_DRIVER,
                KEY_DATABASE,
                KEY_SERVER,
                KEY_DBQ,
                KEY_DSN,
                KEY_PORT,
            };
            return keys;
        }

        public ConnectSettingData()
        {
            string[] list = GetKeyArray();
            foreach (string key in Keys)
            {
                Add(key, "");
            }
        }

        public ConnectSettingData(ConnectSettingData source)
        {
            string[] list = GetKeyArray();
            foreach (string key in Keys)
            {
                Add(key, "");
            }

            foreach (KeyValuePair<string, string> item in source)
            {
                this[item.Key] = item.Value;
            }
        }

        public String Get(string key)
        {
            if(!ContainsKey(key))
            {
                return "";
            }
            string value = this[key];
            if (value == null)
            {
                value = "";
            }
            return value;
        }

        public string SettingName
        {
            get { return Get(KEY_SETTING_NAME); }
            set { this[KEY_SETTING_NAME] = value; }
        }
        public string SettingMethod
        {
            get { return Get(KEY_SETTING_METHOD); }
            set { this[KEY_SETTING_METHOD] = value; }
        }
        public string SettingUnsaveCert
        {
            get { return Get(KEY_SETTING_UNSAVE_CERT); }
            set { this[KEY_SETTING_UNSAVE_CERT] = value; }
        }
        public string SettingOptions
        {
            get { return Get(KEY_SETTING_OPTIONS); }
            set { this[KEY_SETTING_OPTIONS] = value; }
        }

        public string Uid
        {
            get { return Get(KEY_UID); }
            set { this[KEY_UID] = value; }
        }

        public string Pwd
        {
            get { return Get(KEY_PWD); }
            set { this[KEY_PWD] = value; }
        }

        public string Driver
        {
            get { return Get(KEY_DRIVER); }
            set { this[KEY_DRIVER] = value; }
        }

        public string Database
        {
            get { return Get(KEY_DATABASE); }
            set { this[KEY_DATABASE] = value; }
        }

        public string Server
        {
            get { return Get(KEY_SERVER); }
            set { this[KEY_SERVER] = value; }
        }

        public string Dbq
        {
            get { return Get(KEY_DBQ); }
            set { this[KEY_DBQ] = value; }
        }
        public string Dsn
        {
            get { return Get(KEY_DSN); }
            set { this[KEY_DSN] = value; }
        }
        public string Port
        {
            get { return Get(KEY_PORT); }
            set { this[KEY_PORT] = value; }
        }
        public static bool IsUnsaveCert(string unsave)
        {
            return (unsave != null && unsave.Length > 0 && unsave != "0" && unsave != "false");
        }
        public bool IsUnsaveCert()
        {
            return IsUnsaveCert(Get(KEY_SETTING_UNSAVE_CERT));
        }
        public override string ToString()
        {
            return SettingName;
        }
    }
}
