using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;

namespace Oratorio
{
    public interface DatabaseContext : IDisposable
    {
        DatabaseScriptGenerator ScriptGenerator
        {
            get;
        }

        int ProductTypeNumber
        {
            get;
        }

        bool Connected
        {
            get;
        }

        DbProviderFactory Factory
        {
            get;
        }

        DbConnection Connection
        {
            get;
        }

        string CurrentSchemaName
        {
            get;
        }

        string CurrentCatalogName
        {
            get;
        }

        string ProductName
        {
            get;
        }

        void Close();

        string[] GetSchemaList();

        string GetCurrentSchema();

        DbDataAdapter CreateDataAdapter();

        DbCommand CreateCommand(string sql);

        DbCommandBuilder CreateCommandBuilder();

        DbParameter CreateParameter(string name, object value);

        string[] GetTableList(string catalog, string schema);

        string[] GetViewList(string catalog, string schema);

        DatabaseObjectIndex[] GetIndexList(string catalogFilter, string schemaFilter, string objectFilter);

        void GetTableColumnList(string catalog, string schema, string tableName, List<DatabaseColumn> list);

        string[] GetProcedureList(string catalog, string schema);
    }
}
