using System;
using System.Collections.Generic;
using System.Text;

using System.Data;
using System.Data.Odbc;
using System.Data.Common;

namespace Oratorio
{
	public class DatabaseContextOdbcPostgreSql : DatabaseContextOdbc
	{
        public override string ProductName
        {
            get { return "PostgreSQL"; }
        }
        
        public DatabaseContextOdbcPostgreSql(OdbcConnection connection)
            : base(connection)
        {
            _productType = ProductTypes.Postgres;
            _connection = connection;
        }
		public override string GetCurrentSchema()
		{
			string query = "select current_schema()";
			using (DbDataReader reader = CreateCommand(query).ExecuteReader())
			{
				if (!reader.Read())
				{
					throw new NotSupportedException();
				}
				_currentSchemaName = reader.GetString(0);
			}
			return _currentSchemaName;
		}
        public override string[] GetSchemaList()
		{
//			string query = "SELECT schema_name FROM INFORMATION_SCHEMA.SCHEMATA ORDER BY schema_name";
			string query = "SELECT schema_name FROM information_schema.schemata ORDER BY schema_name";
			using (DbDataReader reader = CreateCommand(query).ExecuteReader())
			{
				List<string> resultList = new List<string>();
				while (reader.Read())
				{
					resultList.Add(reader.GetString(0));
				}
				return resultList.ToArray();
			}
		}

        public override DatabaseObjectIndex[] GetIndexList(string catalogFilter, string schemaFilter, string objectFilter)
        {
            try
            {
                string sQuery =
                    "	SELECT " +
                    "		table_catalog, " +
                    "		table_schema, " +
                    "		table_name, " +
                    "		non_unique, " +
                    "		index_name, " +
                    "		ordinal_position, " +
                    "		column_name " +
                    "	FROM " +
                    "		information_schema.indexes " +
                    "	WHERE " +
                    "		table_catalog LIKE ?" +
                    "		AND table_schema LIKE ?" +
                    "		AND table_name LIKE ?" +
                    "	ORDER BY ordinal_position ";
                DbCommand command1 = CreateCommand(sQuery);
//                command1.Parameters.Add(CreateParameter(null, catalogFilter));
//                command1.Parameters.Add(CreateParameter(null, schemaFilter));
                command1.Parameters.Add(CreateParameter(null, "%"));
                command1.Parameters.Add(CreateParameter(null, "%"));
                command1.Parameters.Add(CreateParameter(null, objectFilter));
                DbDataReader reader1 = command1.ExecuteReader();

                List<DatabaseObjectIndex> indexList = new List<DatabaseObjectIndex>();
                DatabaseObjectIndex indexObject = null;
                while (reader1.Read())
                {
                    IDataRecord row = reader1;
                    string catalogName = row["table_catalog"].ToString();
                    string schemaName = row["table_schema"].ToString();
                    string tableName = row["table_name"].ToString();
                    string nonUnique = row["non_unique"].ToString();
                    string indexName = row["index_name"].ToString();
                    string columnName = row["column_name"].ToString();

                    if (indexObject == null || indexObject.ObjectName != indexName)
                    {
                        indexObject = new DatabaseObjectIndex(catalogName, schemaName, indexName);
                        indexObject.ObjectName = indexName;
                        indexObject.IsUnique = (nonUnique != "1");
                        indexList.Add(indexObject);
                    }
                    DatabaseColumn column = new DatabaseColumn();
                    column.ColumnName = columnName;
                    column.Index = indexObject.ColumnList.Count;
                    indexObject.ColumnList.Add(column);
                }
                return indexList.ToArray();
            }
            catch (DbException dbe)
            {
                throw new DatabaseContextException("Select index information failed.", dbe);
            }
        }

        public override bool IsDateType(string typeName)
        {
            if(typeName == "DATE")
            {
                return true;
            }
            return false;
        }
        public override bool IsNumberType(string typeName)
        {
            if(typeName == "DECIMAL")
            {
                return true;
            }
            return false;
        }
	}
}
