using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Oratorio
{
    public partial class ChangeDatabaseForm : Form
    {

        private List<string> _optionList;

        public List<string> OptionList
        {
            get { return _optionList; }
            set { _optionList = value; }
        }

        private string _databaseName;

        public string DatabaseName
        {
            get { return _databaseName; }
            set { _databaseName = value; }
        }
	
	
        public ChangeDatabaseForm()
        {
            InitializeComponent();
        }

        private void ChangeDatabaseForm_Load(object sender, EventArgs e)
        {
            _dbList.Columns.Add("Name", 400);
            foreach (string name in _optionList)
            {
                _dbList.Items.Add(name);
            }
        }

        private void _okButton_Click(object sender, EventArgs e)
        {
            if (_dbList.SelectedIndices.Count == 0)
            {
                return;
            }
            _databaseName = _dbList.SelectedItems[0].Text;
            DialogResult = DialogResult.OK;
            Close();
        }

        private void _dbList_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (_dbList.SelectedIndices.Count == 0)
            {
                return;
            }
            _databaseName = _dbList.SelectedItems[0].Text;
            DialogResult = DialogResult.OK;
            Close();
        }
    }
}