using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Data.OracleClient;

namespace Oratorio
{
    //.NET Managed Provider for Oracle
	public class DatabaseContextProviderOracle : DatabaseContextCommon
    {
        public static DatabaseContextProviderOracle Connect(string connectString)
        {
            if (string.IsNullOrEmpty(connectString))
            {
                throw new ArgumentNullException("connectString");
            }

            OracleConnection con = null;
            try
            {
                con = new OracleConnection();
            }
            catch (TypeInitializationException tie)
            {
                throw new DatabaseContextException(".NET Managed Provider for Oracle initialize failed", tie);
            }
            try
            {
                con.ConnectionString = connectString;
                con.Open();
            }
            catch (DbException ex)
            {
                throw new DatabaseContextException("database connect failed", ex);
            }
            catch (Exception ex)
            {
                throw new DatabaseContextException(".NET Managed Provider for Oracle connect failed", ex);
            }
            DatabaseContextProviderOracle context = new DatabaseContextProviderOracle(con);
            return context;
        }

        public new OracleConnection Connection
        {
            get { return (OracleConnection)_connection; }
        }
        
        public DatabaseContextProviderOracle(OracleConnection conn)
            : base(conn)
        {
            _productType = ProductTypes.Oracle;
            _currentCatalogName = GetCurrentSchema();
            _scriptGenerator = new DatabaseScriptGenerator(this);
            _factory = OracleClientFactory.Instance;
        }

        public override DbCommand CreateCommand(string sql)
        {
            OracleCommand command = Connection.CreateCommand();
            command.CommandText = sql;
            return command;
        }

        public override DbDataAdapter CreateDataAdapter()
        {
            return new OracleDataAdapter();
        }

        public override DbParameter CreateParameter(string name, object value)
        {
            return new OracleParameter(name, value);
        }

        public override string GetCurrentSchema()
        {
            string query = "SELECT USER FROM DUAL";
            using (DbDataReader reader = CreateCommand(query).ExecuteReader())
            {
                if (!reader.Read())
                {
                    throw new NotSupportedException();
                }
                _currentSchemaName = reader.GetString(0);
            }
            return _currentSchemaName;
        }

        public override string[] GetSchemaList()
        {
            string query = "SELECT username FROM all_users ORDER BY username";
            List<string> aList = new List<string>();
            using (DbDataReader reader = CreateCommand(query).ExecuteReader())
            {
                while (reader.Read())
                {
                    aList.Add(reader.GetString(0));
                }
            }
            return aList.ToArray();
        }

        //public override string[] GetTableList(string catalog, string schema)
        //{
        //    string query = "SELECT table_name FROM user_tables ORDER BY table_name";
        //    if (schema != _currentSchemaName)
        //    {
        //        query = "SELECT table_name FROM all_tables WHERE owner = :1 ORDER BY table_name";
        //    }
        //    DbCommand command = CreateCommand(query);
        //    if (schema != _currentSchemaName)
        //    {
        //        command.Parameters.Add(CreateParameter("1", schema));
        //    }
        //    List<string> aList = new List<string>();
        //    using (DbDataReader reader = command.ExecuteReader())
        //    {
        //        while (reader.Read())
        //        {
        //            aList.Add(reader.GetString(0));
        //        }
        //    }
        //    return aList.ToArray();
        //}

        public override string[] GetTableList(string catalog, string schema)
        {
            return base.GetTableList(null, schema);
        }

        public override string[] GetViewList(string catalog, string schema)
        {
            return base.GetViewList(null, schema);
        }


        public override void GetTableColumnList(string catalog, string schema, string tableName, List<DatabaseColumn> list)
        {
            if (tableName == null)
            {
                throw new ArgumentNullException("tableName");
            }
            bool sameSchema = (schema == null || schema == _currentSchemaName);

            try
            {
                string sQuery =
                    "	SELECT " +
                    "		NULL, " +
                    "		NULL, " +
                    "		table_name, " +
                    "		column_name, " +
                    "		data_type, " +
                    "		DECODE(data_precision, NULL, '' || data_length, '' || data_precision || ',' || data_scale) type_length, " +
                    "		NULL, " +
                    "		nullable, " +
                    "		NULL, " +
                    "		data_default" +
                    "	FROM " +
                    "		user_tab_columns " +
                    "	WHERE " +
                    "		table_name = :1" +
                    "	ORDER BY column_id ";
                if (!sameSchema)
                {
                    sQuery =
                        "	SELECT " +
                        "		NULL, " +
                        "		NULL, " +
                        "		table_name, " +
                        "		column_name, " +
                        "		data_type, " +
                        "		DECODE(data_precision, NULL, '' || data_length, '' || data_precision || ',' || data_scale) type_length, " +
                        "		NULL, " +
                        "		nullable, " +
                        "		NULL, " +
                        "		data_default" +
                        "	FROM " +
                        "		all_tab_columns " +
                        "	WHERE " +
                        "		owner = :1" +
                        "		AND table_name = :2" +
                        "	ORDER BY column_id ";
                }
                DbCommand command1 = CreateCommand(sQuery);
                if (!sameSchema)
                {
                    command1.Parameters.Add(CreateParameter("1", schema));
                    command1.Parameters.Add(CreateParameter("2", tableName));
                }
                else
                {
                    command1.Parameters.Add(CreateParameter("1", tableName));
                }
                DbDataReader reader1 = command1.ExecuteReader();

                int index = 0;
                Dictionary<string, DatabaseColumn> indexList = new Dictionary<string, DatabaseColumn>();
                while (reader1.Read())
                {
                    DatabaseColumn column = new DatabaseColumn();
                    column.Index = index++;
                    column.ColumnName = reader1.GetString(3);
                    column.TypeAndSize = reader1.GetString(4);
                    string nullable = reader1.GetString(7);
                    column.IsNullable = (reader1.GetString(7) == "Y");
                    //TODO
                    if (column.TypeAndSize.IndexOf("CHAR") >= 0 || column.TypeAndSize.IndexOf("NUMBER") >= 0)
                    {
                        column.TypeLength = reader1.GetString(5);
                    }
                    list.Add(column);
                    indexList.Add(column.ColumnName, column);
                }

                string sQuery2 =
                    "	SELECT ucc.column_name " +
                    "	FROM " +
                    "		user_constraints ucs, " +
                    "		user_cons_columns ucc " +
                    "	WHERE " +
                    "	ucs.table_name = :1 " +
                    "	AND ucs.constraint_type = 'P' " +
                    "	AND ucc.table_name = ucs.table_name " +
                    "	AND ucc.constraint_name = ucs.constraint_name " +
                    "	ORDER BY ucc.position ";
                if (!sameSchema)
                {
                    sQuery2 =
                        "	SELECT ucc.column_name " +
                        "	FROM " +
                        "		all_constraints ucs, " +
                        "		all_cons_columns ucc " +
                        "	WHERE " +
                        "	ucs.owner = :1 " +
                        "	AND ucs.table_name = :2 " +
                        "	AND ucs.constraint_type = 'P' " +
                        "	AND ucc.owner = ucs.owner " +
                        "	AND ucc.table_name = ucs.table_name " +
                        "	AND ucc.constraint_name = ucs.constraint_name " +
                        "	ORDER BY ucc.position ";
                }
                DbCommand command2 = CreateCommand(sQuery2);
                if (!sameSchema)
                {
                    command2.Parameters.Add(CreateParameter("1", schema));
                    command2.Parameters.Add(CreateParameter("2", tableName));
                }
                else
                {
                    command2.Parameters.Add(CreateParameter("1", tableName));
                }
                DbDataReader reader2 = command2.ExecuteReader();
                while (reader2.Read())
                {
                    string columnName = reader2.GetString(0);
                    indexList[columnName].IsKey = true;
                }
            }
            catch (DbException dbe)
            {
                throw new DatabaseContextException("̎擾Ɏs܂B", dbe);
            }
        }
    }
}
