using System;
using System.Collections.Generic;
using System.Text;

namespace Oratorio
{
    public class DatabaseObject
    {
        protected string _catalogName;
        protected string _schemaName;
        protected string _objectName;

        public string ObjectName
        {
            get { return _objectName; }
            set { _objectName = value; }
        }
	
        public string SchemaName
        {
            get { return _schemaName; }
            set { _schemaName = value; }
        }
	

        public string CatalogName
        {
            get { return _catalogName; }
            set { _catalogName = value; }
        }
	
        protected DatabaseObject()
        {
        }

    }

    public class DatabaseObjectIndex : DatabaseObject
    {
        protected List<DatabaseColumn> _columnList = new List<DatabaseColumn>();

        private bool _isUnique;

        public bool IsUnique
        {
            get { return _isUnique; }
            set { _isUnique = value; }
        }
	
        public List<DatabaseColumn> ColumnList
        {
            get { return _columnList; }
            set { _columnList = value; }
        }
	
        public DatabaseObjectIndex(string catalogName, string schemaName, string objectName)
        {
            _catalogName = catalogName;
            _schemaName = schemaName;
            _objectName = objectName;
        }
    }
}
