using System;
using System.Collections.Generic;
using System.Text;

using System.Data.Common;

namespace Oratorio
{
    public class DatabaseScriptGeneratorOracle : DatabaseScriptGenerator
    {
        public DatabaseScriptGeneratorOracle(DatabaseContextCommon database) : base(database)
        {
        }

        public override string GetCreateProcedureScript(string catalog, string schema, string name)
        {
            string sql = "SELECT text FROM all_source WHERE owner = ? AND name = ? ORDER BY type, line";

            DbCommand command = Database.CreateCommand(sql);
            command.Parameters.Add(Database.CreateParameter(null, schema));
            command.Parameters.Add(Database.CreateParameter(null, name));

            StringBuilder buffer = new StringBuilder();
            using (DbDataReader reader = command.ExecuteReader())
            {
                while (reader.Read())
                {
                    buffer.Append(reader.GetString(0));
                }
            }
            string result = buffer.ToString().Trim();
            if (result.Length > 0)
            {
                result = "CREATE OR REPLACE " + result;
            }
            return result;
        }

        public override string GetCreateViewScript(string catalog, string schema, string name)
        {
            string sql = "SELECT text FROM all_views WHERE owner = ? AND view_name = ?";

            DbCommand command = Database.CreateCommand(sql);
            command.Parameters.Add(Database.CreateParameter(null, schema));
            command.Parameters.Add(Database.CreateParameter(null, name));

            StringBuilder buffer = new StringBuilder();
            using (DbDataReader reader = command.ExecuteReader())
            {
                while (reader.Read())
                {
                    buffer.Append(reader.GetString(0));
                }
            }
            string result = buffer.ToString().Trim();
            if (result.Length > 0)
            {
                result = "CREATE OR REPLACE VIEW " + name + " AS " + result;
            }
            return result;
        }

    }
}
