using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Oratorio
{
    public partial class FilterForm : Form
    {
        public struct FilterFormItem
        {
            public string Column;
            public string Value;
            public int Sort;
        }
        public FilterForm()
        {
            InitializeComponent();
        }

        private List<string> _columnList = new List<string>();
        private List<FilterFormItem> _filterList = new List<FilterFormItem>();

        public List<FilterFormItem> FilterList
        {
            get { return _filterList; }
            set { _filterList = value; }
        }
	
        public List<string> ColumnList
        {
            get { return _columnList; }
            set { _columnList = value; }
        }
	
        private void FilterForm_Load(object sender, EventArgs e)
        {
            _columnList.Sort();
            foreach (string name in _columnList)
            {
                _nameCombo.Items.Add(name);
            }
        }

        protected void SetFilterItem()
        {
            if (_nameCombo.Text.Length == 0)
                return;
            //            _dataGrid.Rows.Add(new string[] { _nameCombo.Text, _valueCombo.Text, _sortCombo.Text });

            if (_dataGrid.Rows.Count > 1)
            {
                DataGridViewRow beforeRow = _dataGrid.Rows[_dataGrid.Rows.Count - 2];
                String nameValue = ((beforeRow.Cells[0].Value == null) ? "" : beforeRow.Cells[0].Value.ToString());
                String valueValue = ((beforeRow.Cells[1].Value == null) ? "" : beforeRow.Cells[1].Value.ToString());
                String sortValue = ((beforeRow.Cells[2].Value == null) ? "" : beforeRow.Cells[2].Value.ToString());
                if (nameValue == _nameCombo.Text
                    && valueValue == _valueCombo.Text
                    && sortValue == _sortCombo.Text)
                {
                    return;
                }
            }
            int rowIndex = _dataGrid.Rows.Add();
            DataGridViewRow row = _dataGrid.Rows[rowIndex];
            row.Cells[0].Value = _nameCombo.Text;
            row.Cells[1].Value = _valueCombo.Text;
            row.Cells[2].Value = _sortCombo.Text;
        }
        private void _setButton_Click(object sender, EventArgs e)
        {
            SetFilterItem();
        }

        private void _okButton_Click(object sender, EventArgs e)
        {
            if (_nameCombo.Text.Length != 0 && (_valueCombo.Text.Length > 0 || _sortCombo.Text.Length > 0))
            {
                SetFilterItem();
            }
            _filterList.Clear();
            for (int rowIndex = 0; rowIndex < _dataGrid.RowCount; rowIndex++)
            {
                FilterFormItem filterItem = new FilterFormItem();
                if(_dataGrid.Rows[rowIndex].Cells[0].Value == null)
                {
                    continue;
                }
                filterItem.Column = _dataGrid.Rows[rowIndex].Cells[0].Value.ToString();
                if (filterItem.Column.Length == 0)
                {
                    continue;
                }
                filterItem.Value = _dataGrid.Rows[rowIndex].Cells[1].Value.ToString();
                filterItem.Sort = -1;
                int.TryParse(_dataGrid.Rows[rowIndex].Cells[2].Value.ToString(), out filterItem.Sort);
                _filterList.Add(filterItem);
            }
        }
    }
}