using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Oratorio
{
    public partial class FindColumnForm : Form
    {
        public string ColumnName
        {
            get { return _columnNameText.Text; }
            set { _columnNameText.Text = value; }
        }

        public List<string> ColumnList
        {
            get
            {
                List<string> names = new List<string>();
                foreach (string name in _columnList.Items)
                {
                    names.Add(name);
                }
                return names;
            }
            set
            {
                List<string> names = value;
                names.Sort();
                foreach (string name in names)
                {
                    _columnList.Items.Add(name);
                }

            }
        }
	
        public FindColumnForm()
        {
            InitializeComponent();
        }

        private void FindColumnForm_Load(object sender, EventArgs e)
        {
            _columnNameText_TextChanged(sender, e);
        }

        private void _columnList_DoubleClick(object sender, EventArgs e)
        {
            if (_columnList.SelectedIndex < 0)
                return;
            string itemText = _columnList.Items[_columnList.SelectedIndex].ToString();
            if (itemText != _columnNameText.Text)
            {
                _columnNameText.Text = itemText;
            }
            DialogResult = DialogResult.OK;
            Close();
        }

        private void _columnNameText_TextChanged(object sender, EventArgs e)
        {
            string currentText = _columnNameText.Text;
            currentText = currentText.ToUpper();
            if (currentText.Length == 0)
                return;
            int findIndex = -1;
            int findMatchCount = 0;
            for(int index = 0; index < _columnList.Items.Count; index++)
            {
                string itemText = _columnList.Items[index].ToString();
                itemText = itemText.ToUpper();
                int matchCount = 0;
                for (matchCount = 0; matchCount < Math.Min(itemText.Length, currentText.Length); matchCount++)
                {
                    if (itemText[matchCount] != currentText[matchCount])
                    {
                        break;
                    }
                }
                if (matchCount > findMatchCount)
                {
                    findIndex = index;
                    findMatchCount = matchCount;
                    if (matchCount >= currentText.Length)
                    {
                        break;
                    }
                }
            }
            if (findIndex >= 0)
            {
                _columnList.SelectedIndex = findIndex;
            }
        }

        private void _columnList_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (!_columnList.Focused)
                return;
            if (_columnList.SelectedIndex < 0)
                return;
            string itemText = _columnList.Items[_columnList.SelectedIndex].ToString();
            if (itemText != _columnNameText.Text)
            {
                _columnNameText.Text = itemText;
            }
        }

        private void _columnNameText_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Down || e.KeyCode == Keys.Up)
            {
                e.Handled = true;
                _columnList.Focus();
            }
        }
    }
}