using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Data.Odbc;
using System.Data.Common;
using System.Data.OleDb;
using Microsoft.Win32;
using System.IO;
using System.Diagnostics;
using System.Xml;
using System.Configuration;

namespace Oratorio
{
    public partial class LoginOdbcForm : Form
    {
        protected DatabaseContextCommon _database;

        protected ConnectSettingStore _settings = new ConnectSettingStore();

        protected enum ConnectTypes
        {
            //            Auto,
            OdbcDefault,
            OracleProvider,
            Oracle10,
            Oracle9,
            SqlServer2005,
        }

        protected static readonly string[] ConnectTypeNames = 
        {
//            "Auto",
            "ODBC",
            "Oracle (.NET Managed Provider)",
            "Oracle 10(ODBC)",
            "Oracle 9(ODBC)",
            "SQL Server 2005(ODBC)",
        };

        public DatabaseContextCommon Database
        {
			get { return _database; }
			set { _database = value; }
        }


        public LoginOdbcForm()
        {
            InitializeComponent();
        }

        private void ctrlOk_Click(object sender, EventArgs e)
        {
			ctrlOk.Enabled = false;

            try
            {
                string connectString = "";
                if (_driverCombo.Text.Length > 0)
                {
                    connectString += "DRIVER={" + _driverCombo.Text + "};";
                }

                DbConnectionStringBuilder connStrBuffer = new DbConnectionStringBuilder();
                if (_dataSourceCombo.Text.Length > 0)
                {
                    connStrBuffer.Add("DSN", _dataSourceCombo.Text);
					//const string sOdbcRegPath = "HKEY_CURRENT_USER\\Software\\ODBC\\ODBC.INI";
					//RegistryKey regKey = Registry.CurrentUser.OpenSubKey(sOdbcRegPath + "\\" + _dataSourceCombo.Text);
					//if (regKey != null)
					//{
					//    regKey.GetValue();
					//    ProgramUtility.ShowError("ODBC driver listing failed.");
					//    Close();
					//    return;
					//}
				}
                if (_userText.Text.Length > 0)
                {
                    connStrBuffer.Add("UID", _userText.Text);
                }
                if (_passwordText.Text.Length > 0)
                {
                    connStrBuffer.Add("PWD", _passwordText.Text);
                }
                if (_serverText.Text.Length > 0)
                {
                    connStrBuffer.Add("SERVER", _serverText.Text);
                }
                if (_portText.Text.Length > 0)
                {
                    connStrBuffer.Add("PORT", _portText.Text);
                }
                if (_databaseText.Text.Length > 0)
                {
                    connStrBuffer.Add("DATABASE", _databaseText.Text);
                }
                if (_dbqText.Text.Length > 0)
                {
                    connStrBuffer.Add("DBQ", _dbqText.Text);
                }
                if (_connectMethodCombo.SelectedIndex == (int)ConnectTypes.Oracle10)
                {
                    //Oracle10̒ڐڑ
                    if (_serverText.Text.Length > 0 && _portText.Text.Length > 0)
                    {
                        connStrBuffer.Remove("SERVER");
                        connStrBuffer.Add("SERVER", _serverText.Text + ":" + _portText.Text);
                    }
                }
                connectString += connStrBuffer.ToString();
                if (connectString.Length == 0)
                {
                    MessageBox.Show(this, "ڂ͂Ă܂B");
                    return;
                }

                Properties.Settings.Default.LatestSettingName = _settingCombo.Text;
				//Properties.Settings.Default.LatestSettingUserName = _userText.Text;
				//Properties.Settings.Default.LatestSettingPassword = _passwordText.Text;
				//Properties.Settings.Default.LatestSettingDriver = _driverCombo.Text;
				//Properties.Settings.Default.LatestSettingDatabase = _databaseText.Text;
				//Properties.Settings.Default.LatestSettingServer = _serverText.Text;
				//Properties.Settings.Default.LatestSettingDbq = _dbqText.Text;
				//Properties.Settings.Default.LatestSettingConnectType = _connectMethodCombo.Text;
                try
                {
                    Properties.Settings.Default.Save();
                }
                catch (ConfigurationException ce)
                {
                    ProgramUtility.ShowError(ce);
                }

                if (_settingCombo.Text.Length > 0)
                {
                    ConnectSettingData settingData = new ConnectSettingData();
                    settingData.SettingName = _settingCombo.Text;
                    settingData.Uid = _userText.Text;
                    settingData.Pwd = _passwordText.Text;
                    settingData.Driver = _driverCombo.Text;
                    settingData.Server = _serverText.Text;
                    settingData.Database = _databaseText.Text;
                    settingData.Dbq = _dbqText.Text;
                    settingData.SettingMethod = _connectMethodCombo.Text;
					settingData.Dsn = _dataSourceCombo.Text;
					settingData.Port = _portText.Text;
					int insertIndex = Math.Max(_settingCombo.Items.Count - 1, 0);
                    for (int index = 0; index < _settings.Count; index++)
                    {
                        if (_settings[index].SettingName == _settingCombo.Text)
                        {
                            insertIndex = index;
                            _settings.RemoveAt(index);
                            break;
                        }
                    }
                    _settings.Insert(insertIndex, settingData);
                    _settings.Save();
                }

                ConnectTypes connectMethodIndex = (ConnectTypes)_connectMethodCombo.SelectedIndex;
				if (connectMethodIndex == ConnectTypes.Oracle10 || connectMethodIndex == ConnectTypes.Oracle9)
				{
					DatabaseContextOdbc database = DatabaseContextOdbc.Connect(connectString);
					_database = database;
				}
				else if (connectMethodIndex == ConnectTypes.OdbcDefault || connectMethodIndex == ConnectTypes.SqlServer2005)
				{
					DatabaseContextOdbc database = DatabaseContextOdbc.Connect(connectString);
					_database = database;
				}
                else if (connectMethodIndex == ConnectTypes.OracleProvider)
                {
                    DatabaseContextProviderOracle database = DatabaseContextProviderOracle.Connect(connectString);
                    _database = database;
                }
                else
                {
                    throw new NotSupportedException();
                }
            }
            catch (DatabaseContextException pe)
            {
                ProgramUtility.ShowError(pe);
                return;
            }
            finally
            {
                ctrlOk.Enabled = true;
            }

			DialogResult = DialogResult.OK;
            Close();
        }

        private void LoginForm_Load(object sender, EventArgs e)
		{
//            ctrlOk.Enabled = false;

			_driverCombo.Items.Add("");
			
			const string sOdbcRegPath = "SOFTWARE\\ODBC\\ODBCINST.INI\\ODBC Drivers";
            RegistryKey regKey = Registry.LocalMachine.OpenSubKey(sOdbcRegPath);
            if (regKey == null)
            {
				ProgramUtility.ShowError("ODBC driver listing failed.");
				Close();
				return;
            }
			try
			{
				foreach (string sName in regKey.GetValueNames())
				{
					_driverCombo.Items.Add(sName);
				}
			}
			finally
			{
				regKey.Close();
			}

			_dataSourceCombo.Items.Add("");
			const string sUserDsnRegPath = "Software\\ODBC\\ODBC.INI\\ODBC Data Sources";
			regKey = Registry.CurrentUser.OpenSubKey(sUserDsnRegPath);
			if (regKey != null)
			{
				try
				{
					foreach (string sName in regKey.GetValueNames())
					{
						_dataSourceCombo.Items.Add(sName);
					}
				}
				finally
				{
					regKey.Close();
				}
			}

			const string sMachineDsnRegPath = "Software\\ODBC\\ODBC.INI\\ODBC Data Sources";
			regKey = Registry.LocalMachine.OpenSubKey(sMachineDsnRegPath);
			if (regKey != null)
			{
				try
				{
					foreach (string sName in regKey.GetValueNames())
					{
						if (_dataSourceCombo.Items.Contains(sName))
						{
							continue;
						}
						_dataSourceCombo.Items.Add(sName);
					}
				}
				finally
				{
					regKey.Close();
				}
			}

			foreach (string method in ConnectTypeNames)
            {
                _connectMethodCombo.Items.Add(method);
            }
            _connectMethodCombo.SelectedIndex = 0;

            _settingCombo.Items.Add("");
            if (File.Exists(_settings.SettingPath))
            {
                _settings.Load();
                Dictionary<string, bool> settingNames = new Dictionary<string, bool>();
                for (int index = 0; index < _settings.Count; index++)
                {
                    ConnectSettingData data = _settings[index];
                    if (settingNames.ContainsKey(data.SettingName))
                    {
                        _settings.RemoveAt(index);
                        index--;
                        continue;
                    }
                    settingNames.Add(data.SettingName, true);
                    _settingCombo.Items.Add(data.SettingName);
                }
            }
            string latestSettingName = Properties.Settings.Default.LatestSettingName;
            for (int index = 0; index < _settingCombo.Items.Count; index++)
            {
                if (_settingCombo.Items[index].ToString() == latestSettingName)
                {
                    _settingCombo.SelectedIndex = index;
                    break;
                }
            }

        }

        protected void RefreshFromData(ConnectSettingData settingData)
        {
            this._userText.Text = settingData.Uid;
            this._passwordText.Text = settingData.Pwd;
            this._driverCombo.Text = settingData.Driver;
            this._serverText.Text = settingData.Server;
            this._databaseText.Text = settingData.Database;
            this._dataSourceCombo.Text = settingData.Dsn;
			this._dbqText.Text = settingData.Dbq;
			this._portText.Text = settingData.Port;
			bool findMethod = false;
            for (int index = 0; index < _connectMethodCombo.Items.Count; index++)
            {
                if (_connectMethodCombo.Items[index].ToString() == settingData.SettingMethod)
                {
                    _connectMethodCombo.SelectedIndex = index;
                    findMethod = true;
                    break;
                }
            }
            if (!findMethod)
            {
                this._connectMethodCombo.SelectedIndex = (int)ConnectTypes.OdbcDefault;
            }
        }
        private void _settingList_SelectedIndexChanged(object sender, EventArgs e)
        {
            int selectedIndex = _settingCombo.SelectedIndex;
            if(selectedIndex < 1 || selectedIndex > _settings.Count)
            {
                ConnectSettingData emptyData = new ConnectSettingData();
                RefreshFromData(emptyData);
                this._userText.Text = "";
                this._passwordText.Text = "";
                this._driverCombo.Text = "";
                this._serverText.Text = "";
                this._databaseText.Text = "";
                this._dbqText.Text = "";
                this._connectMethodCombo.SelectedIndex = (int)ConnectTypes.OdbcDefault;
                return;
            }
            selectedIndex--;
            ConnectSettingData data = _settings[selectedIndex];
            RefreshFromData(data);
        }

        private void _connectMethodList_SelectedIndexChanged(object sender, EventArgs e)
        {
            string serverLabelText = "Server(&S)";
            string dbqLabelText = "Path(&Q)";
			
            bool serverNameEnable = true;
			bool databaseNameEnable = true;
			bool portTextEnable = true;
            bool driverNameEnable = true;
            bool dataSourceEnable  = true;
            bool dbqEnable  = true;

            switch ((ConnectTypes)_connectMethodCombo.SelectedIndex)
			{
				case ConnectTypes.Oracle10:
					dbqLabelText = "TNS Name(&T)";
					_serverText.Text = "";
					_databaseText.Text = "";
                    _portText.Text = "";
					serverNameEnable = false;
					databaseNameEnable = false;
					portTextEnable = false;
					break;
				case ConnectTypes.Oracle9:
                    dbqLabelText = "TNS Name(&T)";
                    _serverText.Text = "";
					_databaseText.Text = "";
                    _portText.Text = "";
                    serverNameEnable = false;
					databaseNameEnable = false;
					portTextEnable = false;
					break;
                case ConnectTypes.OracleProvider:
                    serverLabelText = "TNS Name(&T)";
                    databaseNameEnable = false;
                    portTextEnable = false;
                    driverNameEnable = false;
                    dataSourceEnable = false;
                    _databaseText.Text = "";
                    _dataSourceCombo.Text = "";
                    _portText.Text = "";
                    _driverCombo.Text = "";
                    _dbqText.Text = "";
                    dbqEnable = false;
                    break;
            }

            _serverLabel.Text = serverLabelText;
            _dbqLabel.Text = dbqLabelText;

            _serverText.Enabled = serverNameEnable;
			_databaseText.Enabled = databaseNameEnable;
			_portText.Enabled = portTextEnable;
			_driverCombo.Enabled = driverNameEnable;
            _dataSourceCombo.Enabled = dataSourceEnable;
            _dbqText.Enabled = dbqEnable;
		}
    }
}