﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Text;

using System.IO;
using System.Text.RegularExpressions;
using Microsoft.Win32;
using System.Threading;

namespace Oratorio
{
    static class Program
    {
#if DEBUG
        static void OnException(object sender, ThreadExceptionEventArgs e)
        {
            Exception excep = e.Exception;

            System.Diagnostics.Debug.WriteLine(excep.ToString());
            System.Diagnostics.Debug.Flush();

            MessageBox.Show(e.Exception.ToString());
            throw e.Exception;
        }
        static void OnUnhandledException(object sender, UnhandledExceptionEventArgs e)
        {
            Exception excep = e.ExceptionObject as Exception;
            excep = (excep != null)? excep: new Exception("" + e.ExceptionObject);

            System.Diagnostics.Debug.WriteLine(excep.ToString());
            System.Diagnostics.Debug.Flush();

            MessageBox.Show(e.ExceptionObject.ToString());
            throw (Exception)e.ExceptionObject;
        }
#endif
        public static void ParseTnsNameOption(string tnsFileText, ref int begin)
        {
//            Regex regexOptionBegin = new Regex(@"^\s*\(\s*", RegexOptions.Multiline);
            Regex regexKeyBegin = new Regex(@"\s*\(\s*[a-zA-Z0-9_]+\s*=\s*", RegexOptions.Multiline);
            Regex regexKeyEnd = new Regex(@"\s*[^\(\)\=]*\s*\)\s*", RegexOptions.Multiline);
            for (; begin < tnsFileText.Length; )
            {
                Match matchOptionBegin = regexKeyBegin.Match(tnsFileText, begin);
                if (!matchOptionBegin.Success || matchOptionBegin.Index != begin)
                {
                    break;
                }
                begin = matchOptionBegin.Index + matchOptionBegin.Length;
                //Match matchKeyBegin = regexKeyBegin.Match(tnsFileText, begin);
                //if (!matchKeyBegin.Success || matchKeyBegin.Index != begin)
                //{
                //    break;
                //}
                Match matchSubOptionBegin = regexKeyBegin.Match(tnsFileText, begin);
                if (matchSubOptionBegin.Success && matchSubOptionBegin.Index == begin)
                {
                    ParseTnsNameOption(tnsFileText, ref begin);
                }
                Match matchOptionEnd = regexKeyEnd.Match(tnsFileText, begin);
                if (!matchOptionEnd.Success)
                {
                    break;
                }
                begin = matchOptionEnd.Index + matchOptionEnd.Length;
            }
        }

        public static List<string> GetOracleTnsList()
        {
            List<string> resultList = new List<string>();

            const string oracleHomePath = @"SOFTWARE\ORACLE\HOME0";
            RegistryKey regKey = Registry.LocalMachine.OpenSubKey(oracleHomePath);
            if (regKey == null)
            {
                return null;
            }
            string oracleHome = null;
            try
            {
                oracleHome = (regKey.GetValue("ORACLE_HOME") != null ? regKey.GetValue("ORACLE_HOME").ToString() : null);
                if (oracleHome == null)
                {
                    return null;
                }
            }
            finally
            {
                regKey.Close();
            }
            string oracleNetAdmin = Path.Combine(oracleHome, @"network\ADMIN");
            string oracleTnsNamesPath = Path.Combine(oracleNetAdmin, @"tnsnames.ora");
            if (!Directory.Exists(oracleNetAdmin) || !File.Exists(oracleTnsNamesPath))
            {
                return null;
            }
            string tnsFileText = "";
            StreamReader reader = File.OpenText(oracleTnsNamesPath);
            while(!reader.EndOfStream)
            {
                string line = reader.ReadLine();
                if(line.IndexOf("#") >= 0)
                {
                    line = line.Substring(0, line.IndexOf("#"));
                }
                tnsFileText += line + "\r\n";
            }
            Regex regexTnsName = new Regex(@"^\s*([a-zA-Z0-9_]+)\s*=\s*", RegexOptions.Multiline);
//            Regex regexTnsOptionBegin = new Regex(@"^\s*\(\s*([a-zA-Z0-9_]+)\s*=\s*", RegexOptions.Multiline);
            for (int begin = 0; begin < tnsFileText.Length; )
            {
                Match matchTnsName = regexTnsName.Match(tnsFileText, begin);
                if (!matchTnsName.Success)
                {
                    break;
                }
                string foundName = matchTnsName.Groups[1].Value;
                resultList.Add(foundName);
                begin = matchTnsName.Index + matchTnsName.Length;
                ParseTnsNameOption(tnsFileText, ref begin);
/*
                Match matchTnsParenthesisBegin = regexTnsOptionBegin.Match(tnsFileText, begin);
                if (matchTnsParenthesisBegin.Success)
                {
                    begin = ParseTnsNames(tnsFileText, begin);
                }
                else
                {
                    Match matchTnsParenthesisBegin = regexTnsOptionBegin.Match(tnsFileText, begin);
                    if (matchTnsParenthesisBegin.Success)
                    {
                        begin = ParseTnsNames(tnsFileText, begin);
                }
*/                
            }
            return resultList;
        }

        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

#if DEBUG
            string filename = Application.ExecutablePath + ".log";

            System.Diagnostics.TextWriterTraceListener texttrace =
                new System.Diagnostics.TextWriterTraceListener(filename);
            System.Diagnostics.Debug.Listeners.Add(texttrace);
            System.Diagnostics.Debug.AutoFlush = true;

            Application.ThreadException += OnException;
            Thread.GetDomain().UnhandledException += OnUnhandledException;
#endif

//            List<string> list = GetOracleTnsList();
            //ConnectListForm form = new ConnectListForm();
            //form.ShowDialog();
            Application.Run(new MainForm());
#if DEBUG
            System.Diagnostics.Debug.Flush();
#endif
        }
    }
}