typedef unsigned char UCHAR;

#include <stdio.h>
#include <stdlib.h>

#define MAXSIZ	32 * 1024 * 1024 + 310

int main(int argc, UCHAR **argv)
{
	FILE *fp;
	UCHAR *buf = malloc(MAXSIZ), *l;
	int i, j = 0, k;
	static UCHAR head[0x8c] = {
		0x4c, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, /* +08(d) : g = h + 0x8c */
		0x00, 0x00, 0x00, 0x00, 0x2e, 0x74, 0x65, 0x78,
		0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x20, 0x00, 0x10, 0x60, 0x2e, 0x64, 0x61, 0x74,
		0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +4c(d) h = dataZNVTCY */
		0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +54(d) g */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x40, 0x00, 0x40, 0xc0, 0x2e, 0x62, 0x73, 0x73, /* align=8 */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x80, 0x00, 0x10, 0xc0
	};
	static UCHAR foot[0xa6] = {
		0x2e, 0x66, 0x69, 0x6c, 0x65, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0x00, 0x00,
		0x67, 0x01, 0x6b, 0x5f, 0x62, 0x69, 0x6e, 0x2e,
		0x6f, 0x62, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x2e, 0x74, 0x65, 0x78,
		0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x01, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x2e, 0x64, 0x61, 0x74, 0x61, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
		0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +5a(d) h */
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x2e, 0x62, 0x73, 0x73,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x03, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* +90(q) l 8܂ */
		0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
		0x02, 0x00, 0x04, 0x00, 0x00, 0x00
	};
	if (argc < 4) {
		puts("bin2obj hideyosi version 1.0\n\tusage>bin2obj binfile objfile [-]label");
		return 1;
	}
	l = argv[3];
	if (*l == '-') {
		l++;
		j += 4;
	}
	fp = fopen(argv[1], "rb");
	if (fp == NULL) {
		puts("binfile open error.");
		return 1;
	}
	i = fread(buf + 0x8c + j, 1, MAXSIZ - 310, fp);
	fclose(fp);
	if (i >= MAXSIZ - 310) {
		puts("binfile size error.");
		return 1;
	}
	if (j) {
		buf[0x8c] =  i        & 0xff;
		buf[0x8d] = (i >>  8) & 0xff;
		buf[0x8e] = (i >> 16) & 0xff;
		buf[0x8f] = (i >> 24) & 0xff;
		i += 4;
	}
	for (k = 0; k < 0x8c; k++)
		buf[k] = head[k];
	for (k = 0; k < 0xa6; k++)
		buf[0x8c + i + k] = foot[k];
	k = i + 0x8c;
	buf[0x08] =  k        & 0xff;
	buf[0x09] = (k >>  8) & 0xff;
	buf[0x0a] = (k >> 16) & 0xff;
	buf[0x0b] = (k >> 24) & 0xff;
	buf[0x4c] =  i        & 0xff;
	buf[0x4d] = (i >>  8) & 0xff;
	buf[0x4e] = (i >> 16) & 0xff;
	buf[0x4f] = (i >> 24) & 0xff;
	buf[0x54] =  k        & 0xff;
	buf[0x55] = (k >>  8) & 0xff;
	buf[0x56] = (k >> 16) & 0xff;
	buf[0x57] = (k >> 24) & 0xff;
	buf[0x8c + i + 0x5a] =  i        & 0xff;
	buf[0x8c + i + 0x5b] = (i >>  8) & 0xff;
	buf[0x8c + i + 0x5c] = (i >> 16) & 0xff;
	buf[0x8c + i + 0x5d] = (i >> 24) & 0xff;
	k = 0;
	if (*l == '\0') {
		puts("label error.");
		return 1;
	}
	for (;;) {
		buf[0x8c + i + 0x90 + k] = l[k];
		k++;
		if (l[k] == '\0')
			break;
		if (k == 8) {
			puts("label too long.");
			return 1;
		}
	}
	fp = fopen(argv[2], "wb");
	if (fp == NULL) {
		puts("objfile open error.");
		return 1;
	}
	j = fwrite(buf, 1, i + 306, fp);
	fclose(fp);
	if (j < i + 306) {
		puts("objfile output error.");
		return 1;
	}
	return 0;
}
