<?php
/**
 * ProjectFrsApi
 * PHP version 5
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 *  Copyright 2016 SmartBear Software
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program. 
 * https://github.com/swagger-api/swagger-codegen 
 * Do not edit the class manually.
 */

namespace OSDN\Api;

use \OSDN\Configuration;
use \OSDN\ApiClient;
use \OSDN\ApiException;
use \OSDN\ObjectSerializer;

/**
 * ProjectFrsApi Class Doc Comment
 *
 * @category Class
 * @package  OSDN
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ProjectFrsApi
{

    /**
     * API Client
     * @var \OSDN\ApiClient instance of the ApiClient
     */
    protected $apiClient;
  
    /**
     * Constructor
     * @param \OSDN\ApiClient|null $apiClient The api client to use
     */
    function __construct($apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://osdn.jp/api/v0');
        }
  
        $this->apiClient = $apiClient;
    }
  
    /**
     * Get API client
     * @return \OSDN\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }
  
    /**
     * Set the API client
     * @param \OSDN\ApiClient $apiClient set the API client
     * @return ProjectFrsApi
     */
    public function setApiClient(ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }
  
    
    /**
     * listPackages
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return \OSDN\Model\Package[]
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listPackages($id_or_name)
    {
        list($response, $statusCode, $httpHeader) = $this->listPackagesWithHttpInfo ($id_or_name);
        return $response; 
    }


    /**
     * listPackagesWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @return Array of \OSDN\Model\Package[], HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function listPackagesWithHttpInfo($id_or_name)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling listPackages');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\Package[]'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\Package[]', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\Package[]', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * createPackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name package name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\Package
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createPackage($id_or_name, $name, $visibility = null)
    {
        list($response, $statusCode, $httpHeader) = $this->createPackageWithHttpInfo ($id_or_name, $name, $visibility);
        return $response; 
    }


    /**
     * createPackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param string $name package name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\Package, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createPackageWithHttpInfo($id_or_name, $name, $visibility = null)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createPackage');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createPackage');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            
            
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
            
        }// form params
        if ($visibility !== null) {
            
            
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
            
        }
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\Package'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\Package', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 201:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\Package', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * getPackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return \OSDN\Model\Package
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getPackage($id_or_name, $package_id)
    {
        list($response, $statusCode, $httpHeader) = $this->getPackageWithHttpInfo ($id_or_name, $package_id);
        return $response; 
    }


    /**
     * getPackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return Array of \OSDN\Model\Package, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getPackageWithHttpInfo($id_or_name, $package_id)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getPackage');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling getPackage');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\Package'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\Package', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\Package', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * createRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name Release name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param string $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param string $release_note Release note body text. (optional)
     * @param string $change_log Changelog body text. (optional)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createRelease($id_or_name, $package_id, $name, $visibility = null, $time = null, $release_note = null, $change_log = null)
    {
        list($response, $statusCode, $httpHeader) = $this->createReleaseWithHttpInfo ($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log);
        return $response; 
    }


    /**
     * createReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name Release name (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param string $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param string $release_note Release note body text. (optional)
     * @param string $change_log Changelog body text. (optional)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createReleaseWithHttpInfo($id_or_name, $package_id, $name, $visibility = null, $time = null, $release_note = null, $change_log = null)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling createRelease');
        }
        // verify the required parameter 'name' is set
        if ($name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $name when calling createRelease');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            
            
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
            
        }// form params
        if ($name !== null) {
            
            
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
            
        }// form params
        if ($time !== null) {
            
            
            $formParams['time'] = $this->apiClient->getSerializer()->toFormValue($time);
            
        }// form params
        if ($release_note !== null) {
            
            
            $formParams['release_note'] = $this->apiClient->getSerializer()->toFormValue($release_note);
            
        }// form params
        if ($change_log !== null) {
            
            
            $formParams['change_log'] = $this->apiClient->getSerializer()->toFormValue($change_log);
            
        }
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\Release'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 201:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * deletePackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deletePackage($id_or_name, $package_id)
    {
        list($response, $statusCode, $httpHeader) = $this->deletePackageWithHttpInfo ($id_or_name, $package_id);
        return $response; 
    }


    /**
     * deletePackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deletePackageWithHttpInfo($id_or_name, $package_id)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deletePackage');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling deletePackage');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'DELETE',
                $queryParams, $httpBody,
                $headerParams
            );
            
            return array(null, $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            }
  
            throw $e;
        }
    }
    
    /**
     * updatePackage
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name package name (optional)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\Package
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updatePackage($id_or_name, $package_id, $name = null, $visibility = null)
    {
        list($response, $statusCode, $httpHeader) = $this->updatePackageWithHttpInfo ($id_or_name, $package_id, $name, $visibility);
        return $response; 
    }


    /**
     * updatePackageWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param string $name package name (optional)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\Package, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updatePackageWithHttpInfo($id_or_name, $package_id, $name = null, $visibility = null)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updatePackage');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling updatePackage');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($name !== null) {
            
            
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
            
        }// form params
        if ($visibility !== null) {
            
            
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
            
        }
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'PATCH',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\Package'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\Package', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\Package', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * draftRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function draftRelease($id_or_name, $package_id)
    {
        list($response, $statusCode, $httpHeader) = $this->draftReleaseWithHttpInfo ($id_or_name, $package_id);
        return $response; 
    }


    /**
     * draftReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function draftReleaseWithHttpInfo($id_or_name, $package_id)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling draftRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling draftRelease');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/draft";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\Release'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * getRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getRelease($id_or_name, $package_id, $release_id)
    {
        list($response, $statusCode, $httpHeader) = $this->getReleaseWithHttpInfo ($id_or_name, $package_id, $release_id);
        return $response; 
    }


    /**
     * getReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getReleaseWithHttpInfo($id_or_name, $package_id, $release_id)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling getRelease');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling getRelease');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }// path params
        
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\Release'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * createReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param \SplFileObject $file Upload file in \&quot;multipart/form-data\&quot;. (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\RelFile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility = null)
    {
        list($response, $statusCode, $httpHeader) = $this->createReleaseFileWithHttpInfo ($id_or_name, $package_id, $release_id, $file, $visibility);
        return $response; 
    }


    /**
     * createReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param \SplFileObject $file Upload file in \&quot;multipart/form-data\&quot;. (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\RelFile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function createReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file, $visibility = null)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling createReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling createReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling createReleaseFile');
        }
        // verify the required parameter 'file' is set
        if ($file === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file when calling createReleaseFile');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('multipart/form-data'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }// path params
        
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            
            
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
            
        }// form params
        if ($file !== null) {
            
            // PHP 5.5 introduced a CurlFile object that deprecates the old @filename syntax
            // See: https://wiki.php.net/rfc/curl-file-upload
            if (function_exists('curl_file_create')) {
                $formParams['file'] = curl_file_create($this->apiClient->getSerializer()->toFormValue($file));
            } else {
               $formParams['file'] = '@' . $this->apiClient->getSerializer()->toFormValue($file);
            }
            
            
        }
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'POST',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\RelFile'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\RelFile', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 201:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\RelFile', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * deleteRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteRelease($id_or_name, $package_id, $release_id)
    {
        list($response, $statusCode, $httpHeader) = $this->deleteReleaseWithHttpInfo ($id_or_name, $package_id, $release_id);
        return $response; 
    }


    /**
     * deleteReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteReleaseWithHttpInfo($id_or_name, $package_id, $release_id)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling deleteRelease');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling deleteRelease');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }// path params
        
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'DELETE',
                $queryParams, $httpBody,
                $headerParams
            );
            
            return array(null, $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            }
  
            throw $e;
        }
    }
    
    /**
     * updateRelease
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param string $name Release name (optional)
     * @param string $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param int $move_to_package_id If this parameter is specified, the release move to another package. (optional)
     * @return \OSDN\Model\Release
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateRelease($id_or_name, $package_id, $release_id, $visibility = null, $name = null, $time = null, $move_to_package_id = null)
    {
        list($response, $statusCode, $httpHeader) = $this->updateReleaseWithHttpInfo ($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id);
        return $response; 
    }


    /**
     * updateReleaseWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @param string $name Release name (optional)
     * @param string $time Release datetime. If you set future time, the release hide until specified time. (optional)
     * @param int $move_to_package_id If this parameter is specified, the release move to another package. (optional)
     * @return Array of \OSDN\Model\Release, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateReleaseWithHttpInfo($id_or_name, $package_id, $release_id, $visibility = null, $name = null, $time = null, $move_to_package_id = null)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateRelease');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling updateRelease');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling updateRelease');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }// path params
        
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            
            
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
            
        }// form params
        if ($name !== null) {
            
            
            $formParams['name'] = $this->apiClient->getSerializer()->toFormValue($name);
            
        }// form params
        if ($time !== null) {
            
            
            $formParams['time'] = $this->apiClient->getSerializer()->toFormValue($time);
            
        }// form params
        if ($move_to_package_id !== null) {
            
            
            $formParams['move_to_package_id'] = $this->apiClient->getSerializer()->toFormValue($move_to_package_id);
            
        }
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'PATCH',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\Release'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\Release', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\Release', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * getReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return \OSDN\Model\RelFile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getReleaseFile($id_or_name, $package_id, $release_id, $file_id)
    {
        list($response, $statusCode, $httpHeader) = $this->getReleaseFileWithHttpInfo ($id_or_name, $package_id, $release_id, $file_id);
        return $response; 
    }


    /**
     * getReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return Array of \OSDN\Model\RelFile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function getReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling getReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling getReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling getReleaseFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling getReleaseFile');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }// path params
        
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }// path params
        
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "file_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'GET',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\RelFile'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\RelFile', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\RelFile', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
    /**
     * deleteReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return void
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id)
    {
        list($response, $statusCode, $httpHeader) = $this->deleteReleaseFileWithHttpInfo ($id_or_name, $package_id, $release_id, $file_id);
        return $response; 
    }


    /**
     * deleteReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function deleteReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling deleteReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling deleteReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling deleteReleaseFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling deleteReleaseFile');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }// path params
        
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }// path params
        
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "file_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'DELETE',
                $queryParams, $httpBody,
                $headerParams
            );
            
            return array(null, $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            }
  
            throw $e;
        }
    }
    
    /**
     * updateReleaseFile
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return \OSDN\Model\RelFile
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility = null)
    {
        list($response, $statusCode, $httpHeader) = $this->updateReleaseFileWithHttpInfo ($id_or_name, $package_id, $release_id, $file_id, $visibility);
        return $response; 
    }


    /**
     * updateReleaseFileWithHttpInfo
     *
     * 
     *
     * @param string $id_or_name numeric project id or project name (required)
     * @param int $package_id  (required)
     * @param int $release_id  (required)
     * @param int $file_id  (required)
     * @param string $visibility visibility status (public, hidden or private) (optional)
     * @return Array of \OSDN\Model\RelFile, HTTP status code, HTTP response headers (array of strings)
     * @throws \OSDN\ApiException on non-2xx response
     */
    public function updateReleaseFileWithHttpInfo($id_or_name, $package_id, $release_id, $file_id, $visibility = null)
    {
        
        // verify the required parameter 'id_or_name' is set
        if ($id_or_name === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id_or_name when calling updateReleaseFile');
        }
        // verify the required parameter 'package_id' is set
        if ($package_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $package_id when calling updateReleaseFile');
        }
        // verify the required parameter 'release_id' is set
        if ($release_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $release_id when calling updateReleaseFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling updateReleaseFile');
        }
  
        // parse inputs
        $resourcePath = "/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = ApiClient::selectHeaderAccept(array());
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = ApiClient::selectHeaderContentType(array('application/x-www-form-urlencoded'));
  
        
        
        // path params
        
        if ($id_or_name !== null) {
            $resourcePath = str_replace(
                "{" . "id_or_name" . "}",
                $this->apiClient->getSerializer()->toPathValue($id_or_name),
                $resourcePath
            );
        }// path params
        
        if ($package_id !== null) {
            $resourcePath = str_replace(
                "{" . "package_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($package_id),
                $resourcePath
            );
        }// path params
        
        if ($release_id !== null) {
            $resourcePath = str_replace(
                "{" . "release_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($release_id),
                $resourcePath
            );
        }// path params
        
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "file_id" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // form params
        if ($visibility !== null) {
            
            
            $formParams['visibility'] = $this->apiClient->getSerializer()->toFormValue($visibility);
            
        }
        
  
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath, 'PATCH',
                $queryParams, $httpBody,
                $headerParams, '\OSDN\Model\RelFile'
            );
            
            if (!$response) {
                return array(null, $statusCode, $httpHeader);
            }

            return array(\OSDN\ObjectSerializer::deserialize($response, '\OSDN\Model\RelFile', $httpHeader), $statusCode, $httpHeader);
            
        } catch (ApiException $e) {
            switch ($e->getCode()) { 
            case 200:
                $data = \OSDN\ObjectSerializer::deserialize($e->getResponseBody(), '\OSDN\Model\RelFile', $e->getResponseHeaders());
                $e->setResponseObject($data);
                break;
            }
  
            throw $e;
        }
    }
    
}
