# coding: utf-8

"""
DefaultApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class DefaultApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def token(self, client_id, client_secret, code, **kwargs):
        """
        
        Get access token by access code.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.token(client_id, client_secret, code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: Your application ID (required)
        :param str client_secret: Your application secret (key) (required)
        :param str code: Set auth code issued by https://sf-test-sugi.office.osdn.jp/account/oauth2ui/authorize (required)
        :param str grant_type: You need to set this as \"authorization_code\"
        :return: Token
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'client_secret', 'code', 'grant_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method token" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `token`")
        # verify the required parameter 'client_secret' is set
        if ('client_secret' not in params) or (params['client_secret'] is None):
            raise ValueError("Missing the required parameter `client_secret` when calling `token`")
        # verify the required parameter 'code' is set
        if ('code' not in params) or (params['code'] is None):
            raise ValueError("Missing the required parameter `code` when calling `token`")

        resource_path = '/token'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}
        if 'client_id' in params:
            form_params['client_id'] = params['client_id']
        if 'client_secret' in params:
            form_params['client_secret'] = params['client_secret']
        if 'code' in params:
            form_params['code'] = params['code']
        if 'grant_type' in params:
            form_params['grant_type'] = params['grant_type']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='Token',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
