# coding: utf-8

"""
ProjectNewsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ProjectNewsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def list_news(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int group_id: filter by group ID
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_news" % key
                )
            params[key] = val
        del params['kwargs']


        resource_path = '/news'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'group_id' in params:
            query_params['group_id'] = params['group_id']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='list[News]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_news(self, title, body, group_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news(title, body, group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :param int group_id: group_id the news created in (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['title', 'body', 'group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_news" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_news`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_news`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `create_news`")

        resource_path = '/news'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}
        if 'group_id' in params:
            query_params['group_id'] = params['group_id']

        header_params = {}

        form_params = {}
        files = {}
        if 'title' in params:
            form_params['title'] = params['title']
        if 'body' in params:
            form_params['body'] = params['body']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_news(self, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_news" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `get_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_news(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_news" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `delete_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def update_news(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id', 'title', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_news" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `update_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}
        if 'title' in params:
            form_params['title'] = params['title']
        if 'body' in params:
            form_params['body'] = params['body']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_news_1(self, id_or_name, **kwargs):
        """
        
        Get news list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_1(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_news_1" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_news_1`")

        resource_path = '/project/{id_or_name}/news'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='list[News]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_news_2(self, id_or_name, title, body, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_2(id_or_name, title, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'title', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_news_2" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_news_2`")
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_news_2`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_news_2`")

        resource_path = '/project/{id_or_name}/news'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}
        if 'title' in params:
            form_params['title'] = params['title']
        if 'body' in params:
            form_params['body'] = params['body']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_news_3(self, id_or_name, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_3(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'news_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_news_3" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_news_3`")
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `get_news_3`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_news_4(self, id_or_name, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_4(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'news_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_news_4" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_news_4`")
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `delete_news_4`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def update_news_5(self, news_id, id_or_name, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_5(news_id, id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id', 'id_or_name', 'title', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_news_5" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `update_news_5`")
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_news_5`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}
        if 'title' in params:
            form_params['title'] = params['title']
        if 'body' in params:
            form_params['body'] = params['body']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-implicit']

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
