# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class RelFile(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        RelFile - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'date': 'datetime',
            'url': 'str',
            'visibility': 'str',
            'cascaded_visibility': 'str',
            'release_id': 'int',
            'size': 'int',
            'digest_md5': 'str',
            'digest_sha1': 'str',
            'digest_sha256': 'str',
            'download_count': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date': 'date',
            'url': 'url',
            'visibility': 'visibility',
            'cascaded_visibility': 'cascaded_visibility',
            'release_id': 'release_id',
            'size': 'size',
            'digest_md5': 'digest_md5',
            'digest_sha1': 'digest_sha1',
            'digest_sha256': 'digest_sha256',
            'download_count': 'download_count'
        }

        self._id = None
        self._name = None
        self._date = None
        self._url = None
        self._visibility = None
        self._cascaded_visibility = None
        self._release_id = None
        self._size = None
        self._digest_md5 = None
        self._digest_sha1 = None
        self._digest_sha256 = None
        self._download_count = None

    @property
    def id(self):
        """
        Gets the id of this RelFile.


        :return: The id of this RelFile.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RelFile.


        :param id: The id of this RelFile.
        :type: int
        """
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this RelFile.


        :return: The name of this RelFile.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this RelFile.


        :param name: The name of this RelFile.
        :type: str
        """
        self._name = name

    @property
    def date(self):
        """
        Gets the date of this RelFile.


        :return: The date of this RelFile.
        :rtype: datetime
        """
        return self._date

    @date.setter
    def date(self, date):
        """
        Sets the date of this RelFile.


        :param date: The date of this RelFile.
        :type: datetime
        """
        self._date = date

    @property
    def url(self):
        """
        Gets the url of this RelFile.


        :return: The url of this RelFile.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this RelFile.


        :param url: The url of this RelFile.
        :type: str
        """
        self._url = url

    @property
    def visibility(self):
        """
        Gets the visibility of this RelFile.


        :return: The visibility of this RelFile.
        :rtype: str
        """
        return self._visibility

    @visibility.setter
    def visibility(self, visibility):
        """
        Sets the visibility of this RelFile.


        :param visibility: The visibility of this RelFile.
        :type: str
        """
        self._visibility = visibility

    @property
    def cascaded_visibility(self):
        """
        Gets the cascaded_visibility of this RelFile.


        :return: The cascaded_visibility of this RelFile.
        :rtype: str
        """
        return self._cascaded_visibility

    @cascaded_visibility.setter
    def cascaded_visibility(self, cascaded_visibility):
        """
        Sets the cascaded_visibility of this RelFile.


        :param cascaded_visibility: The cascaded_visibility of this RelFile.
        :type: str
        """
        self._cascaded_visibility = cascaded_visibility

    @property
    def release_id(self):
        """
        Gets the release_id of this RelFile.


        :return: The release_id of this RelFile.
        :rtype: int
        """
        return self._release_id

    @release_id.setter
    def release_id(self, release_id):
        """
        Sets the release_id of this RelFile.


        :param release_id: The release_id of this RelFile.
        :type: int
        """
        self._release_id = release_id

    @property
    def size(self):
        """
        Gets the size of this RelFile.


        :return: The size of this RelFile.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        Sets the size of this RelFile.


        :param size: The size of this RelFile.
        :type: int
        """
        self._size = size

    @property
    def digest_md5(self):
        """
        Gets the digest_md5 of this RelFile.


        :return: The digest_md5 of this RelFile.
        :rtype: str
        """
        return self._digest_md5

    @digest_md5.setter
    def digest_md5(self, digest_md5):
        """
        Sets the digest_md5 of this RelFile.


        :param digest_md5: The digest_md5 of this RelFile.
        :type: str
        """
        self._digest_md5 = digest_md5

    @property
    def digest_sha1(self):
        """
        Gets the digest_sha1 of this RelFile.


        :return: The digest_sha1 of this RelFile.
        :rtype: str
        """
        return self._digest_sha1

    @digest_sha1.setter
    def digest_sha1(self, digest_sha1):
        """
        Sets the digest_sha1 of this RelFile.


        :param digest_sha1: The digest_sha1 of this RelFile.
        :type: str
        """
        self._digest_sha1 = digest_sha1

    @property
    def digest_sha256(self):
        """
        Gets the digest_sha256 of this RelFile.


        :return: The digest_sha256 of this RelFile.
        :rtype: str
        """
        return self._digest_sha256

    @digest_sha256.setter
    def digest_sha256(self, digest_sha256):
        """
        Sets the digest_sha256 of this RelFile.


        :param digest_sha256: The digest_sha256 of this RelFile.
        :type: str
        """
        self._digest_sha256 = digest_sha256

    @property
    def download_count(self):
        """
        Gets the download_count of this RelFile.


        :return: The download_count of this RelFile.
        :rtype: int
        """
        return self._download_count

    @download_count.setter
    def download_count(self, download_count):
        """
        Sets the download_count of this RelFile.


        :param download_count: The download_count of this RelFile.
        :type: int
        """
        self._download_count = download_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

