# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class Release(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Release - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'url': 'str',
            'visibility': 'str',
            'cascaded_visibility': 'str',
            'package_id': 'int',
            'file_count': 'int',
            'is_draft': 'bool',
            '_files': 'list[RelFile]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'url': 'url',
            'visibility': 'visibility',
            'cascaded_visibility': 'cascaded_visibility',
            'package_id': 'package_id',
            'file_count': 'file_count',
            'is_draft': 'is_draft',
            '_files': 'files'
        }

        self._id = None
        self._name = None
        self._url = None
        self._visibility = None
        self._cascaded_visibility = None
        self._package_id = None
        self._file_count = None
        self._is_draft = None
        self.__files = None

    @property
    def id(self):
        """
        Gets the id of this Release.


        :return: The id of this Release.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Release.


        :param id: The id of this Release.
        :type: int
        """
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Release.


        :return: The name of this Release.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Release.


        :param name: The name of this Release.
        :type: str
        """
        self._name = name

    @property
    def url(self):
        """
        Gets the url of this Release.


        :return: The url of this Release.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this Release.


        :param url: The url of this Release.
        :type: str
        """
        self._url = url

    @property
    def visibility(self):
        """
        Gets the visibility of this Release.


        :return: The visibility of this Release.
        :rtype: str
        """
        return self._visibility

    @visibility.setter
    def visibility(self, visibility):
        """
        Sets the visibility of this Release.


        :param visibility: The visibility of this Release.
        :type: str
        """
        self._visibility = visibility

    @property
    def cascaded_visibility(self):
        """
        Gets the cascaded_visibility of this Release.


        :return: The cascaded_visibility of this Release.
        :rtype: str
        """
        return self._cascaded_visibility

    @cascaded_visibility.setter
    def cascaded_visibility(self, cascaded_visibility):
        """
        Sets the cascaded_visibility of this Release.


        :param cascaded_visibility: The cascaded_visibility of this Release.
        :type: str
        """
        self._cascaded_visibility = cascaded_visibility

    @property
    def package_id(self):
        """
        Gets the package_id of this Release.


        :return: The package_id of this Release.
        :rtype: int
        """
        return self._package_id

    @package_id.setter
    def package_id(self, package_id):
        """
        Sets the package_id of this Release.


        :param package_id: The package_id of this Release.
        :type: int
        """
        self._package_id = package_id

    @property
    def file_count(self):
        """
        Gets the file_count of this Release.


        :return: The file_count of this Release.
        :rtype: int
        """
        return self._file_count

    @file_count.setter
    def file_count(self, file_count):
        """
        Sets the file_count of this Release.


        :param file_count: The file_count of this Release.
        :type: int
        """
        self._file_count = file_count

    @property
    def is_draft(self):
        """
        Gets the is_draft of this Release.


        :return: The is_draft of this Release.
        :rtype: bool
        """
        return self._is_draft

    @is_draft.setter
    def is_draft(self, is_draft):
        """
        Sets the is_draft of this Release.


        :param is_draft: The is_draft of this Release.
        :type: bool
        """
        self._is_draft = is_draft

    @property
    def _files(self):
        """
        Gets the _files of this Release.


        :return: The _files of this Release.
        :rtype: list[RelFile]
        """
        return self.__files

    @_files.setter
    def _files(self, _files):
        """
        Sets the _files of this Release.


        :param _files: The _files of this Release.
        :type: list[RelFile]
        """
        self.__files = _files

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

