# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems


class Group(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Group - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'name': 'str',
            'display_name': 'str',
            'last_update': 'datetime',
            'description': 'str',
            'description_html': 'str',
            'start_date': 'datetime',
            'license': 'str',
            'license_other': 'str',
            'url': 'str',
            'homepage': 'str',
            'logo_image': 'str',
            'banner_image': 'str',
            'thumbnail_image': 'str',
            'tools': 'GroupToolFlags',
            'members': 'list[SimpleUser]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'display_name': 'display_name',
            'last_update': 'last_update',
            'description': 'description',
            'description_html': 'description_html',
            'start_date': 'start_date',
            'license': 'license',
            'license_other': 'license_other',
            'url': 'url',
            'homepage': 'homepage',
            'logo_image': 'logo_image',
            'banner_image': 'banner_image',
            'thumbnail_image': 'thumbnail_image',
            'tools': 'tools',
            'members': 'members'
        }

        self._id = None
        self._name = None
        self._display_name = None
        self._last_update = None
        self._description = None
        self._description_html = None
        self._start_date = None
        self._license = None
        self._license_other = None
        self._url = None
        self._homepage = None
        self._logo_image = None
        self._banner_image = None
        self._thumbnail_image = None
        self._tools = None
        self._members = None

    @property
    def id(self):
        """
        Gets the id of this Group.


        :return: The id of this Group.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Group.


        :param id: The id of this Group.
        :type: int
        """
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Group.


        :return: The name of this Group.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Group.


        :param name: The name of this Group.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        Gets the display_name of this Group.


        :return: The display_name of this Group.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Group.


        :param display_name: The display_name of this Group.
        :type: str
        """
        self._display_name = display_name

    @property
    def last_update(self):
        """
        Gets the last_update of this Group.


        :return: The last_update of this Group.
        :rtype: datetime
        """
        return self._last_update

    @last_update.setter
    def last_update(self, last_update):
        """
        Sets the last_update of this Group.


        :param last_update: The last_update of this Group.
        :type: datetime
        """
        self._last_update = last_update

    @property
    def description(self):
        """
        Gets the description of this Group.


        :return: The description of this Group.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Group.


        :param description: The description of this Group.
        :type: str
        """
        self._description = description

    @property
    def description_html(self):
        """
        Gets the description_html of this Group.


        :return: The description_html of this Group.
        :rtype: str
        """
        return self._description_html

    @description_html.setter
    def description_html(self, description_html):
        """
        Sets the description_html of this Group.


        :param description_html: The description_html of this Group.
        :type: str
        """
        self._description_html = description_html

    @property
    def start_date(self):
        """
        Gets the start_date of this Group.


        :return: The start_date of this Group.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this Group.


        :param start_date: The start_date of this Group.
        :type: datetime
        """
        self._start_date = start_date

    @property
    def license(self):
        """
        Gets the license of this Group.


        :return: The license of this Group.
        :rtype: str
        """
        return self._license

    @license.setter
    def license(self, license):
        """
        Sets the license of this Group.


        :param license: The license of this Group.
        :type: str
        """
        self._license = license

    @property
    def license_other(self):
        """
        Gets the license_other of this Group.


        :return: The license_other of this Group.
        :rtype: str
        """
        return self._license_other

    @license_other.setter
    def license_other(self, license_other):
        """
        Sets the license_other of this Group.


        :param license_other: The license_other of this Group.
        :type: str
        """
        self._license_other = license_other

    @property
    def url(self):
        """
        Gets the url of this Group.


        :return: The url of this Group.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this Group.


        :param url: The url of this Group.
        :type: str
        """
        self._url = url

    @property
    def homepage(self):
        """
        Gets the homepage of this Group.


        :return: The homepage of this Group.
        :rtype: str
        """
        return self._homepage

    @homepage.setter
    def homepage(self, homepage):
        """
        Sets the homepage of this Group.


        :param homepage: The homepage of this Group.
        :type: str
        """
        self._homepage = homepage

    @property
    def logo_image(self):
        """
        Gets the logo_image of this Group.


        :return: The logo_image of this Group.
        :rtype: str
        """
        return self._logo_image

    @logo_image.setter
    def logo_image(self, logo_image):
        """
        Sets the logo_image of this Group.


        :param logo_image: The logo_image of this Group.
        :type: str
        """
        self._logo_image = logo_image

    @property
    def banner_image(self):
        """
        Gets the banner_image of this Group.


        :return: The banner_image of this Group.
        :rtype: str
        """
        return self._banner_image

    @banner_image.setter
    def banner_image(self, banner_image):
        """
        Sets the banner_image of this Group.


        :param banner_image: The banner_image of this Group.
        :type: str
        """
        self._banner_image = banner_image

    @property
    def thumbnail_image(self):
        """
        Gets the thumbnail_image of this Group.


        :return: The thumbnail_image of this Group.
        :rtype: str
        """
        return self._thumbnail_image

    @thumbnail_image.setter
    def thumbnail_image(self, thumbnail_image):
        """
        Sets the thumbnail_image of this Group.


        :param thumbnail_image: The thumbnail_image of this Group.
        :type: str
        """
        self._thumbnail_image = thumbnail_image

    @property
    def tools(self):
        """
        Gets the tools of this Group.


        :return: The tools of this Group.
        :rtype: GroupToolFlags
        """
        return self._tools

    @tools.setter
    def tools(self, tools):
        """
        Sets the tools of this Group.


        :param tools: The tools of this Group.
        :type: GroupToolFlags
        """
        self._tools = tools

    @property
    def members(self):
        """
        Gets the members of this Group.


        :return: The members of this Group.
        :rtype: list[SimpleUser]
        """
        return self._members

    @members.setter
    def members(self, members):
        """
        Sets the members of this Group.


        :param members: The members of this Group.
        :type: list[SimpleUser]
        """
        self._members = members

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other): 
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """ 
        Returns true if both objects are not equal
        """
        return not self == other

