# OSDNClient.DefaultApi

All URIs are relative to *https://osdn.jp/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ping**](DefaultApi.md#ping) | **GET** /ping | 
[**token**](DefaultApi.md#token) | **POST** /token | 


<a name="ping"></a>
# **ping**
> Pong ping()



return pong for test 

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.DefaultApi();

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.ping(callback);
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**Pong**](Pong.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="token"></a>
# **token**
> Token token(clientId, clientSecret, opts)



Get access token by access code.

### Example
```javascript
var OSDNClient = require('osdn-client');

var apiInstance = new OSDNClient.DefaultApi();

var clientId = "clientId_example"; // String | Your application ID

var clientSecret = "clientSecret_example"; // String | Your application secret (key)

var opts = { 
  'grantType': "authorization_code", // String | \"authorization_code\" or \"refresh_token\"
  'code': "code_example", // String | Set auth code issued by https://osdn.jp/account/oauth2ui/authorize for grant_type=authorization_code
  'refreshToken': "refreshToken_example" // String | Set refresh token to update access token.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.token(clientId, clientSecret, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **clientId** | **String**| Your application ID | 
 **clientSecret** | **String**| Your application secret (key) | 
 **grantType** | **String**| \&quot;authorization_code\&quot; or \&quot;refresh_token\&quot; | [optional] [default to authorization_code]
 **code** | **String**| Set auth code issued by https://osdn.jp/account/oauth2ui/authorize for grant_type&#x3D;authorization_code | [optional] 
 **refreshToken** | **String**| Set refresh token to update access token. | [optional] 

### Return type

[**Token**](Token.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

