# OSDNClient.ProjectFrsApi

All URIs are relative to *https://osdn.jp/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createPackage**](ProjectFrsApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
[**createRelease**](ProjectFrsApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
[**createReleaseFile**](ProjectFrsApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deletePackage**](ProjectFrsApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
[**deleteRelease**](ProjectFrsApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteReleaseFile**](ProjectFrsApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**draftRelease**](ProjectFrsApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
[**getPackage**](ProjectFrsApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
[**getRelease**](ProjectFrsApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**getReleaseFile**](ProjectFrsApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**listPackages**](ProjectFrsApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
[**updatePackage**](ProjectFrsApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
[**updateRelease**](ProjectFrsApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**updateReleaseFile**](ProjectFrsApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 


<a name="createPackage"></a>
# **createPackage**
> ModelPackage createPackage(idOrName, name, opts)



Create a package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | package name

var opts = { 
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createPackage(idOrName, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| package name | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**ModelPackage**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createRelease"></a>
# **createRelease**
> Release createRelease(idOrName, packageId, name, opts)



Create new release in specified package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var name = "name_example"; // String | Release name

var opts = { 
  'visibility': "visibility_example", // String | visibility status (public, hidden or private)
  'time': "time_example", // String | Release datetime. If you set future time, the release hide until specified time.
  'releaseNote': "releaseNote_example", // String | Release note body text.
  'changeLog': "changeLog_example" // String | Changelog body text.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createRelease(idOrName, packageId, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **name** | **String**| Release name | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 
 **time** | **String**| Release datetime. If you set future time, the release hide until specified time. | [optional] 
 **releaseNote** | **String**| Release note body text. | [optional] 
 **changeLog** | **String**| Changelog body text. | [optional] 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createReleaseFile"></a>
# **createReleaseFile**
> RelFile createReleaseFile(idOrName, packageId, releaseId, file, opts)



Create new file in target release.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var file = "/path/to/file.txt"; // File | Upload file in \"multipart/form-data\".

var opts = { 
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createReleaseFile(idOrName, packageId, releaseId, file, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **file** | **File**| Upload file in \&quot;multipart/form-data\&quot;. | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**RelFile**](RelFile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: Not defined

<a name="deletePackage"></a>
# **deletePackage**
> deletePackage(idOrName, packageId)



Delete taret package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deletePackage(idOrName, packageId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteRelease"></a>
# **deleteRelease**
> deleteRelease(idOrName, packageId, releaseId)



Delete target release.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteRelease(idOrName, packageId, releaseId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteReleaseFile"></a>
# **deleteReleaseFile**
> deleteReleaseFile(idOrName, packageId, releaseId, fileId)



Delete target file.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var fileId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteReleaseFile(idOrName, packageId, releaseId, fileId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **fileId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="draftRelease"></a>
# **draftRelease**
> Release draftRelease(idOrName, packageId)



Get release draft in specified package. If draft is not exist, it will be created automatically.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.draftRelease(idOrName, packageId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getPackage"></a>
# **getPackage**
> ModelPackage getPackage(idOrName, packageId)



Get specified package info and release list of the package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getPackage(idOrName, packageId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 

### Return type

[**ModelPackage**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getRelease"></a>
# **getRelease**
> Release getRelease(idOrName, packageId, releaseId)



Get specified release info and file list of the release.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getRelease(idOrName, packageId, releaseId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getReleaseFile"></a>
# **getReleaseFile**
> RelFile getReleaseFile(idOrName, packageId, releaseId, fileId)



Get single file object.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var fileId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getReleaseFile(idOrName, packageId, releaseId, fileId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **fileId** | **Integer**|  | 

### Return type

[**RelFile**](RelFile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listPackages"></a>
# **listPackages**
> [ModelPackage] listPackages(idOrName)



Get package list of specified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listPackages(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ModelPackage]**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updatePackage"></a>
# **updatePackage**
> ModelPackage updatePackage(idOrName, packageId, opts)



Update tagret package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var opts = { 
  'name': "name_example", // String | package name
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updatePackage(idOrName, packageId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **name** | **String**| package name | [optional] 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**ModelPackage**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateRelease"></a>
# **updateRelease**
> Release updateRelease(idOrName, packageId, releaseId, opts)



Update target release. (Note: If you update draft release, the release will be public automatically.) 

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var opts = { 
  'visibility': "visibility_example", // String | visibility status (public, hidden or private)
  'name': "name_example", // String | Release name
  'time': "time_example", // String | Release datetime. If you set future time, the release hide until specified time.
  'moveToPackageId': 56 // Integer | If this parameter is specified, the release move to another package.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateRelease(idOrName, packageId, releaseId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 
 **name** | **String**| Release name | [optional] 
 **time** | **String**| Release datetime. If you set future time, the release hide until specified time. | [optional] 
 **moveToPackageId** | **Integer**| If this parameter is specified, the release move to another package. | [optional] 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateReleaseFile"></a>
# **updateReleaseFile**
> RelFile updateReleaseFile(idOrName, packageId, releaseId, fileId, opts)



Change visibility of target file.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectFrsApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var fileId = 56; // Integer | 

var opts = { 
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateReleaseFile(idOrName, packageId, releaseId, fileId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **fileId** | **Integer**|  | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**RelFile**](RelFile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

