/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.jp/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.jp/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20160304
 * Contact: admin@osdn.jp
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/ModelPackage', 'OSDN/OSDN\Model/Release', 'OSDN/OSDN\Model/RelFile'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../OSDN\Model/ModelPackage'), require('../OSDN\Model/Release'), require('../OSDN\Model/RelFile'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.ProjectFrsApi = factory(root.OSDNClient.ApiClient, root.OSDNClient.ModelPackage, root.OSDNClient.Release, root.OSDNClient.RelFile);
  }
}(this, function(ApiClient, ModelPackage, Release, RelFile) {
  'use strict';

  /**
   * ProjectFrs service.
   * @module OSDN/OSDN\Api/ProjectFrsApi
   * @version 0.0.20160711
   */

  /**
   * Constructs a new ProjectFrsApi. 
   * @alias module:OSDN/OSDN\Api/ProjectFrsApi
   * @class
   * @param {module:OSDN/ApiClient} apiClient Optional API client implementation to use,
   * default to {@link module:OSDN/ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the createPackage operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~createPackageCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ModelPackage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a package.
     * @param {String} idOrName numeric project id or project name
     * @param {String} name package name
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~createPackageCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ModelPackage}
     */
    this.createPackage = function(idOrName, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createPackage";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createPackage";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'visibility': opts['visibility']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ModelPackage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~createReleaseCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Release} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new release in specified package.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {String} name Release name
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {String} opts.time Release datetime. If you set future time, the release hide until specified time.
     * @param {String} opts.releaseNote Release note body text.
     * @param {String} opts.changeLog Changelog body text.
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~createReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Release}
     */
    this.createRelease = function(idOrName, packageId, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling createRelease";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'visibility': opts['visibility'],
        'name': name,
        'time': opts['time'],
        'release_note': opts['releaseNote'],
        'change_log': opts['changeLog']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Release;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createReleaseFile operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~createReleaseFileCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/RelFile} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new file in target release.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {File} file Upload file in \&quot;multipart/form-data\&quot;.
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~createReleaseFileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/RelFile}
     */
    this.createReleaseFile = function(idOrName, packageId, releaseId, file, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createReleaseFile";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling createReleaseFile";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling createReleaseFile";
      }

      // verify the required parameter 'file' is set
      if (file == undefined || file == null) {
        throw "Missing the required parameter 'file' when calling createReleaseFile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'visibility': opts['visibility'],
        'file': file
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['multipart/form-data'];
      var accepts = [];
      var returnType = RelFile;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deletePackage operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~deletePackageCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete taret package.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~deletePackageCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deletePackage = function(idOrName, packageId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deletePackage";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling deletePackage";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~deleteReleaseCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete target release.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~deleteReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteRelease = function(idOrName, packageId, releaseId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling deleteRelease";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling deleteRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteReleaseFile operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~deleteReleaseFileCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete target file.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {Integer} fileId 
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~deleteReleaseFileCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteReleaseFile = function(idOrName, packageId, releaseId, fileId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteReleaseFile";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling deleteReleaseFile";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling deleteReleaseFile";
      }

      // verify the required parameter 'fileId' is set
      if (fileId == undefined || fileId == null) {
        throw "Missing the required parameter 'fileId' when calling deleteReleaseFile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId,
        'file_id': fileId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the draftRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~draftReleaseCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Release} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get release draft in specified package. If draft is not exist, it will be created automatically.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~draftReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Release}
     */
    this.draftRelease = function(idOrName, packageId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling draftRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling draftRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Release;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/draft', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getPackage operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~getPackageCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ModelPackage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get specified package info and release list of the package.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~getPackageCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ModelPackage}
     */
    this.getPackage = function(idOrName, packageId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getPackage";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling getPackage";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ModelPackage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~getReleaseCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Release} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get specified release info and file list of the release.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~getReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Release}
     */
    this.getRelease = function(idOrName, packageId, releaseId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling getRelease";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling getRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Release;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getReleaseFile operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~getReleaseFileCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/RelFile} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get single file object.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {Integer} fileId 
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~getReleaseFileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/RelFile}
     */
    this.getReleaseFile = function(idOrName, packageId, releaseId, fileId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getReleaseFile";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling getReleaseFile";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling getReleaseFile";
      }

      // verify the required parameter 'fileId' is set
      if (fileId == undefined || fileId == null) {
        throw "Missing the required parameter 'fileId' when calling getReleaseFile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId,
        'file_id': fileId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = RelFile;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listPackages operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~listPackagesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ModelPackage>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get package list of specified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~listPackagesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ModelPackage>}
     */
    this.listPackages = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listPackages";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ModelPackage];

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updatePackage operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~updatePackageCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ModelPackage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update tagret package.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.name package name
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~updatePackageCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ModelPackage}
     */
    this.updatePackage = function(idOrName, packageId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updatePackage";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling updatePackage";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'visibility': opts['visibility']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ModelPackage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~updateReleaseCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Release} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update target release. (Note: If you update draft release, the release will be public automatically.) 
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {String} opts.name Release name
     * @param {String} opts.time Release datetime. If you set future time, the release hide until specified time.
     * @param {Integer} opts.moveToPackageId If this parameter is specified, the release move to another package.
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~updateReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Release}
     */
    this.updateRelease = function(idOrName, packageId, releaseId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling updateRelease";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling updateRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'visibility': opts['visibility'],
        'name': opts['name'],
        'time': opts['time'],
        'move_to_package_id': opts['moveToPackageId']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Release;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateReleaseFile operation.
     * @callback module:OSDN/OSDN\Api/ProjectFrsApi~updateReleaseFileCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/RelFile} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Change visibility of target file.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {Integer} fileId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {module:OSDN/OSDN\Api/ProjectFrsApi~updateReleaseFileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/RelFile}
     */
    this.updateReleaseFile = function(idOrName, packageId, releaseId, fileId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateReleaseFile";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling updateReleaseFile";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling updateReleaseFile";
      }

      // verify the required parameter 'fileId' is set
      if (fileId == undefined || fileId == null) {
        throw "Missing the required parameter 'fileId' when calling updateReleaseFile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId,
        'file_id': fileId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'visibility': opts['visibility']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = RelFile;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
