/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.jp/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.jp/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20160304
 * Contact: admin@osdn.jp
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/SimpleUser'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./SimpleUser'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.News = factory(root.OSDNClient.ApiClient, root.OSDNClient.SimpleUser);
  }
}(this, function(ApiClient, SimpleUser) {
  'use strict';




  /**
   * The News model module.
   * @module OSDN/OSDN\Model/News
   * @version 0.0.20160711
   */

  /**
   * Constructs a new <code>News</code>.
   * @alias module:OSDN/OSDN\Model/News
   * @class
   */
  var exports = function() {
    var _this = this;








  };

  /**
   * Constructs a <code>News</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:OSDN/OSDN\Model/News} obj Optional instance to populate.
   * @return {module:OSDN/OSDN\Model/News} The populated <code>News</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('id')) {
        obj['id'] = ApiClient.convertToType(data['id'], 'Integer');
      }
      if (data.hasOwnProperty('url')) {
        obj['url'] = ApiClient.convertToType(data['url'], 'String');
      }
      if (data.hasOwnProperty('title')) {
        obj['title'] = ApiClient.convertToType(data['title'], 'String');
      }
      if (data.hasOwnProperty('body')) {
        obj['body'] = ApiClient.convertToType(data['body'], 'String');
      }
      if (data.hasOwnProperty('body_html')) {
        obj['body_html'] = ApiClient.convertToType(data['body_html'], 'String');
      }
      if (data.hasOwnProperty('last_update')) {
        obj['last_update'] = ApiClient.convertToType(data['last_update'], 'Date');
      }
      if (data.hasOwnProperty('submitter')) {
        obj['submitter'] = SimpleUser.constructFromObject(data['submitter']);
      }
    }
    return obj;
  }

  /**
   * @member {Integer} id
   */
  exports.prototype['id'] = undefined;
  /**
   * @member {String} url
   */
  exports.prototype['url'] = undefined;
  /**
   * @member {String} title
   */
  exports.prototype['title'] = undefined;
  /**
   * @member {String} body
   */
  exports.prototype['body'] = undefined;
  /**
   * @member {String} body_html
   */
  exports.prototype['body_html'] = undefined;
  /**
   * @member {Date} last_update
   */
  exports.prototype['last_update'] = undefined;
  /**
   * @member {module:OSDN/OSDN\Model/SimpleUser} submitter
   */
  exports.prototype['submitter'] = undefined;



  return exports;
}));


