# OSDN\ProjectApi

All URIs are relative to *https://osdn.jp/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createNews**](ProjectApi.md#createNews) | **POST** /news | 
[**createNews_0**](ProjectApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
[**createPackage**](ProjectApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
[**createRelease**](ProjectApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
[**createReleaseFile**](ProjectApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteNews**](ProjectApi.md#deleteNews) | **DELETE** /news/{news_id} | 
[**deleteNews_0**](ProjectApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
[**deletePackage**](ProjectApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
[**deleteRelease**](ProjectApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteReleaseFile**](ProjectApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**draftRelease**](ProjectApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
[**getNews**](ProjectApi.md#getNews) | **GET** /news/{news_id} | 
[**getNews_0**](ProjectApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
[**getPackage**](ProjectApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
[**getProject**](ProjectApi.md#getProject) | **GET** /project/{id_or_name} | 
[**getRelease**](ProjectApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**getReleaseFile**](ProjectApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**listNews**](ProjectApi.md#listNews) | **GET** /news | 
[**listNews_0**](ProjectApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
[**listPackages**](ProjectApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
[**updateNews**](ProjectApi.md#updateNews) | **PATCH** /news/{news_id} | 
[**updateNews_0**](ProjectApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
[**updatePackage**](ProjectApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
[**updateRelease**](ProjectApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**updateReleaseFile**](ProjectApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 


# **createNews**
> string createNews($title, $body, $group_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.
$group_id = 56; // int | group_id the news created in

try {
    $result = $api_instance->createNews($title, $body, $group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **title** | **string**| news title |
 **body** | **string**| news body in OSDN Wiki format. |
 **group_id** | **int**| group_id the news created in |

### Return type

**string**

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createNews_0**
> string createNews_0($id_or_name, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->createNews_0($id_or_name, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **title** | **string**| news title |
 **body** | **string**| news body in OSDN Wiki format. |

### Return type

**string**

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createPackage**
> \OSDN\Model\Package createPackage($id_or_name, $name, $visibility)



Create a package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | package name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->createPackage($id_or_name, $name, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| package name |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createRelease**
> \OSDN\Model\Release createRelease($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log)



Create new release in specified package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$name = "name_example"; // string | Release name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)
$time = "time_example"; // string | Release datetime. If you set future time, the release hide until specified time.
$release_note = "release_note_example"; // string | Release note body text.
$change_log = "change_log_example"; // string | Changelog body text.

try {
    $result = $api_instance->createRelease($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **name** | **string**| Release name |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]
 **time** | **string**| Release datetime. If you set future time, the release hide until specified time. | [optional]
 **release_note** | **string**| Release note body text. | [optional]
 **change_log** | **string**| Changelog body text. | [optional]

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createReleaseFile**
> \OSDN\Model\RelFile createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility)



Create new file in target release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file = "/path/to/file.txt"; // \SplFileObject | Upload file in \"multipart/form-data\".
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file** | **\SplFileObject**| Upload file in \&quot;multipart/form-data\&quot;. |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteNews**
> deleteNews($news_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 

try {
    $api_instance->deleteNews($news_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteNews_0**
> deleteNews_0($id_or_name, $news_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$news_id = 56; // int | 

try {
    $api_instance->deleteNews_0($id_or_name, $news_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **news_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deletePackage**
> deletePackage($id_or_name, $package_id)



Delete taret package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $api_instance->deletePackage($id_or_name, $package_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deletePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRelease**
> deleteRelease($id_or_name, $package_id, $release_id)



Delete target release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 

try {
    $api_instance->deleteRelease($id_or_name, $package_id, $release_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteReleaseFile**
> deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id)



Delete target file.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 

try {
    $api_instance->deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **draftRelease**
> \OSDN\Model\Release draftRelease($id_or_name, $package_id)



Get release draft in specified package. If draft is not exist, it will be created automatically.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $result = $api_instance->draftRelease($id_or_name, $package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->draftRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNews**
> \OSDN\Model\News getNews($news_id)



Get single news object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 

try {
    $result = $api_instance->getNews($news_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNews_0**
> \OSDN\Model\News getNews_0($id_or_name, $news_id)



Get single news object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$news_id = 56; // int | 

try {
    $result = $api_instance->getNews_0($id_or_name, $news_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **news_id** | **int**|  |

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackage**
> \OSDN\Model\Package getPackage($id_or_name, $package_id)



Get specified package info and release list of the package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $result = $api_instance->getPackage($id_or_name, $package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProject**
> \OSDN\Model\Group getProject($id_or_name)



Get project info.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProject($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProject: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\Group**](../Model/Group.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRelease**
> \OSDN\Model\Release getRelease($id_or_name, $package_id, $release_id)



Get specified release info and file list of the release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 

try {
    $result = $api_instance->getRelease($id_or_name, $package_id, $release_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReleaseFile**
> \OSDN\Model\RelFile getReleaseFile($id_or_name, $package_id, $release_id, $file_id)



Get single file object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 

try {
    $result = $api_instance->getReleaseFile($id_or_name, $package_id, $release_id, $file_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listNews**
> \OSDN\Model\News[] listNews($group_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$group_id = 56; // int | filter by group ID

try {
    $result = $api_instance->listNews($group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_id** | **int**| filter by group ID | [optional]

### Return type

[**\OSDN\Model\News[]**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listNews_0**
> \OSDN\Model\News[] listNews_0($id_or_name)



Get news list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listNews_0($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\News[]**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listPackages**
> \OSDN\Model\Package[] listPackages($id_or_name)



Get package list of specified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listPackages($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listPackages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\Package[]**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateNews**
> \OSDN\Model\News updateNews($news_id, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->updateNews($news_id, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |
 **title** | **string**| news title | [optional]
 **body** | **string**| news body in OSDN Wiki format. | [optional]

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateNews_0**
> \OSDN\Model\News updateNews_0($news_id, $id_or_name, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->updateNews_0($news_id, $id_or_name, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |
 **id_or_name** | **string**| numeric project id or project name |
 **title** | **string**| news title | [optional]
 **body** | **string**| news body in OSDN Wiki format. | [optional]

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updatePackage**
> \OSDN\Model\Package updatePackage($id_or_name, $package_id, $name, $visibility)



Update tagret package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$name = "name_example"; // string | package name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->updatePackage($id_or_name, $package_id, $name, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updatePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **name** | **string**| package name | [optional]
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateRelease**
> \OSDN\Model\Release updateRelease($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id)



Update target release. (Note: If you update draft release, the release will be public automatically.)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)
$name = "name_example"; // string | Release name
$time = "time_example"; // string | Release datetime. If you set future time, the release hide until specified time.
$move_to_package_id = 56; // int | If this parameter is specified, the release move to another package.

try {
    $result = $api_instance->updateRelease($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]
 **name** | **string**| Release name | [optional]
 **time** | **string**| Release datetime. If you set future time, the release hide until specified time. | [optional]
 **move_to_package_id** | **int**| If this parameter is specified, the release move to another package. | [optional]

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateReleaseFile**
> \OSDN\Model\RelFile updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility)



Change visibility of target file.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

