# OSDN\ProjectNewsApi

All URIs are relative to *https://osdn.jp/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createNews**](ProjectNewsApi.md#createNews) | **POST** /news | 
[**createNews_0**](ProjectNewsApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
[**deleteNews**](ProjectNewsApi.md#deleteNews) | **DELETE** /news/{news_id} | 
[**deleteNews_0**](ProjectNewsApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
[**getNews**](ProjectNewsApi.md#getNews) | **GET** /news/{news_id} | 
[**getNews_0**](ProjectNewsApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
[**listNews**](ProjectNewsApi.md#listNews) | **GET** /news | 
[**listNews_0**](ProjectNewsApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
[**updateNews**](ProjectNewsApi.md#updateNews) | **PATCH** /news/{news_id} | 
[**updateNews_0**](ProjectNewsApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 


# **createNews**
> string createNews($title, $body, $group_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.
$group_id = 56; // int | group_id the news created in

try {
    $result = $api_instance->createNews($title, $body, $group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->createNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **title** | **string**| news title |
 **body** | **string**| news body in OSDN Wiki format. |
 **group_id** | **int**| group_id the news created in |

### Return type

**string**

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createNews_0**
> string createNews_0($id_or_name, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->createNews_0($id_or_name, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->createNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **title** | **string**| news title |
 **body** | **string**| news body in OSDN Wiki format. |

### Return type

**string**

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteNews**
> deleteNews($news_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$news_id = 56; // int | 

try {
    $api_instance->deleteNews($news_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->deleteNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteNews_0**
> deleteNews_0($id_or_name, $news_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$news_id = 56; // int | 

try {
    $api_instance->deleteNews_0($id_or_name, $news_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->deleteNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **news_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNews**
> \OSDN\Model\News getNews($news_id)



Get single news object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$news_id = 56; // int | 

try {
    $result = $api_instance->getNews($news_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->getNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNews_0**
> \OSDN\Model\News getNews_0($id_or_name, $news_id)



Get single news object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$news_id = 56; // int | 

try {
    $result = $api_instance->getNews_0($id_or_name, $news_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->getNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **news_id** | **int**|  |

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listNews**
> \OSDN\Model\News[] listNews($group_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$group_id = 56; // int | filter by group ID

try {
    $result = $api_instance->listNews($group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->listNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_id** | **int**| filter by group ID | [optional]

### Return type

[**\OSDN\Model\News[]**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listNews_0**
> \OSDN\Model\News[] listNews_0($id_or_name)



Get news list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listNews_0($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->listNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\News[]**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateNews**
> \OSDN\Model\News updateNews($news_id, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$news_id = 56; // int | 
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->updateNews($news_id, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->updateNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |
 **title** | **string**| news title | [optional]
 **body** | **string**| news body in OSDN Wiki format. | [optional]

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateNews_0**
> \OSDN\Model\News updateNews_0($news_id, $id_or_name, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectNewsApi();
$news_id = 56; // int | 
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->updateNews_0($news_id, $id_or_name, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectNewsApi->updateNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |
 **id_or_name** | **string**| numeric project id or project name |
 **title** | **string**| news title | [optional]
 **body** | **string**| news body in OSDN Wiki format. | [optional]

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

