# coding: utf-8

"""
    OSDN REST API v0 beta

    OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.jp/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.jp/projects/osdn-codes/releases/p14859 . 

    OpenAPI spec version: 0.0.20160304
    Contact: admin@osdn.jp
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ProjectNewsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_news(self, title, body, group_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news(title, body, group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :param int group_id: group_id the news created in (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_news_with_http_info(title, body, group_id, **kwargs)
        else:
            (data) = self.create_news_with_http_info(title, body, group_id, **kwargs)
            return data

    def create_news_with_http_info(self, title, body, group_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_with_http_info(title, body, group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :param int group_id: group_id the news created in (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['title', 'body', 'group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_news`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_news`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `create_news`")

        resource_path = '/news'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'group_id' in params:
            query_params['group_id'] = params['group_id']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_news_0(self, id_or_name, title, body, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_0(id_or_name, title, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_news_0_with_http_info(id_or_name, title, body, **kwargs)
        else:
            (data) = self.create_news_0_with_http_info(id_or_name, title, body, **kwargs)
            return data

    def create_news_0_with_http_info(self, id_or_name, title, body, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_0_with_http_info(id_or_name, title, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'title', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_news_0`")
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_news_0`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_news_0`")

        resource_path = '/project/{id_or_name}/news'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_news(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_news_with_http_info(news_id, **kwargs)
        else:
            (data) = self.delete_news_with_http_info(news_id, **kwargs)
            return data

    def delete_news_with_http_info(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_with_http_info(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `delete_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_news_0(self, id_or_name, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_0(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_news_0_with_http_info(id_or_name, news_id, **kwargs)
        else:
            (data) = self.delete_news_0_with_http_info(id_or_name, news_id, **kwargs)
            return data

    def delete_news_0_with_http_info(self, id_or_name, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_0_with_http_info(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_news_0`")
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `delete_news_0`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_news(self, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_news_with_http_info(news_id, **kwargs)
        else:
            (data) = self.get_news_with_http_info(news_id, **kwargs)
            return data

    def get_news_with_http_info(self, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_with_http_info(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `get_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_news_0(self, id_or_name, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_0(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_news_0_with_http_info(id_or_name, news_id, **kwargs)
        else:
            (data) = self.get_news_0_with_http_info(id_or_name, news_id, **kwargs)
            return data

    def get_news_0_with_http_info(self, id_or_name, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_0_with_http_info(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_news_0`")
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `get_news_0`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_news(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int group_id: filter by group ID
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_news_with_http_info(**kwargs)
        else:
            (data) = self.list_news_with_http_info(**kwargs)
            return data

    def list_news_with_http_info(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int group_id: filter by group ID
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_news" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/news'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'group_id' in params:
            query_params['group_id'] = params['group_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[News]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_news_0(self, id_or_name, **kwargs):
        """
        
        Get news list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_0(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_news_0_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_news_0_with_http_info(id_or_name, **kwargs)
            return data

    def list_news_0_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get news list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_0_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_news_0`")

        resource_path = '/project/{id_or_name}/news'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[News]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_news(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_news_with_http_info(news_id, **kwargs)
        else:
            (data) = self.update_news_with_http_info(news_id, **kwargs)
            return data

    def update_news_with_http_info(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_with_http_info(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id', 'title', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `update_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_news_0(self, news_id, id_or_name, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_0(news_id, id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_news_0_with_http_info(news_id, id_or_name, **kwargs)
        else:
            (data) = self.update_news_0_with_http_info(news_id, id_or_name, **kwargs)
            return data

    def update_news_0_with_http_info(self, news_id, id_or_name, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_0_with_http_info(news_id, id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id', 'id_or_name', 'title', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `update_news_0`")
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_news_0`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
