# OSDNClient.ProjectSCMApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createProjectBzr**](ProjectSCMApi.md#createProjectBzr) | **POST** /project/{id_or_name}/bzr | 
[**createProjectGit**](ProjectSCMApi.md#createProjectGit) | **POST** /project/{id_or_name}/git | 
[**createProjectGitHook**](ProjectSCMApi.md#createProjectGitHook) | **POST** /project/{id_or_name}/git/{repo_id}/hooks | 
[**createProjectHg**](ProjectSCMApi.md#createProjectHg) | **POST** /project/{id_or_name}/hg | 
[**deleteProjectGitHook**](ProjectSCMApi.md#deleteProjectGitHook) | **DELETE** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**disableProjectBzr**](ProjectSCMApi.md#disableProjectBzr) | **DELETE** /project/{id_or_name}/bzr/{repo_id} | 
[**disableProjectGit**](ProjectSCMApi.md#disableProjectGit) | **DELETE** /project/{id_or_name}/git/{repo_id} | 
[**disableProjectHg**](ProjectSCMApi.md#disableProjectHg) | **DELETE** /project/{id_or_name}/hg/{repo_id} | 
[**getProjectBzr**](ProjectSCMApi.md#getProjectBzr) | **GET** /project/{id_or_name}/bzr/{repo_id} | 
[**getProjectGit**](ProjectSCMApi.md#getProjectGit) | **GET** /project/{id_or_name}/git/{repo_id} | 
[**getProjectGitHook**](ProjectSCMApi.md#getProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**getProjectHg**](ProjectSCMApi.md#getProjectHg) | **GET** /project/{id_or_name}/hg/{repo_id} | 
[**getProjectSvn**](ProjectSCMApi.md#getProjectSvn) | **GET** /project/{id_or_name}/svn | 
[**listProjectBzr**](ProjectSCMApi.md#listProjectBzr) | **GET** /project/{id_or_name}/bzr | 
[**listProjectGit**](ProjectSCMApi.md#listProjectGit) | **GET** /project/{id_or_name}/git | 
[**listProjectGitHook**](ProjectSCMApi.md#listProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks | 
[**listProjectHg**](ProjectSCMApi.md#listProjectHg) | **GET** /project/{id_or_name}/hg | 
[**updateProjectBzr**](ProjectSCMApi.md#updateProjectBzr) | **PATCH** /project/{id_or_name}/bzr/{repo_id} | 
[**updateProjectGit**](ProjectSCMApi.md#updateProjectGit) | **PATCH** /project/{id_or_name}/git/{repo_id} | 
[**updateProjectHg**](ProjectSCMApi.md#updateProjectHg) | **PATCH** /project/{id_or_name}/hg/{repo_id} | 


<a name="createProjectBzr"></a>
# **createProjectBzr**
> ProjectBzr createProjectBzr(idOrName, name, opts)



Create a new bzr repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | 

var opts = { 
  'description': "description_example" // String | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectBzr(idOrName, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**|  | 
 **description** | **String**|  | [optional] 

### Return type

[**ProjectBzr**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectGit"></a>
# **createProjectGit**
> ProjectGit createProjectGit(idOrName, name, opts)



Create a new git repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | 

var opts = { 
  'description': "description_example", // String | 
  'mailEnabled': true, // Boolean | 
  'mailRecipients': "mailRecipients_example", // String | 
  'allowNonFastForward': true, // Boolean | 
  'defaultBranch': "defaultBranch_example" // String | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectGit(idOrName, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**|  | 
 **description** | **String**|  | [optional] 
 **mailEnabled** | **Boolean**|  | [optional] 
 **mailRecipients** | **String**|  | [optional] 
 **allowNonFastForward** | **Boolean**|  | [optional] 
 **defaultBranch** | **String**|  | [optional] 

### Return type

[**ProjectGit**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectGitHook"></a>
# **createProjectGitHook**
> ScmHook createProjectGitHook(idOrName, repoId, targetUrl)



Create a new hook for project git repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var targetUrl = "targetUrl_example"; // String | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectGitHook(idOrName, repoId, targetUrl, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **targetUrl** | **String**|  | 

### Return type

[**ScmHook**](ScmHook.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectHg"></a>
# **createProjectHg**
> ProjectHg createProjectHg(idOrName, name, opts)



Create a new hg repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | 

var opts = { 
  'description': "description_example", // String | 
  'mailRecipients': "mailRecipients_example" // String | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectHg(idOrName, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**|  | 
 **description** | **String**|  | [optional] 
 **mailRecipients** | **String**|  | [optional] 

### Return type

[**ProjectHg**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectGitHook"></a>
# **deleteProjectGitHook**
> deleteProjectGitHook(idOrName, repoId, hookId)



Delete a Git repository hook

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var hookId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectGitHook(idOrName, repoId, hookId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **hookId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="disableProjectBzr"></a>
# **disableProjectBzr**
> ProjectBzr disableProjectBzr(idOrName, repoId)



Disable a bzr repository (not an actual delete, just a shorthand for updating with active&#x3D;false)

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.disableProjectBzr(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectBzr**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="disableProjectGit"></a>
# **disableProjectGit**
> ProjectGit disableProjectGit(idOrName, repoId)



Disable a git repository (not an actual delete, just a shorthand for updating with active&#x3D;false)

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.disableProjectGit(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectGit**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="disableProjectHg"></a>
# **disableProjectHg**
> ProjectHg disableProjectHg(idOrName, repoId)



Disable a hg repository (not an actual delete, just a shorthand for updating with active&#x3D;false)

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.disableProjectHg(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectHg**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectBzr"></a>
# **getProjectBzr**
> ProjectBzr getProjectBzr(idOrName, repoId)



Get a bzr repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectBzr(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectBzr**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectGit"></a>
# **getProjectGit**
> ProjectGit getProjectGit(idOrName, repoId)



Get a git repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectGit(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectGit**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectGitHook"></a>
# **getProjectGitHook**
> ScmHook getProjectGitHook(idOrName, repoId, hookId)



Get a repository hook

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var hookId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectGitHook(idOrName, repoId, hookId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **hookId** | **Integer**|  | 

### Return type

[**ScmHook**](ScmHook.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectHg"></a>
# **getProjectHg**
> ProjectHg getProjectHg(idOrName, repoId)



Get a hg repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectHg(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectHg**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectSvn"></a>
# **getProjectSvn**
> ProjectSvn getProjectSvn(idOrName)



Get Subversion repository of the project

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectSvn(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**ProjectSvn**](ProjectSvn.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectBzr"></a>
# **listProjectBzr**
> [ProjectBzr] listProjectBzr(idOrName)



Get Bazzar repository list

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectBzr(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectBzr]**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectGit"></a>
# **listProjectGit**
> [ProjectGit] listProjectGit(idOrName)



Get git repository list

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectGit(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectGit]**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectGitHook"></a>
# **listProjectGitHook**
> [ScmHook] listProjectGitHook(idOrName, repoId)



Get Git repository hook list

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectGitHook(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**[ScmHook]**](ScmHook.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectHg"></a>
# **listProjectHg**
> [ProjectHg] listProjectHg(idOrName)



Get Mercurial repository list

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectHg(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectHg]**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectBzr"></a>
# **updateProjectBzr**
> ProjectBzr updateProjectBzr(idOrName, repoId, opts)



Update a bzr repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var opts = { 
  'description': "description_example", // String | 
  'active': true // Boolean | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectBzr(idOrName, repoId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **description** | **String**|  | [optional] 
 **active** | **Boolean**|  | [optional] 

### Return type

[**ProjectBzr**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectGit"></a>
# **updateProjectGit**
> ProjectGit updateProjectGit(idOrName, repoId, opts)



Update a git repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var opts = { 
  'description': "description_example", // String | 
  'mailEnabled': true, // Boolean | 
  'mailRecipients': "mailRecipients_example", // String | 
  'allowNonFastForward': true, // Boolean | 
  'defaultBranch': "defaultBranch_example", // String | 
  'active': true // Boolean | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectGit(idOrName, repoId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **description** | **String**|  | [optional] 
 **mailEnabled** | **Boolean**|  | [optional] 
 **mailRecipients** | **String**|  | [optional] 
 **allowNonFastForward** | **Boolean**|  | [optional] 
 **defaultBranch** | **String**|  | [optional] 
 **active** | **Boolean**|  | [optional] 

### Return type

[**ProjectGit**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectHg"></a>
# **updateProjectHg**
> ProjectHg updateProjectHg(idOrName, repoId, opts)



Update a hg repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectSCMApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var opts = { 
  'description': "description_example", // String | 
  'mailRecipients': "mailRecipients_example", // String | 
  'active': true // Boolean | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectHg(idOrName, repoId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **description** | **String**|  | [optional] 
 **mailRecipients** | **String**|  | [optional] 
 **active** | **Boolean**|  | [optional] 

### Return type

[**ProjectHg**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

