/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/ModelPackage', 'OSDN/OSDN\Model/ProjectBzr', 'OSDN/OSDN\Model/ProjectGit', 'OSDN/OSDN\Model/ScmHook', 'OSDN/OSDN\Model/ProjectHg', 'OSDN/OSDN\Model/GroupProfile', 'OSDN/OSDN\Model/ProjectTicketItem', 'OSDN/OSDN\Model/ProjectTicketComment', 'OSDN/OSDN\Model/ProjectTicketComponent', 'OSDN/OSDN\Model/ProjectTicketMilestone', 'OSDN/OSDN\Model/ProjectTicketType', 'OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage', 'OSDN/OSDN\Model/Release', 'OSDN/OSDN\Model/RelFile', 'OSDN/OSDN\Model/FrsAdminPrefs', 'OSDN/OSDN\Model/News', 'OSDN/OSDN\Model/Group', 'OSDN/OSDN\Model/ProjectWeb', 'OSDN/OSDN\Model/History', 'OSDN/OSDN\Model/GroupProfilePerLanguage', 'OSDN/OSDN\Model/ProjectSvn', 'OSDN/OSDN\Model/GroupToolFlags', 'OSDN/OSDN\Model/ProjectTicketTypeInstructions', 'OSDN/OSDN\Model/ProjectTicketPrefs'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../OSDN\Model/ModelPackage'), require('../OSDN\Model/ProjectBzr'), require('../OSDN\Model/ProjectGit'), require('../OSDN\Model/ScmHook'), require('../OSDN\Model/ProjectHg'), require('../OSDN\Model/GroupProfile'), require('../OSDN\Model/ProjectTicketItem'), require('../OSDN\Model/ProjectTicketComment'), require('../OSDN\Model/ProjectTicketComponent'), require('../OSDN\Model/ProjectTicketMilestone'), require('../OSDN\Model/ProjectTicketType'), require('../OSDN\Model/ProjectTicketTypeInstructionPerLanguage'), require('../OSDN\Model/Release'), require('../OSDN\Model/RelFile'), require('../OSDN\Model/FrsAdminPrefs'), require('../OSDN\Model/News'), require('../OSDN\Model/Group'), require('../OSDN\Model/ProjectWeb'), require('../OSDN\Model/History'), require('../OSDN\Model/GroupProfilePerLanguage'), require('../OSDN\Model/ProjectSvn'), require('../OSDN\Model/GroupToolFlags'), require('../OSDN\Model/ProjectTicketTypeInstructions'), require('../OSDN\Model/ProjectTicketPrefs'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.ProjectApi = factory(root.OSDNClient.ApiClient, root.OSDNClient.ModelPackage, root.OSDNClient.ProjectBzr, root.OSDNClient.ProjectGit, root.OSDNClient.ScmHook, root.OSDNClient.ProjectHg, root.OSDNClient.GroupProfile, root.OSDNClient.ProjectTicketItem, root.OSDNClient.ProjectTicketComment, root.OSDNClient.ProjectTicketComponent, root.OSDNClient.ProjectTicketMilestone, root.OSDNClient.ProjectTicketType, root.OSDNClient.ProjectTicketTypeInstructionPerLanguage, root.OSDNClient.Release, root.OSDNClient.RelFile, root.OSDNClient.FrsAdminPrefs, root.OSDNClient.News, root.OSDNClient.Group, root.OSDNClient.ProjectWeb, root.OSDNClient.History, root.OSDNClient.GroupProfilePerLanguage, root.OSDNClient.ProjectSvn, root.OSDNClient.GroupToolFlags, root.OSDNClient.ProjectTicketTypeInstructions, root.OSDNClient.ProjectTicketPrefs);
  }
}(this, function(ApiClient, ModelPackage, ProjectBzr, ProjectGit, ScmHook, ProjectHg, GroupProfile, ProjectTicketItem, ProjectTicketComment, ProjectTicketComponent, ProjectTicketMilestone, ProjectTicketType, ProjectTicketTypeInstructionPerLanguage, Release, RelFile, FrsAdminPrefs, News, Group, ProjectWeb, History, GroupProfilePerLanguage, ProjectSvn, GroupToolFlags, ProjectTicketTypeInstructions, ProjectTicketPrefs) {
  'use strict';

  /**
   * Project service.
   * @module OSDN/OSDN\Api/ProjectApi
   * @version 0.0.20161031
   */

  /**
   * Constructs a new ProjectApi. 
   * @alias module:OSDN/OSDN\Api/ProjectApi
   * @class
   * @param {module:OSDN/ApiClient} apiClient Optional API client implementation to use,
   * default to {@link module:OSDN/ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the createNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createNewsCallback
     * @param {String} error Error message, if any.
     * @param {'String'} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} title news title
     * @param {String} body news body in OSDN Wiki format.
     * @param {Integer} groupId group_id the news created in
     * @param {module:OSDN/OSDN\Api/ProjectApi~createNewsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {'String'}
     */
    this.createNews = function(title, body, groupId, callback) {
      var postBody = null;

      // verify the required parameter 'title' is set
      if (title == undefined || title == null) {
        throw "Missing the required parameter 'title' when calling createNews";
      }

      // verify the required parameter 'body' is set
      if (body == undefined || body == null) {
        throw "Missing the required parameter 'body' when calling createNews";
      }

      // verify the required parameter 'groupId' is set
      if (groupId == undefined || groupId == null) {
        throw "Missing the required parameter 'groupId' when calling createNews";
      }


      var pathParams = {
      };
      var queryParams = {
        'group_id': groupId
      };
      var headerParams = {
      };
      var formParams = {
        'title': title,
        'body': body
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = 'String';

      return this.apiClient.callApi(
        '/news', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createNews_0Callback
     * @param {String} error Error message, if any.
     * @param {'String'} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} idOrName numeric project id or project name
     * @param {String} title news title
     * @param {String} body news body in OSDN Wiki format.
     * @param {module:OSDN/OSDN\Api/ProjectApi~createNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {'String'}
     */
    this.createNews_0 = function(idOrName, title, body, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createNews_0";
      }

      // verify the required parameter 'title' is set
      if (title == undefined || title == null) {
        throw "Missing the required parameter 'title' when calling createNews_0";
      }

      // verify the required parameter 'body' is set
      if (body == undefined || body == null) {
        throw "Missing the required parameter 'body' when calling createNews_0";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'title': title,
        'body': body
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = 'String';

      return this.apiClient.callApi(
        '/project/{id_or_name}/news', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createPackage operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createPackageCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ModelPackage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a package.
     * @param {String} idOrName numeric project id or project name
     * @param {String} name package name
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {module:OSDN/OSDN\Api/ProjectApi~createPackageCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ModelPackage}
     */
    this.createPackage = function(idOrName, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createPackage";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createPackage";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'visibility': opts['visibility']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ModelPackage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectBzr} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new bzr repository
     * @param {String} idOrName numeric project id or project name
     * @param {String} name 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectBzr}
     */
    this.createProjectBzr = function(idOrName, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectBzr";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': opts['description']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectBzr;

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectGit} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new git repository
     * @param {String} idOrName numeric project id or project name
     * @param {String} name 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {Boolean} opts.mailEnabled 
     * @param {String} opts.mailRecipients 
     * @param {Boolean} opts.allowNonFastForward 
     * @param {String} opts.defaultBranch 
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectGit}
     */
    this.createProjectGit = function(idOrName, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectGit";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': opts['description'],
        'mail_enabled': opts['mailEnabled'],
        'mail_recipients': opts['mailRecipients'],
        'allow_non_fast_forward': opts['allowNonFastForward'],
        'default_branch': opts['defaultBranch']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectGit;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectGitHook operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectGitHookCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ScmHook} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new hook for project git repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {String} targetUrl 
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectGitHookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ScmHook}
     */
    this.createProjectGitHook = function(idOrName, repoId, targetUrl, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectGitHook";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling createProjectGitHook";
      }

      // verify the required parameter 'targetUrl' is set
      if (targetUrl == undefined || targetUrl == null) {
        throw "Missing the required parameter 'targetUrl' when calling createProjectGitHook";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'target_url': targetUrl
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ScmHook;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}/hooks', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectHg} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new hg repository
     * @param {String} idOrName numeric project id or project name
     * @param {String} name 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {String} opts.mailRecipients 
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectHg}
     */
    this.createProjectHg = function(idOrName, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectHg";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': opts['description'],
        'mail_recipients': opts['mailRecipients']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectHg;

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectProfile operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectProfileCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/GroupProfile} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create project profile for the language
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Model/String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {String} displayName Project display name
     * @param {String} description Project description
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectProfileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/GroupProfile}
     */
    this.createProjectProfile = function(idOrName, languageCode, displayName, description, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectProfile";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling createProjectProfile";
      }

      // verify the required parameter 'displayName' is set
      if (displayName == undefined || displayName == null) {
        throw "Missing the required parameter 'displayName' when calling createProjectProfile";
      }

      // verify the required parameter 'description' is set
      if (description == undefined || description == null) {
        throw "Missing the required parameter 'description' when calling createProjectProfile";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'language_code': languageCode,
        'display_name': displayName,
        'description': description
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = GroupProfile;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/profile', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicket operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectTicketCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketItem} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create project ticket
     * @param {String} idOrName numeric project id or project name
     * @param {String} name Project ticket name (title)
     * @param {String} description Project ticket description details
     * @param {Integer} typeId numeric project ticket type id
     * @param {Object} opts Optional parameters
     * @param {Integer} opts.milestoneId numeric project ticket milestone id
     * @param {Integer} opts.componentId numeric project ticket component id
     * @param {Integer} opts.priority project ticket priority (min &#x3D; 1 and max &#x3D; 9)
     * @param {Integer} opts.severity project ticket severity (min &#x3D; 1 and max &#x3D; 9)
     * @param {Integer} opts.owner numeric project ticket owner user id
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectTicketCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketItem}
     */
    this.createProjectTicket = function(idOrName, name, description, typeId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicket";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectTicket";
      }

      // verify the required parameter 'description' is set
      if (description == undefined || description == null) {
        throw "Missing the required parameter 'description' when calling createProjectTicket";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling createProjectTicket";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': description,
        'type_id': typeId,
        'milestone_id': opts['milestoneId'],
        'component_id': opts['componentId'],
        'priority': opts['priority'],
        'severity': opts['severity'],
        'owner': opts['owner']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketItem;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketComment operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectTicketCommentCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComment} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new project ticket comment of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {String} comment Ticket comment text
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectTicketCommentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComment}
     */
    this.createProjectTicketComment = function(idOrName, ticketId, comment, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketComment";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling createProjectTicketComment";
      }

      // verify the required parameter 'comment' is set
      if (comment == undefined || comment == null) {
        throw "Missing the required parameter 'comment' when calling createProjectTicketComment";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'comment': comment
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComment;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}/comment', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketComponent>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new project ticket component of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {String} name Ticket component name
     * @param {String} description Ticket component description
     * @param {Object} opts Optional parameters
     * @param {Integer} opts.owner Ticket componet owner user_id
     * @param {Boolean} opts.active Ticket componet will be shown the component select list when this parameter is true
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketComponent>}
     */
    this.createProjectTicketComponent = function(idOrName, name, description, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketComponent";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectTicketComponent";
      }

      // verify the required parameter 'description' is set
      if (description == undefined || description == null) {
        throw "Missing the required parameter 'description' when calling createProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': description,
        'owner': opts['owner'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketComponent];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketMilestone} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new project ticket milestone of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {String} name Ticket milestone name
     * @param {String} description Ticket milestone description
     * @param {Object} opts Optional parameters
     * @param {Date} opts.start Ticket milestone start date
     * @param {Date} opts.end Ticket milestone due date
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketMilestone}
     */
    this.createProjectTicketMilestone = function(idOrName, name, description, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketMilestone";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectTicketMilestone";
      }

      // verify the required parameter 'description' is set
      if (description == undefined || description == null) {
        throw "Missing the required parameter 'description' when calling createProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': description,
        'start': opts['start'],
        'end': opts['end']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketMilestone;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketType} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new project ticket type of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {String} name Ticket type name
     * @param {String} description Ticket type description
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.isPublic if set as false, this type will be shown to project members only.
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketType}
     */
    this.createProjectTicketType = function(idOrName, name, description, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketType";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectTicketType";
      }

      // verify the required parameter 'description' is set
      if (description == undefined || description == null) {
        throw "Missing the required parameter 'description' when calling createProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': description,
        'is_public': opts['isPublic']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketType;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketTypeInstruction operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createProjectTicketTypeInstructionCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create project ticket type instructions for the language
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {String} instruction Ticket submit instruction for the type
     * @param {module:OSDN/OSDN\Api/ProjectApi~createProjectTicketTypeInstructionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage}
     */
    this.createProjectTicketTypeInstruction = function(idOrName, typeId, languageCode, instruction, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketTypeInstruction";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling createProjectTicketTypeInstruction";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling createProjectTicketTypeInstruction";
      }

      // verify the required parameter 'instruction' is set
      if (instruction == undefined || instruction == null) {
        throw "Missing the required parameter 'instruction' when calling createProjectTicketTypeInstruction";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'language_code': languageCode,
        'instruction': instruction
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketTypeInstructionPerLanguage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createReleaseCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Release} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new release in specified package.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {String} name Release name
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {Date} opts.time Release datetime. If you set future time, the release hide until specified time.
     * @param {String} opts.releaseNote Release note body text.
     * @param {String} opts.changeLog Changelog body text.
     * @param {module:OSDN/OSDN\Api/ProjectApi~createReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Release}
     */
    this.createRelease = function(idOrName, packageId, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling createRelease";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'visibility': opts['visibility'],
        'name': name,
        'time': opts['time'],
        'release_note': opts['releaseNote'],
        'change_log': opts['changeLog']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Release;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createReleaseFile operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~createReleaseFileCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/RelFile} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new file in target release.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {File} file Upload file in \&quot;multipart/form-data\&quot;.
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {module:OSDN/OSDN\Api/ProjectApi~createReleaseFileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/RelFile}
     */
    this.createReleaseFile = function(idOrName, packageId, releaseId, file, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createReleaseFile";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling createReleaseFile";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling createReleaseFile";
      }

      // verify the required parameter 'file' is set
      if (file == undefined || file == null) {
        throw "Missing the required parameter 'file' when calling createReleaseFile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'visibility': opts['visibility'],
        'file': file
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['multipart/form-data'];
      var accepts = [];
      var returnType = RelFile;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteNewsCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {Integer} newsId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteNewsCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteNews = function(newsId, callback) {
      var postBody = null;

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling deleteNews";
      }


      var pathParams = {
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/news/{news_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteNews_0Callback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} newsId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteNews_0 = function(idOrName, newsId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteNews_0";
      }

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling deleteNews_0";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/news/{news_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deletePackage operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deletePackageCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete taret package.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~deletePackageCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deletePackage = function(idOrName, packageId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deletePackage";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling deletePackage";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectAdminProjectweb operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteProjectAdminProjectwebCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project homepage url
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteProjectAdminProjectwebCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectAdminProjectweb = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectAdminProjectweb";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/project_web', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectGitHook operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteProjectGitHookCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete a Git repository hook
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Integer} hookId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteProjectGitHookCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectGitHook = function(idOrName, repoId, hookId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectGitHook";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling deleteProjectGitHook";
      }

      // verify the required parameter 'hookId' is set
      if (hookId == undefined || hookId == null) {
        throw "Missing the required parameter 'hookId' when calling deleteProjectGitHook";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId,
        'hook_id': hookId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectProfile operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteProjectProfileCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project profile for the language
     * @param {String} idOrName numeric project id or project name
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteProjectProfileCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectProfile = function(idOrName, languageCode, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectProfile";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling deleteProjectProfile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'language_code': languageCode
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/profile/{language_code}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project ticket component
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} componentId numeric project ticket component id
     * @param {Integer} migrateTo Tickets that assigned to delete target will be migrate to the ticket component_id
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectTicketComponent = function(idOrName, componentId, migrateTo, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectTicketComponent";
      }

      // verify the required parameter 'componentId' is set
      if (componentId == undefined || componentId == null) {
        throw "Missing the required parameter 'componentId' when calling deleteProjectTicketComponent";
      }

      // verify the required parameter 'migrateTo' is set
      if (migrateTo == undefined || migrateTo == null) {
        throw "Missing the required parameter 'migrateTo' when calling deleteProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'component_id': componentId
      };
      var queryParams = {
        'migrate_to': migrateTo
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component/{component_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project ticket milestone
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} milestoneId numeric project ticket milestone id
     * @param {Object} opts Optional parameters
     * @param {Integer} opts.migrateTo Tickets that assigned to delete target will be migrate to the ticket milestone_id
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectTicketMilestone = function(idOrName, milestoneId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectTicketMilestone";
      }

      // verify the required parameter 'milestoneId' is set
      if (milestoneId == undefined || milestoneId == null) {
        throw "Missing the required parameter 'milestoneId' when calling deleteProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'milestone_id': milestoneId
      };
      var queryParams = {
        'migrate_to': opts['migrateTo']
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone/{milestone_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project ticket type
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {Integer} migrateTo Tickets that assigned to delete target will be migrate to the ticket type_id
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectTicketType = function(idOrName, typeId, migrateTo, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectTicketType";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling deleteProjectTicketType";
      }

      // verify the required parameter 'migrateTo' is set
      if (migrateTo == undefined || migrateTo == null) {
        throw "Missing the required parameter 'migrateTo' when calling deleteProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
        'migrate_to': migrateTo
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectTicketTypeInstruction operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteProjectTicketTypeInstructionCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project ticket type instructions on the language
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteProjectTicketTypeInstructionCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectTicketTypeInstruction = function(idOrName, typeId, languageCode, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectTicketTypeInstruction";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling deleteProjectTicketTypeInstruction";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling deleteProjectTicketTypeInstruction";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId,
        'language_code': languageCode
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteReleaseCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete target release.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteRelease = function(idOrName, packageId, releaseId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling deleteRelease";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling deleteRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteReleaseFile operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~deleteReleaseFileCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete target file.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {Integer} fileId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~deleteReleaseFileCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteReleaseFile = function(idOrName, packageId, releaseId, fileId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteReleaseFile";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling deleteReleaseFile";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling deleteReleaseFile";
      }

      // verify the required parameter 'fileId' is set
      if (fileId == undefined || fileId == null) {
        throw "Missing the required parameter 'fileId' when calling deleteReleaseFile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId,
        'file_id': fileId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the disableProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~disableProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectBzr} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Disable a bzr repository (not an actual delete, just a shorthand for updating with active&#x3D;false)
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~disableProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectBzr}
     */
    this.disableProjectBzr = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling disableProjectBzr";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling disableProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectBzr;

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr/{repo_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the disableProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~disableProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectGit} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Disable a git repository (not an actual delete, just a shorthand for updating with active&#x3D;false)
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~disableProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectGit}
     */
    this.disableProjectGit = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling disableProjectGit";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling disableProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectGit;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the disableProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~disableProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectHg} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Disable a hg repository (not an actual delete, just a shorthand for updating with active&#x3D;false)
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~disableProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectHg}
     */
    this.disableProjectHg = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling disableProjectHg";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling disableProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectHg;

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg/{repo_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the draftRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~draftReleaseCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Release} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get release draft in specified package. If draft is not exist, it will be created automatically.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~draftReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Release}
     */
    this.draftRelease = function(idOrName, packageId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling draftRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling draftRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Release;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/draft', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getFrsAdminprefs operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getFrsAdminprefsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/FrsAdminPrefs} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project frs admin preferences.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~getFrsAdminprefsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/FrsAdminPrefs}
     */
    this.getFrsAdminprefs = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getFrsAdminprefs";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = FrsAdminPrefs;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/admin', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getNewsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/News} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get single news object.
     * @param {Integer} newsId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~getNewsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/News}
     */
    this.getNews = function(newsId, callback) {
      var postBody = null;

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling getNews";
      }


      var pathParams = {
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = News;

      return this.apiClient.callApi(
        '/news/{news_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getNews_0Callback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/News} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get single news object.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} newsId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~getNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/News}
     */
    this.getNews_0 = function(idOrName, newsId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getNews_0";
      }

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling getNews_0";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = News;

      return this.apiClient.callApi(
        '/project/{id_or_name}/news/{news_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getPackage operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getPackageCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ModelPackage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get specified package info and release list of the package.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~getPackageCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ModelPackage}
     */
    this.getPackage = function(idOrName, packageId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getPackage";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling getPackage";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ModelPackage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProject operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Group} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project info.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Group}
     */
    this.getProject = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProject";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Group;

      return this.apiClient.callApi(
        '/project/{id_or_name}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectAdminProjectweb operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectAdminProjectwebCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectWeb} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project homepage url
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectAdminProjectwebCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectWeb}
     */
    this.getProjectAdminProjectweb = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectAdminProjectweb";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectWeb;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/project_web', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectBzr} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a bzr repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectBzr}
     */
    this.getProjectBzr = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectBzr";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling getProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectBzr;

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr/{repo_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectGit} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a git repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectGit}
     */
    this.getProjectGit = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectGit";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling getProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectGit;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectGitHook operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectGitHookCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ScmHook} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a repository hook
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Integer} hookId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectGitHookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ScmHook}
     */
    this.getProjectGitHook = function(idOrName, repoId, hookId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectGitHook";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling getProjectGitHook";
      }

      // verify the required parameter 'hookId' is set
      if (hookId == undefined || hookId == null) {
        throw "Missing the required parameter 'hookId' when calling getProjectGitHook";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId,
        'hook_id': hookId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ScmHook;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectHg} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a hg repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectHg}
     */
    this.getProjectHg = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectHg";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling getProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectHg;

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg/{repo_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectHistories operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectHistoriesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/History>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project histories.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectHistoriesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/History>}
     */
    this.getProjectHistories = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectHistories";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [History];

      return this.apiClient.callApi(
        '/project/{id_or_name}/history', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectProfile operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectProfileCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/GroupProfilePerLanguage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project profile on the language
     * @param {String} idOrName numeric project id or project name
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectProfileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/GroupProfilePerLanguage}
     */
    this.getProjectProfile = function(idOrName, languageCode, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectProfile";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling getProjectProfile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'language_code': languageCode
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = GroupProfilePerLanguage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/profile/{language_code}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectProfileList operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectProfileListCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/GroupProfile} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project profile in all languages
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectProfileListCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/GroupProfile}
     */
    this.getProjectProfileList = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectProfileList";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = GroupProfile;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/profile', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectSvn operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectSvnCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectSvn} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Subversion repository of the project
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectSvnCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectSvn}
     */
    this.getProjectSvn = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectSvn";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectSvn;

      return this.apiClient.callApi(
        '/project/{id_or_name}/svn', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicket operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectTicketCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketItem} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectTicketCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketItem}
     */
    this.getProjectTicket = function(idOrName, ticketId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicket";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling getProjectTicket";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketItem;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComponent} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket component
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} componentId numeric project ticket component id
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComponent}
     */
    this.getProjectTicketComponent = function(idOrName, componentId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketComponent";
      }

      // verify the required parameter 'componentId' is set
      if (componentId == undefined || componentId == null) {
        throw "Missing the required parameter 'componentId' when calling getProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'component_id': componentId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComponent;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component/{component_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketMilestone} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket milestone of spscified milestone_id.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} milestoneId numeric project ticket milestone id
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketMilestone}
     */
    this.getProjectTicketMilestone = function(idOrName, milestoneId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketMilestone";
      }

      // verify the required parameter 'milestoneId' is set
      if (milestoneId == undefined || milestoneId == null) {
        throw "Missing the required parameter 'milestoneId' when calling getProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'milestone_id': milestoneId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketMilestone;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone/{milestone_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketType} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket type
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketType}
     */
    this.getProjectTicketType = function(idOrName, typeId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketType";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling getProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketType;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketTypeInstruction operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectTicketTypeInstructionCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket type instructions on the language
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectTicketTypeInstructionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage}
     */
    this.getProjectTicketTypeInstruction = function(idOrName, typeId, languageCode, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketTypeInstruction";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling getProjectTicketTypeInstruction";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling getProjectTicketTypeInstruction";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId,
        'language_code': languageCode
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketTypeInstructionPerLanguage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketTypeInstruction_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectTicketTypeInstruction_0Callback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket type instructions on the language
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {String} instruction Ticket submit instruction for the type
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectTicketTypeInstruction_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage}
     */
    this.getProjectTicketTypeInstruction_0 = function(idOrName, typeId, languageCode, instruction, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketTypeInstruction_0";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling getProjectTicketTypeInstruction_0";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling getProjectTicketTypeInstruction_0";
      }

      // verify the required parameter 'instruction' is set
      if (instruction == undefined || instruction == null) {
        throw "Missing the required parameter 'instruction' when calling getProjectTicketTypeInstruction_0";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId,
        'language_code': languageCode
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'instruction': instruction
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketTypeInstructionPerLanguage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTools operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getProjectToolsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/GroupToolFlags} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project tools info.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~getProjectToolsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/GroupToolFlags}
     */
    this.getProjectTools = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTools";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = GroupToolFlags;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/tools', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getReleaseCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Release} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get specified release info and file list of the release.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~getReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Release}
     */
    this.getRelease = function(idOrName, packageId, releaseId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling getRelease";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling getRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Release;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getReleaseFile operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~getReleaseFileCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/RelFile} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get single file object.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {Integer} fileId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~getReleaseFileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/RelFile}
     */
    this.getReleaseFile = function(idOrName, packageId, releaseId, fileId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getReleaseFile";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling getReleaseFile";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling getReleaseFile";
      }

      // verify the required parameter 'fileId' is set
      if (fileId == undefined || fileId == null) {
        throw "Missing the required parameter 'fileId' when calling getReleaseFile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId,
        'file_id': fileId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = RelFile;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listNewsCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/News>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {Object} opts Optional parameters
     * @param {Integer} opts.groupId filter by group ID
     * @param {module:OSDN/OSDN\Api/ProjectApi~listNewsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/News>}
     */
    this.listNews = function(opts, callback) {
      opts = opts || {};
      var postBody = null;


      var pathParams = {
      };
      var queryParams = {
        'group_id': opts['groupId']
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [News];

      return this.apiClient.callApi(
        '/news', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listNews_0Callback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/News>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get news list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~listNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/News>}
     */
    this.listNews_0 = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listNews_0";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [News];

      return this.apiClient.callApi(
        '/project/{id_or_name}/news', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listPackages operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listPackagesCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ModelPackage>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get package list of specified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~listPackagesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ModelPackage>}
     */
    this.listPackages = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listPackages";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ModelPackage];

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectBzr>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Bazzar repository list
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectBzr>}
     */
    this.listProjectBzr = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectBzr];

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectGit>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get git repository list
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectGit>}
     */
    this.listProjectGit = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectGit];

      return this.apiClient.callApi(
        '/project/{id_or_name}/git', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectGitHook operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectGitHookCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ScmHook>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Git repository hook list
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectGitHookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ScmHook>}
     */
    this.listProjectGitHook = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectGitHook";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling listProjectGitHook";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ScmHook];

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}/hooks', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectHg>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Mercurial repository list
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectHg>}
     */
    this.listProjectHg = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectHg];

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicket operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectTicketCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketItem>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * List project ticket order by submit date descending
     * @param {String} idOrName numeric project id or project name
     * @param {Object} opts Optional parameters
     * @param {Array.<module:OSDN/OSDN\Model/String>} opts.status Tickets are assigned to these type_ids
     * @param {Array.<Integer>} opts.typeId Listing tickets are assigned to these type_ids
     * @param {Array.<Integer>} opts.notTypeId Listing tickets are NOT assigned to these type_ids
     * @param {Array.<Integer>} opts.componentId Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0)
     * @param {Array.<Integer>} opts.notComponentId Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0)
     * @param {Array.<Integer>} opts.milestoneId Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0)
     * @param {Array.<Integer>} opts.notMilestoneId Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned)
     * @param {Integer} opts.maxPriority Listing equal or lower priority tickets
     * @param {Integer} opts.minPriority Listing equal or higher priority tickets
     * @param {Integer} opts.priority Listing tickets have this priority
     * @param {Integer} opts.maxSeverity Listing equal or lower severity tickets
     * @param {Integer} opts.minSeverity Listing equal or higher severity tickets
     * @param {Integer} opts.severity Listing tickets have this severity
     * @param {Array.<Integer>} opts.owner Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned)
     * @param {Array.<Integer>} opts.notOwner Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned)
     * @param {Array.<Integer>} opts.reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user)
     * @param {Array.<Integer>} opts.notReporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user)
     * @param {String} opts.text Listing tickets title or description or comment include the text
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectTicketCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketItem>}
     */
    this.listProjectTicket = function(idOrName, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicket";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
        'status': this.apiClient.buildCollectionParam(opts['status'], 'csv'),
        'type_id': this.apiClient.buildCollectionParam(opts['typeId'], 'csv'),
        'not_type_id': this.apiClient.buildCollectionParam(opts['notTypeId'], 'csv'),
        'component_id': this.apiClient.buildCollectionParam(opts['componentId'], 'csv'),
        'not_component_id': this.apiClient.buildCollectionParam(opts['notComponentId'], 'csv'),
        'milestone_id': this.apiClient.buildCollectionParam(opts['milestoneId'], 'csv'),
        'not_milestone_id': this.apiClient.buildCollectionParam(opts['notMilestoneId'], 'csv'),
        'max_priority': opts['maxPriority'],
        'min_priority': opts['minPriority'],
        'priority': opts['priority'],
        'max_severity': opts['maxSeverity'],
        'min_severity': opts['minSeverity'],
        'severity': opts['severity'],
        'owner': this.apiClient.buildCollectionParam(opts['owner'], 'csv'),
        'not_owner': this.apiClient.buildCollectionParam(opts['notOwner'], 'csv'),
        'reporter': this.apiClient.buildCollectionParam(opts['reporter'], 'csv'),
        'not_reporter': this.apiClient.buildCollectionParam(opts['notReporter'], 'csv'),
        'text': opts['text']
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketItem];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketComment operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectTicketCommentCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketComment>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket comment list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectTicketCommentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketComment>}
     */
    this.listProjectTicketComment = function(idOrName, ticketId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketComment";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling listProjectTicketComment";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketComment];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}/comment', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketComponent>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket component list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketComponent>}
     */
    this.listProjectTicketComponent = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketComponent];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketMilestone>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket milestone list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketMilestone>}
     */
    this.listProjectTicketMilestone = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketMilestone];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketType>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket type list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketType>}
     */
    this.listProjectTicketType = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketType];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketTypeInstruction operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~listProjectTicketTypeInstructionCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketTypeInstructions} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket type instructions
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {module:OSDN/OSDN\Api/ProjectApi~listProjectTicketTypeInstructionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketTypeInstructions}
     */
    this.listProjectTicketTypeInstruction = function(idOrName, typeId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketTypeInstruction";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling listProjectTicketTypeInstruction";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketTypeInstructions;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the showProjectTicketAdminprefs operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~showProjectTicketAdminprefsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketPrefs} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket admin preferences.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectApi~showProjectTicketAdminprefsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketPrefs}
     */
    this.showProjectTicketAdminprefs = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling showProjectTicketAdminprefs";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketPrefs;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/admin', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the showProjectTicketComment operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~showProjectTicketCommentCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComment} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket comment spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {Integer} commentId numeric project ticket comment id
     * @param {module:OSDN/OSDN\Api/ProjectApi~showProjectTicketCommentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComment}
     */
    this.showProjectTicketComment = function(idOrName, ticketId, commentId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling showProjectTicketComment";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling showProjectTicketComment";
      }

      // verify the required parameter 'commentId' is set
      if (commentId == undefined || commentId == null) {
        throw "Missing the required parameter 'commentId' when calling showProjectTicketComment";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId,
        'comment_id': commentId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComment;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateFrsAdminprefs operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateFrsAdminprefsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/FrsAdminPrefs} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project frs admin preferences.
     * @param {String} idOrName numeric project id or project name
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.allowOverwrite Allow overwrite files when filenames are conflict
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateFrsAdminprefsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/FrsAdminPrefs}
     */
    this.updateFrsAdminprefs = function(idOrName, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateFrsAdminprefs";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'allow_overwrite': opts['allowOverwrite']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = FrsAdminPrefs;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/admin', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateNews operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateNewsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/News} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {Integer} newsId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.title news title
     * @param {String} opts.body news body in OSDN Wiki format.
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateNewsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/News}
     */
    this.updateNews = function(newsId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling updateNews";
      }


      var pathParams = {
        'news_id': newsId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'title': opts['title'],
        'body': opts['body']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = News;

      return this.apiClient.callApi(
        '/news/{news_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateNews_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateNews_0Callback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/News} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * @param {Integer} newsId 
     * @param {String} idOrName numeric project id or project name
     * @param {Object} opts Optional parameters
     * @param {String} opts.title news title
     * @param {String} opts.body news body in OSDN Wiki format.
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateNews_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/News}
     */
    this.updateNews_0 = function(newsId, idOrName, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'newsId' is set
      if (newsId == undefined || newsId == null) {
        throw "Missing the required parameter 'newsId' when calling updateNews_0";
      }

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateNews_0";
      }


      var pathParams = {
        'news_id': newsId,
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'title': opts['title'],
        'body': opts['body']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = News;

      return this.apiClient.callApi(
        '/project/{id_or_name}/news/{news_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updatePackage operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updatePackageCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ModelPackage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update tagret package.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.name package name
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {module:OSDN/OSDN\Api/ProjectApi~updatePackageCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ModelPackage}
     */
    this.updatePackage = function(idOrName, packageId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updatePackage";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling updatePackage";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'visibility': opts['visibility']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ModelPackage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectAdminProjectweb operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectAdminProjectwebCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectWeb} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project homepage url
     * @param {String} idOrName numeric project id or project name
     * @param {Object} opts Optional parameters
     * @param {String} opts.homepage Project home page full URL (should start with http:// or https://). If reset param is true, this url will be ignored (URL will be reset to default url)
     * @param {Boolean} opts.reset Project home page URL reset to default value
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectAdminProjectwebCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectWeb}
     */
    this.updateProjectAdminProjectweb = function(idOrName, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectAdminProjectweb";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'homepage': opts['homepage'],
        'reset': opts['reset']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectWeb;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/project_web', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectBzr} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update a bzr repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {Boolean} opts.active 
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectBzr}
     */
    this.updateProjectBzr = function(idOrName, repoId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectBzr";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling updateProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'description': opts['description'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectBzr;

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr/{repo_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectGit} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update a git repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {Boolean} opts.mailEnabled 
     * @param {String} opts.mailRecipients 
     * @param {Boolean} opts.allowNonFastForward 
     * @param {String} opts.defaultBranch 
     * @param {Boolean} opts.active 
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectGit}
     */
    this.updateProjectGit = function(idOrName, repoId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectGit";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling updateProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'description': opts['description'],
        'mail_enabled': opts['mailEnabled'],
        'mail_recipients': opts['mailRecipients'],
        'allow_non_fast_forward': opts['allowNonFastForward'],
        'default_branch': opts['defaultBranch'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectGit;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectHg} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update a hg repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {String} opts.mailRecipients 
     * @param {Boolean} opts.active 
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectHg}
     */
    this.updateProjectHg = function(idOrName, repoId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectHg";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling updateProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'description': opts['description'],
        'mail_recipients': opts['mailRecipients'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectHg;

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg/{repo_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectProfile operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectProfileCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/GroupProfilePerLanguage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project profile.
     * @param {String} idOrName numeric project id or project name
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {Object} opts Optional parameters
     * @param {String} opts.displayName Project display name
     * @param {String} opts.description Project description
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectProfileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/GroupProfilePerLanguage}
     */
    this.updateProjectProfile = function(idOrName, languageCode, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectProfile";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling updateProjectProfile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'language_code': languageCode
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'display_name': opts['displayName'],
        'description': opts['description']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = GroupProfilePerLanguage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/profile/{language_code}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicket operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketItem} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {Object} opts Optional parameters
     * @param {String} opts.name Project ticket name (title)
     * @param {String} opts.description Project ticket description details
     * @param {Integer} opts.typeId numeric project ticket type id
     * @param {Integer} opts.milestoneId numeric project ticket milestone id
     * @param {Integer} opts.componentId numeric project ticket component id
     * @param {Integer} opts.priority project ticket priority (min &#x3D; 1 and max &#x3D; 9)
     * @param {Integer} opts.severity project ticket severity (min &#x3D; 1 and max &#x3D; 9)
     * @param {Integer} opts.owner numeric project ticket owner user id
     * @param {module:OSDN/OSDN\Model/String} opts.resolution project ticket resolution text
     * @param {module:OSDN/OSDN\Model/String} opts.status project ticket status (open or close)
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketItem}
     */
    this.updateProjectTicket = function(idOrName, ticketId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicket";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling updateProjectTicket";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'description': opts['description'],
        'type_id': opts['typeId'],
        'milestone_id': opts['milestoneId'],
        'component_id': opts['componentId'],
        'priority': opts['priority'],
        'severity': opts['severity'],
        'owner': opts['owner'],
        'resolution': opts['resolution'],
        'status': opts['status']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketItem;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicketAdminprefs operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketAdminprefsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketPrefs} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket admin preferences.
     * @param {String} idOrName numeric project id or project name
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.allowAnonymouse Non login user allows to post new ticket/comment
     * @param {module:OSDN/OSDN\Model/String} opts.frsAutosync Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39;
     * @param {module:OSDN/OSDN\Model/String} opts.mailsendType Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39;
     * @param {Integer} opts.mailingListId Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list)
     * @param {module:OSDN/OSDN\Model/String} opts.mailLang Ticket update mail language
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketAdminprefsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketPrefs}
     */
    this.updateProjectTicketAdminprefs = function(idOrName, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicketAdminprefs";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'allow_anonymouse': opts['allowAnonymouse'],
        'frs_autosync': opts['frsAutosync'],
        'mailsend_type': opts['mailsendType'],
        'mailing_list_id': opts['mailingListId'],
        'mail_lang': opts['mailLang']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketPrefs;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/admin', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComponent} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket component
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} componentId numeric project ticket component id
     * @param {Object} opts Optional parameters
     * @param {String} opts.name Ticket component name
     * @param {String} opts.description Ticket component description
     * @param {Integer} opts.owner Ticket componet owner user_id
     * @param {Boolean} opts.active Ticket componet will be shown the component select list when this parameter is true
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComponent}
     */
    this.updateProjectTicketComponent = function(idOrName, componentId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicketComponent";
      }

      // verify the required parameter 'componentId' is set
      if (componentId == undefined || componentId == null) {
        throw "Missing the required parameter 'componentId' when calling updateProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'component_id': componentId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'description': opts['description'],
        'owner': opts['owner'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComponent;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component/{component_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComponent} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket milestone
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} milestoneId numeric project ticket milestone id
     * @param {Object} opts Optional parameters
     * @param {String} opts.name Ticket milestone name
     * @param {String} opts.description Ticket milestone description
     * @param {Date} opts.start Ticket milestone start date
     * @param {Date} opts.end Ticket milestone due date
     * @param {String} opts.forceStatus If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39;
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComponent}
     */
    this.updateProjectTicketMilestone = function(idOrName, milestoneId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicketMilestone";
      }

      // verify the required parameter 'milestoneId' is set
      if (milestoneId == undefined || milestoneId == null) {
        throw "Missing the required parameter 'milestoneId' when calling updateProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'milestone_id': milestoneId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'description': opts['description'],
        'start': opts['start'],
        'end': opts['end'],
        'force_status': opts['forceStatus']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComponent;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone/{milestone_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketType} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket type
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {Object} opts Optional parameters
     * @param {String} opts.name Ticket type name
     * @param {String} opts.description Ticket type description
     * @param {Boolean} opts.isPublic if set as false, this type will be shown to project members only.
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketType}
     */
    this.updateProjectTicketType = function(idOrName, typeId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicketType";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling updateProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'description': opts['description'],
        'is_public': opts['isPublic']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketType;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTools operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateProjectToolsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/GroupToolFlags} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project tools info.
     * @param {String} idOrName numeric project id or project name
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.git use git flag
     * @param {Boolean} opts.svn use Subversion flag
     * @param {Boolean} opts.hg use Mercurial(Hg) flag
     * @param {Boolean} opts.bzr use Bazaar flag
     * @param {Boolean} opts.frs use File Release flag
     * @param {Boolean} opts.ticket use Ticket flag
     * @param {Boolean} opts.wiki use Wiki flag
     * @param {Boolean} opts.forum use Forum flag
     * @param {Boolean} opts.ml use Mailing List flag
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateProjectToolsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/GroupToolFlags}
     */
    this.updateProjectTools = function(idOrName, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTools";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'git': opts['git'],
        'svn': opts['svn'],
        'hg': opts['hg'],
        'bzr': opts['bzr'],
        'frs': opts['frs'],
        'ticket': opts['ticket'],
        'wiki': opts['wiki'],
        'forum': opts['forum'],
        'ml': opts['ml']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = GroupToolFlags;

      return this.apiClient.callApi(
        '/project/{id_or_name}/admin/tools', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateRelease operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateReleaseCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/Release} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update target release. (Note: If you update draft release, the release will be public automatically.) 
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {String} opts.name Release name
     * @param {Date} opts.time Release datetime. If you set future time, the release hide until specified time.
     * @param {Integer} opts.moveToPackageId If this parameter is specified, the release move to another package.
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateReleaseCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/Release}
     */
    this.updateRelease = function(idOrName, packageId, releaseId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateRelease";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling updateRelease";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling updateRelease";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'visibility': opts['visibility'],
        'name': opts['name'],
        'time': opts['time'],
        'move_to_package_id': opts['moveToPackageId']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = Release;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateReleaseFile operation.
     * @callback module:OSDN/OSDN\Api/ProjectApi~updateReleaseFileCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/RelFile} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Change visibility of target file.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} packageId 
     * @param {Integer} releaseId 
     * @param {Integer} fileId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.visibility visibility status (public, hidden or private)
     * @param {module:OSDN/OSDN\Api/ProjectApi~updateReleaseFileCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/RelFile}
     */
    this.updateReleaseFile = function(idOrName, packageId, releaseId, fileId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateReleaseFile";
      }

      // verify the required parameter 'packageId' is set
      if (packageId == undefined || packageId == null) {
        throw "Missing the required parameter 'packageId' when calling updateReleaseFile";
      }

      // verify the required parameter 'releaseId' is set
      if (releaseId == undefined || releaseId == null) {
        throw "Missing the required parameter 'releaseId' when calling updateReleaseFile";
      }

      // verify the required parameter 'fileId' is set
      if (fileId == undefined || fileId == null) {
        throw "Missing the required parameter 'fileId' when calling updateReleaseFile";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'package_id': packageId,
        'release_id': releaseId,
        'file_id': fileId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'visibility': opts['visibility']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = RelFile;

      return this.apiClient.callApi(
        '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
