/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/GroupProfile', 'OSDN/OSDN\Model/GroupToolFlags', 'OSDN/OSDN\Model/SimpleUser'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./GroupProfile'), require('./GroupToolFlags'), require('./SimpleUser'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.Group = factory(root.OSDNClient.ApiClient, root.OSDNClient.GroupProfile, root.OSDNClient.GroupToolFlags, root.OSDNClient.SimpleUser);
  }
}(this, function(ApiClient, GroupProfile, GroupToolFlags, SimpleUser) {
  'use strict';




  /**
   * The Group model module.
   * @module OSDN/OSDN\Model/Group
   * @version 0.0.20161031
   */

  /**
   * Constructs a new <code>Group</code>.
   * @alias module:OSDN/OSDN\Model/Group
   * @class
   */
  var exports = function() {
    var _this = this;















  };

  /**
   * Constructs a <code>Group</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:OSDN/OSDN\Model/Group} obj Optional instance to populate.
   * @return {module:OSDN/OSDN\Model/Group} The populated <code>Group</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('id')) {
        obj['id'] = ApiClient.convertToType(data['id'], 'Integer');
      }
      if (data.hasOwnProperty('name')) {
        obj['name'] = ApiClient.convertToType(data['name'], 'String');
      }
      if (data.hasOwnProperty('profile')) {
        obj['profile'] = GroupProfile.constructFromObject(data['profile']);
      }
      if (data.hasOwnProperty('last_update')) {
        obj['last_update'] = ApiClient.convertToType(data['last_update'], 'Date');
      }
      if (data.hasOwnProperty('start_date')) {
        obj['start_date'] = ApiClient.convertToType(data['start_date'], 'Date');
      }
      if (data.hasOwnProperty('license')) {
        obj['license'] = ApiClient.convertToType(data['license'], 'String');
      }
      if (data.hasOwnProperty('license_other')) {
        obj['license_other'] = ApiClient.convertToType(data['license_other'], 'String');
      }
      if (data.hasOwnProperty('url')) {
        obj['url'] = ApiClient.convertToType(data['url'], 'String');
      }
      if (data.hasOwnProperty('homepage')) {
        obj['homepage'] = ApiClient.convertToType(data['homepage'], 'String');
      }
      if (data.hasOwnProperty('logo_image')) {
        obj['logo_image'] = ApiClient.convertToType(data['logo_image'], 'String');
      }
      if (data.hasOwnProperty('banner_image')) {
        obj['banner_image'] = ApiClient.convertToType(data['banner_image'], 'String');
      }
      if (data.hasOwnProperty('thumbnail_image')) {
        obj['thumbnail_image'] = ApiClient.convertToType(data['thumbnail_image'], 'String');
      }
      if (data.hasOwnProperty('tools')) {
        obj['tools'] = GroupToolFlags.constructFromObject(data['tools']);
      }
      if (data.hasOwnProperty('members')) {
        obj['members'] = ApiClient.convertToType(data['members'], [SimpleUser]);
      }
    }
    return obj;
  }

  /**
   * @member {Integer} id
   */
  exports.prototype['id'] = undefined;
  /**
   * @member {String} name
   */
  exports.prototype['name'] = undefined;
  /**
   * @member {module:OSDN/OSDN\Model/GroupProfile} profile
   */
  exports.prototype['profile'] = undefined;
  /**
   * @member {Date} last_update
   */
  exports.prototype['last_update'] = undefined;
  /**
   * @member {Date} start_date
   */
  exports.prototype['start_date'] = undefined;
  /**
   * @member {String} license
   */
  exports.prototype['license'] = undefined;
  /**
   * @member {String} license_other
   */
  exports.prototype['license_other'] = undefined;
  /**
   * @member {String} url
   */
  exports.prototype['url'] = undefined;
  /**
   * @member {String} homepage
   */
  exports.prototype['homepage'] = undefined;
  /**
   * @member {String} logo_image
   */
  exports.prototype['logo_image'] = undefined;
  /**
   * @member {String} banner_image
   */
  exports.prototype['banner_image'] = undefined;
  /**
   * @member {String} thumbnail_image
   */
  exports.prototype['thumbnail_image'] = undefined;
  /**
   * @member {module:OSDN/OSDN\Model/GroupToolFlags} tools
   */
  exports.prototype['tools'] = undefined;
  /**
   * @member {Array.<module:OSDN/OSDN\Model/SimpleUser>} members
   */
  exports.prototype['members'] = undefined;



  return exports;
}));


