/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/I18NText', 'OSDN/OSDN\Model/ProjectTicketTypeSummary'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./I18NText'), require('./ProjectTicketTypeSummary'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.ProjectTicketType = factory(root.OSDNClient.ApiClient, root.OSDNClient.I18NText, root.OSDNClient.ProjectTicketTypeSummary);
  }
}(this, function(ApiClient, I18NText, ProjectTicketTypeSummary) {
  'use strict';




  /**
   * The ProjectTicketType model module.
   * @module OSDN/OSDN\Model/ProjectTicketType
   * @version 0.0.20161031
   */

  /**
   * Constructs a new <code>ProjectTicketType</code>.
   * @alias module:OSDN/OSDN\Model/ProjectTicketType
   * @class
   */
  var exports = function() {
    var _this = this;









  };

  /**
   * Constructs a <code>ProjectTicketType</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:OSDN/OSDN\Model/ProjectTicketType} obj Optional instance to populate.
   * @return {module:OSDN/OSDN\Model/ProjectTicketType} The populated <code>ProjectTicketType</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('id')) {
        obj['id'] = ApiClient.convertToType(data['id'], 'Integer');
      }
      if (data.hasOwnProperty('name')) {
        obj['name'] = ApiClient.convertToType(data['name'], 'String');
      }
      if (data.hasOwnProperty('description')) {
        obj['description'] = ApiClient.convertToType(data['description'], 'String');
      }
      if (data.hasOwnProperty('is_public')) {
        obj['is_public'] = ApiClient.convertToType(data['is_public'], 'Boolean');
      }
      if (data.hasOwnProperty('is_editable')) {
        obj['is_editable'] = ApiClient.convertToType(data['is_editable'], 'Boolean');
      }
      if (data.hasOwnProperty('submit_instruction')) {
        obj['submit_instruction'] = ApiClient.convertToType(data['submit_instruction'], [I18NText]);
      }
      if (data.hasOwnProperty('submit_instruction_html')) {
        obj['submit_instruction_html'] = ApiClient.convertToType(data['submit_instruction_html'], [I18NText]);
      }
      if (data.hasOwnProperty('summary')) {
        obj['summary'] = ProjectTicketTypeSummary.constructFromObject(data['summary']);
      }
    }
    return obj;
  }

  /**
   * @member {Integer} id
   */
  exports.prototype['id'] = undefined;
  /**
   * @member {String} name
   */
  exports.prototype['name'] = undefined;
  /**
   * @member {String} description
   */
  exports.prototype['description'] = undefined;
  /**
   * @member {Boolean} is_public
   */
  exports.prototype['is_public'] = undefined;
  /**
   * @member {Boolean} is_editable
   */
  exports.prototype['is_editable'] = undefined;
  /**
   * @member {Array.<module:OSDN/OSDN\Model/I18NText>} submit_instruction
   */
  exports.prototype['submit_instruction'] = undefined;
  /**
   * @member {Array.<module:OSDN/OSDN\Model/I18NText>} submit_instruction_html
   */
  exports.prototype['submit_instruction_html'] = undefined;
  /**
   * @member {module:OSDN/OSDN\Model/ProjectTicketTypeSummary} summary
   */
  exports.prototype['summary'] = undefined;



  return exports;
}));


