/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/RelFile'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./RelFile'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.Release = factory(root.OSDNClient.ApiClient, root.OSDNClient.RelFile);
  }
}(this, function(ApiClient, RelFile) {
  'use strict';




  /**
   * The Release model module.
   * @module OSDN/OSDN\Model/Release
   * @version 0.0.20161031
   */

  /**
   * Constructs a new <code>Release</code>.
   * @alias module:OSDN/OSDN\Model/Release
   * @class
   */
  var exports = function() {
    var _this = this;










  };

  /**
   * Constructs a <code>Release</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:OSDN/OSDN\Model/Release} obj Optional instance to populate.
   * @return {module:OSDN/OSDN\Model/Release} The populated <code>Release</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('id')) {
        obj['id'] = ApiClient.convertToType(data['id'], 'Integer');
      }
      if (data.hasOwnProperty('name')) {
        obj['name'] = ApiClient.convertToType(data['name'], 'String');
      }
      if (data.hasOwnProperty('url')) {
        obj['url'] = ApiClient.convertToType(data['url'], 'String');
      }
      if (data.hasOwnProperty('visibility')) {
        obj['visibility'] = ApiClient.convertToType(data['visibility'], 'String');
      }
      if (data.hasOwnProperty('cascaded_visibility')) {
        obj['cascaded_visibility'] = ApiClient.convertToType(data['cascaded_visibility'], 'String');
      }
      if (data.hasOwnProperty('package_id')) {
        obj['package_id'] = ApiClient.convertToType(data['package_id'], 'Integer');
      }
      if (data.hasOwnProperty('file_count')) {
        obj['file_count'] = ApiClient.convertToType(data['file_count'], 'Integer');
      }
      if (data.hasOwnProperty('is_draft')) {
        obj['is_draft'] = ApiClient.convertToType(data['is_draft'], 'Boolean');
      }
      if (data.hasOwnProperty('files')) {
        obj['files'] = ApiClient.convertToType(data['files'], [RelFile]);
      }
    }
    return obj;
  }

  /**
   * @member {Integer} id
   */
  exports.prototype['id'] = undefined;
  /**
   * @member {String} name
   */
  exports.prototype['name'] = undefined;
  /**
   * @member {String} url
   */
  exports.prototype['url'] = undefined;
  /**
   * @member {String} visibility
   */
  exports.prototype['visibility'] = undefined;
  /**
   * @member {String} cascaded_visibility
   */
  exports.prototype['cascaded_visibility'] = undefined;
  /**
   * @member {Integer} package_id
   */
  exports.prototype['package_id'] = undefined;
  /**
   * @member {Integer} file_count
   */
  exports.prototype['file_count'] = undefined;
  /**
   * @member {Boolean} is_draft
   */
  exports.prototype['is_draft'] = undefined;
  /**
   * @member {Array.<module:OSDN/OSDN\Model/RelFile>} files
   */
  exports.prototype['files'] = undefined;



  return exports;
}));


