/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.UserStats = factory(root.OSDNClient.ApiClient);
  }
}(this, function(ApiClient) {
  'use strict';




  /**
   * The UserStats model module.
   * @module OSDN/OSDN\Model/UserStats
   * @version 0.0.20161031
   */

  /**
   * Constructs a new <code>UserStats</code>.
   * @alias module:OSDN/OSDN\Model/UserStats
   * @class
   */
  var exports = function() {
    var _this = this;



























  };

  /**
   * Constructs a <code>UserStats</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:OSDN/OSDN\Model/UserStats} obj Optional instance to populate.
   * @return {module:OSDN/OSDN\Model/UserStats} The populated <code>UserStats</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('date')) {
        obj['date'] = ApiClient.convertToType(data['date'], 'String');
      }
      if (data.hasOwnProperty('user_point')) {
        obj['user_point'] = ApiClient.convertToType(data['user_point'], 'Integer');
      }
      if (data.hasOwnProperty('news_count')) {
        obj['news_count'] = ApiClient.convertToType(data['news_count'], 'Integer');
      }
      if (data.hasOwnProperty('git_count')) {
        obj['git_count'] = ApiClient.convertToType(data['git_count'], 'Integer');
      }
      if (data.hasOwnProperty('svn_count')) {
        obj['svn_count'] = ApiClient.convertToType(data['svn_count'], 'Integer');
      }
      if (data.hasOwnProperty('hg_count')) {
        obj['hg_count'] = ApiClient.convertToType(data['hg_count'], 'Integer');
      }
      if (data.hasOwnProperty('bzr_count')) {
        obj['bzr_count'] = ApiClient.convertToType(data['bzr_count'], 'Integer');
      }
      if (data.hasOwnProperty('cvs_count')) {
        obj['cvs_count'] = ApiClient.convertToType(data['cvs_count'], 'Integer');
      }
      if (data.hasOwnProperty('wiki_count')) {
        obj['wiki_count'] = ApiClient.convertToType(data['wiki_count'], 'Integer');
      }
      if (data.hasOwnProperty('forum_count')) {
        obj['forum_count'] = ApiClient.convertToType(data['forum_count'], 'Integer');
      }
      if (data.hasOwnProperty('forum_misc_count')) {
        obj['forum_misc_count'] = ApiClient.convertToType(data['forum_misc_count'], 'Integer');
      }
      if (data.hasOwnProperty('ticket_open_count')) {
        obj['ticket_open_count'] = ApiClient.convertToType(data['ticket_open_count'], 'Integer');
      }
      if (data.hasOwnProperty('ticket_close_count')) {
        obj['ticket_close_count'] = ApiClient.convertToType(data['ticket_close_count'], 'Integer');
      }
      if (data.hasOwnProperty('ticket_comment_count')) {
        obj['ticket_comment_count'] = ApiClient.convertToType(data['ticket_comment_count'], 'Integer');
      }
      if (data.hasOwnProperty('ticket_owner_count')) {
        obj['ticket_owner_count'] = ApiClient.convertToType(data['ticket_owner_count'], 'Integer');
      }
      if (data.hasOwnProperty('ticket_misc_count')) {
        obj['ticket_misc_count'] = ApiClient.convertToType(data['ticket_misc_count'], 'Integer');
      }
      if (data.hasOwnProperty('ticket_milestone_count')) {
        obj['ticket_milestone_count'] = ApiClient.convertToType(data['ticket_milestone_count'], 'Integer');
      }
      if (data.hasOwnProperty('group_approved_count')) {
        obj['group_approved_count'] = ApiClient.convertToType(data['group_approved_count'], 'Integer');
      }
      if (data.hasOwnProperty('group_history_count')) {
        obj['group_history_count'] = ApiClient.convertToType(data['group_history_count'], 'Integer');
      }
      if (data.hasOwnProperty('ghosted_submit_count')) {
        obj['ghosted_submit_count'] = ApiClient.convertToType(data['ghosted_submit_count'], 'Integer');
      }
      if (data.hasOwnProperty('ghosted_approve_count')) {
        obj['ghosted_approve_count'] = ApiClient.convertToType(data['ghosted_approve_count'], 'Integer');
      }
      if (data.hasOwnProperty('project_review_submit_count')) {
        obj['project_review_submit_count'] = ApiClient.convertToType(data['project_review_submit_count'], 'Integer');
      }
      if (data.hasOwnProperty('project_review_update_count')) {
        obj['project_review_update_count'] = ApiClient.convertToType(data['project_review_update_count'], 'Integer');
      }
      if (data.hasOwnProperty('project_review_rating_submit_count')) {
        obj['project_review_rating_submit_count'] = ApiClient.convertToType(data['project_review_rating_submit_count'], 'Integer');
      }
      if (data.hasOwnProperty('chamber_file_count')) {
        obj['chamber_file_count'] = ApiClient.convertToType(data['chamber_file_count'], 'Integer');
      }
      if (data.hasOwnProperty('chamber_vcs_count')) {
        obj['chamber_vcs_count'] = ApiClient.convertToType(data['chamber_vcs_count'], 'Integer');
      }
    }
    return obj;
  }

  /**
   * @member {String} date
   */
  exports.prototype['date'] = undefined;
  /**
   * @member {Integer} user_point
   */
  exports.prototype['user_point'] = undefined;
  /**
   * @member {Integer} news_count
   */
  exports.prototype['news_count'] = undefined;
  /**
   * @member {Integer} git_count
   */
  exports.prototype['git_count'] = undefined;
  /**
   * @member {Integer} svn_count
   */
  exports.prototype['svn_count'] = undefined;
  /**
   * @member {Integer} hg_count
   */
  exports.prototype['hg_count'] = undefined;
  /**
   * @member {Integer} bzr_count
   */
  exports.prototype['bzr_count'] = undefined;
  /**
   * @member {Integer} cvs_count
   */
  exports.prototype['cvs_count'] = undefined;
  /**
   * @member {Integer} wiki_count
   */
  exports.prototype['wiki_count'] = undefined;
  /**
   * @member {Integer} forum_count
   */
  exports.prototype['forum_count'] = undefined;
  /**
   * @member {Integer} forum_misc_count
   */
  exports.prototype['forum_misc_count'] = undefined;
  /**
   * @member {Integer} ticket_open_count
   */
  exports.prototype['ticket_open_count'] = undefined;
  /**
   * @member {Integer} ticket_close_count
   */
  exports.prototype['ticket_close_count'] = undefined;
  /**
   * @member {Integer} ticket_comment_count
   */
  exports.prototype['ticket_comment_count'] = undefined;
  /**
   * @member {Integer} ticket_owner_count
   */
  exports.prototype['ticket_owner_count'] = undefined;
  /**
   * @member {Integer} ticket_misc_count
   */
  exports.prototype['ticket_misc_count'] = undefined;
  /**
   * @member {Integer} ticket_milestone_count
   */
  exports.prototype['ticket_milestone_count'] = undefined;
  /**
   * @member {Integer} group_approved_count
   */
  exports.prototype['group_approved_count'] = undefined;
  /**
   * @member {Integer} group_history_count
   */
  exports.prototype['group_history_count'] = undefined;
  /**
   * @member {Integer} ghosted_submit_count
   */
  exports.prototype['ghosted_submit_count'] = undefined;
  /**
   * @member {Integer} ghosted_approve_count
   */
  exports.prototype['ghosted_approve_count'] = undefined;
  /**
   * @member {Integer} project_review_submit_count
   */
  exports.prototype['project_review_submit_count'] = undefined;
  /**
   * @member {Integer} project_review_update_count
   */
  exports.prototype['project_review_update_count'] = undefined;
  /**
   * @member {Integer} project_review_rating_submit_count
   */
  exports.prototype['project_review_rating_submit_count'] = undefined;
  /**
   * @member {Integer} chamber_file_count
   */
  exports.prototype['chamber_file_count'] = undefined;
  /**
   * @member {Integer} chamber_vcs_count
   */
  exports.prototype['chamber_vcs_count'] = undefined;



  return exports;
}));


