# OSDN\ProjectApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createNews**](ProjectApi.md#createNews) | **POST** /news | 
[**createNews_0**](ProjectApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
[**createPackage**](ProjectApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
[**createProjectBzr**](ProjectApi.md#createProjectBzr) | **POST** /project/{id_or_name}/bzr | 
[**createProjectGit**](ProjectApi.md#createProjectGit) | **POST** /project/{id_or_name}/git | 
[**createProjectGitHook**](ProjectApi.md#createProjectGitHook) | **POST** /project/{id_or_name}/git/{repo_id}/hooks | 
[**createProjectHg**](ProjectApi.md#createProjectHg) | **POST** /project/{id_or_name}/hg | 
[**createProjectProfile**](ProjectApi.md#createProjectProfile) | **POST** /project/{id_or_name}/admin/profile | 
[**createProjectTicket**](ProjectApi.md#createProjectTicket) | **POST** /project/{id_or_name}/ticket | 
[**createProjectTicketComment**](ProjectApi.md#createProjectTicketComment) | **POST** /project/{id_or_name}/ticket/{ticket_id}/comment | 
[**createProjectTicketComponent**](ProjectApi.md#createProjectTicketComponent) | **POST** /project/{id_or_name}/ticket/component | 
[**createProjectTicketMilestone**](ProjectApi.md#createProjectTicketMilestone) | **POST** /project/{id_or_name}/ticket/milestone | 
[**createProjectTicketType**](ProjectApi.md#createProjectTicketType) | **POST** /project/{id_or_name}/ticket/type | 
[**createProjectTicketTypeInstruction**](ProjectApi.md#createProjectTicketTypeInstruction) | **POST** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
[**createRelease**](ProjectApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
[**createReleaseFile**](ProjectApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteNews**](ProjectApi.md#deleteNews) | **DELETE** /news/{news_id} | 
[**deleteNews_0**](ProjectApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
[**deletePackage**](ProjectApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
[**deleteProjectAdminProjectweb**](ProjectApi.md#deleteProjectAdminProjectweb) | **DELETE** /project/{id_or_name}/admin/project_web | 
[**deleteProjectGitHook**](ProjectApi.md#deleteProjectGitHook) | **DELETE** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**deleteProjectProfile**](ProjectApi.md#deleteProjectProfile) | **DELETE** /project/{id_or_name}/admin/profile/{language_code} | 
[**deleteProjectTicketComponent**](ProjectApi.md#deleteProjectTicketComponent) | **DELETE** /project/{id_or_name}/ticket/component/{component_id} | 
[**deleteProjectTicketMilestone**](ProjectApi.md#deleteProjectTicketMilestone) | **DELETE** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**deleteProjectTicketType**](ProjectApi.md#deleteProjectTicketType) | **DELETE** /project/{id_or_name}/ticket/type/{type_id} | 
[**deleteProjectTicketTypeInstruction**](ProjectApi.md#deleteProjectTicketTypeInstruction) | **DELETE** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**deleteRelease**](ProjectApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteReleaseFile**](ProjectApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**disableProjectBzr**](ProjectApi.md#disableProjectBzr) | **DELETE** /project/{id_or_name}/bzr/{repo_id} | 
[**disableProjectGit**](ProjectApi.md#disableProjectGit) | **DELETE** /project/{id_or_name}/git/{repo_id} | 
[**disableProjectHg**](ProjectApi.md#disableProjectHg) | **DELETE** /project/{id_or_name}/hg/{repo_id} | 
[**draftRelease**](ProjectApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
[**getFrsAdminprefs**](ProjectApi.md#getFrsAdminprefs) | **GET** /project/{id_or_name}/frs/admin | 
[**getNews**](ProjectApi.md#getNews) | **GET** /news/{news_id} | 
[**getNews_0**](ProjectApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
[**getPackage**](ProjectApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
[**getProject**](ProjectApi.md#getProject) | **GET** /project/{id_or_name} | 
[**getProjectAdminProjectweb**](ProjectApi.md#getProjectAdminProjectweb) | **GET** /project/{id_or_name}/admin/project_web | 
[**getProjectBzr**](ProjectApi.md#getProjectBzr) | **GET** /project/{id_or_name}/bzr/{repo_id} | 
[**getProjectGit**](ProjectApi.md#getProjectGit) | **GET** /project/{id_or_name}/git/{repo_id} | 
[**getProjectGitHook**](ProjectApi.md#getProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**getProjectHg**](ProjectApi.md#getProjectHg) | **GET** /project/{id_or_name}/hg/{repo_id} | 
[**getProjectHistories**](ProjectApi.md#getProjectHistories) | **GET** /project/{id_or_name}/history | 
[**getProjectProfile**](ProjectApi.md#getProjectProfile) | **GET** /project/{id_or_name}/admin/profile/{language_code} | 
[**getProjectProfileList**](ProjectApi.md#getProjectProfileList) | **GET** /project/{id_or_name}/admin/profile | 
[**getProjectSvn**](ProjectApi.md#getProjectSvn) | **GET** /project/{id_or_name}/svn | 
[**getProjectTicket**](ProjectApi.md#getProjectTicket) | **GET** /project/{id_or_name}/ticket/{ticket_id} | 
[**getProjectTicketComponent**](ProjectApi.md#getProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component/{component_id} | 
[**getProjectTicketMilestone**](ProjectApi.md#getProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**getProjectTicketType**](ProjectApi.md#getProjectTicketType) | **GET** /project/{id_or_name}/ticket/type/{type_id} | 
[**getProjectTicketTypeInstruction**](ProjectApi.md#getProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**getProjectTicketTypeInstruction_0**](ProjectApi.md#getProjectTicketTypeInstruction_0) | **PATCH** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**getProjectTools**](ProjectApi.md#getProjectTools) | **GET** /project/{id_or_name}/admin/tools | 
[**getRelease**](ProjectApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**getReleaseFile**](ProjectApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**listNews**](ProjectApi.md#listNews) | **GET** /news | 
[**listNews_0**](ProjectApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
[**listPackages**](ProjectApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
[**listProjectBzr**](ProjectApi.md#listProjectBzr) | **GET** /project/{id_or_name}/bzr | 
[**listProjectGit**](ProjectApi.md#listProjectGit) | **GET** /project/{id_or_name}/git | 
[**listProjectGitHook**](ProjectApi.md#listProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks | 
[**listProjectHg**](ProjectApi.md#listProjectHg) | **GET** /project/{id_or_name}/hg | 
[**listProjectTicket**](ProjectApi.md#listProjectTicket) | **GET** /project/{id_or_name}/ticket | 
[**listProjectTicketComment**](ProjectApi.md#listProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment | 
[**listProjectTicketComponent**](ProjectApi.md#listProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component | 
[**listProjectTicketMilestone**](ProjectApi.md#listProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone | 
[**listProjectTicketType**](ProjectApi.md#listProjectTicketType) | **GET** /project/{id_or_name}/ticket/type | 
[**listProjectTicketTypeInstruction**](ProjectApi.md#listProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
[**showProjectTicketAdminprefs**](ProjectApi.md#showProjectTicketAdminprefs) | **GET** /project/{id_or_name}/ticket/admin | 
[**showProjectTicketComment**](ProjectApi.md#showProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id} | 
[**updateFrsAdminprefs**](ProjectApi.md#updateFrsAdminprefs) | **PATCH** /project/{id_or_name}/frs/admin | 
[**updateNews**](ProjectApi.md#updateNews) | **PATCH** /news/{news_id} | 
[**updateNews_0**](ProjectApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
[**updatePackage**](ProjectApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
[**updateProjectAdminProjectweb**](ProjectApi.md#updateProjectAdminProjectweb) | **PATCH** /project/{id_or_name}/admin/project_web | 
[**updateProjectBzr**](ProjectApi.md#updateProjectBzr) | **PATCH** /project/{id_or_name}/bzr/{repo_id} | 
[**updateProjectGit**](ProjectApi.md#updateProjectGit) | **PATCH** /project/{id_or_name}/git/{repo_id} | 
[**updateProjectHg**](ProjectApi.md#updateProjectHg) | **PATCH** /project/{id_or_name}/hg/{repo_id} | 
[**updateProjectProfile**](ProjectApi.md#updateProjectProfile) | **PATCH** /project/{id_or_name}/admin/profile/{language_code} | 
[**updateProjectTicket**](ProjectApi.md#updateProjectTicket) | **PATCH** /project/{id_or_name}/ticket/{ticket_id} | 
[**updateProjectTicketAdminprefs**](ProjectApi.md#updateProjectTicketAdminprefs) | **PATCH** /project/{id_or_name}/ticket/admin | 
[**updateProjectTicketComponent**](ProjectApi.md#updateProjectTicketComponent) | **PATCH** /project/{id_or_name}/ticket/component/{component_id} | 
[**updateProjectTicketMilestone**](ProjectApi.md#updateProjectTicketMilestone) | **PATCH** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**updateProjectTicketType**](ProjectApi.md#updateProjectTicketType) | **PATCH** /project/{id_or_name}/ticket/type/{type_id} | 
[**updateProjectTools**](ProjectApi.md#updateProjectTools) | **PATCH** /project/{id_or_name}/admin/tools | 
[**updateRelease**](ProjectApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**updateReleaseFile**](ProjectApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 


# **createNews**
> string createNews($title, $body, $group_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.
$group_id = 56; // int | group_id the news created in

try {
    $result = $api_instance->createNews($title, $body, $group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **title** | **string**| news title |
 **body** | **string**| news body in OSDN Wiki format. |
 **group_id** | **int**| group_id the news created in |

### Return type

**string**

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createNews_0**
> string createNews_0($id_or_name, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->createNews_0($id_or_name, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **title** | **string**| news title |
 **body** | **string**| news body in OSDN Wiki format. |

### Return type

**string**

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createPackage**
> \OSDN\Model\Package createPackage($id_or_name, $name, $visibility)



Create a package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | package name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->createPackage($id_or_name, $name, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| package name |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectBzr**
> \OSDN\Model\ProjectBzr createProjectBzr($id_or_name, $name, $description)



Create a new bzr repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | 
$description = "description_example"; // string | 

try {
    $result = $api_instance->createProjectBzr($id_or_name, $name, $description);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**|  |
 **description** | **string**|  | [optional]

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectGit**
> \OSDN\Model\ProjectGit createProjectGit($id_or_name, $name, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $default_branch)



Create a new git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | 
$description = "description_example"; // string | 
$mail_enabled = true; // bool | 
$mail_recipients = "mail_recipients_example"; // string | 
$allow_non_fast_forward = true; // bool | 
$default_branch = "default_branch_example"; // string | 

try {
    $result = $api_instance->createProjectGit($id_or_name, $name, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $default_branch);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**|  |
 **description** | **string**|  | [optional]
 **mail_enabled** | **bool**|  | [optional]
 **mail_recipients** | **string**|  | [optional]
 **allow_non_fast_forward** | **bool**|  | [optional]
 **default_branch** | **string**|  | [optional]

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectGitHook**
> \OSDN\Model\ScmHook createProjectGitHook($id_or_name, $repo_id, $target_url)



Create a new hook for project git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$target_url = "target_url_example"; // string | 

try {
    $result = $api_instance->createProjectGitHook($id_or_name, $repo_id, $target_url);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **target_url** | **string**|  |

### Return type

[**\OSDN\Model\ScmHook**](../Model/ScmHook.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectHg**
> \OSDN\Model\ProjectHg createProjectHg($id_or_name, $name, $description, $mail_recipients)



Create a new hg repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | 
$description = "description_example"; // string | 
$mail_recipients = "mail_recipients_example"; // string | 

try {
    $result = $api_instance->createProjectHg($id_or_name, $name, $description, $mail_recipients);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**|  |
 **description** | **string**|  | [optional]
 **mail_recipients** | **string**|  | [optional]

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectProfile**
> \OSDN\Model\GroupProfile createProjectProfile($id_or_name, $language_code, $display_name, $description)



Create project profile for the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)
$display_name = "display_name_example"; // string | Project display name
$description = "description_example"; // string | Project description

try {
    $result = $api_instance->createProjectProfile($id_or_name, $language_code, $display_name, $description);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectProfile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |
 **display_name** | **string**| Project display name |
 **description** | **string**| Project description |

### Return type

[**\OSDN\Model\GroupProfile**](../Model/GroupProfile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicket**
> \OSDN\Model\ProjectTicketItem createProjectTicket($id_or_name, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner)



Create project ticket

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | Project ticket name (title)
$description = "description_example"; // string | Project ticket description details
$type_id = 56; // int | numeric project ticket type id
$milestone_id = 56; // int | numeric project ticket milestone id
$component_id = 56; // int | numeric project ticket component id
$priority = 56; // int | project ticket priority (min = 1 and max = 9)
$severity = 56; // int | project ticket severity (min = 1 and max = 9)
$owner = 56; // int | numeric project ticket owner user id

try {
    $result = $api_instance->createProjectTicket($id_or_name, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectTicket: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| Project ticket name (title) |
 **description** | **string**| Project ticket description details |
 **type_id** | **int**| numeric project ticket type id |
 **milestone_id** | **int**| numeric project ticket milestone id | [optional]
 **component_id** | **int**| numeric project ticket component id | [optional]
 **priority** | **int**| project ticket priority (min &#x3D; 1 and max &#x3D; 9) | [optional]
 **severity** | **int**| project ticket severity (min &#x3D; 1 and max &#x3D; 9) | [optional]
 **owner** | **int**| numeric project ticket owner user id | [optional]

### Return type

[**\OSDN\Model\ProjectTicketItem**](../Model/ProjectTicketItem.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketComment**
> \OSDN\Model\ProjectTicketComment createProjectTicketComment($id_or_name, $ticket_id, $comment)



Create new project ticket comment of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id
$comment = "comment_example"; // string | Ticket comment text

try {
    $result = $api_instance->createProjectTicketComment($id_or_name, $ticket_id, $comment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectTicketComment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |
 **comment** | **string**| Ticket comment text |

### Return type

[**\OSDN\Model\ProjectTicketComment**](../Model/ProjectTicketComment.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketComponent**
> \OSDN\Model\ProjectTicketComponent[] createProjectTicketComponent($id_or_name, $name, $description, $owner, $active)



Create new project ticket component of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | Ticket component name
$description = "description_example"; // string | Ticket component description
$owner = 56; // int | Ticket componet owner user_id
$active = true; // bool | Ticket componet will be shown the component select list when this parameter is true

try {
    $result = $api_instance->createProjectTicketComponent($id_or_name, $name, $description, $owner, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| Ticket component name |
 **description** | **string**| Ticket component description |
 **owner** | **int**| Ticket componet owner user_id | [optional]
 **active** | **bool**| Ticket componet will be shown the component select list when this parameter is true | [optional]

### Return type

[**\OSDN\Model\ProjectTicketComponent[]**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketMilestone**
> \OSDN\Model\ProjectTicketMilestone createProjectTicketMilestone($id_or_name, $name, $description, $start, $end)



Create new project ticket milestone of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | Ticket milestone name
$description = "description_example"; // string | Ticket milestone description
$start = new \DateTime(); // \DateTime | Ticket milestone start date
$end = new \DateTime(); // \DateTime | Ticket milestone due date

try {
    $result = $api_instance->createProjectTicketMilestone($id_or_name, $name, $description, $start, $end);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| Ticket milestone name |
 **description** | **string**| Ticket milestone description |
 **start** | **\DateTime**| Ticket milestone start date | [optional]
 **end** | **\DateTime**| Ticket milestone due date | [optional]

### Return type

[**\OSDN\Model\ProjectTicketMilestone**](../Model/ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketType**
> \OSDN\Model\ProjectTicketType createProjectTicketType($id_or_name, $name, $description, $is_public)



Create new project ticket type of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$name = "name_example"; // string | Ticket type name
$description = "description_example"; // string | Ticket type description
$is_public = true; // bool | if set as false, this type will be shown to project members only.

try {
    $result = $api_instance->createProjectTicketType($id_or_name, $name, $description, $is_public);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **name** | **string**| Ticket type name |
 **description** | **string**| Ticket type description |
 **is_public** | **bool**| if set as false, this type will be shown to project members only. | [optional]

### Return type

[**\OSDN\Model\ProjectTicketType**](../Model/ProjectTicketType.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProjectTicketTypeInstruction**
> \OSDN\Model\ProjectTicketTypeInstructionPerLanguage createProjectTicketTypeInstruction($id_or_name, $type_id, $language_code, $instruction)



Create project ticket type instructions for the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)
$instruction = "instruction_example"; // string | Ticket submit instruction for the type

try {
    $result = $api_instance->createProjectTicketTypeInstruction($id_or_name, $type_id, $language_code, $instruction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createProjectTicketTypeInstruction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |
 **instruction** | **string**| Ticket submit instruction for the type |

### Return type

[**\OSDN\Model\ProjectTicketTypeInstructionPerLanguage**](../Model/ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createRelease**
> \OSDN\Model\Release createRelease($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log)



Create new release in specified package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$name = "name_example"; // string | Release name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)
$time = new \DateTime(); // \DateTime | Release datetime. If you set future time, the release hide until specified time.
$release_note = "release_note_example"; // string | Release note body text.
$change_log = "change_log_example"; // string | Changelog body text.

try {
    $result = $api_instance->createRelease($id_or_name, $package_id, $name, $visibility, $time, $release_note, $change_log);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **name** | **string**| Release name |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]
 **time** | **\DateTime**| Release datetime. If you set future time, the release hide until specified time. | [optional]
 **release_note** | **string**| Release note body text. | [optional]
 **change_log** | **string**| Changelog body text. | [optional]

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createReleaseFile**
> \OSDN\Model\RelFile createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility)



Create new file in target release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file = "/path/to/file.txt"; // \SplFileObject | Upload file in \"multipart/form-data\".
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->createReleaseFile($id_or_name, $package_id, $release_id, $file, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->createReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file** | **\SplFileObject**| Upload file in \&quot;multipart/form-data\&quot;. |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteNews**
> deleteNews($news_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 

try {
    $api_instance->deleteNews($news_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteNews_0**
> deleteNews_0($id_or_name, $news_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$news_id = 56; // int | 

try {
    $api_instance->deleteNews_0($id_or_name, $news_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **news_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deletePackage**
> deletePackage($id_or_name, $package_id)



Delete taret package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $api_instance->deletePackage($id_or_name, $package_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deletePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectAdminProjectweb**
> deleteProjectAdminProjectweb($id_or_name)



Delete project homepage url

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $api_instance->deleteProjectAdminProjectweb($id_or_name);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteProjectAdminProjectweb: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectGitHook**
> deleteProjectGitHook($id_or_name, $repo_id, $hook_id)



Delete a Git repository hook

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$hook_id = 56; // int | 

try {
    $api_instance->deleteProjectGitHook($id_or_name, $repo_id, $hook_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **hook_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectProfile**
> deleteProjectProfile($id_or_name, $language_code)



Delete project profile for the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)

try {
    $api_instance->deleteProjectProfile($id_or_name, $language_code);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteProjectProfile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectTicketComponent**
> deleteProjectTicketComponent($id_or_name, $component_id, $migrate_to)



Delete project ticket component

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$component_id = 56; // int | numeric project ticket component id
$migrate_to = 56; // int | Tickets that assigned to delete target will be migrate to the ticket component_id

try {
    $api_instance->deleteProjectTicketComponent($id_or_name, $component_id, $migrate_to);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **component_id** | **int**| numeric project ticket component id |
 **migrate_to** | **int**| Tickets that assigned to delete target will be migrate to the ticket component_id |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectTicketMilestone**
> deleteProjectTicketMilestone($id_or_name, $milestone_id, $migrate_to)



Delete project ticket milestone

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$milestone_id = 56; // int | numeric project ticket milestone id
$migrate_to = 56; // int | Tickets that assigned to delete target will be migrate to the ticket milestone_id

try {
    $api_instance->deleteProjectTicketMilestone($id_or_name, $milestone_id, $migrate_to);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **milestone_id** | **int**| numeric project ticket milestone id |
 **migrate_to** | **int**| Tickets that assigned to delete target will be migrate to the ticket milestone_id | [optional]

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectTicketType**
> deleteProjectTicketType($id_or_name, $type_id, $migrate_to)



Delete project ticket type

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$migrate_to = 56; // int | Tickets that assigned to delete target will be migrate to the ticket type_id

try {
    $api_instance->deleteProjectTicketType($id_or_name, $type_id, $migrate_to);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **migrate_to** | **int**| Tickets that assigned to delete target will be migrate to the ticket type_id |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProjectTicketTypeInstruction**
> deleteProjectTicketTypeInstruction($id_or_name, $type_id, $language_code)



Delete project ticket type instructions on the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)

try {
    $api_instance->deleteProjectTicketTypeInstruction($id_or_name, $type_id, $language_code);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteProjectTicketTypeInstruction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRelease**
> deleteRelease($id_or_name, $package_id, $release_id)



Delete target release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 

try {
    $api_instance->deleteRelease($id_or_name, $package_id, $release_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteReleaseFile**
> deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id)



Delete target file.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 

try {
    $api_instance->deleteReleaseFile($id_or_name, $package_id, $release_id, $file_id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->deleteReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **disableProjectBzr**
> \OSDN\Model\ProjectBzr disableProjectBzr($id_or_name, $repo_id)



Disable a bzr repository (not an actual delete, just a shorthand for updating with active=false)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->disableProjectBzr($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->disableProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **disableProjectGit**
> \OSDN\Model\ProjectGit disableProjectGit($id_or_name, $repo_id)



Disable a git repository (not an actual delete, just a shorthand for updating with active=false)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->disableProjectGit($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->disableProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **disableProjectHg**
> \OSDN\Model\ProjectHg disableProjectHg($id_or_name, $repo_id)



Disable a hg repository (not an actual delete, just a shorthand for updating with active=false)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->disableProjectHg($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->disableProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **draftRelease**
> \OSDN\Model\Release draftRelease($id_or_name, $package_id)



Get release draft in specified package. If draft is not exist, it will be created automatically.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $result = $api_instance->draftRelease($id_or_name, $package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->draftRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFrsAdminprefs**
> \OSDN\Model\FrsAdminPrefs getFrsAdminprefs($id_or_name)



Get project frs admin preferences.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getFrsAdminprefs($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getFrsAdminprefs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\FrsAdminPrefs**](../Model/FrsAdminPrefs.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNews**
> \OSDN\Model\News getNews($news_id)



Get single news object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 

try {
    $result = $api_instance->getNews($news_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getNews_0**
> \OSDN\Model\News getNews_0($id_or_name, $news_id)



Get single news object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$news_id = 56; // int | 

try {
    $result = $api_instance->getNews_0($id_or_name, $news_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **news_id** | **int**|  |

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPackage**
> \OSDN\Model\Package getPackage($id_or_name, $package_id)



Get specified package info and release list of the package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 

try {
    $result = $api_instance->getPackage($id_or_name, $package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getPackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProject**
> \OSDN\Model\Group getProject($id_or_name)



Get project info.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProject($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProject: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\Group**](../Model/Group.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectAdminProjectweb**
> \OSDN\Model\ProjectWeb getProjectAdminProjectweb($id_or_name)



Get project homepage url

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectAdminProjectweb($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectAdminProjectweb: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectWeb**](../Model/ProjectWeb.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectBzr**
> \OSDN\Model\ProjectBzr getProjectBzr($id_or_name, $repo_id)



Get a bzr repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->getProjectBzr($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectGit**
> \OSDN\Model\ProjectGit getProjectGit($id_or_name, $repo_id)



Get a git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->getProjectGit($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectGitHook**
> \OSDN\Model\ScmHook getProjectGitHook($id_or_name, $repo_id, $hook_id)



Get a repository hook

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$hook_id = 56; // int | 

try {
    $result = $api_instance->getProjectGitHook($id_or_name, $repo_id, $hook_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **hook_id** | **int**|  |

### Return type

[**\OSDN\Model\ScmHook**](../Model/ScmHook.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectHg**
> \OSDN\Model\ProjectHg getProjectHg($id_or_name, $repo_id)



Get a hg repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->getProjectHg($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectHistories**
> \OSDN\Model\History[] getProjectHistories($id_or_name)



Get project histories.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectHistories($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectHistories: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\History[]**](../Model/History.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectProfile**
> \OSDN\Model\GroupProfilePerLanguage getProjectProfile($id_or_name, $language_code)



Get project profile on the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)

try {
    $result = $api_instance->getProjectProfile($id_or_name, $language_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectProfile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |

### Return type

[**\OSDN\Model\GroupProfilePerLanguage**](../Model/GroupProfilePerLanguage.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectProfileList**
> \OSDN\Model\GroupProfile getProjectProfileList($id_or_name)



Get project profile in all languages

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectProfileList($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectProfileList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\GroupProfile**](../Model/GroupProfile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectSvn**
> \OSDN\Model\ProjectSvn getProjectSvn($id_or_name)



Get Subversion repository of the project

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectSvn($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectSvn: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectSvn**](../Model/ProjectSvn.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicket**
> \OSDN\Model\ProjectTicketItem getProjectTicket($id_or_name, $ticket_id)



Get project ticket

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id

try {
    $result = $api_instance->getProjectTicket($id_or_name, $ticket_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectTicket: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |

### Return type

[**\OSDN\Model\ProjectTicketItem**](../Model/ProjectTicketItem.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketComponent**
> \OSDN\Model\ProjectTicketComponent getProjectTicketComponent($id_or_name, $component_id)



Get project ticket component

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$component_id = 56; // int | numeric project ticket component id

try {
    $result = $api_instance->getProjectTicketComponent($id_or_name, $component_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **component_id** | **int**| numeric project ticket component id |

### Return type

[**\OSDN\Model\ProjectTicketComponent**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketMilestone**
> \OSDN\Model\ProjectTicketMilestone getProjectTicketMilestone($id_or_name, $milestone_id)



Get project ticket milestone of spscified milestone_id.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$milestone_id = 56; // int | numeric project ticket milestone id

try {
    $result = $api_instance->getProjectTicketMilestone($id_or_name, $milestone_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **milestone_id** | **int**| numeric project ticket milestone id |

### Return type

[**\OSDN\Model\ProjectTicketMilestone**](../Model/ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketType**
> \OSDN\Model\ProjectTicketType getProjectTicketType($id_or_name, $type_id)



Get project ticket type

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id

try {
    $result = $api_instance->getProjectTicketType($id_or_name, $type_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |

### Return type

[**\OSDN\Model\ProjectTicketType**](../Model/ProjectTicketType.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketTypeInstruction**
> \OSDN\Model\ProjectTicketTypeInstructionPerLanguage getProjectTicketTypeInstruction($id_or_name, $type_id, $language_code)



Get project ticket type instructions on the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)

try {
    $result = $api_instance->getProjectTicketTypeInstruction($id_or_name, $type_id, $language_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectTicketTypeInstruction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |

### Return type

[**\OSDN\Model\ProjectTicketTypeInstructionPerLanguage**](../Model/ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTicketTypeInstruction_0**
> \OSDN\Model\ProjectTicketTypeInstructionPerLanguage getProjectTicketTypeInstruction_0($id_or_name, $type_id, $language_code, $instruction)



Update project ticket type instructions on the language

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)
$instruction = "instruction_example"; // string | Ticket submit instruction for the type

try {
    $result = $api_instance->getProjectTicketTypeInstruction_0($id_or_name, $type_id, $language_code, $instruction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectTicketTypeInstruction_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |
 **instruction** | **string**| Ticket submit instruction for the type |

### Return type

[**\OSDN\Model\ProjectTicketTypeInstructionPerLanguage**](../Model/ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProjectTools**
> \OSDN\Model\GroupToolFlags getProjectTools($id_or_name)



Get project tools info.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->getProjectTools($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getProjectTools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\GroupToolFlags**](../Model/GroupToolFlags.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRelease**
> \OSDN\Model\Release getRelease($id_or_name, $package_id, $release_id)



Get specified release info and file list of the release.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 

try {
    $result = $api_instance->getRelease($id_or_name, $package_id, $release_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReleaseFile**
> \OSDN\Model\RelFile getReleaseFile($id_or_name, $package_id, $release_id, $file_id)



Get single file object.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 

try {
    $result = $api_instance->getReleaseFile($id_or_name, $package_id, $release_id, $file_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->getReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listNews**
> \OSDN\Model\News[] listNews($group_id)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$group_id = 56; // int | filter by group ID

try {
    $result = $api_instance->listNews($group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **group_id** | **int**| filter by group ID | [optional]

### Return type

[**\OSDN\Model\News[]**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listNews_0**
> \OSDN\Model\News[] listNews_0($id_or_name)



Get news list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listNews_0($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\News[]**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listPackages**
> \OSDN\Model\Package[] listPackages($id_or_name)



Get package list of specified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listPackages($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listPackages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\Package[]**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectBzr**
> \OSDN\Model\ProjectBzr[] listProjectBzr($id_or_name)



Get Bazzar repository list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectBzr($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectBzr[]**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectGit**
> \OSDN\Model\ProjectGit[] listProjectGit($id_or_name)



Get git repository list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectGit($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectGit[]**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectGitHook**
> \OSDN\Model\ScmHook[] listProjectGitHook($id_or_name, $repo_id)



Get Git repository hook list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 

try {
    $result = $api_instance->listProjectGitHook($id_or_name, $repo_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectGitHook: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |

### Return type

[**\OSDN\Model\ScmHook[]**](../Model/ScmHook.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectHg**
> \OSDN\Model\ProjectHg[] listProjectHg($id_or_name)



Get Mercurial repository list

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectHg($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectHg[]**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicket**
> \OSDN\Model\ProjectTicketItem[] listProjectTicket($id_or_name, $status, $type_id, $not_type_id, $component_id, $not_component_id, $milestone_id, $not_milestone_id, $max_priority, $min_priority, $priority, $max_severity, $min_severity, $severity, $owner, $not_owner, $reporter, $not_reporter, $text)



List project ticket order by submit date descending

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$status = array("status_example"); // string[] | Tickets are assigned to these type_ids
$type_id = array(56); // int[] | Listing tickets are assigned to these type_ids
$not_type_id = array(56); // int[] | Listing tickets are NOT assigned to these type_ids
$component_id = array(56); // int[] | Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
$not_component_id = array(56); // int[] | Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
$milestone_id = array(56); // int[] | Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id = 0)
$not_milestone_id = array(56); // int[] | Listing tickets are NOT assigned to these milestone_ids (milestone_id = 0 means milestone not assigned)
$max_priority = 56; // int | Listing equal or lower priority tickets
$min_priority = 56; // int | Listing equal or higher priority tickets
$priority = 56; // int | Listing tickets have this priority
$max_severity = 56; // int | Listing equal or lower severity tickets
$min_severity = 56; // int | Listing equal or higher severity tickets
$severity = 56; // int | Listing tickets have this severity
$owner = array(56); // int[] | Listing tickets assigned to these owners (owner = 100 means owner is not assigned)
$not_owner = array(56); // int[] | Listing tickets NOT assigned to these owners (owner = 100 means owner is not assigned)
$reporter = array(56); // int[] | Listing tickets reported by these users (report = 100 means reported by non login user)
$not_reporter = array(56); // int[] | Listing tickets reported by these users (report = 100 means reported by non login user)
$text = "text_example"; // string | Listing tickets title or description or comment include the text

try {
    $result = $api_instance->listProjectTicket($id_or_name, $status, $type_id, $not_type_id, $component_id, $not_component_id, $milestone_id, $not_milestone_id, $max_priority, $min_priority, $priority, $max_severity, $min_severity, $severity, $owner, $not_owner, $reporter, $not_reporter, $text);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectTicket: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **status** | [**string[]**](../Model/string.md)| Tickets are assigned to these type_ids | [optional]
 **type_id** | [**int[]**](../Model/int.md)| Listing tickets are assigned to these type_ids | [optional]
 **not_type_id** | [**int[]**](../Model/int.md)| Listing tickets are NOT assigned to these type_ids | [optional]
 **component_id** | [**int[]**](../Model/int.md)| Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) | [optional]
 **not_component_id** | [**int[]**](../Model/int.md)| Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) | [optional]
 **milestone_id** | [**int[]**](../Model/int.md)| Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0) | [optional]
 **not_milestone_id** | [**int[]**](../Model/int.md)| Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned) | [optional]
 **max_priority** | **int**| Listing equal or lower priority tickets | [optional]
 **min_priority** | **int**| Listing equal or higher priority tickets | [optional]
 **priority** | **int**| Listing tickets have this priority | [optional]
 **max_severity** | **int**| Listing equal or lower severity tickets | [optional]
 **min_severity** | **int**| Listing equal or higher severity tickets | [optional]
 **severity** | **int**| Listing tickets have this severity | [optional]
 **owner** | [**int[]**](../Model/int.md)| Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned) | [optional]
 **not_owner** | [**int[]**](../Model/int.md)| Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned) | [optional]
 **reporter** | [**int[]**](../Model/int.md)| Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) | [optional]
 **not_reporter** | [**int[]**](../Model/int.md)| Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) | [optional]
 **text** | **string**| Listing tickets title or description or comment include the text | [optional]

### Return type

[**\OSDN\Model\ProjectTicketItem[]**](../Model/ProjectTicketItem.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketComment**
> \OSDN\Model\ProjectTicketComment[] listProjectTicketComment($id_or_name, $ticket_id)



Get project ticket comment list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id

try {
    $result = $api_instance->listProjectTicketComment($id_or_name, $ticket_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectTicketComment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |

### Return type

[**\OSDN\Model\ProjectTicketComment[]**](../Model/ProjectTicketComment.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketComponent**
> \OSDN\Model\ProjectTicketComponent[] listProjectTicketComponent($id_or_name)



Get project ticket component list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectTicketComponent($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectTicketComponent[]**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketMilestone**
> \OSDN\Model\ProjectTicketMilestone[] listProjectTicketMilestone($id_or_name)



Get project ticket milestone list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectTicketMilestone($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectTicketMilestone[]**](../Model/ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketType**
> \OSDN\Model\ProjectTicketType[] listProjectTicketType($id_or_name)



Get project ticket type list of spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->listProjectTicketType($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectTicketType[]**](../Model/ProjectTicketType.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **listProjectTicketTypeInstruction**
> \OSDN\Model\ProjectTicketTypeInstructions listProjectTicketTypeInstruction($id_or_name, $type_id)



Get project ticket type instructions

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id

try {
    $result = $api_instance->listProjectTicketTypeInstruction($id_or_name, $type_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->listProjectTicketTypeInstruction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |

### Return type

[**\OSDN\Model\ProjectTicketTypeInstructions**](../Model/ProjectTicketTypeInstructions.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **showProjectTicketAdminprefs**
> \OSDN\Model\ProjectTicketPrefs showProjectTicketAdminprefs($id_or_name)



Get project ticket admin preferences.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name

try {
    $result = $api_instance->showProjectTicketAdminprefs($id_or_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->showProjectTicketAdminprefs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |

### Return type

[**\OSDN\Model\ProjectTicketPrefs**](../Model/ProjectTicketPrefs.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **showProjectTicketComment**
> \OSDN\Model\ProjectTicketComment showProjectTicketComment($id_or_name, $ticket_id, $comment_id)



Get project ticket comment spscified project.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id
$comment_id = 56; // int | numeric project ticket comment id

try {
    $result = $api_instance->showProjectTicketComment($id_or_name, $ticket_id, $comment_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->showProjectTicketComment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |
 **comment_id** | **int**| numeric project ticket comment id |

### Return type

[**\OSDN\Model\ProjectTicketComment**](../Model/ProjectTicketComment.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateFrsAdminprefs**
> \OSDN\Model\FrsAdminPrefs updateFrsAdminprefs($id_or_name, $allow_overwrite)



Update project frs admin preferences.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$allow_overwrite = true; // bool | Allow overwrite files when filenames are conflict

try {
    $result = $api_instance->updateFrsAdminprefs($id_or_name, $allow_overwrite);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateFrsAdminprefs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **allow_overwrite** | **bool**| Allow overwrite files when filenames are conflict | [optional]

### Return type

[**\OSDN\Model\FrsAdminPrefs**](../Model/FrsAdminPrefs.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateNews**
> \OSDN\Model\News updateNews($news_id, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->updateNews($news_id, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateNews: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |
 **title** | **string**| news title | [optional]
 **body** | **string**| news body in OSDN Wiki format. | [optional]

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateNews_0**
> \OSDN\Model\News updateNews_0($news_id, $id_or_name, $title, $body)



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$news_id = 56; // int | 
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$title = "title_example"; // string | news title
$body = "body_example"; // string | news body in OSDN Wiki format.

try {
    $result = $api_instance->updateNews_0($news_id, $id_or_name, $title, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateNews_0: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **news_id** | **int**|  |
 **id_or_name** | **string**| numeric project id or project name |
 **title** | **string**| news title | [optional]
 **body** | **string**| news body in OSDN Wiki format. | [optional]

### Return type

[**\OSDN\Model\News**](../Model/News.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updatePackage**
> \OSDN\Model\Package updatePackage($id_or_name, $package_id, $name, $visibility)



Update tagret package.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$name = "name_example"; // string | package name
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->updatePackage($id_or_name, $package_id, $name, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updatePackage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **name** | **string**| package name | [optional]
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\Package**](../Model/Package.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectAdminProjectweb**
> \OSDN\Model\ProjectWeb updateProjectAdminProjectweb($id_or_name, $homepage, $reset)



Update project homepage url

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$homepage = "homepage_example"; // string | Project home page full URL (should start with http:// or https://). If reset param is true, this url will be ignored (URL will be reset to default url)
$reset = true; // bool | Project home page URL reset to default value

try {
    $result = $api_instance->updateProjectAdminProjectweb($id_or_name, $homepage, $reset);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectAdminProjectweb: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **homepage** | **string**| Project home page full URL (should start with http:// or https://). If reset param is true, this url will be ignored (URL will be reset to default url) | [optional]
 **reset** | **bool**| Project home page URL reset to default value | [optional]

### Return type

[**\OSDN\Model\ProjectWeb**](../Model/ProjectWeb.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectBzr**
> \OSDN\Model\ProjectBzr updateProjectBzr($id_or_name, $repo_id, $description, $active)



Update a bzr repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$description = "description_example"; // string | 
$active = true; // bool | 

try {
    $result = $api_instance->updateProjectBzr($id_or_name, $repo_id, $description, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectBzr: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **description** | **string**|  | [optional]
 **active** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectBzr**](../Model/ProjectBzr.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectGit**
> \OSDN\Model\ProjectGit updateProjectGit($id_or_name, $repo_id, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $default_branch, $active)



Update a git repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$description = "description_example"; // string | 
$mail_enabled = true; // bool | 
$mail_recipients = "mail_recipients_example"; // string | 
$allow_non_fast_forward = true; // bool | 
$default_branch = "default_branch_example"; // string | 
$active = true; // bool | 

try {
    $result = $api_instance->updateProjectGit($id_or_name, $repo_id, $description, $mail_enabled, $mail_recipients, $allow_non_fast_forward, $default_branch, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectGit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **description** | **string**|  | [optional]
 **mail_enabled** | **bool**|  | [optional]
 **mail_recipients** | **string**|  | [optional]
 **allow_non_fast_forward** | **bool**|  | [optional]
 **default_branch** | **string**|  | [optional]
 **active** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectGit**](../Model/ProjectGit.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectHg**
> \OSDN\Model\ProjectHg updateProjectHg($id_or_name, $repo_id, $description, $mail_recipients, $active)



Update a hg repository

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$repo_id = 56; // int | 
$description = "description_example"; // string | 
$mail_recipients = "mail_recipients_example"; // string | 
$active = true; // bool | 

try {
    $result = $api_instance->updateProjectHg($id_or_name, $repo_id, $description, $mail_recipients, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectHg: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **repo_id** | **int**|  |
 **description** | **string**|  | [optional]
 **mail_recipients** | **string**|  | [optional]
 **active** | **bool**|  | [optional]

### Return type

[**\OSDN\Model\ProjectHg**](../Model/ProjectHg.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectProfile**
> \OSDN\Model\GroupProfilePerLanguage updateProjectProfile($id_or_name, $language_code, $display_name, $description)



Update project profile.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$language_code = "language_code_example"; // string | Language code for display name and description (example en, ja, zh-TW)
$display_name = "display_name_example"; // string | Project display name
$description = "description_example"; // string | Project description

try {
    $result = $api_instance->updateProjectProfile($id_or_name, $language_code, $display_name, $description);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectProfile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **language_code** | **string**| Language code for display name and description (example en, ja, zh-TW) |
 **display_name** | **string**| Project display name | [optional]
 **description** | **string**| Project description | [optional]

### Return type

[**\OSDN\Model\GroupProfilePerLanguage**](../Model/GroupProfilePerLanguage.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicket**
> \OSDN\Model\ProjectTicketItem updateProjectTicket($id_or_name, $ticket_id, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner, $resolution, $status)



Update project ticket

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$ticket_id = 56; // int | numeric project ticket id
$name = "name_example"; // string | Project ticket name (title)
$description = "description_example"; // string | Project ticket description details
$type_id = 56; // int | numeric project ticket type id
$milestone_id = 56; // int | numeric project ticket milestone id
$component_id = 56; // int | numeric project ticket component id
$priority = 56; // int | project ticket priority (min = 1 and max = 9)
$severity = 56; // int | project ticket severity (min = 1 and max = 9)
$owner = 56; // int | numeric project ticket owner user id
$resolution = "resolution_example"; // string | project ticket resolution text
$status = "status_example"; // string | project ticket status (open or close)

try {
    $result = $api_instance->updateProjectTicket($id_or_name, $ticket_id, $name, $description, $type_id, $milestone_id, $component_id, $priority, $severity, $owner, $resolution, $status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectTicket: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **ticket_id** | **int**| numeric project ticket id |
 **name** | **string**| Project ticket name (title) | [optional]
 **description** | **string**| Project ticket description details | [optional]
 **type_id** | **int**| numeric project ticket type id | [optional]
 **milestone_id** | **int**| numeric project ticket milestone id | [optional]
 **component_id** | **int**| numeric project ticket component id | [optional]
 **priority** | **int**| project ticket priority (min &#x3D; 1 and max &#x3D; 9) | [optional]
 **severity** | **int**| project ticket severity (min &#x3D; 1 and max &#x3D; 9) | [optional]
 **owner** | **int**| numeric project ticket owner user id | [optional]
 **resolution** | **string**| project ticket resolution text | [optional]
 **status** | **string**| project ticket status (open or close) | [optional]

### Return type

[**\OSDN\Model\ProjectTicketItem**](../Model/ProjectTicketItem.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicketAdminprefs**
> \OSDN\Model\ProjectTicketPrefs updateProjectTicketAdminprefs($id_or_name, $allow_anonymouse, $frs_autosync, $mailsend_type, $mailing_list_id, $mail_lang)



Update project ticket admin preferences.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$allow_anonymouse = true; // bool | Non login user allows to post new ticket/comment
$frs_autosync = "frs_autosync_example"; // string | Componet File release autosync type 'Disabled', 'Package', 'Release', 'Package and Release'
$mailsend_type = "mailsend_type_example"; // string | Ticket update mail destination type 'None', 'Ticket Technician', 'Ticket Administrator', 'Ticket Administrator and Technician', 'All project members', 'Mailing List'
$mailing_list_id = 56; // int | Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list)
$mail_lang = "mail_lang_example"; // string | Ticket update mail language

try {
    $result = $api_instance->updateProjectTicketAdminprefs($id_or_name, $allow_anonymouse, $frs_autosync, $mailsend_type, $mailing_list_id, $mail_lang);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectTicketAdminprefs: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **allow_anonymouse** | **bool**| Non login user allows to post new ticket/comment | [optional]
 **frs_autosync** | **string**| Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39; | [optional]
 **mailsend_type** | **string**| Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39; | [optional]
 **mailing_list_id** | **int**| Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list) | [optional]
 **mail_lang** | **string**| Ticket update mail language | [optional]

### Return type

[**\OSDN\Model\ProjectTicketPrefs**](../Model/ProjectTicketPrefs.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicketComponent**
> \OSDN\Model\ProjectTicketComponent updateProjectTicketComponent($id_or_name, $component_id, $name, $description, $owner, $active)



Update project ticket component

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$component_id = 56; // int | numeric project ticket component id
$name = "name_example"; // string | Ticket component name
$description = "description_example"; // string | Ticket component description
$owner = 56; // int | Ticket componet owner user_id
$active = true; // bool | Ticket componet will be shown the component select list when this parameter is true

try {
    $result = $api_instance->updateProjectTicketComponent($id_or_name, $component_id, $name, $description, $owner, $active);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectTicketComponent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **component_id** | **int**| numeric project ticket component id |
 **name** | **string**| Ticket component name | [optional]
 **description** | **string**| Ticket component description | [optional]
 **owner** | **int**| Ticket componet owner user_id | [optional]
 **active** | **bool**| Ticket componet will be shown the component select list when this parameter is true | [optional]

### Return type

[**\OSDN\Model\ProjectTicketComponent**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicketMilestone**
> \OSDN\Model\ProjectTicketComponent updateProjectTicketMilestone($id_or_name, $milestone_id, $name, $description, $start, $end, $force_status)



Update project ticket milestone

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$milestone_id = 56; // int | numeric project ticket milestone id
$name = "name_example"; // string | Ticket milestone name
$description = "description_example"; // string | Ticket milestone description
$start = new \DateTime(); // \DateTime | Ticket milestone start date
$end = new \DateTime(); // \DateTime | Ticket milestone due date
$force_status = "force_status_example"; // string | If you want to force close the milestone set to 'close' or reopen it set to 'reopen'

try {
    $result = $api_instance->updateProjectTicketMilestone($id_or_name, $milestone_id, $name, $description, $start, $end, $force_status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectTicketMilestone: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **milestone_id** | **int**| numeric project ticket milestone id |
 **name** | **string**| Ticket milestone name | [optional]
 **description** | **string**| Ticket milestone description | [optional]
 **start** | **\DateTime**| Ticket milestone start date | [optional]
 **end** | **\DateTime**| Ticket milestone due date | [optional]
 **force_status** | **string**| If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39; | [optional]

### Return type

[**\OSDN\Model\ProjectTicketComponent**](../Model/ProjectTicketComponent.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTicketType**
> \OSDN\Model\ProjectTicketType updateProjectTicketType($id_or_name, $type_id, $name, $description, $is_public)



Update project ticket type

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$type_id = 56; // int | numeric project ticket type id
$name = "name_example"; // string | Ticket type name
$description = "description_example"; // string | Ticket type description
$is_public = true; // bool | if set as false, this type will be shown to project members only.

try {
    $result = $api_instance->updateProjectTicketType($id_or_name, $type_id, $name, $description, $is_public);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectTicketType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **type_id** | **int**| numeric project ticket type id |
 **name** | **string**| Ticket type name | [optional]
 **description** | **string**| Ticket type description | [optional]
 **is_public** | **bool**| if set as false, this type will be shown to project members only. | [optional]

### Return type

[**\OSDN\Model\ProjectTicketType**](../Model/ProjectTicketType.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProjectTools**
> \OSDN\Model\GroupToolFlags updateProjectTools($id_or_name, $git, $svn, $hg, $bzr, $frs, $ticket, $wiki, $forum, $ml)



Update project tools info.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$git = true; // bool | use git flag
$svn = true; // bool | use Subversion flag
$hg = true; // bool | use Mercurial(Hg) flag
$bzr = true; // bool | use Bazaar flag
$frs = true; // bool | use File Release flag
$ticket = true; // bool | use Ticket flag
$wiki = true; // bool | use Wiki flag
$forum = true; // bool | use Forum flag
$ml = true; // bool | use Mailing List flag

try {
    $result = $api_instance->updateProjectTools($id_or_name, $git, $svn, $hg, $bzr, $frs, $ticket, $wiki, $forum, $ml);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateProjectTools: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **git** | **bool**| use git flag | [optional]
 **svn** | **bool**| use Subversion flag | [optional]
 **hg** | **bool**| use Mercurial(Hg) flag | [optional]
 **bzr** | **bool**| use Bazaar flag | [optional]
 **frs** | **bool**| use File Release flag | [optional]
 **ticket** | **bool**| use Ticket flag | [optional]
 **wiki** | **bool**| use Wiki flag | [optional]
 **forum** | **bool**| use Forum flag | [optional]
 **ml** | **bool**| use Mailing List flag | [optional]

### Return type

[**\OSDN\Model\GroupToolFlags**](../Model/GroupToolFlags.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateRelease**
> \OSDN\Model\Release updateRelease($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id)



Update target release. (Note: If you update draft release, the release will be public automatically.)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)
$name = "name_example"; // string | Release name
$time = new \DateTime(); // \DateTime | Release datetime. If you set future time, the release hide until specified time.
$move_to_package_id = 56; // int | If this parameter is specified, the release move to another package.

try {
    $result = $api_instance->updateRelease($id_or_name, $package_id, $release_id, $visibility, $name, $time, $move_to_package_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateRelease: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]
 **name** | **string**| Release name | [optional]
 **time** | **\DateTime**| Release datetime. If you set future time, the release hide until specified time. | [optional]
 **move_to_package_id** | **int**| If this parameter is specified, the release move to another package. | [optional]

### Return type

[**\OSDN\Model\Release**](../Model/Release.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateReleaseFile**
> \OSDN\Model\RelFile updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility)



Change visibility of target file.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\ProjectApi();
$id_or_name = "id_or_name_example"; // string | numeric project id or project name
$package_id = 56; // int | 
$release_id = 56; // int | 
$file_id = 56; // int | 
$visibility = "visibility_example"; // string | visibility status (public, hidden or private)

try {
    $result = $api_instance->updateReleaseFile($id_or_name, $package_id, $release_id, $file_id, $visibility);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->updateReleaseFile: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id_or_name** | **string**| numeric project id or project name |
 **package_id** | **int**|  |
 **release_id** | **int**|  |
 **file_id** | **int**|  |
 **visibility** | **string**| visibility status (public, hidden or private) | [optional]

### Return type

[**\OSDN\Model\RelFile**](../Model/RelFile.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

