# osdn-client

OSDNClient - JavaScript client for osdn-client
OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
This SDK is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.20171120
- Package version: 0.0.20171120
- Build date: 2019-12-23T17:21:52.869+09:00
- Build package: class io.swagger.codegen.languages.JavascriptClientCodegen
For more information, please visit [https://osdn.net/projects/osdn-codes/wiki/APIGuide](https://osdn.net/projects/osdn-codes/wiki/APIGuide)

## Installation

### For [Node.js](https://nodejs.org/)

#### npm

To publish the library as a [npm](https://www.npmjs.com/),
please follow the procedure in ["Publishing npm packages"](https://docs.npmjs.com/getting-started/publishing-npm-packages).

Then install it via:

```shell
npm install osdn-client --save
```

#### git
#
If the library is hosted at a git repository, e.g.
https://github.com/OSDN/Client
then install it via:

```shell
    npm install OSDN/Client --save
```

### For browser

The library also works in the browser environment via npm and [browserify](http://browserify.org/). After following
the above steps with Node.js and installing browserify with `npm install -g browserify`,
perform the following (assuming *main.js* is your entry file):

```shell
browserify main.js > bundle.js
```

Then include *bundle.js* in the HTML pages.

## Getting Started

Please follow the [installation](#installation) instruction and execute the following JS code:

```javascript
var OSDNClient = require('osdn-client');

var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = "YOUR ACCESS TOKEN"

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = "YOUR ACCESS TOKEN"

var api = new OSDNClient.DefaultApi()

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
api.ping(callback);

```

## Documentation for API Endpoints

All URIs are relative to *https://osdn.net/api/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OSDNClient.DefaultApi* | [**ping**](docs/DefaultApi.md#ping) | **GET** /ping | 
*OSDNClient.DefaultApi* | [**token**](docs/DefaultApi.md#token) | **POST** /token | 
*OSDNClient.ProjectApi* | [**createNews**](docs/ProjectApi.md#createNews) | **POST** /news | 
*OSDNClient.ProjectApi* | [**createNews_0**](docs/ProjectApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
*OSDNClient.ProjectApi* | [**createPackage**](docs/ProjectApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
*OSDNClient.ProjectApi* | [**createProjectBzr**](docs/ProjectApi.md#createProjectBzr) | **POST** /project/{id_or_name}/bzr | 
*OSDNClient.ProjectApi* | [**createProjectGit**](docs/ProjectApi.md#createProjectGit) | **POST** /project/{id_or_name}/git | 
*OSDNClient.ProjectApi* | [**createProjectGitHook**](docs/ProjectApi.md#createProjectGitHook) | **POST** /project/{id_or_name}/git/{repo_id}/hooks | 
*OSDNClient.ProjectApi* | [**createProjectHg**](docs/ProjectApi.md#createProjectHg) | **POST** /project/{id_or_name}/hg | 
*OSDNClient.ProjectApi* | [**createProjectProfile**](docs/ProjectApi.md#createProjectProfile) | **POST** /project/{id_or_name}/admin/profile | 
*OSDNClient.ProjectApi* | [**createProjectTicket**](docs/ProjectApi.md#createProjectTicket) | **POST** /project/{id_or_name}/ticket | 
*OSDNClient.ProjectApi* | [**createProjectTicketComment**](docs/ProjectApi.md#createProjectTicketComment) | **POST** /project/{id_or_name}/ticket/{ticket_id}/comment | 
*OSDNClient.ProjectApi* | [**createProjectTicketComponent**](docs/ProjectApi.md#createProjectTicketComponent) | **POST** /project/{id_or_name}/ticket/component | 
*OSDNClient.ProjectApi* | [**createProjectTicketMilestone**](docs/ProjectApi.md#createProjectTicketMilestone) | **POST** /project/{id_or_name}/ticket/milestone | 
*OSDNClient.ProjectApi* | [**createProjectTicketType**](docs/ProjectApi.md#createProjectTicketType) | **POST** /project/{id_or_name}/ticket/type | 
*OSDNClient.ProjectApi* | [**createProjectTicketTypeInstruction**](docs/ProjectApi.md#createProjectTicketTypeInstruction) | **POST** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
*OSDNClient.ProjectApi* | [**createRelease**](docs/ProjectApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectApi* | [**createReleaseFile**](docs/ProjectApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectApi* | [**deleteNews**](docs/ProjectApi.md#deleteNews) | **DELETE** /news/{news_id} | 
*OSDNClient.ProjectApi* | [**deleteNews_0**](docs/ProjectApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectApi* | [**deletePackage**](docs/ProjectApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectApi* | [**deleteProjectAdminProjectweb**](docs/ProjectApi.md#deleteProjectAdminProjectweb) | **DELETE** /project/{id_or_name}/admin/project_web | 
*OSDNClient.ProjectApi* | [**deleteProjectGitHook**](docs/ProjectApi.md#deleteProjectGitHook) | **DELETE** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
*OSDNClient.ProjectApi* | [**deleteProjectProfile**](docs/ProjectApi.md#deleteProjectProfile) | **DELETE** /project/{id_or_name}/admin/profile/{language_code} | 
*OSDNClient.ProjectApi* | [**deleteProjectTicketComponent**](docs/ProjectApi.md#deleteProjectTicketComponent) | **DELETE** /project/{id_or_name}/ticket/component/{component_id} | 
*OSDNClient.ProjectApi* | [**deleteProjectTicketMilestone**](docs/ProjectApi.md#deleteProjectTicketMilestone) | **DELETE** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*OSDNClient.ProjectApi* | [**deleteProjectTicketType**](docs/ProjectApi.md#deleteProjectTicketType) | **DELETE** /project/{id_or_name}/ticket/type/{type_id} | 
*OSDNClient.ProjectApi* | [**deleteProjectTicketTypeInstruction**](docs/ProjectApi.md#deleteProjectTicketTypeInstruction) | **DELETE** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*OSDNClient.ProjectApi* | [**deleteRelease**](docs/ProjectApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectApi* | [**deleteReleaseFile**](docs/ProjectApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectApi* | [**disableProjectBzr**](docs/ProjectApi.md#disableProjectBzr) | **DELETE** /project/{id_or_name}/bzr/{repo_id} | 
*OSDNClient.ProjectApi* | [**disableProjectGit**](docs/ProjectApi.md#disableProjectGit) | **DELETE** /project/{id_or_name}/git/{repo_id} | 
*OSDNClient.ProjectApi* | [**disableProjectHg**](docs/ProjectApi.md#disableProjectHg) | **DELETE** /project/{id_or_name}/hg/{repo_id} | 
*OSDNClient.ProjectApi* | [**draftRelease**](docs/ProjectApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
*OSDNClient.ProjectApi* | [**getFrsAdminprefs**](docs/ProjectApi.md#getFrsAdminprefs) | **GET** /project/{id_or_name}/frs/admin | 
*OSDNClient.ProjectApi* | [**getNews**](docs/ProjectApi.md#getNews) | **GET** /news/{news_id} | 
*OSDNClient.ProjectApi* | [**getNews_0**](docs/ProjectApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectApi* | [**getPackage**](docs/ProjectApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectApi* | [**getProject**](docs/ProjectApi.md#getProject) | **GET** /project/{id_or_name} | 
*OSDNClient.ProjectApi* | [**getProjectAdminProjectweb**](docs/ProjectApi.md#getProjectAdminProjectweb) | **GET** /project/{id_or_name}/admin/project_web | 
*OSDNClient.ProjectApi* | [**getProjectBzr**](docs/ProjectApi.md#getProjectBzr) | **GET** /project/{id_or_name}/bzr/{repo_id} | 
*OSDNClient.ProjectApi* | [**getProjectGit**](docs/ProjectApi.md#getProjectGit) | **GET** /project/{id_or_name}/git/{repo_id} | 
*OSDNClient.ProjectApi* | [**getProjectGitHook**](docs/ProjectApi.md#getProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
*OSDNClient.ProjectApi* | [**getProjectHg**](docs/ProjectApi.md#getProjectHg) | **GET** /project/{id_or_name}/hg/{repo_id} | 
*OSDNClient.ProjectApi* | [**getProjectHistories**](docs/ProjectApi.md#getProjectHistories) | **GET** /project/{id_or_name}/history | 
*OSDNClient.ProjectApi* | [**getProjectProfile**](docs/ProjectApi.md#getProjectProfile) | **GET** /project/{id_or_name}/admin/profile/{language_code} | 
*OSDNClient.ProjectApi* | [**getProjectProfileList**](docs/ProjectApi.md#getProjectProfileList) | **GET** /project/{id_or_name}/admin/profile | 
*OSDNClient.ProjectApi* | [**getProjectSvn**](docs/ProjectApi.md#getProjectSvn) | **GET** /project/{id_or_name}/svn | 
*OSDNClient.ProjectApi* | [**getProjectTicket**](docs/ProjectApi.md#getProjectTicket) | **GET** /project/{id_or_name}/ticket/{ticket_id} | 
*OSDNClient.ProjectApi* | [**getProjectTicketComponent**](docs/ProjectApi.md#getProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component/{component_id} | 
*OSDNClient.ProjectApi* | [**getProjectTicketMilestone**](docs/ProjectApi.md#getProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*OSDNClient.ProjectApi* | [**getProjectTicketType**](docs/ProjectApi.md#getProjectTicketType) | **GET** /project/{id_or_name}/ticket/type/{type_id} | 
*OSDNClient.ProjectApi* | [**getProjectTicketTypeInstruction**](docs/ProjectApi.md#getProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*OSDNClient.ProjectApi* | [**getProjectTicketTypeInstruction_0**](docs/ProjectApi.md#getProjectTicketTypeInstruction_0) | **PATCH** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*OSDNClient.ProjectApi* | [**getProjectTools**](docs/ProjectApi.md#getProjectTools) | **GET** /project/{id_or_name}/admin/tools | 
*OSDNClient.ProjectApi* | [**getRelease**](docs/ProjectApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectApi* | [**getReleaseFile**](docs/ProjectApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectApi* | [**listNews**](docs/ProjectApi.md#listNews) | **GET** /news | 
*OSDNClient.ProjectApi* | [**listNews_0**](docs/ProjectApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
*OSDNClient.ProjectApi* | [**listPackages**](docs/ProjectApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
*OSDNClient.ProjectApi* | [**listProjectBzr**](docs/ProjectApi.md#listProjectBzr) | **GET** /project/{id_or_name}/bzr | 
*OSDNClient.ProjectApi* | [**listProjectGit**](docs/ProjectApi.md#listProjectGit) | **GET** /project/{id_or_name}/git | 
*OSDNClient.ProjectApi* | [**listProjectGitHook**](docs/ProjectApi.md#listProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks | 
*OSDNClient.ProjectApi* | [**listProjectHg**](docs/ProjectApi.md#listProjectHg) | **GET** /project/{id_or_name}/hg | 
*OSDNClient.ProjectApi* | [**listProjectTicket**](docs/ProjectApi.md#listProjectTicket) | **GET** /project/{id_or_name}/ticket | 
*OSDNClient.ProjectApi* | [**listProjectTicketComment**](docs/ProjectApi.md#listProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment | 
*OSDNClient.ProjectApi* | [**listProjectTicketComponent**](docs/ProjectApi.md#listProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component | 
*OSDNClient.ProjectApi* | [**listProjectTicketMilestone**](docs/ProjectApi.md#listProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone | 
*OSDNClient.ProjectApi* | [**listProjectTicketType**](docs/ProjectApi.md#listProjectTicketType) | **GET** /project/{id_or_name}/ticket/type | 
*OSDNClient.ProjectApi* | [**listProjectTicketTypeInstruction**](docs/ProjectApi.md#listProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
*OSDNClient.ProjectApi* | [**showProjectTicketAdminprefs**](docs/ProjectApi.md#showProjectTicketAdminprefs) | **GET** /project/{id_or_name}/ticket/admin | 
*OSDNClient.ProjectApi* | [**showProjectTicketComment**](docs/ProjectApi.md#showProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id} | 
*OSDNClient.ProjectApi* | [**updateFrsAdminprefs**](docs/ProjectApi.md#updateFrsAdminprefs) | **PATCH** /project/{id_or_name}/frs/admin | 
*OSDNClient.ProjectApi* | [**updateNews**](docs/ProjectApi.md#updateNews) | **PATCH** /news/{news_id} | 
*OSDNClient.ProjectApi* | [**updateNews_0**](docs/ProjectApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectApi* | [**updatePackage**](docs/ProjectApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectApi* | [**updateProjectAdminProjectweb**](docs/ProjectApi.md#updateProjectAdminProjectweb) | **PATCH** /project/{id_or_name}/admin/project_web | 
*OSDNClient.ProjectApi* | [**updateProjectBzr**](docs/ProjectApi.md#updateProjectBzr) | **PATCH** /project/{id_or_name}/bzr/{repo_id} | 
*OSDNClient.ProjectApi* | [**updateProjectGit**](docs/ProjectApi.md#updateProjectGit) | **PATCH** /project/{id_or_name}/git/{repo_id} | 
*OSDNClient.ProjectApi* | [**updateProjectHg**](docs/ProjectApi.md#updateProjectHg) | **PATCH** /project/{id_or_name}/hg/{repo_id} | 
*OSDNClient.ProjectApi* | [**updateProjectProfile**](docs/ProjectApi.md#updateProjectProfile) | **PATCH** /project/{id_or_name}/admin/profile/{language_code} | 
*OSDNClient.ProjectApi* | [**updateProjectTicket**](docs/ProjectApi.md#updateProjectTicket) | **PATCH** /project/{id_or_name}/ticket/{ticket_id} | 
*OSDNClient.ProjectApi* | [**updateProjectTicketAdminprefs**](docs/ProjectApi.md#updateProjectTicketAdminprefs) | **PATCH** /project/{id_or_name}/ticket/admin | 
*OSDNClient.ProjectApi* | [**updateProjectTicketComponent**](docs/ProjectApi.md#updateProjectTicketComponent) | **PATCH** /project/{id_or_name}/ticket/component/{component_id} | 
*OSDNClient.ProjectApi* | [**updateProjectTicketMilestone**](docs/ProjectApi.md#updateProjectTicketMilestone) | **PATCH** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*OSDNClient.ProjectApi* | [**updateProjectTicketType**](docs/ProjectApi.md#updateProjectTicketType) | **PATCH** /project/{id_or_name}/ticket/type/{type_id} | 
*OSDNClient.ProjectApi* | [**updateProjectTools**](docs/ProjectApi.md#updateProjectTools) | **PATCH** /project/{id_or_name}/admin/tools | 
*OSDNClient.ProjectApi* | [**updateRelease**](docs/ProjectApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectApi* | [**updateReleaseFile**](docs/ProjectApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectFrsApi* | [**createPackage**](docs/ProjectFrsApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
*OSDNClient.ProjectFrsApi* | [**createRelease**](docs/ProjectFrsApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectFrsApi* | [**createReleaseFile**](docs/ProjectFrsApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectFrsApi* | [**deletePackage**](docs/ProjectFrsApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectFrsApi* | [**deleteRelease**](docs/ProjectFrsApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectFrsApi* | [**deleteReleaseFile**](docs/ProjectFrsApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectFrsApi* | [**draftRelease**](docs/ProjectFrsApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
*OSDNClient.ProjectFrsApi* | [**getFrsAdminprefs**](docs/ProjectFrsApi.md#getFrsAdminprefs) | **GET** /project/{id_or_name}/frs/admin | 
*OSDNClient.ProjectFrsApi* | [**getPackage**](docs/ProjectFrsApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectFrsApi* | [**getRelease**](docs/ProjectFrsApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectFrsApi* | [**getReleaseFile**](docs/ProjectFrsApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectFrsApi* | [**listPackages**](docs/ProjectFrsApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
*OSDNClient.ProjectFrsApi* | [**updateFrsAdminprefs**](docs/ProjectFrsApi.md#updateFrsAdminprefs) | **PATCH** /project/{id_or_name}/frs/admin | 
*OSDNClient.ProjectFrsApi* | [**updatePackage**](docs/ProjectFrsApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
*OSDNClient.ProjectFrsApi* | [**updateRelease**](docs/ProjectFrsApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*OSDNClient.ProjectFrsApi* | [**updateReleaseFile**](docs/ProjectFrsApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*OSDNClient.ProjectNewsApi* | [**createNews**](docs/ProjectNewsApi.md#createNews) | **POST** /news | 
*OSDNClient.ProjectNewsApi* | [**createNews_0**](docs/ProjectNewsApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
*OSDNClient.ProjectNewsApi* | [**deleteNews**](docs/ProjectNewsApi.md#deleteNews) | **DELETE** /news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**deleteNews_0**](docs/ProjectNewsApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**getNews**](docs/ProjectNewsApi.md#getNews) | **GET** /news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**getNews_0**](docs/ProjectNewsApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**listNews**](docs/ProjectNewsApi.md#listNews) | **GET** /news | 
*OSDNClient.ProjectNewsApi* | [**listNews_0**](docs/ProjectNewsApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
*OSDNClient.ProjectNewsApi* | [**updateNews**](docs/ProjectNewsApi.md#updateNews) | **PATCH** /news/{news_id} | 
*OSDNClient.ProjectNewsApi* | [**updateNews_0**](docs/ProjectNewsApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
*OSDNClient.ProjectSCMApi* | [**createProjectBzr**](docs/ProjectSCMApi.md#createProjectBzr) | **POST** /project/{id_or_name}/bzr | 
*OSDNClient.ProjectSCMApi* | [**createProjectGit**](docs/ProjectSCMApi.md#createProjectGit) | **POST** /project/{id_or_name}/git | 
*OSDNClient.ProjectSCMApi* | [**createProjectGitHook**](docs/ProjectSCMApi.md#createProjectGitHook) | **POST** /project/{id_or_name}/git/{repo_id}/hooks | 
*OSDNClient.ProjectSCMApi* | [**createProjectHg**](docs/ProjectSCMApi.md#createProjectHg) | **POST** /project/{id_or_name}/hg | 
*OSDNClient.ProjectSCMApi* | [**deleteProjectGitHook**](docs/ProjectSCMApi.md#deleteProjectGitHook) | **DELETE** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
*OSDNClient.ProjectSCMApi* | [**disableProjectBzr**](docs/ProjectSCMApi.md#disableProjectBzr) | **DELETE** /project/{id_or_name}/bzr/{repo_id} | 
*OSDNClient.ProjectSCMApi* | [**disableProjectGit**](docs/ProjectSCMApi.md#disableProjectGit) | **DELETE** /project/{id_or_name}/git/{repo_id} | 
*OSDNClient.ProjectSCMApi* | [**disableProjectHg**](docs/ProjectSCMApi.md#disableProjectHg) | **DELETE** /project/{id_or_name}/hg/{repo_id} | 
*OSDNClient.ProjectSCMApi* | [**getProjectBzr**](docs/ProjectSCMApi.md#getProjectBzr) | **GET** /project/{id_or_name}/bzr/{repo_id} | 
*OSDNClient.ProjectSCMApi* | [**getProjectGit**](docs/ProjectSCMApi.md#getProjectGit) | **GET** /project/{id_or_name}/git/{repo_id} | 
*OSDNClient.ProjectSCMApi* | [**getProjectGitHook**](docs/ProjectSCMApi.md#getProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
*OSDNClient.ProjectSCMApi* | [**getProjectHg**](docs/ProjectSCMApi.md#getProjectHg) | **GET** /project/{id_or_name}/hg/{repo_id} | 
*OSDNClient.ProjectSCMApi* | [**getProjectSvn**](docs/ProjectSCMApi.md#getProjectSvn) | **GET** /project/{id_or_name}/svn | 
*OSDNClient.ProjectSCMApi* | [**listProjectBzr**](docs/ProjectSCMApi.md#listProjectBzr) | **GET** /project/{id_or_name}/bzr | 
*OSDNClient.ProjectSCMApi* | [**listProjectGit**](docs/ProjectSCMApi.md#listProjectGit) | **GET** /project/{id_or_name}/git | 
*OSDNClient.ProjectSCMApi* | [**listProjectGitHook**](docs/ProjectSCMApi.md#listProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks | 
*OSDNClient.ProjectSCMApi* | [**listProjectHg**](docs/ProjectSCMApi.md#listProjectHg) | **GET** /project/{id_or_name}/hg | 
*OSDNClient.ProjectSCMApi* | [**updateProjectBzr**](docs/ProjectSCMApi.md#updateProjectBzr) | **PATCH** /project/{id_or_name}/bzr/{repo_id} | 
*OSDNClient.ProjectSCMApi* | [**updateProjectGit**](docs/ProjectSCMApi.md#updateProjectGit) | **PATCH** /project/{id_or_name}/git/{repo_id} | 
*OSDNClient.ProjectSCMApi* | [**updateProjectHg**](docs/ProjectSCMApi.md#updateProjectHg) | **PATCH** /project/{id_or_name}/hg/{repo_id} | 
*OSDNClient.ProjectTicketApi* | [**createProjectTicket**](docs/ProjectTicketApi.md#createProjectTicket) | **POST** /project/{id_or_name}/ticket | 
*OSDNClient.ProjectTicketApi* | [**createProjectTicketComment**](docs/ProjectTicketApi.md#createProjectTicketComment) | **POST** /project/{id_or_name}/ticket/{ticket_id}/comment | 
*OSDNClient.ProjectTicketApi* | [**createProjectTicketComponent**](docs/ProjectTicketApi.md#createProjectTicketComponent) | **POST** /project/{id_or_name}/ticket/component | 
*OSDNClient.ProjectTicketApi* | [**createProjectTicketMilestone**](docs/ProjectTicketApi.md#createProjectTicketMilestone) | **POST** /project/{id_or_name}/ticket/milestone | 
*OSDNClient.ProjectTicketApi* | [**createProjectTicketType**](docs/ProjectTicketApi.md#createProjectTicketType) | **POST** /project/{id_or_name}/ticket/type | 
*OSDNClient.ProjectTicketApi* | [**createProjectTicketTypeInstruction**](docs/ProjectTicketApi.md#createProjectTicketTypeInstruction) | **POST** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
*OSDNClient.ProjectTicketApi* | [**deleteProjectTicketComponent**](docs/ProjectTicketApi.md#deleteProjectTicketComponent) | **DELETE** /project/{id_or_name}/ticket/component/{component_id} | 
*OSDNClient.ProjectTicketApi* | [**deleteProjectTicketMilestone**](docs/ProjectTicketApi.md#deleteProjectTicketMilestone) | **DELETE** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*OSDNClient.ProjectTicketApi* | [**deleteProjectTicketType**](docs/ProjectTicketApi.md#deleteProjectTicketType) | **DELETE** /project/{id_or_name}/ticket/type/{type_id} | 
*OSDNClient.ProjectTicketApi* | [**deleteProjectTicketTypeInstruction**](docs/ProjectTicketApi.md#deleteProjectTicketTypeInstruction) | **DELETE** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*OSDNClient.ProjectTicketApi* | [**getProjectTicket**](docs/ProjectTicketApi.md#getProjectTicket) | **GET** /project/{id_or_name}/ticket/{ticket_id} | 
*OSDNClient.ProjectTicketApi* | [**getProjectTicketComponent**](docs/ProjectTicketApi.md#getProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component/{component_id} | 
*OSDNClient.ProjectTicketApi* | [**getProjectTicketMilestone**](docs/ProjectTicketApi.md#getProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*OSDNClient.ProjectTicketApi* | [**getProjectTicketType**](docs/ProjectTicketApi.md#getProjectTicketType) | **GET** /project/{id_or_name}/ticket/type/{type_id} | 
*OSDNClient.ProjectTicketApi* | [**getProjectTicketTypeInstruction**](docs/ProjectTicketApi.md#getProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*OSDNClient.ProjectTicketApi* | [**getProjectTicketTypeInstruction_0**](docs/ProjectTicketApi.md#getProjectTicketTypeInstruction_0) | **PATCH** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*OSDNClient.ProjectTicketApi* | [**listProjectTicket**](docs/ProjectTicketApi.md#listProjectTicket) | **GET** /project/{id_or_name}/ticket | 
*OSDNClient.ProjectTicketApi* | [**listProjectTicketComment**](docs/ProjectTicketApi.md#listProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment | 
*OSDNClient.ProjectTicketApi* | [**listProjectTicketComponent**](docs/ProjectTicketApi.md#listProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component | 
*OSDNClient.ProjectTicketApi* | [**listProjectTicketMilestone**](docs/ProjectTicketApi.md#listProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone | 
*OSDNClient.ProjectTicketApi* | [**listProjectTicketType**](docs/ProjectTicketApi.md#listProjectTicketType) | **GET** /project/{id_or_name}/ticket/type | 
*OSDNClient.ProjectTicketApi* | [**listProjectTicketTypeInstruction**](docs/ProjectTicketApi.md#listProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
*OSDNClient.ProjectTicketApi* | [**showProjectTicketAdminprefs**](docs/ProjectTicketApi.md#showProjectTicketAdminprefs) | **GET** /project/{id_or_name}/ticket/admin | 
*OSDNClient.ProjectTicketApi* | [**showProjectTicketComment**](docs/ProjectTicketApi.md#showProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id} | 
*OSDNClient.ProjectTicketApi* | [**updateProjectTicket**](docs/ProjectTicketApi.md#updateProjectTicket) | **PATCH** /project/{id_or_name}/ticket/{ticket_id} | 
*OSDNClient.ProjectTicketApi* | [**updateProjectTicketAdminprefs**](docs/ProjectTicketApi.md#updateProjectTicketAdminprefs) | **PATCH** /project/{id_or_name}/ticket/admin | 
*OSDNClient.ProjectTicketApi* | [**updateProjectTicketComponent**](docs/ProjectTicketApi.md#updateProjectTicketComponent) | **PATCH** /project/{id_or_name}/ticket/component/{component_id} | 
*OSDNClient.ProjectTicketApi* | [**updateProjectTicketMilestone**](docs/ProjectTicketApi.md#updateProjectTicketMilestone) | **PATCH** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*OSDNClient.ProjectTicketApi* | [**updateProjectTicketType**](docs/ProjectTicketApi.md#updateProjectTicketType) | **PATCH** /project/{id_or_name}/ticket/type/{type_id} | 
*OSDNClient.UserApi* | [**getUser**](docs/UserApi.md#getUser) | **GET** /user/{id_or_name} | 
*OSDNClient.UserApi* | [**getUserHistory**](docs/UserApi.md#getUserHistory) | **GET** /user/{id_or_name}/history | 
*OSDNClient.UserApi* | [**getUserStatsDaily**](docs/UserApi.md#getUserStatsDaily) | **GET** /user/{id_or_name}/stats/daily | 
*OSDNClient.UserApi* | [**getUserStatsMonthly**](docs/UserApi.md#getUserStatsMonthly) | **GET** /user/{id_or_name}/stats/monthly | 
*OSDNClient.UserApi* | [**updateUserIcon**](docs/UserApi.md#updateUserIcon) | **POST** /user/{id_or_name}/icon | 
*OSDNClient.UserApi* | [**updateUserPhoto**](docs/UserApi.md#updateUserPhoto) | **POST** /user/{id_or_name}/photo | 


## Documentation for Models

 - [OSDNClient.FrsAdminPrefs](docs/FrsAdminPrefs.md)
 - [OSDNClient.Group](docs/Group.md)
 - [OSDNClient.GroupProfile](docs/GroupProfile.md)
 - [OSDNClient.GroupProfilePerLanguage](docs/GroupProfilePerLanguage.md)
 - [OSDNClient.GroupToolFlags](docs/GroupToolFlags.md)
 - [OSDNClient.History](docs/History.md)
 - [OSDNClient.I18NText](docs/I18NText.md)
 - [OSDNClient.ModelPackage](docs/ModelPackage.md)
 - [OSDNClient.News](docs/News.md)
 - [OSDNClient.Pong](docs/Pong.md)
 - [OSDNClient.ProjectBzr](docs/ProjectBzr.md)
 - [OSDNClient.ProjectGit](docs/ProjectGit.md)
 - [OSDNClient.ProjectHg](docs/ProjectHg.md)
 - [OSDNClient.ProjectSCM](docs/ProjectSCM.md)
 - [OSDNClient.ProjectSCMLastCommit](docs/ProjectSCMLastCommit.md)
 - [OSDNClient.ProjectSvn](docs/ProjectSvn.md)
 - [OSDNClient.ProjectTicketComment](docs/ProjectTicketComment.md)
 - [OSDNClient.ProjectTicketComponent](docs/ProjectTicketComponent.md)
 - [OSDNClient.ProjectTicketComponentSummary](docs/ProjectTicketComponentSummary.md)
 - [OSDNClient.ProjectTicketComponentSummarySummarizedBy](docs/ProjectTicketComponentSummarySummarizedBy.md)
 - [OSDNClient.ProjectTicketHistory](docs/ProjectTicketHistory.md)
 - [OSDNClient.ProjectTicketItem](docs/ProjectTicketItem.md)
 - [OSDNClient.ProjectTicketMilestone](docs/ProjectTicketMilestone.md)
 - [OSDNClient.ProjectTicketMilestoneSummary](docs/ProjectTicketMilestoneSummary.md)
 - [OSDNClient.ProjectTicketMilestoneSummarySummarizedBy](docs/ProjectTicketMilestoneSummarySummarizedBy.md)
 - [OSDNClient.ProjectTicketPrefs](docs/ProjectTicketPrefs.md)
 - [OSDNClient.ProjectTicketType](docs/ProjectTicketType.md)
 - [OSDNClient.ProjectTicketTypeInstructionPerLanguage](docs/ProjectTicketTypeInstructionPerLanguage.md)
 - [OSDNClient.ProjectTicketTypeInstructions](docs/ProjectTicketTypeInstructions.md)
 - [OSDNClient.ProjectTicketTypeSummary](docs/ProjectTicketTypeSummary.md)
 - [OSDNClient.ProjectTicketTypeSummarySummarizedBy](docs/ProjectTicketTypeSummarySummarizedBy.md)
 - [OSDNClient.ProjectWeb](docs/ProjectWeb.md)
 - [OSDNClient.RelFile](docs/RelFile.md)
 - [OSDNClient.Release](docs/Release.md)
 - [OSDNClient.ScmHook](docs/ScmHook.md)
 - [OSDNClient.SimpleChamber](docs/SimpleChamber.md)
 - [OSDNClient.SimpleGroup](docs/SimpleGroup.md)
 - [OSDNClient.SimpleUser](docs/SimpleUser.md)
 - [OSDNClient.Skill](docs/Skill.md)
 - [OSDNClient.SummariadByComponent](docs/SummariadByComponent.md)
 - [OSDNClient.SummariadByComponentInner](docs/SummariadByComponentInner.md)
 - [OSDNClient.SummariadByMilestone](docs/SummariadByMilestone.md)
 - [OSDNClient.SummariadByMilestoneInner](docs/SummariadByMilestoneInner.md)
 - [OSDNClient.SummariadByOwner](docs/SummariadByOwner.md)
 - [OSDNClient.SummariadByOwnerInner](docs/SummariadByOwnerInner.md)
 - [OSDNClient.SummariadByPriority](docs/SummariadByPriority.md)
 - [OSDNClient.SummariadByPriorityInner](docs/SummariadByPriorityInner.md)
 - [OSDNClient.SummariadBySeverity](docs/SummariadBySeverity.md)
 - [OSDNClient.SummariadBySeverityInner](docs/SummariadBySeverityInner.md)
 - [OSDNClient.SummariadByType](docs/SummariadByType.md)
 - [OSDNClient.SummariadByTypeInner](docs/SummariadByTypeInner.md)
 - [OSDNClient.Token](docs/Token.md)
 - [OSDNClient.User](docs/User.md)
 - [OSDNClient.UserImages](docs/UserImages.md)
 - [OSDNClient.UserStats](docs/UserStats.md)


## Documentation for Authorization


### oauth2-code

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://osdn.net/account/oauth2ui/authorize
- **Scopes**: 
  - profile: Read basic user profile
  - profile_write: Write basic user profile
  - group: read access to group data
  - group_write: write access to group data
  - chamber: read access to chamber data
  - chamber_write: write access to chamber data

### oauth2-implicit

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://osdn.net/account/oauth2ui/authorize
- **Scopes**: 
  - profile: Read basic user profile
  - profile_write: Write basic user profile
  - group: read access to group data
  - group_write: write access to group data
  - chamber: read access to chamber data
  - chamber_write: write access to chamber data

