# OSDNClient.ProjectApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createNews**](ProjectApi.md#createNews) | **POST** /news | 
[**createNews_0**](ProjectApi.md#createNews_0) | **POST** /project/{id_or_name}/news | 
[**createPackage**](ProjectApi.md#createPackage) | **POST** /project/{id_or_name}/frs | 
[**createProjectBzr**](ProjectApi.md#createProjectBzr) | **POST** /project/{id_or_name}/bzr | 
[**createProjectGit**](ProjectApi.md#createProjectGit) | **POST** /project/{id_or_name}/git | 
[**createProjectGitHook**](ProjectApi.md#createProjectGitHook) | **POST** /project/{id_or_name}/git/{repo_id}/hooks | 
[**createProjectHg**](ProjectApi.md#createProjectHg) | **POST** /project/{id_or_name}/hg | 
[**createProjectProfile**](ProjectApi.md#createProjectProfile) | **POST** /project/{id_or_name}/admin/profile | 
[**createProjectTicket**](ProjectApi.md#createProjectTicket) | **POST** /project/{id_or_name}/ticket | 
[**createProjectTicketComment**](ProjectApi.md#createProjectTicketComment) | **POST** /project/{id_or_name}/ticket/{ticket_id}/comment | 
[**createProjectTicketComponent**](ProjectApi.md#createProjectTicketComponent) | **POST** /project/{id_or_name}/ticket/component | 
[**createProjectTicketMilestone**](ProjectApi.md#createProjectTicketMilestone) | **POST** /project/{id_or_name}/ticket/milestone | 
[**createProjectTicketType**](ProjectApi.md#createProjectTicketType) | **POST** /project/{id_or_name}/ticket/type | 
[**createProjectTicketTypeInstruction**](ProjectApi.md#createProjectTicketTypeInstruction) | **POST** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
[**createRelease**](ProjectApi.md#createRelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
[**createReleaseFile**](ProjectApi.md#createReleaseFile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteNews**](ProjectApi.md#deleteNews) | **DELETE** /news/{news_id} | 
[**deleteNews_0**](ProjectApi.md#deleteNews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
[**deletePackage**](ProjectApi.md#deletePackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
[**deleteProjectAdminProjectweb**](ProjectApi.md#deleteProjectAdminProjectweb) | **DELETE** /project/{id_or_name}/admin/project_web | 
[**deleteProjectGitHook**](ProjectApi.md#deleteProjectGitHook) | **DELETE** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**deleteProjectProfile**](ProjectApi.md#deleteProjectProfile) | **DELETE** /project/{id_or_name}/admin/profile/{language_code} | 
[**deleteProjectTicketComponent**](ProjectApi.md#deleteProjectTicketComponent) | **DELETE** /project/{id_or_name}/ticket/component/{component_id} | 
[**deleteProjectTicketMilestone**](ProjectApi.md#deleteProjectTicketMilestone) | **DELETE** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**deleteProjectTicketType**](ProjectApi.md#deleteProjectTicketType) | **DELETE** /project/{id_or_name}/ticket/type/{type_id} | 
[**deleteProjectTicketTypeInstruction**](ProjectApi.md#deleteProjectTicketTypeInstruction) | **DELETE** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**deleteRelease**](ProjectApi.md#deleteRelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**deleteReleaseFile**](ProjectApi.md#deleteReleaseFile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**disableProjectBzr**](ProjectApi.md#disableProjectBzr) | **DELETE** /project/{id_or_name}/bzr/{repo_id} | 
[**disableProjectGit**](ProjectApi.md#disableProjectGit) | **DELETE** /project/{id_or_name}/git/{repo_id} | 
[**disableProjectHg**](ProjectApi.md#disableProjectHg) | **DELETE** /project/{id_or_name}/hg/{repo_id} | 
[**draftRelease**](ProjectApi.md#draftRelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
[**getFrsAdminprefs**](ProjectApi.md#getFrsAdminprefs) | **GET** /project/{id_or_name}/frs/admin | 
[**getNews**](ProjectApi.md#getNews) | **GET** /news/{news_id} | 
[**getNews_0**](ProjectApi.md#getNews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
[**getPackage**](ProjectApi.md#getPackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
[**getProject**](ProjectApi.md#getProject) | **GET** /project/{id_or_name} | 
[**getProjectAdminProjectweb**](ProjectApi.md#getProjectAdminProjectweb) | **GET** /project/{id_or_name}/admin/project_web | 
[**getProjectBzr**](ProjectApi.md#getProjectBzr) | **GET** /project/{id_or_name}/bzr/{repo_id} | 
[**getProjectGit**](ProjectApi.md#getProjectGit) | **GET** /project/{id_or_name}/git/{repo_id} | 
[**getProjectGitHook**](ProjectApi.md#getProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
[**getProjectHg**](ProjectApi.md#getProjectHg) | **GET** /project/{id_or_name}/hg/{repo_id} | 
[**getProjectHistories**](ProjectApi.md#getProjectHistories) | **GET** /project/{id_or_name}/history | 
[**getProjectProfile**](ProjectApi.md#getProjectProfile) | **GET** /project/{id_or_name}/admin/profile/{language_code} | 
[**getProjectProfileList**](ProjectApi.md#getProjectProfileList) | **GET** /project/{id_or_name}/admin/profile | 
[**getProjectSvn**](ProjectApi.md#getProjectSvn) | **GET** /project/{id_or_name}/svn | 
[**getProjectTicket**](ProjectApi.md#getProjectTicket) | **GET** /project/{id_or_name}/ticket/{ticket_id} | 
[**getProjectTicketComponent**](ProjectApi.md#getProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component/{component_id} | 
[**getProjectTicketMilestone**](ProjectApi.md#getProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**getProjectTicketType**](ProjectApi.md#getProjectTicketType) | **GET** /project/{id_or_name}/ticket/type/{type_id} | 
[**getProjectTicketTypeInstruction**](ProjectApi.md#getProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**getProjectTicketTypeInstruction_0**](ProjectApi.md#getProjectTicketTypeInstruction_0) | **PATCH** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**getProjectTools**](ProjectApi.md#getProjectTools) | **GET** /project/{id_or_name}/admin/tools | 
[**getRelease**](ProjectApi.md#getRelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**getReleaseFile**](ProjectApi.md#getReleaseFile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
[**listNews**](ProjectApi.md#listNews) | **GET** /news | 
[**listNews_0**](ProjectApi.md#listNews_0) | **GET** /project/{id_or_name}/news | 
[**listPackages**](ProjectApi.md#listPackages) | **GET** /project/{id_or_name}/frs | 
[**listProjectBzr**](ProjectApi.md#listProjectBzr) | **GET** /project/{id_or_name}/bzr | 
[**listProjectGit**](ProjectApi.md#listProjectGit) | **GET** /project/{id_or_name}/git | 
[**listProjectGitHook**](ProjectApi.md#listProjectGitHook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks | 
[**listProjectHg**](ProjectApi.md#listProjectHg) | **GET** /project/{id_or_name}/hg | 
[**listProjectTicket**](ProjectApi.md#listProjectTicket) | **GET** /project/{id_or_name}/ticket | 
[**listProjectTicketComment**](ProjectApi.md#listProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment | 
[**listProjectTicketComponent**](ProjectApi.md#listProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component | 
[**listProjectTicketMilestone**](ProjectApi.md#listProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone | 
[**listProjectTicketType**](ProjectApi.md#listProjectTicketType) | **GET** /project/{id_or_name}/ticket/type | 
[**listProjectTicketTypeInstruction**](ProjectApi.md#listProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
[**showProjectTicketAdminprefs**](ProjectApi.md#showProjectTicketAdminprefs) | **GET** /project/{id_or_name}/ticket/admin | 
[**showProjectTicketComment**](ProjectApi.md#showProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id} | 
[**updateFrsAdminprefs**](ProjectApi.md#updateFrsAdminprefs) | **PATCH** /project/{id_or_name}/frs/admin | 
[**updateNews**](ProjectApi.md#updateNews) | **PATCH** /news/{news_id} | 
[**updateNews_0**](ProjectApi.md#updateNews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
[**updatePackage**](ProjectApi.md#updatePackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
[**updateProjectAdminProjectweb**](ProjectApi.md#updateProjectAdminProjectweb) | **PATCH** /project/{id_or_name}/admin/project_web | 
[**updateProjectBzr**](ProjectApi.md#updateProjectBzr) | **PATCH** /project/{id_or_name}/bzr/{repo_id} | 
[**updateProjectGit**](ProjectApi.md#updateProjectGit) | **PATCH** /project/{id_or_name}/git/{repo_id} | 
[**updateProjectHg**](ProjectApi.md#updateProjectHg) | **PATCH** /project/{id_or_name}/hg/{repo_id} | 
[**updateProjectProfile**](ProjectApi.md#updateProjectProfile) | **PATCH** /project/{id_or_name}/admin/profile/{language_code} | 
[**updateProjectTicket**](ProjectApi.md#updateProjectTicket) | **PATCH** /project/{id_or_name}/ticket/{ticket_id} | 
[**updateProjectTicketAdminprefs**](ProjectApi.md#updateProjectTicketAdminprefs) | **PATCH** /project/{id_or_name}/ticket/admin | 
[**updateProjectTicketComponent**](ProjectApi.md#updateProjectTicketComponent) | **PATCH** /project/{id_or_name}/ticket/component/{component_id} | 
[**updateProjectTicketMilestone**](ProjectApi.md#updateProjectTicketMilestone) | **PATCH** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**updateProjectTicketType**](ProjectApi.md#updateProjectTicketType) | **PATCH** /project/{id_or_name}/ticket/type/{type_id} | 
[**updateProjectTools**](ProjectApi.md#updateProjectTools) | **PATCH** /project/{id_or_name}/admin/tools | 
[**updateRelease**](ProjectApi.md#updateRelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
[**updateReleaseFile**](ProjectApi.md#updateReleaseFile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 


<a name="createNews"></a>
# **createNews**
> &#39;String&#39; createNews(title, body, groupId)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var title = "title_example"; // String | news title

var body = "body_example"; // String | news body in OSDN Wiki format.

var groupId = 56; // Integer | group_id the news created in


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createNews(title, body, groupId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **title** | **String**| news title | 
 **body** | **String**| news body in OSDN Wiki format. | 
 **groupId** | **Integer**| group_id the news created in | 

### Return type

**&#39;String&#39;**

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createNews_0"></a>
# **createNews_0**
> &#39;String&#39; createNews_0(idOrName, title, body)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var title = "title_example"; // String | news title

var body = "body_example"; // String | news body in OSDN Wiki format.


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createNews_0(idOrName, title, body, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **title** | **String**| news title | 
 **body** | **String**| news body in OSDN Wiki format. | 

### Return type

**&#39;String&#39;**

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createPackage"></a>
# **createPackage**
> ModelPackage createPackage(idOrName, name, opts)



Create a package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | package name

var opts = { 
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createPackage(idOrName, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| package name | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**ModelPackage**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectBzr"></a>
# **createProjectBzr**
> ProjectBzr createProjectBzr(idOrName, name, opts)



Create a new bzr repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | 

var opts = { 
  'description': "description_example" // String | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectBzr(idOrName, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**|  | 
 **description** | **String**|  | [optional] 

### Return type

[**ProjectBzr**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectGit"></a>
# **createProjectGit**
> ProjectGit createProjectGit(idOrName, name, opts)



Create a new git repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | 

var opts = { 
  'description': "description_example", // String | 
  'mailEnabled': true, // Boolean | 
  'mailRecipients': "mailRecipients_example", // String | 
  'allowNonFastForward': true, // Boolean | 
  'defaultBranch': "defaultBranch_example" // String | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectGit(idOrName, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**|  | 
 **description** | **String**|  | [optional] 
 **mailEnabled** | **Boolean**|  | [optional] 
 **mailRecipients** | **String**|  | [optional] 
 **allowNonFastForward** | **Boolean**|  | [optional] 
 **defaultBranch** | **String**|  | [optional] 

### Return type

[**ProjectGit**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectGitHook"></a>
# **createProjectGitHook**
> ScmHook createProjectGitHook(idOrName, repoId, targetUrl)



Create a new hook for project git repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var targetUrl = "targetUrl_example"; // String | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectGitHook(idOrName, repoId, targetUrl, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **targetUrl** | **String**|  | 

### Return type

[**ScmHook**](ScmHook.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectHg"></a>
# **createProjectHg**
> ProjectHg createProjectHg(idOrName, name, opts)



Create a new hg repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | 

var opts = { 
  'description': "description_example", // String | 
  'mailRecipients': "mailRecipients_example" // String | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectHg(idOrName, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**|  | 
 **description** | **String**|  | [optional] 
 **mailRecipients** | **String**|  | [optional] 

### Return type

[**ProjectHg**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectProfile"></a>
# **createProjectProfile**
> GroupProfile createProjectProfile(idOrName, languageCode, displayName, description)



Create project profile for the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)

var displayName = "displayName_example"; // String | Project display name

var description = "description_example"; // String | Project description


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectProfile(idOrName, languageCode, displayName, description, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 
 **displayName** | **String**| Project display name | 
 **description** | **String**| Project description | 

### Return type

[**GroupProfile**](GroupProfile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicket"></a>
# **createProjectTicket**
> ProjectTicketItem createProjectTicket(idOrName, name, description, typeId, opts)



Create project ticket

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | Project ticket name (title)

var description = "description_example"; // String | Project ticket description details

var typeId = 56; // Integer | numeric project ticket type id

var opts = { 
  'milestoneId': 56, // Integer | numeric project ticket milestone id
  'componentId': 56, // Integer | numeric project ticket component id
  'priority': 56, // Integer | project ticket priority (min = 1 and max = 9)
  'severity': 56, // Integer | project ticket severity (min = 1 and max = 9)
  'owner': 56 // Integer | numeric project ticket owner user id
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicket(idOrName, name, description, typeId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| Project ticket name (title) | 
 **description** | **String**| Project ticket description details | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **milestoneId** | **Integer**| numeric project ticket milestone id | [optional] 
 **componentId** | **Integer**| numeric project ticket component id | [optional] 
 **priority** | **Integer**| project ticket priority (min &#x3D; 1 and max &#x3D; 9) | [optional] 
 **severity** | **Integer**| project ticket severity (min &#x3D; 1 and max &#x3D; 9) | [optional] 
 **owner** | **Integer**| numeric project ticket owner user id | [optional] 

### Return type

[**ProjectTicketItem**](ProjectTicketItem.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketComment"></a>
# **createProjectTicketComment**
> ProjectTicketComment createProjectTicketComment(idOrName, ticketId, comment)



Create new project ticket comment of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id

var comment = "comment_example"; // String | Ticket comment text


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketComment(idOrName, ticketId, comment, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 
 **comment** | **String**| Ticket comment text | 

### Return type

[**ProjectTicketComment**](ProjectTicketComment.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketComponent"></a>
# **createProjectTicketComponent**
> [ProjectTicketComponent] createProjectTicketComponent(idOrName, name, description, opts)



Create new project ticket component of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | Ticket component name

var description = "description_example"; // String | Ticket component description

var opts = { 
  'owner': 56, // Integer | Ticket componet owner user_id
  'active': true // Boolean | Ticket componet will be shown the component select list when this parameter is true
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketComponent(idOrName, name, description, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| Ticket component name | 
 **description** | **String**| Ticket component description | 
 **owner** | **Integer**| Ticket componet owner user_id | [optional] 
 **active** | **Boolean**| Ticket componet will be shown the component select list when this parameter is true | [optional] 

### Return type

[**[ProjectTicketComponent]**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketMilestone"></a>
# **createProjectTicketMilestone**
> ProjectTicketMilestone createProjectTicketMilestone(idOrName, name, description, opts)



Create new project ticket milestone of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | Ticket milestone name

var description = "description_example"; // String | Ticket milestone description

var opts = { 
  'start': new Date("2013-10-20T19:20:30+01:00"), // Date | Ticket milestone start date
  'end': new Date("2013-10-20T19:20:30+01:00") // Date | Ticket milestone due date
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketMilestone(idOrName, name, description, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| Ticket milestone name | 
 **description** | **String**| Ticket milestone description | 
 **start** | **Date**| Ticket milestone start date | [optional] 
 **end** | **Date**| Ticket milestone due date | [optional] 

### Return type

[**ProjectTicketMilestone**](ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketType"></a>
# **createProjectTicketType**
> ProjectTicketType createProjectTicketType(idOrName, name, description, opts)



Create new project ticket type of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | Ticket type name

var description = "description_example"; // String | Ticket type description

var opts = { 
  'isPublic': true // Boolean | if set as false, this type will be shown to project members only.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketType(idOrName, name, description, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| Ticket type name | 
 **description** | **String**| Ticket type description | 
 **isPublic** | **Boolean**| if set as false, this type will be shown to project members only. | [optional] 

### Return type

[**ProjectTicketType**](ProjectTicketType.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketTypeInstruction"></a>
# **createProjectTicketTypeInstruction**
> ProjectTicketTypeInstructionPerLanguage createProjectTicketTypeInstruction(idOrName, typeId, languageCode, instruction)



Create project ticket type instructions for the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)

var instruction = "instruction_example"; // String | Ticket submit instruction for the type


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketTypeInstruction(idOrName, typeId, languageCode, instruction, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 
 **instruction** | **String**| Ticket submit instruction for the type | 

### Return type

[**ProjectTicketTypeInstructionPerLanguage**](ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createRelease"></a>
# **createRelease**
> Release createRelease(idOrName, packageId, name, opts)



Create new release in specified package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var name = "name_example"; // String | Release name

var opts = { 
  'visibility': "visibility_example", // String | visibility status (public, hidden or private)
  'time': new Date("2013-10-20T19:20:30+01:00"), // Date | Release datetime. If you set future time, the release hide until specified time.
  'releaseNote': "releaseNote_example", // String | Release note body text.
  'changeLog': "changeLog_example" // String | Changelog body text.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createRelease(idOrName, packageId, name, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **name** | **String**| Release name | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 
 **time** | **Date**| Release datetime. If you set future time, the release hide until specified time. | [optional] 
 **releaseNote** | **String**| Release note body text. | [optional] 
 **changeLog** | **String**| Changelog body text. | [optional] 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createReleaseFile"></a>
# **createReleaseFile**
> RelFile createReleaseFile(idOrName, packageId, releaseId, file, opts)



Create new file in target release.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var file = "/path/to/file.txt"; // File | Upload file in \"multipart/form-data\".

var opts = { 
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createReleaseFile(idOrName, packageId, releaseId, file, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **file** | **File**| Upload file in \&quot;multipart/form-data\&quot;. | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**RelFile**](RelFile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: Not defined

<a name="deleteNews"></a>
# **deleteNews**
> deleteNews(newsId)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var newsId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteNews(newsId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **newsId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteNews_0"></a>
# **deleteNews_0**
> deleteNews_0(idOrName, newsId)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var newsId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteNews_0(idOrName, newsId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **newsId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deletePackage"></a>
# **deletePackage**
> deletePackage(idOrName, packageId)



Delete taret package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deletePackage(idOrName, packageId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectAdminProjectweb"></a>
# **deleteProjectAdminProjectweb**
> deleteProjectAdminProjectweb(idOrName)



Delete project homepage url

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectAdminProjectweb(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectGitHook"></a>
# **deleteProjectGitHook**
> deleteProjectGitHook(idOrName, repoId, hookId)



Delete a Git repository hook

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var hookId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectGitHook(idOrName, repoId, hookId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **hookId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectProfile"></a>
# **deleteProjectProfile**
> deleteProjectProfile(idOrName, languageCode)



Delete project profile for the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectProfile(idOrName, languageCode, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectTicketComponent"></a>
# **deleteProjectTicketComponent**
> deleteProjectTicketComponent(idOrName, componentId, migrateTo)



Delete project ticket component

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var componentId = 56; // Integer | numeric project ticket component id

var migrateTo = 56; // Integer | Tickets that assigned to delete target will be migrate to the ticket component_id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectTicketComponent(idOrName, componentId, migrateTo, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **componentId** | **Integer**| numeric project ticket component id | 
 **migrateTo** | **Integer**| Tickets that assigned to delete target will be migrate to the ticket component_id | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectTicketMilestone"></a>
# **deleteProjectTicketMilestone**
> deleteProjectTicketMilestone(idOrName, milestoneId, opts)



Delete project ticket milestone

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var milestoneId = 56; // Integer | numeric project ticket milestone id

var opts = { 
  'migrateTo': 56 // Integer | Tickets that assigned to delete target will be migrate to the ticket milestone_id
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectTicketMilestone(idOrName, milestoneId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **milestoneId** | **Integer**| numeric project ticket milestone id | 
 **migrateTo** | **Integer**| Tickets that assigned to delete target will be migrate to the ticket milestone_id | [optional] 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectTicketType"></a>
# **deleteProjectTicketType**
> deleteProjectTicketType(idOrName, typeId, migrateTo)



Delete project ticket type

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var migrateTo = 56; // Integer | Tickets that assigned to delete target will be migrate to the ticket type_id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectTicketType(idOrName, typeId, migrateTo, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **migrateTo** | **Integer**| Tickets that assigned to delete target will be migrate to the ticket type_id | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectTicketTypeInstruction"></a>
# **deleteProjectTicketTypeInstruction**
> deleteProjectTicketTypeInstruction(idOrName, typeId, languageCode)



Delete project ticket type instructions on the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectTicketTypeInstruction(idOrName, typeId, languageCode, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteRelease"></a>
# **deleteRelease**
> deleteRelease(idOrName, packageId, releaseId)



Delete target release.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteRelease(idOrName, packageId, releaseId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteReleaseFile"></a>
# **deleteReleaseFile**
> deleteReleaseFile(idOrName, packageId, releaseId, fileId)



Delete target file.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var fileId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteReleaseFile(idOrName, packageId, releaseId, fileId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **fileId** | **Integer**|  | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="disableProjectBzr"></a>
# **disableProjectBzr**
> ProjectBzr disableProjectBzr(idOrName, repoId)



Disable a bzr repository (not an actual delete, just a shorthand for updating with active&#x3D;false)

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.disableProjectBzr(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectBzr**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="disableProjectGit"></a>
# **disableProjectGit**
> ProjectGit disableProjectGit(idOrName, repoId)



Disable a git repository (not an actual delete, just a shorthand for updating with active&#x3D;false)

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.disableProjectGit(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectGit**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="disableProjectHg"></a>
# **disableProjectHg**
> ProjectHg disableProjectHg(idOrName, repoId)



Disable a hg repository (not an actual delete, just a shorthand for updating with active&#x3D;false)

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.disableProjectHg(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectHg**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="draftRelease"></a>
# **draftRelease**
> Release draftRelease(idOrName, packageId)



Get release draft in specified package. If draft is not exist, it will be created automatically.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.draftRelease(idOrName, packageId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getFrsAdminprefs"></a>
# **getFrsAdminprefs**
> FrsAdminPrefs getFrsAdminprefs(idOrName)



Get project frs admin preferences.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getFrsAdminprefs(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**FrsAdminPrefs**](FrsAdminPrefs.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getNews"></a>
# **getNews**
> News getNews(newsId)



Get single news object.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var newsId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getNews(newsId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **newsId** | **Integer**|  | 

### Return type

[**News**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getNews_0"></a>
# **getNews_0**
> News getNews_0(idOrName, newsId)



Get single news object.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var newsId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getNews_0(idOrName, newsId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **newsId** | **Integer**|  | 

### Return type

[**News**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getPackage"></a>
# **getPackage**
> ModelPackage getPackage(idOrName, packageId)



Get specified package info and release list of the package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getPackage(idOrName, packageId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 

### Return type

[**ModelPackage**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProject"></a>
# **getProject**
> Group getProject(idOrName)



Get project info.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProject(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**Group**](Group.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectAdminProjectweb"></a>
# **getProjectAdminProjectweb**
> ProjectWeb getProjectAdminProjectweb(idOrName)



Get project homepage url

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectAdminProjectweb(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**ProjectWeb**](ProjectWeb.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectBzr"></a>
# **getProjectBzr**
> ProjectBzr getProjectBzr(idOrName, repoId)



Get a bzr repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectBzr(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectBzr**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectGit"></a>
# **getProjectGit**
> ProjectGit getProjectGit(idOrName, repoId)



Get a git repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectGit(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectGit**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectGitHook"></a>
# **getProjectGitHook**
> ScmHook getProjectGitHook(idOrName, repoId, hookId)



Get a repository hook

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var hookId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectGitHook(idOrName, repoId, hookId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **hookId** | **Integer**|  | 

### Return type

[**ScmHook**](ScmHook.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectHg"></a>
# **getProjectHg**
> ProjectHg getProjectHg(idOrName, repoId)



Get a hg repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectHg(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**ProjectHg**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectHistories"></a>
# **getProjectHistories**
> [History] getProjectHistories(idOrName)



Get project histories.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectHistories(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[History]**](History.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectProfile"></a>
# **getProjectProfile**
> GroupProfilePerLanguage getProjectProfile(idOrName, languageCode)



Get project profile on the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectProfile(idOrName, languageCode, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 

### Return type

[**GroupProfilePerLanguage**](GroupProfilePerLanguage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectProfileList"></a>
# **getProjectProfileList**
> GroupProfile getProjectProfileList(idOrName)



Get project profile in all languages

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectProfileList(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**GroupProfile**](GroupProfile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectSvn"></a>
# **getProjectSvn**
> ProjectSvn getProjectSvn(idOrName)



Get Subversion repository of the project

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectSvn(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**ProjectSvn**](ProjectSvn.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicket"></a>
# **getProjectTicket**
> ProjectTicketItem getProjectTicket(idOrName, ticketId)



Get project ticket

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicket(idOrName, ticketId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 

### Return type

[**ProjectTicketItem**](ProjectTicketItem.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketComponent"></a>
# **getProjectTicketComponent**
> ProjectTicketComponent getProjectTicketComponent(idOrName, componentId)



Get project ticket component

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var componentId = 56; // Integer | numeric project ticket component id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketComponent(idOrName, componentId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **componentId** | **Integer**| numeric project ticket component id | 

### Return type

[**ProjectTicketComponent**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketMilestone"></a>
# **getProjectTicketMilestone**
> ProjectTicketMilestone getProjectTicketMilestone(idOrName, milestoneId)



Get project ticket milestone of spscified milestone_id.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var milestoneId = 56; // Integer | numeric project ticket milestone id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketMilestone(idOrName, milestoneId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **milestoneId** | **Integer**| numeric project ticket milestone id | 

### Return type

[**ProjectTicketMilestone**](ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketType"></a>
# **getProjectTicketType**
> ProjectTicketType getProjectTicketType(idOrName, typeId)



Get project ticket type

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketType(idOrName, typeId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 

### Return type

[**ProjectTicketType**](ProjectTicketType.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketTypeInstruction"></a>
# **getProjectTicketTypeInstruction**
> ProjectTicketTypeInstructionPerLanguage getProjectTicketTypeInstruction(idOrName, typeId, languageCode)



Get project ticket type instructions on the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketTypeInstruction(idOrName, typeId, languageCode, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 

### Return type

[**ProjectTicketTypeInstructionPerLanguage**](ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketTypeInstruction_0"></a>
# **getProjectTicketTypeInstruction_0**
> ProjectTicketTypeInstructionPerLanguage getProjectTicketTypeInstruction_0(idOrName, typeId, languageCode, instruction)



Update project ticket type instructions on the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)

var instruction = "instruction_example"; // String | Ticket submit instruction for the type


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketTypeInstruction_0(idOrName, typeId, languageCode, instruction, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 
 **instruction** | **String**| Ticket submit instruction for the type | 

### Return type

[**ProjectTicketTypeInstructionPerLanguage**](ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTools"></a>
# **getProjectTools**
> GroupToolFlags getProjectTools(idOrName)



Get project tools info.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTools(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**GroupToolFlags**](GroupToolFlags.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getRelease"></a>
# **getRelease**
> Release getRelease(idOrName, packageId, releaseId)



Get specified release info and file list of the release.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getRelease(idOrName, packageId, releaseId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getReleaseFile"></a>
# **getReleaseFile**
> RelFile getReleaseFile(idOrName, packageId, releaseId, fileId)



Get single file object.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var fileId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getReleaseFile(idOrName, packageId, releaseId, fileId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **fileId** | **Integer**|  | 

### Return type

[**RelFile**](RelFile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listNews"></a>
# **listNews**
> [News] listNews(opts)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var opts = { 
  'groupId': 56 // Integer | filter by group ID
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listNews(opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **Integer**| filter by group ID | [optional] 

### Return type

[**[News]**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listNews_0"></a>
# **listNews_0**
> [News] listNews_0(idOrName)



Get news list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listNews_0(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[News]**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listPackages"></a>
# **listPackages**
> [ModelPackage] listPackages(idOrName)



Get package list of specified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listPackages(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ModelPackage]**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectBzr"></a>
# **listProjectBzr**
> [ProjectBzr] listProjectBzr(idOrName)



Get Bazzar repository list

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectBzr(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectBzr]**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectGit"></a>
# **listProjectGit**
> [ProjectGit] listProjectGit(idOrName)



Get git repository list

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectGit(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectGit]**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectGitHook"></a>
# **listProjectGitHook**
> [ScmHook] listProjectGitHook(idOrName, repoId)



Get Git repository hook list

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectGitHook(idOrName, repoId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 

### Return type

[**[ScmHook]**](ScmHook.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectHg"></a>
# **listProjectHg**
> [ProjectHg] listProjectHg(idOrName)



Get Mercurial repository list

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectHg(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectHg]**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicket"></a>
# **listProjectTicket**
> [ProjectTicketItem] listProjectTicket(idOrName, opts)



List project ticket order by submit date descending

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var opts = { 
  'status': ["status_example"], // [String] | Tickets are assigned to these type_ids
  'typeId': [56], // [Integer] | Listing tickets are assigned to these type_ids
  'notTypeId': [56], // [Integer] | Listing tickets are NOT assigned to these type_ids
  'componentId': [56], // [Integer] | Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
  'notComponentId': [56], // [Integer] | Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
  'milestoneId': [56], // [Integer] | Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id = 0)
  'notMilestoneId': [56], // [Integer] | Listing tickets are NOT assigned to these milestone_ids (milestone_id = 0 means milestone not assigned)
  'maxPriority': 56, // Integer | Listing equal or lower priority tickets
  'minPriority': 56, // Integer | Listing equal or higher priority tickets
  'priority': 56, // Integer | Listing tickets have this priority
  'maxSeverity': 56, // Integer | Listing equal or lower severity tickets
  'minSeverity': 56, // Integer | Listing equal or higher severity tickets
  'severity': 56, // Integer | Listing tickets have this severity
  'owner': [56], // [Integer] | Listing tickets assigned to these owners (owner = 100 means owner is not assigned)
  'notOwner': [56], // [Integer] | Listing tickets NOT assigned to these owners (owner = 100 means owner is not assigned)
  'reporter': [56], // [Integer] | Listing tickets reported by these users (report = 100 means reported by non login user)
  'notReporter': [56], // [Integer] | Listing tickets reported by these users (report = 100 means reported by non login user)
  'text': "text_example" // String | Listing tickets title or description or comment include the text
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicket(idOrName, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **status** | [**[String]**](String.md)| Tickets are assigned to these type_ids | [optional] 
 **typeId** | [**[Integer]**](Integer.md)| Listing tickets are assigned to these type_ids | [optional] 
 **notTypeId** | [**[Integer]**](Integer.md)| Listing tickets are NOT assigned to these type_ids | [optional] 
 **componentId** | [**[Integer]**](Integer.md)| Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) | [optional] 
 **notComponentId** | [**[Integer]**](Integer.md)| Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) | [optional] 
 **milestoneId** | [**[Integer]**](Integer.md)| Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0) | [optional] 
 **notMilestoneId** | [**[Integer]**](Integer.md)| Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned) | [optional] 
 **maxPriority** | **Integer**| Listing equal or lower priority tickets | [optional] 
 **minPriority** | **Integer**| Listing equal or higher priority tickets | [optional] 
 **priority** | **Integer**| Listing tickets have this priority | [optional] 
 **maxSeverity** | **Integer**| Listing equal or lower severity tickets | [optional] 
 **minSeverity** | **Integer**| Listing equal or higher severity tickets | [optional] 
 **severity** | **Integer**| Listing tickets have this severity | [optional] 
 **owner** | [**[Integer]**](Integer.md)| Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned) | [optional] 
 **notOwner** | [**[Integer]**](Integer.md)| Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned) | [optional] 
 **reporter** | [**[Integer]**](Integer.md)| Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) | [optional] 
 **notReporter** | [**[Integer]**](Integer.md)| Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) | [optional] 
 **text** | **String**| Listing tickets title or description or comment include the text | [optional] 

### Return type

[**[ProjectTicketItem]**](ProjectTicketItem.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketComment"></a>
# **listProjectTicketComment**
> [ProjectTicketComment] listProjectTicketComment(idOrName, ticketId)



Get project ticket comment list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketComment(idOrName, ticketId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 

### Return type

[**[ProjectTicketComment]**](ProjectTicketComment.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketComponent"></a>
# **listProjectTicketComponent**
> [ProjectTicketComponent] listProjectTicketComponent(idOrName)



Get project ticket component list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketComponent(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectTicketComponent]**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketMilestone"></a>
# **listProjectTicketMilestone**
> [ProjectTicketMilestone] listProjectTicketMilestone(idOrName)



Get project ticket milestone list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketMilestone(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectTicketMilestone]**](ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketType"></a>
# **listProjectTicketType**
> [ProjectTicketType] listProjectTicketType(idOrName)



Get project ticket type list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketType(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectTicketType]**](ProjectTicketType.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketTypeInstruction"></a>
# **listProjectTicketTypeInstruction**
> ProjectTicketTypeInstructions listProjectTicketTypeInstruction(idOrName, typeId)



Get project ticket type instructions

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketTypeInstruction(idOrName, typeId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 

### Return type

[**ProjectTicketTypeInstructions**](ProjectTicketTypeInstructions.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="showProjectTicketAdminprefs"></a>
# **showProjectTicketAdminprefs**
> ProjectTicketPrefs showProjectTicketAdminprefs(idOrName)



Get project ticket admin preferences.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.showProjectTicketAdminprefs(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**ProjectTicketPrefs**](ProjectTicketPrefs.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="showProjectTicketComment"></a>
# **showProjectTicketComment**
> ProjectTicketComment showProjectTicketComment(idOrName, ticketId, commentId)



Get project ticket comment spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id

var commentId = 56; // Integer | numeric project ticket comment id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.showProjectTicketComment(idOrName, ticketId, commentId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 
 **commentId** | **Integer**| numeric project ticket comment id | 

### Return type

[**ProjectTicketComment**](ProjectTicketComment.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateFrsAdminprefs"></a>
# **updateFrsAdminprefs**
> FrsAdminPrefs updateFrsAdminprefs(idOrName, opts)



Update project frs admin preferences.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var opts = { 
  'allowOverwrite': true // Boolean | Allow overwrite files when filenames are conflict
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateFrsAdminprefs(idOrName, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **allowOverwrite** | **Boolean**| Allow overwrite files when filenames are conflict | [optional] 

### Return type

[**FrsAdminPrefs**](FrsAdminPrefs.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateNews"></a>
# **updateNews**
> News updateNews(newsId, opts)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var newsId = 56; // Integer | 

var opts = { 
  'title': "title_example", // String | news title
  'body': "body_example" // String | news body in OSDN Wiki format.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateNews(newsId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **newsId** | **Integer**|  | 
 **title** | **String**| news title | [optional] 
 **body** | **String**| news body in OSDN Wiki format. | [optional] 

### Return type

[**News**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateNews_0"></a>
# **updateNews_0**
> News updateNews_0(newsId, idOrName, opts)



### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var newsId = 56; // Integer | 

var idOrName = "idOrName_example"; // String | numeric project id or project name

var opts = { 
  'title': "title_example", // String | news title
  'body': "body_example" // String | news body in OSDN Wiki format.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateNews_0(newsId, idOrName, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **newsId** | **Integer**|  | 
 **idOrName** | **String**| numeric project id or project name | 
 **title** | **String**| news title | [optional] 
 **body** | **String**| news body in OSDN Wiki format. | [optional] 

### Return type

[**News**](News.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updatePackage"></a>
# **updatePackage**
> ModelPackage updatePackage(idOrName, packageId, opts)



Update tagret package.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var opts = { 
  'name': "name_example", // String | package name
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updatePackage(idOrName, packageId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **name** | **String**| package name | [optional] 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**ModelPackage**](ModelPackage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectAdminProjectweb"></a>
# **updateProjectAdminProjectweb**
> ProjectWeb updateProjectAdminProjectweb(idOrName, opts)



Update project homepage url

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var opts = { 
  'homepage': "homepage_example", // String | Project home page full URL (should start with http:// or https://). If reset param is true, this url will be ignored (URL will be reset to default url)
  'reset': true // Boolean | Project home page URL reset to default value
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectAdminProjectweb(idOrName, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **homepage** | **String**| Project home page full URL (should start with http:// or https://). If reset param is true, this url will be ignored (URL will be reset to default url) | [optional] 
 **reset** | **Boolean**| Project home page URL reset to default value | [optional] 

### Return type

[**ProjectWeb**](ProjectWeb.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectBzr"></a>
# **updateProjectBzr**
> ProjectBzr updateProjectBzr(idOrName, repoId, opts)



Update a bzr repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var opts = { 
  'description': "description_example", // String | 
  'active': true // Boolean | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectBzr(idOrName, repoId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **description** | **String**|  | [optional] 
 **active** | **Boolean**|  | [optional] 

### Return type

[**ProjectBzr**](ProjectBzr.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectGit"></a>
# **updateProjectGit**
> ProjectGit updateProjectGit(idOrName, repoId, opts)



Update a git repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var opts = { 
  'description': "description_example", // String | 
  'mailEnabled': true, // Boolean | 
  'mailRecipients': "mailRecipients_example", // String | 
  'allowNonFastForward': true, // Boolean | 
  'defaultBranch': "defaultBranch_example", // String | 
  'active': true // Boolean | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectGit(idOrName, repoId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **description** | **String**|  | [optional] 
 **mailEnabled** | **Boolean**|  | [optional] 
 **mailRecipients** | **String**|  | [optional] 
 **allowNonFastForward** | **Boolean**|  | [optional] 
 **defaultBranch** | **String**|  | [optional] 
 **active** | **Boolean**|  | [optional] 

### Return type

[**ProjectGit**](ProjectGit.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectHg"></a>
# **updateProjectHg**
> ProjectHg updateProjectHg(idOrName, repoId, opts)



Update a hg repository

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var repoId = 56; // Integer | 

var opts = { 
  'description': "description_example", // String | 
  'mailRecipients': "mailRecipients_example", // String | 
  'active': true // Boolean | 
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectHg(idOrName, repoId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **repoId** | **Integer**|  | 
 **description** | **String**|  | [optional] 
 **mailRecipients** | **String**|  | [optional] 
 **active** | **Boolean**|  | [optional] 

### Return type

[**ProjectHg**](ProjectHg.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectProfile"></a>
# **updateProjectProfile**
> GroupProfilePerLanguage updateProjectProfile(idOrName, languageCode, opts)



Update project profile.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)

var opts = { 
  'displayName': "displayName_example", // String | Project display name
  'description': "description_example" // String | Project description
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectProfile(idOrName, languageCode, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 
 **displayName** | **String**| Project display name | [optional] 
 **description** | **String**| Project description | [optional] 

### Return type

[**GroupProfilePerLanguage**](GroupProfilePerLanguage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicket"></a>
# **updateProjectTicket**
> ProjectTicketItem updateProjectTicket(idOrName, ticketId, opts)



Update project ticket

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id

var opts = { 
  'name': "name_example", // String | Project ticket name (title)
  'description': "description_example", // String | Project ticket description details
  'typeId': 56, // Integer | numeric project ticket type id
  'milestoneId': 56, // Integer | numeric project ticket milestone id
  'componentId': 56, // Integer | numeric project ticket component id
  'priority': 56, // Integer | project ticket priority (min = 1 and max = 9)
  'severity': 56, // Integer | project ticket severity (min = 1 and max = 9)
  'owner': 56, // Integer | numeric project ticket owner user id
  'resolution': "resolution_example", // String | project ticket resolution text
  'status': "status_example" // String | project ticket status (open or close)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicket(idOrName, ticketId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 
 **name** | **String**| Project ticket name (title) | [optional] 
 **description** | **String**| Project ticket description details | [optional] 
 **typeId** | **Integer**| numeric project ticket type id | [optional] 
 **milestoneId** | **Integer**| numeric project ticket milestone id | [optional] 
 **componentId** | **Integer**| numeric project ticket component id | [optional] 
 **priority** | **Integer**| project ticket priority (min &#x3D; 1 and max &#x3D; 9) | [optional] 
 **severity** | **Integer**| project ticket severity (min &#x3D; 1 and max &#x3D; 9) | [optional] 
 **owner** | **Integer**| numeric project ticket owner user id | [optional] 
 **resolution** | **String**| project ticket resolution text | [optional] 
 **status** | **String**| project ticket status (open or close) | [optional] 

### Return type

[**ProjectTicketItem**](ProjectTicketItem.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicketAdminprefs"></a>
# **updateProjectTicketAdminprefs**
> ProjectTicketPrefs updateProjectTicketAdminprefs(idOrName, opts)



Update project ticket admin preferences.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var opts = { 
  'allowAnonymouse': true, // Boolean | Non login user allows to post new ticket/comment
  'frsAutosync': "frsAutosync_example", // String | Componet File release autosync type 'Disabled', 'Package', 'Release', 'Package and Release'
  'mailsendType': "mailsendType_example", // String | Ticket update mail destination type 'None', 'Ticket Technician', 'Ticket Administrator', 'Ticket Administrator and Technician', 'All project members', 'Mailing List'
  'mailingListId': 56, // Integer | Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list)
  'mailLang': "mailLang_example" // String | Ticket update mail language
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicketAdminprefs(idOrName, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **allowAnonymouse** | **Boolean**| Non login user allows to post new ticket/comment | [optional] 
 **frsAutosync** | **String**| Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39; | [optional] 
 **mailsendType** | **String**| Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39; | [optional] 
 **mailingListId** | **Integer**| Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list) | [optional] 
 **mailLang** | **String**| Ticket update mail language | [optional] 

### Return type

[**ProjectTicketPrefs**](ProjectTicketPrefs.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicketComponent"></a>
# **updateProjectTicketComponent**
> ProjectTicketComponent updateProjectTicketComponent(idOrName, componentId, opts)



Update project ticket component

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var componentId = 56; // Integer | numeric project ticket component id

var opts = { 
  'name': "name_example", // String | Ticket component name
  'description': "description_example", // String | Ticket component description
  'owner': 56, // Integer | Ticket componet owner user_id
  'active': true // Boolean | Ticket componet will be shown the component select list when this parameter is true
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicketComponent(idOrName, componentId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **componentId** | **Integer**| numeric project ticket component id | 
 **name** | **String**| Ticket component name | [optional] 
 **description** | **String**| Ticket component description | [optional] 
 **owner** | **Integer**| Ticket componet owner user_id | [optional] 
 **active** | **Boolean**| Ticket componet will be shown the component select list when this parameter is true | [optional] 

### Return type

[**ProjectTicketComponent**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicketMilestone"></a>
# **updateProjectTicketMilestone**
> ProjectTicketComponent updateProjectTicketMilestone(idOrName, milestoneId, opts)



Update project ticket milestone

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var milestoneId = 56; // Integer | numeric project ticket milestone id

var opts = { 
  'name': "name_example", // String | Ticket milestone name
  'description': "description_example", // String | Ticket milestone description
  'start': new Date("2013-10-20T19:20:30+01:00"), // Date | Ticket milestone start date
  'end': new Date("2013-10-20T19:20:30+01:00"), // Date | Ticket milestone due date
  'forceStatus': "forceStatus_example" // String | If you want to force close the milestone set to 'close' or reopen it set to 'reopen'
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicketMilestone(idOrName, milestoneId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **milestoneId** | **Integer**| numeric project ticket milestone id | 
 **name** | **String**| Ticket milestone name | [optional] 
 **description** | **String**| Ticket milestone description | [optional] 
 **start** | **Date**| Ticket milestone start date | [optional] 
 **end** | **Date**| Ticket milestone due date | [optional] 
 **forceStatus** | **String**| If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39; | [optional] 

### Return type

[**ProjectTicketComponent**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicketType"></a>
# **updateProjectTicketType**
> ProjectTicketType updateProjectTicketType(idOrName, typeId, opts)



Update project ticket type

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var opts = { 
  'name': "name_example", // String | Ticket type name
  'description': "description_example", // String | Ticket type description
  'isPublic': true // Boolean | if set as false, this type will be shown to project members only.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicketType(idOrName, typeId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **name** | **String**| Ticket type name | [optional] 
 **description** | **String**| Ticket type description | [optional] 
 **isPublic** | **Boolean**| if set as false, this type will be shown to project members only. | [optional] 

### Return type

[**ProjectTicketType**](ProjectTicketType.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTools"></a>
# **updateProjectTools**
> GroupToolFlags updateProjectTools(idOrName, opts)



Update project tools info.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var opts = { 
  'git': true, // Boolean | use git flag
  'svn': true, // Boolean | use Subversion flag
  'hg': true, // Boolean | use Mercurial(Hg) flag
  'bzr': true, // Boolean | use Bazaar flag
  'frs': true, // Boolean | use File Release flag
  'ticket': true, // Boolean | use Ticket flag
  'wiki': true, // Boolean | use Wiki flag
  'forum': true, // Boolean | use Forum flag
  'ml': true // Boolean | use Mailing List flag
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTools(idOrName, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **git** | **Boolean**| use git flag | [optional] 
 **svn** | **Boolean**| use Subversion flag | [optional] 
 **hg** | **Boolean**| use Mercurial(Hg) flag | [optional] 
 **bzr** | **Boolean**| use Bazaar flag | [optional] 
 **frs** | **Boolean**| use File Release flag | [optional] 
 **ticket** | **Boolean**| use Ticket flag | [optional] 
 **wiki** | **Boolean**| use Wiki flag | [optional] 
 **forum** | **Boolean**| use Forum flag | [optional] 
 **ml** | **Boolean**| use Mailing List flag | [optional] 

### Return type

[**GroupToolFlags**](GroupToolFlags.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateRelease"></a>
# **updateRelease**
> Release updateRelease(idOrName, packageId, releaseId, opts)



Update target release. (Note: If you update draft release, the release will be public automatically.) 

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var opts = { 
  'visibility': "visibility_example", // String | visibility status (public, hidden or private)
  'name': "name_example", // String | Release name
  'time': new Date("2013-10-20T19:20:30+01:00"), // Date | Release datetime. If you set future time, the release hide until specified time.
  'moveToPackageId': 56 // Integer | If this parameter is specified, the release move to another package.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateRelease(idOrName, packageId, releaseId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 
 **name** | **String**| Release name | [optional] 
 **time** | **Date**| Release datetime. If you set future time, the release hide until specified time. | [optional] 
 **moveToPackageId** | **Integer**| If this parameter is specified, the release move to another package. | [optional] 

### Return type

[**Release**](Release.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateReleaseFile"></a>
# **updateReleaseFile**
> RelFile updateReleaseFile(idOrName, packageId, releaseId, fileId, opts)



Change visibility of target file.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var packageId = 56; // Integer | 

var releaseId = 56; // Integer | 

var fileId = 56; // Integer | 

var opts = { 
  'visibility': "visibility_example" // String | visibility status (public, hidden or private)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateReleaseFile(idOrName, packageId, releaseId, fileId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **packageId** | **Integer**|  | 
 **releaseId** | **Integer**|  | 
 **fileId** | **Integer**|  | 
 **visibility** | **String**| visibility status (public, hidden or private) | [optional] 

### Return type

[**RelFile**](RelFile.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

