# OSDNClient.ProjectTicketApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createProjectTicket**](ProjectTicketApi.md#createProjectTicket) | **POST** /project/{id_or_name}/ticket | 
[**createProjectTicketComment**](ProjectTicketApi.md#createProjectTicketComment) | **POST** /project/{id_or_name}/ticket/{ticket_id}/comment | 
[**createProjectTicketComponent**](ProjectTicketApi.md#createProjectTicketComponent) | **POST** /project/{id_or_name}/ticket/component | 
[**createProjectTicketMilestone**](ProjectTicketApi.md#createProjectTicketMilestone) | **POST** /project/{id_or_name}/ticket/milestone | 
[**createProjectTicketType**](ProjectTicketApi.md#createProjectTicketType) | **POST** /project/{id_or_name}/ticket/type | 
[**createProjectTicketTypeInstruction**](ProjectTicketApi.md#createProjectTicketTypeInstruction) | **POST** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
[**deleteProjectTicketComponent**](ProjectTicketApi.md#deleteProjectTicketComponent) | **DELETE** /project/{id_or_name}/ticket/component/{component_id} | 
[**deleteProjectTicketMilestone**](ProjectTicketApi.md#deleteProjectTicketMilestone) | **DELETE** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**deleteProjectTicketType**](ProjectTicketApi.md#deleteProjectTicketType) | **DELETE** /project/{id_or_name}/ticket/type/{type_id} | 
[**deleteProjectTicketTypeInstruction**](ProjectTicketApi.md#deleteProjectTicketTypeInstruction) | **DELETE** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**getProjectTicket**](ProjectTicketApi.md#getProjectTicket) | **GET** /project/{id_or_name}/ticket/{ticket_id} | 
[**getProjectTicketComponent**](ProjectTicketApi.md#getProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component/{component_id} | 
[**getProjectTicketMilestone**](ProjectTicketApi.md#getProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**getProjectTicketType**](ProjectTicketApi.md#getProjectTicketType) | **GET** /project/{id_or_name}/ticket/type/{type_id} | 
[**getProjectTicketTypeInstruction**](ProjectTicketApi.md#getProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**getProjectTicketTypeInstruction_0**](ProjectTicketApi.md#getProjectTicketTypeInstruction_0) | **PATCH** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
[**listProjectTicket**](ProjectTicketApi.md#listProjectTicket) | **GET** /project/{id_or_name}/ticket | 
[**listProjectTicketComment**](ProjectTicketApi.md#listProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment | 
[**listProjectTicketComponent**](ProjectTicketApi.md#listProjectTicketComponent) | **GET** /project/{id_or_name}/ticket/component | 
[**listProjectTicketMilestone**](ProjectTicketApi.md#listProjectTicketMilestone) | **GET** /project/{id_or_name}/ticket/milestone | 
[**listProjectTicketType**](ProjectTicketApi.md#listProjectTicketType) | **GET** /project/{id_or_name}/ticket/type | 
[**listProjectTicketTypeInstruction**](ProjectTicketApi.md#listProjectTicketTypeInstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
[**showProjectTicketAdminprefs**](ProjectTicketApi.md#showProjectTicketAdminprefs) | **GET** /project/{id_or_name}/ticket/admin | 
[**showProjectTicketComment**](ProjectTicketApi.md#showProjectTicketComment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id} | 
[**updateProjectTicket**](ProjectTicketApi.md#updateProjectTicket) | **PATCH** /project/{id_or_name}/ticket/{ticket_id} | 
[**updateProjectTicketAdminprefs**](ProjectTicketApi.md#updateProjectTicketAdminprefs) | **PATCH** /project/{id_or_name}/ticket/admin | 
[**updateProjectTicketComponent**](ProjectTicketApi.md#updateProjectTicketComponent) | **PATCH** /project/{id_or_name}/ticket/component/{component_id} | 
[**updateProjectTicketMilestone**](ProjectTicketApi.md#updateProjectTicketMilestone) | **PATCH** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
[**updateProjectTicketType**](ProjectTicketApi.md#updateProjectTicketType) | **PATCH** /project/{id_or_name}/ticket/type/{type_id} | 


<a name="createProjectTicket"></a>
# **createProjectTicket**
> ProjectTicketItem createProjectTicket(idOrName, name, description, typeId, opts)



Create project ticket

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | Project ticket name (title)

var description = "description_example"; // String | Project ticket description details

var typeId = 56; // Integer | numeric project ticket type id

var opts = { 
  'milestoneId': 56, // Integer | numeric project ticket milestone id
  'componentId': 56, // Integer | numeric project ticket component id
  'priority': 56, // Integer | project ticket priority (min = 1 and max = 9)
  'severity': 56, // Integer | project ticket severity (min = 1 and max = 9)
  'owner': 56 // Integer | numeric project ticket owner user id
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicket(idOrName, name, description, typeId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| Project ticket name (title) | 
 **description** | **String**| Project ticket description details | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **milestoneId** | **Integer**| numeric project ticket milestone id | [optional] 
 **componentId** | **Integer**| numeric project ticket component id | [optional] 
 **priority** | **Integer**| project ticket priority (min &#x3D; 1 and max &#x3D; 9) | [optional] 
 **severity** | **Integer**| project ticket severity (min &#x3D; 1 and max &#x3D; 9) | [optional] 
 **owner** | **Integer**| numeric project ticket owner user id | [optional] 

### Return type

[**ProjectTicketItem**](ProjectTicketItem.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketComment"></a>
# **createProjectTicketComment**
> ProjectTicketComment createProjectTicketComment(idOrName, ticketId, comment)



Create new project ticket comment of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id

var comment = "comment_example"; // String | Ticket comment text


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketComment(idOrName, ticketId, comment, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 
 **comment** | **String**| Ticket comment text | 

### Return type

[**ProjectTicketComment**](ProjectTicketComment.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketComponent"></a>
# **createProjectTicketComponent**
> [ProjectTicketComponent] createProjectTicketComponent(idOrName, name, description, opts)



Create new project ticket component of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | Ticket component name

var description = "description_example"; // String | Ticket component description

var opts = { 
  'owner': 56, // Integer | Ticket componet owner user_id
  'active': true // Boolean | Ticket componet will be shown the component select list when this parameter is true
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketComponent(idOrName, name, description, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| Ticket component name | 
 **description** | **String**| Ticket component description | 
 **owner** | **Integer**| Ticket componet owner user_id | [optional] 
 **active** | **Boolean**| Ticket componet will be shown the component select list when this parameter is true | [optional] 

### Return type

[**[ProjectTicketComponent]**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketMilestone"></a>
# **createProjectTicketMilestone**
> ProjectTicketMilestone createProjectTicketMilestone(idOrName, name, description, opts)



Create new project ticket milestone of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | Ticket milestone name

var description = "description_example"; // String | Ticket milestone description

var opts = { 
  'start': new Date("2013-10-20T19:20:30+01:00"), // Date | Ticket milestone start date
  'end': new Date("2013-10-20T19:20:30+01:00") // Date | Ticket milestone due date
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketMilestone(idOrName, name, description, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| Ticket milestone name | 
 **description** | **String**| Ticket milestone description | 
 **start** | **Date**| Ticket milestone start date | [optional] 
 **end** | **Date**| Ticket milestone due date | [optional] 

### Return type

[**ProjectTicketMilestone**](ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketType"></a>
# **createProjectTicketType**
> ProjectTicketType createProjectTicketType(idOrName, name, description, opts)



Create new project ticket type of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var name = "name_example"; // String | Ticket type name

var description = "description_example"; // String | Ticket type description

var opts = { 
  'isPublic': true // Boolean | if set as false, this type will be shown to project members only.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketType(idOrName, name, description, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **name** | **String**| Ticket type name | 
 **description** | **String**| Ticket type description | 
 **isPublic** | **Boolean**| if set as false, this type will be shown to project members only. | [optional] 

### Return type

[**ProjectTicketType**](ProjectTicketType.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="createProjectTicketTypeInstruction"></a>
# **createProjectTicketTypeInstruction**
> ProjectTicketTypeInstructionPerLanguage createProjectTicketTypeInstruction(idOrName, typeId, languageCode, instruction)



Create project ticket type instructions for the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)

var instruction = "instruction_example"; // String | Ticket submit instruction for the type


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.createProjectTicketTypeInstruction(idOrName, typeId, languageCode, instruction, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 
 **instruction** | **String**| Ticket submit instruction for the type | 

### Return type

[**ProjectTicketTypeInstructionPerLanguage**](ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectTicketComponent"></a>
# **deleteProjectTicketComponent**
> deleteProjectTicketComponent(idOrName, componentId, migrateTo)



Delete project ticket component

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var componentId = 56; // Integer | numeric project ticket component id

var migrateTo = 56; // Integer | Tickets that assigned to delete target will be migrate to the ticket component_id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectTicketComponent(idOrName, componentId, migrateTo, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **componentId** | **Integer**| numeric project ticket component id | 
 **migrateTo** | **Integer**| Tickets that assigned to delete target will be migrate to the ticket component_id | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectTicketMilestone"></a>
# **deleteProjectTicketMilestone**
> deleteProjectTicketMilestone(idOrName, milestoneId, opts)



Delete project ticket milestone

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var milestoneId = 56; // Integer | numeric project ticket milestone id

var opts = { 
  'migrateTo': 56 // Integer | Tickets that assigned to delete target will be migrate to the ticket milestone_id
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectTicketMilestone(idOrName, milestoneId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **milestoneId** | **Integer**| numeric project ticket milestone id | 
 **migrateTo** | **Integer**| Tickets that assigned to delete target will be migrate to the ticket milestone_id | [optional] 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectTicketType"></a>
# **deleteProjectTicketType**
> deleteProjectTicketType(idOrName, typeId, migrateTo)



Delete project ticket type

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var migrateTo = 56; // Integer | Tickets that assigned to delete target will be migrate to the ticket type_id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectTicketType(idOrName, typeId, migrateTo, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **migrateTo** | **Integer**| Tickets that assigned to delete target will be migrate to the ticket type_id | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="deleteProjectTicketTypeInstruction"></a>
# **deleteProjectTicketTypeInstruction**
> deleteProjectTicketTypeInstruction(idOrName, typeId, languageCode)



Delete project ticket type instructions on the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
};
apiInstance.deleteProjectTicketTypeInstruction(idOrName, typeId, languageCode, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 

### Return type

null (empty response body)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicket"></a>
# **getProjectTicket**
> ProjectTicketItem getProjectTicket(idOrName, ticketId)



Get project ticket

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicket(idOrName, ticketId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 

### Return type

[**ProjectTicketItem**](ProjectTicketItem.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketComponent"></a>
# **getProjectTicketComponent**
> ProjectTicketComponent getProjectTicketComponent(idOrName, componentId)



Get project ticket component

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var componentId = 56; // Integer | numeric project ticket component id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketComponent(idOrName, componentId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **componentId** | **Integer**| numeric project ticket component id | 

### Return type

[**ProjectTicketComponent**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketMilestone"></a>
# **getProjectTicketMilestone**
> ProjectTicketMilestone getProjectTicketMilestone(idOrName, milestoneId)



Get project ticket milestone of spscified milestone_id.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var milestoneId = 56; // Integer | numeric project ticket milestone id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketMilestone(idOrName, milestoneId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **milestoneId** | **Integer**| numeric project ticket milestone id | 

### Return type

[**ProjectTicketMilestone**](ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketType"></a>
# **getProjectTicketType**
> ProjectTicketType getProjectTicketType(idOrName, typeId)



Get project ticket type

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketType(idOrName, typeId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 

### Return type

[**ProjectTicketType**](ProjectTicketType.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketTypeInstruction"></a>
# **getProjectTicketTypeInstruction**
> ProjectTicketTypeInstructionPerLanguage getProjectTicketTypeInstruction(idOrName, typeId, languageCode)



Get project ticket type instructions on the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketTypeInstruction(idOrName, typeId, languageCode, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 

### Return type

[**ProjectTicketTypeInstructionPerLanguage**](ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="getProjectTicketTypeInstruction_0"></a>
# **getProjectTicketTypeInstruction_0**
> ProjectTicketTypeInstructionPerLanguage getProjectTicketTypeInstruction_0(idOrName, typeId, languageCode, instruction)



Update project ticket type instructions on the language

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var languageCode = "languageCode_example"; // String | Language code for display name and description (example en, ja, zh-TW)

var instruction = "instruction_example"; // String | Ticket submit instruction for the type


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.getProjectTicketTypeInstruction_0(idOrName, typeId, languageCode, instruction, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **languageCode** | **String**| Language code for display name and description (example en, ja, zh-TW) | 
 **instruction** | **String**| Ticket submit instruction for the type | 

### Return type

[**ProjectTicketTypeInstructionPerLanguage**](ProjectTicketTypeInstructionPerLanguage.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicket"></a>
# **listProjectTicket**
> [ProjectTicketItem] listProjectTicket(idOrName, opts)



List project ticket order by submit date descending

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var opts = { 
  'status': ["status_example"], // [String] | Tickets are assigned to these type_ids
  'typeId': [56], // [Integer] | Listing tickets are assigned to these type_ids
  'notTypeId': [56], // [Integer] | Listing tickets are NOT assigned to these type_ids
  'componentId': [56], // [Integer] | Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
  'notComponentId': [56], // [Integer] | Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
  'milestoneId': [56], // [Integer] | Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id = 0)
  'notMilestoneId': [56], // [Integer] | Listing tickets are NOT assigned to these milestone_ids (milestone_id = 0 means milestone not assigned)
  'maxPriority': 56, // Integer | Listing equal or lower priority tickets
  'minPriority': 56, // Integer | Listing equal or higher priority tickets
  'priority': 56, // Integer | Listing tickets have this priority
  'maxSeverity': 56, // Integer | Listing equal or lower severity tickets
  'minSeverity': 56, // Integer | Listing equal or higher severity tickets
  'severity': 56, // Integer | Listing tickets have this severity
  'owner': [56], // [Integer] | Listing tickets assigned to these owners (owner = 100 means owner is not assigned)
  'notOwner': [56], // [Integer] | Listing tickets NOT assigned to these owners (owner = 100 means owner is not assigned)
  'reporter': [56], // [Integer] | Listing tickets reported by these users (report = 100 means reported by non login user)
  'notReporter': [56], // [Integer] | Listing tickets reported by these users (report = 100 means reported by non login user)
  'text': "text_example" // String | Listing tickets title or description or comment include the text
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicket(idOrName, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **status** | [**[String]**](String.md)| Tickets are assigned to these type_ids | [optional] 
 **typeId** | [**[Integer]**](Integer.md)| Listing tickets are assigned to these type_ids | [optional] 
 **notTypeId** | [**[Integer]**](Integer.md)| Listing tickets are NOT assigned to these type_ids | [optional] 
 **componentId** | [**[Integer]**](Integer.md)| Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) | [optional] 
 **notComponentId** | [**[Integer]**](Integer.md)| Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0) | [optional] 
 **milestoneId** | [**[Integer]**](Integer.md)| Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0) | [optional] 
 **notMilestoneId** | [**[Integer]**](Integer.md)| Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned) | [optional] 
 **maxPriority** | **Integer**| Listing equal or lower priority tickets | [optional] 
 **minPriority** | **Integer**| Listing equal or higher priority tickets | [optional] 
 **priority** | **Integer**| Listing tickets have this priority | [optional] 
 **maxSeverity** | **Integer**| Listing equal or lower severity tickets | [optional] 
 **minSeverity** | **Integer**| Listing equal or higher severity tickets | [optional] 
 **severity** | **Integer**| Listing tickets have this severity | [optional] 
 **owner** | [**[Integer]**](Integer.md)| Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned) | [optional] 
 **notOwner** | [**[Integer]**](Integer.md)| Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned) | [optional] 
 **reporter** | [**[Integer]**](Integer.md)| Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) | [optional] 
 **notReporter** | [**[Integer]**](Integer.md)| Listing tickets reported by these users (report &#x3D; 100 means reported by non login user) | [optional] 
 **text** | **String**| Listing tickets title or description or comment include the text | [optional] 

### Return type

[**[ProjectTicketItem]**](ProjectTicketItem.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketComment"></a>
# **listProjectTicketComment**
> [ProjectTicketComment] listProjectTicketComment(idOrName, ticketId)



Get project ticket comment list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketComment(idOrName, ticketId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 

### Return type

[**[ProjectTicketComment]**](ProjectTicketComment.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketComponent"></a>
# **listProjectTicketComponent**
> [ProjectTicketComponent] listProjectTicketComponent(idOrName)



Get project ticket component list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketComponent(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectTicketComponent]**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketMilestone"></a>
# **listProjectTicketMilestone**
> [ProjectTicketMilestone] listProjectTicketMilestone(idOrName)



Get project ticket milestone list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketMilestone(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectTicketMilestone]**](ProjectTicketMilestone.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketType"></a>
# **listProjectTicketType**
> [ProjectTicketType] listProjectTicketType(idOrName)



Get project ticket type list of spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketType(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**[ProjectTicketType]**](ProjectTicketType.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="listProjectTicketTypeInstruction"></a>
# **listProjectTicketTypeInstruction**
> ProjectTicketTypeInstructions listProjectTicketTypeInstruction(idOrName, typeId)



Get project ticket type instructions

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.listProjectTicketTypeInstruction(idOrName, typeId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 

### Return type

[**ProjectTicketTypeInstructions**](ProjectTicketTypeInstructions.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="showProjectTicketAdminprefs"></a>
# **showProjectTicketAdminprefs**
> ProjectTicketPrefs showProjectTicketAdminprefs(idOrName)



Get project ticket admin preferences.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.showProjectTicketAdminprefs(idOrName, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 

### Return type

[**ProjectTicketPrefs**](ProjectTicketPrefs.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="showProjectTicketComment"></a>
# **showProjectTicketComment**
> ProjectTicketComment showProjectTicketComment(idOrName, ticketId, commentId)



Get project ticket comment spscified project.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id

var commentId = 56; // Integer | numeric project ticket comment id


var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.showProjectTicketComment(idOrName, ticketId, commentId, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 
 **commentId** | **Integer**| numeric project ticket comment id | 

### Return type

[**ProjectTicketComment**](ProjectTicketComment.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicket"></a>
# **updateProjectTicket**
> ProjectTicketItem updateProjectTicket(idOrName, ticketId, opts)



Update project ticket

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var ticketId = 56; // Integer | numeric project ticket id

var opts = { 
  'name': "name_example", // String | Project ticket name (title)
  'description': "description_example", // String | Project ticket description details
  'typeId': 56, // Integer | numeric project ticket type id
  'milestoneId': 56, // Integer | numeric project ticket milestone id
  'componentId': 56, // Integer | numeric project ticket component id
  'priority': 56, // Integer | project ticket priority (min = 1 and max = 9)
  'severity': 56, // Integer | project ticket severity (min = 1 and max = 9)
  'owner': 56, // Integer | numeric project ticket owner user id
  'resolution': "resolution_example", // String | project ticket resolution text
  'status': "status_example" // String | project ticket status (open or close)
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicket(idOrName, ticketId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **ticketId** | **Integer**| numeric project ticket id | 
 **name** | **String**| Project ticket name (title) | [optional] 
 **description** | **String**| Project ticket description details | [optional] 
 **typeId** | **Integer**| numeric project ticket type id | [optional] 
 **milestoneId** | **Integer**| numeric project ticket milestone id | [optional] 
 **componentId** | **Integer**| numeric project ticket component id | [optional] 
 **priority** | **Integer**| project ticket priority (min &#x3D; 1 and max &#x3D; 9) | [optional] 
 **severity** | **Integer**| project ticket severity (min &#x3D; 1 and max &#x3D; 9) | [optional] 
 **owner** | **Integer**| numeric project ticket owner user id | [optional] 
 **resolution** | **String**| project ticket resolution text | [optional] 
 **status** | **String**| project ticket status (open or close) | [optional] 

### Return type

[**ProjectTicketItem**](ProjectTicketItem.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicketAdminprefs"></a>
# **updateProjectTicketAdminprefs**
> ProjectTicketPrefs updateProjectTicketAdminprefs(idOrName, opts)



Update project ticket admin preferences.

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var opts = { 
  'allowAnonymouse': true, // Boolean | Non login user allows to post new ticket/comment
  'frsAutosync': "frsAutosync_example", // String | Componet File release autosync type 'Disabled', 'Package', 'Release', 'Package and Release'
  'mailsendType': "mailsendType_example", // String | Ticket update mail destination type 'None', 'Ticket Technician', 'Ticket Administrator', 'Ticket Administrator and Technician', 'All project members', 'Mailing List'
  'mailingListId': 56, // Integer | Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list)
  'mailLang': "mailLang_example" // String | Ticket update mail language
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicketAdminprefs(idOrName, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **allowAnonymouse** | **Boolean**| Non login user allows to post new ticket/comment | [optional] 
 **frsAutosync** | **String**| Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39; | [optional] 
 **mailsendType** | **String**| Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39; | [optional] 
 **mailingListId** | **Integer**| Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list) | [optional] 
 **mailLang** | **String**| Ticket update mail language | [optional] 

### Return type

[**ProjectTicketPrefs**](ProjectTicketPrefs.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicketComponent"></a>
# **updateProjectTicketComponent**
> ProjectTicketComponent updateProjectTicketComponent(idOrName, componentId, opts)



Update project ticket component

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var componentId = 56; // Integer | numeric project ticket component id

var opts = { 
  'name': "name_example", // String | Ticket component name
  'description': "description_example", // String | Ticket component description
  'owner': 56, // Integer | Ticket componet owner user_id
  'active': true // Boolean | Ticket componet will be shown the component select list when this parameter is true
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicketComponent(idOrName, componentId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **componentId** | **Integer**| numeric project ticket component id | 
 **name** | **String**| Ticket component name | [optional] 
 **description** | **String**| Ticket component description | [optional] 
 **owner** | **Integer**| Ticket componet owner user_id | [optional] 
 **active** | **Boolean**| Ticket componet will be shown the component select list when this parameter is true | [optional] 

### Return type

[**ProjectTicketComponent**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicketMilestone"></a>
# **updateProjectTicketMilestone**
> ProjectTicketComponent updateProjectTicketMilestone(idOrName, milestoneId, opts)



Update project ticket milestone

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var milestoneId = 56; // Integer | numeric project ticket milestone id

var opts = { 
  'name': "name_example", // String | Ticket milestone name
  'description': "description_example", // String | Ticket milestone description
  'start': new Date("2013-10-20T19:20:30+01:00"), // Date | Ticket milestone start date
  'end': new Date("2013-10-20T19:20:30+01:00"), // Date | Ticket milestone due date
  'forceStatus': "forceStatus_example" // String | If you want to force close the milestone set to 'close' or reopen it set to 'reopen'
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicketMilestone(idOrName, milestoneId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **milestoneId** | **Integer**| numeric project ticket milestone id | 
 **name** | **String**| Ticket milestone name | [optional] 
 **description** | **String**| Ticket milestone description | [optional] 
 **start** | **Date**| Ticket milestone start date | [optional] 
 **end** | **Date**| Ticket milestone due date | [optional] 
 **forceStatus** | **String**| If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39; | [optional] 

### Return type

[**ProjectTicketComponent**](ProjectTicketComponent.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

<a name="updateProjectTicketType"></a>
# **updateProjectTicketType**
> ProjectTicketType updateProjectTicketType(idOrName, typeId, opts)



Update project ticket type

### Example
```javascript
var OSDNClient = require('osdn-client');
var defaultClient = OSDNClient.ApiClient.default;

// Configure OAuth2 access token for authorization: oauth2-code
var oauth2-code = defaultClient.authentications['oauth2-code'];
oauth2-code.accessToken = 'YOUR ACCESS TOKEN';

// Configure OAuth2 access token for authorization: oauth2-implicit
var oauth2-implicit = defaultClient.authentications['oauth2-implicit'];
oauth2-implicit.accessToken = 'YOUR ACCESS TOKEN';

var apiInstance = new OSDNClient.ProjectTicketApi();

var idOrName = "idOrName_example"; // String | numeric project id or project name

var typeId = 56; // Integer | numeric project ticket type id

var opts = { 
  'name': "name_example", // String | Ticket type name
  'description': "description_example", // String | Ticket type description
  'isPublic': true // Boolean | if set as false, this type will be shown to project members only.
};

var callback = function(error, data, response) {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
};
apiInstance.updateProjectTicketType(idOrName, typeId, opts, callback);
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **idOrName** | **String**| numeric project id or project name | 
 **typeId** | **Integer**| numeric project ticket type id | 
 **name** | **String**| Ticket type name | [optional] 
 **description** | **String**| Ticket type description | [optional] 
 **isPublic** | **Boolean**| if set as false, this type will be shown to project members only. | [optional] 

### Return type

[**ProjectTicketType**](ProjectTicketType.md)

### Authorization

[oauth2-code](../README.md#oauth2-code), [oauth2-implicit](../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

