/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/ProjectBzr', 'OSDN/OSDN\Model/ProjectGit', 'OSDN/OSDN\Model/ScmHook', 'OSDN/OSDN\Model/ProjectHg', 'OSDN/OSDN\Model/ProjectSvn'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../OSDN\Model/ProjectBzr'), require('../OSDN\Model/ProjectGit'), require('../OSDN\Model/ScmHook'), require('../OSDN\Model/ProjectHg'), require('../OSDN\Model/ProjectSvn'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.ProjectSCMApi = factory(root.OSDNClient.ApiClient, root.OSDNClient.ProjectBzr, root.OSDNClient.ProjectGit, root.OSDNClient.ScmHook, root.OSDNClient.ProjectHg, root.OSDNClient.ProjectSvn);
  }
}(this, function(ApiClient, ProjectBzr, ProjectGit, ScmHook, ProjectHg, ProjectSvn) {
  'use strict';

  /**
   * ProjectSCM service.
   * @module OSDN/OSDN\Api/ProjectSCMApi
   * @version 0.0.20171120
   */

  /**
   * Constructs a new ProjectSCMApi. 
   * @alias module:OSDN/OSDN\Api/ProjectSCMApi
   * @class
   * @param {module:OSDN/ApiClient} apiClient Optional API client implementation to use,
   * default to {@link module:OSDN/ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the createProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~createProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectBzr} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new bzr repository
     * @param {String} idOrName numeric project id or project name
     * @param {String} name 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~createProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectBzr}
     */
    this.createProjectBzr = function(idOrName, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectBzr";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': opts['description']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectBzr;

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~createProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectGit} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new git repository
     * @param {String} idOrName numeric project id or project name
     * @param {String} name 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {Boolean} opts.mailEnabled 
     * @param {String} opts.mailRecipients 
     * @param {Boolean} opts.allowNonFastForward 
     * @param {String} opts.defaultBranch 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~createProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectGit}
     */
    this.createProjectGit = function(idOrName, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectGit";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': opts['description'],
        'mail_enabled': opts['mailEnabled'],
        'mail_recipients': opts['mailRecipients'],
        'allow_non_fast_forward': opts['allowNonFastForward'],
        'default_branch': opts['defaultBranch']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectGit;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectGitHook operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~createProjectGitHookCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ScmHook} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new hook for project git repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {String} targetUrl 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~createProjectGitHookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ScmHook}
     */
    this.createProjectGitHook = function(idOrName, repoId, targetUrl, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectGitHook";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling createProjectGitHook";
      }

      // verify the required parameter 'targetUrl' is set
      if (targetUrl == undefined || targetUrl == null) {
        throw "Missing the required parameter 'targetUrl' when calling createProjectGitHook";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'target_url': targetUrl
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ScmHook;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}/hooks', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~createProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectHg} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create a new hg repository
     * @param {String} idOrName numeric project id or project name
     * @param {String} name 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {String} opts.mailRecipients 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~createProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectHg}
     */
    this.createProjectHg = function(idOrName, name, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectHg";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': opts['description'],
        'mail_recipients': opts['mailRecipients']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectHg;

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectGitHook operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~deleteProjectGitHookCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete a Git repository hook
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Integer} hookId 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~deleteProjectGitHookCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectGitHook = function(idOrName, repoId, hookId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectGitHook";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling deleteProjectGitHook";
      }

      // verify the required parameter 'hookId' is set
      if (hookId == undefined || hookId == null) {
        throw "Missing the required parameter 'hookId' when calling deleteProjectGitHook";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId,
        'hook_id': hookId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the disableProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~disableProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectBzr} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Disable a bzr repository (not an actual delete, just a shorthand for updating with active&#x3D;false)
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~disableProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectBzr}
     */
    this.disableProjectBzr = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling disableProjectBzr";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling disableProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectBzr;

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr/{repo_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the disableProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~disableProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectGit} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Disable a git repository (not an actual delete, just a shorthand for updating with active&#x3D;false)
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~disableProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectGit}
     */
    this.disableProjectGit = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling disableProjectGit";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling disableProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectGit;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the disableProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~disableProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectHg} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Disable a hg repository (not an actual delete, just a shorthand for updating with active&#x3D;false)
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~disableProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectHg}
     */
    this.disableProjectHg = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling disableProjectHg";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling disableProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectHg;

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg/{repo_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~getProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectBzr} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a bzr repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~getProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectBzr}
     */
    this.getProjectBzr = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectBzr";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling getProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectBzr;

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr/{repo_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~getProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectGit} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a git repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~getProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectGit}
     */
    this.getProjectGit = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectGit";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling getProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectGit;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectGitHook operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~getProjectGitHookCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ScmHook} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a repository hook
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Integer} hookId 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~getProjectGitHookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ScmHook}
     */
    this.getProjectGitHook = function(idOrName, repoId, hookId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectGitHook";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling getProjectGitHook";
      }

      // verify the required parameter 'hookId' is set
      if (hookId == undefined || hookId == null) {
        throw "Missing the required parameter 'hookId' when calling getProjectGitHook";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId,
        'hook_id': hookId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ScmHook;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~getProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectHg} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get a hg repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~getProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectHg}
     */
    this.getProjectHg = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectHg";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling getProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectHg;

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg/{repo_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectSvn operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~getProjectSvnCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectSvn} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Subversion repository of the project
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~getProjectSvnCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectSvn}
     */
    this.getProjectSvn = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectSvn";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectSvn;

      return this.apiClient.callApi(
        '/project/{id_or_name}/svn', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~listProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectBzr>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Bazzar repository list
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~listProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectBzr>}
     */
    this.listProjectBzr = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectBzr];

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~listProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectGit>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get git repository list
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~listProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectGit>}
     */
    this.listProjectGit = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectGit];

      return this.apiClient.callApi(
        '/project/{id_or_name}/git', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectGitHook operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~listProjectGitHookCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ScmHook>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Git repository hook list
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~listProjectGitHookCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ScmHook>}
     */
    this.listProjectGitHook = function(idOrName, repoId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectGitHook";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling listProjectGitHook";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ScmHook];

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}/hooks', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~listProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectHg>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get Mercurial repository list
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~listProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectHg>}
     */
    this.listProjectHg = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectHg];

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectBzr operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~updateProjectBzrCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectBzr} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update a bzr repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {Boolean} opts.active 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~updateProjectBzrCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectBzr}
     */
    this.updateProjectBzr = function(idOrName, repoId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectBzr";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling updateProjectBzr";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'description': opts['description'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectBzr;

      return this.apiClient.callApi(
        '/project/{id_or_name}/bzr/{repo_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectGit operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~updateProjectGitCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectGit} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update a git repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {Boolean} opts.mailEnabled 
     * @param {String} opts.mailRecipients 
     * @param {Boolean} opts.allowNonFastForward 
     * @param {String} opts.defaultBranch 
     * @param {Boolean} opts.active 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~updateProjectGitCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectGit}
     */
    this.updateProjectGit = function(idOrName, repoId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectGit";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling updateProjectGit";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'description': opts['description'],
        'mail_enabled': opts['mailEnabled'],
        'mail_recipients': opts['mailRecipients'],
        'allow_non_fast_forward': opts['allowNonFastForward'],
        'default_branch': opts['defaultBranch'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectGit;

      return this.apiClient.callApi(
        '/project/{id_or_name}/git/{repo_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectHg operation.
     * @callback module:OSDN/OSDN\Api/ProjectSCMApi~updateProjectHgCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectHg} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update a hg repository
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} repoId 
     * @param {Object} opts Optional parameters
     * @param {String} opts.description 
     * @param {String} opts.mailRecipients 
     * @param {Boolean} opts.active 
     * @param {module:OSDN/OSDN\Api/ProjectSCMApi~updateProjectHgCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectHg}
     */
    this.updateProjectHg = function(idOrName, repoId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectHg";
      }

      // verify the required parameter 'repoId' is set
      if (repoId == undefined || repoId == null) {
        throw "Missing the required parameter 'repoId' when calling updateProjectHg";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'repo_id': repoId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'description': opts['description'],
        'mail_recipients': opts['mailRecipients'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectHg;

      return this.apiClient.callApi(
        '/project/{id_or_name}/hg/{repo_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
