/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/ProjectTicketItem', 'OSDN/OSDN\Model/ProjectTicketComment', 'OSDN/OSDN\Model/ProjectTicketComponent', 'OSDN/OSDN\Model/ProjectTicketMilestone', 'OSDN/OSDN\Model/ProjectTicketType', 'OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage', 'OSDN/OSDN\Model/ProjectTicketTypeInstructions', 'OSDN/OSDN\Model/ProjectTicketPrefs'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('../OSDN\Model/ProjectTicketItem'), require('../OSDN\Model/ProjectTicketComment'), require('../OSDN\Model/ProjectTicketComponent'), require('../OSDN\Model/ProjectTicketMilestone'), require('../OSDN\Model/ProjectTicketType'), require('../OSDN\Model/ProjectTicketTypeInstructionPerLanguage'), require('../OSDN\Model/ProjectTicketTypeInstructions'), require('../OSDN\Model/ProjectTicketPrefs'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.ProjectTicketApi = factory(root.OSDNClient.ApiClient, root.OSDNClient.ProjectTicketItem, root.OSDNClient.ProjectTicketComment, root.OSDNClient.ProjectTicketComponent, root.OSDNClient.ProjectTicketMilestone, root.OSDNClient.ProjectTicketType, root.OSDNClient.ProjectTicketTypeInstructionPerLanguage, root.OSDNClient.ProjectTicketTypeInstructions, root.OSDNClient.ProjectTicketPrefs);
  }
}(this, function(ApiClient, ProjectTicketItem, ProjectTicketComment, ProjectTicketComponent, ProjectTicketMilestone, ProjectTicketType, ProjectTicketTypeInstructionPerLanguage, ProjectTicketTypeInstructions, ProjectTicketPrefs) {
  'use strict';

  /**
   * ProjectTicket service.
   * @module OSDN/OSDN\Api/ProjectTicketApi
   * @version 0.0.20171120
   */

  /**
   * Constructs a new ProjectTicketApi. 
   * @alias module:OSDN/OSDN\Api/ProjectTicketApi
   * @class
   * @param {module:OSDN/ApiClient} apiClient Optional API client implementation to use,
   * default to {@link module:OSDN/ApiClient#instance} if unspecified.
   */
  var exports = function(apiClient) {
    this.apiClient = apiClient || ApiClient.instance;


    /**
     * Callback function to receive the result of the createProjectTicket operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketItem} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create project ticket
     * @param {String} idOrName numeric project id or project name
     * @param {String} name Project ticket name (title)
     * @param {String} description Project ticket description details
     * @param {Integer} typeId numeric project ticket type id
     * @param {Object} opts Optional parameters
     * @param {Integer} opts.milestoneId numeric project ticket milestone id
     * @param {Integer} opts.componentId numeric project ticket component id
     * @param {Integer} opts.priority project ticket priority (min &#x3D; 1 and max &#x3D; 9)
     * @param {Integer} opts.severity project ticket severity (min &#x3D; 1 and max &#x3D; 9)
     * @param {Integer} opts.owner numeric project ticket owner user id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketItem}
     */
    this.createProjectTicket = function(idOrName, name, description, typeId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicket";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectTicket";
      }

      // verify the required parameter 'description' is set
      if (description == undefined || description == null) {
        throw "Missing the required parameter 'description' when calling createProjectTicket";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling createProjectTicket";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': description,
        'type_id': typeId,
        'milestone_id': opts['milestoneId'],
        'component_id': opts['componentId'],
        'priority': opts['priority'],
        'severity': opts['severity'],
        'owner': opts['owner']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketItem;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketComment operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketCommentCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComment} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new project ticket comment of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {String} comment Ticket comment text
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketCommentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComment}
     */
    this.createProjectTicketComment = function(idOrName, ticketId, comment, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketComment";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling createProjectTicketComment";
      }

      // verify the required parameter 'comment' is set
      if (comment == undefined || comment == null) {
        throw "Missing the required parameter 'comment' when calling createProjectTicketComment";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'comment': comment
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComment;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}/comment', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketComponent>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new project ticket component of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {String} name Ticket component name
     * @param {String} description Ticket component description
     * @param {Object} opts Optional parameters
     * @param {Integer} opts.owner Ticket componet owner user_id
     * @param {Boolean} opts.active Ticket componet will be shown the component select list when this parameter is true
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketComponent>}
     */
    this.createProjectTicketComponent = function(idOrName, name, description, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketComponent";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectTicketComponent";
      }

      // verify the required parameter 'description' is set
      if (description == undefined || description == null) {
        throw "Missing the required parameter 'description' when calling createProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': description,
        'owner': opts['owner'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketComponent];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketMilestone} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new project ticket milestone of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {String} name Ticket milestone name
     * @param {String} description Ticket milestone description
     * @param {Object} opts Optional parameters
     * @param {Date} opts.start Ticket milestone start date
     * @param {Date} opts.end Ticket milestone due date
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketMilestone}
     */
    this.createProjectTicketMilestone = function(idOrName, name, description, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketMilestone";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectTicketMilestone";
      }

      // verify the required parameter 'description' is set
      if (description == undefined || description == null) {
        throw "Missing the required parameter 'description' when calling createProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': description,
        'start': opts['start'],
        'end': opts['end']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketMilestone;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketType} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create new project ticket type of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {String} name Ticket type name
     * @param {String} description Ticket type description
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.isPublic if set as false, this type will be shown to project members only.
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketType}
     */
    this.createProjectTicketType = function(idOrName, name, description, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketType";
      }

      // verify the required parameter 'name' is set
      if (name == undefined || name == null) {
        throw "Missing the required parameter 'name' when calling createProjectTicketType";
      }

      // verify the required parameter 'description' is set
      if (description == undefined || description == null) {
        throw "Missing the required parameter 'description' when calling createProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': name,
        'description': description,
        'is_public': opts['isPublic']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketType;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the createProjectTicketTypeInstruction operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketTypeInstructionCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Create project ticket type instructions for the language
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {String} instruction Ticket submit instruction for the type
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~createProjectTicketTypeInstructionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage}
     */
    this.createProjectTicketTypeInstruction = function(idOrName, typeId, languageCode, instruction, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling createProjectTicketTypeInstruction";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling createProjectTicketTypeInstruction";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling createProjectTicketTypeInstruction";
      }

      // verify the required parameter 'instruction' is set
      if (instruction == undefined || instruction == null) {
        throw "Missing the required parameter 'instruction' when calling createProjectTicketTypeInstruction";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'language_code': languageCode,
        'instruction': instruction
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketTypeInstructionPerLanguage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~deleteProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project ticket component
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} componentId numeric project ticket component id
     * @param {Integer} migrateTo Tickets that assigned to delete target will be migrate to the ticket component_id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~deleteProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectTicketComponent = function(idOrName, componentId, migrateTo, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectTicketComponent";
      }

      // verify the required parameter 'componentId' is set
      if (componentId == undefined || componentId == null) {
        throw "Missing the required parameter 'componentId' when calling deleteProjectTicketComponent";
      }

      // verify the required parameter 'migrateTo' is set
      if (migrateTo == undefined || migrateTo == null) {
        throw "Missing the required parameter 'migrateTo' when calling deleteProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'component_id': componentId
      };
      var queryParams = {
        'migrate_to': migrateTo
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component/{component_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~deleteProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project ticket milestone
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} milestoneId numeric project ticket milestone id
     * @param {Object} opts Optional parameters
     * @param {Integer} opts.migrateTo Tickets that assigned to delete target will be migrate to the ticket milestone_id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~deleteProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectTicketMilestone = function(idOrName, milestoneId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectTicketMilestone";
      }

      // verify the required parameter 'milestoneId' is set
      if (milestoneId == undefined || milestoneId == null) {
        throw "Missing the required parameter 'milestoneId' when calling deleteProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'milestone_id': milestoneId
      };
      var queryParams = {
        'migrate_to': opts['migrateTo']
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone/{milestone_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~deleteProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project ticket type
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {Integer} migrateTo Tickets that assigned to delete target will be migrate to the ticket type_id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~deleteProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectTicketType = function(idOrName, typeId, migrateTo, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectTicketType";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling deleteProjectTicketType";
      }

      // verify the required parameter 'migrateTo' is set
      if (migrateTo == undefined || migrateTo == null) {
        throw "Missing the required parameter 'migrateTo' when calling deleteProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
        'migrate_to': migrateTo
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the deleteProjectTicketTypeInstruction operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~deleteProjectTicketTypeInstructionCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Delete project ticket type instructions on the language
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~deleteProjectTicketTypeInstructionCallback} callback The callback function, accepting three arguments: error, data, response
     */
    this.deleteProjectTicketTypeInstruction = function(idOrName, typeId, languageCode, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling deleteProjectTicketTypeInstruction";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling deleteProjectTicketTypeInstruction";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling deleteProjectTicketTypeInstruction";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId,
        'language_code': languageCode
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = null;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicket operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketItem} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketItem}
     */
    this.getProjectTicket = function(idOrName, ticketId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicket";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling getProjectTicket";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketItem;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComponent} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket component
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} componentId numeric project ticket component id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComponent}
     */
    this.getProjectTicketComponent = function(idOrName, componentId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketComponent";
      }

      // verify the required parameter 'componentId' is set
      if (componentId == undefined || componentId == null) {
        throw "Missing the required parameter 'componentId' when calling getProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'component_id': componentId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComponent;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component/{component_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketMilestone} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket milestone of spscified milestone_id.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} milestoneId numeric project ticket milestone id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketMilestone}
     */
    this.getProjectTicketMilestone = function(idOrName, milestoneId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketMilestone";
      }

      // verify the required parameter 'milestoneId' is set
      if (milestoneId == undefined || milestoneId == null) {
        throw "Missing the required parameter 'milestoneId' when calling getProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'milestone_id': milestoneId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketMilestone;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone/{milestone_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketType} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket type
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketType}
     */
    this.getProjectTicketType = function(idOrName, typeId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketType";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling getProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketType;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketTypeInstruction operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketTypeInstructionCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket type instructions on the language
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketTypeInstructionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage}
     */
    this.getProjectTicketTypeInstruction = function(idOrName, typeId, languageCode, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketTypeInstruction";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling getProjectTicketTypeInstruction";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling getProjectTicketTypeInstruction";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId,
        'language_code': languageCode
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketTypeInstructionPerLanguage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the getProjectTicketTypeInstruction_0 operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketTypeInstruction_0Callback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket type instructions on the language
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {String} languageCode Language code for display name and description (example en, ja, zh-TW)
     * @param {String} instruction Ticket submit instruction for the type
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~getProjectTicketTypeInstruction_0Callback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketTypeInstructionPerLanguage}
     */
    this.getProjectTicketTypeInstruction_0 = function(idOrName, typeId, languageCode, instruction, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling getProjectTicketTypeInstruction_0";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling getProjectTicketTypeInstruction_0";
      }

      // verify the required parameter 'languageCode' is set
      if (languageCode == undefined || languageCode == null) {
        throw "Missing the required parameter 'languageCode' when calling getProjectTicketTypeInstruction_0";
      }

      // verify the required parameter 'instruction' is set
      if (instruction == undefined || instruction == null) {
        throw "Missing the required parameter 'instruction' when calling getProjectTicketTypeInstruction_0";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId,
        'language_code': languageCode
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'instruction': instruction
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketTypeInstructionPerLanguage;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicket operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketItem>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * List project ticket order by submit date descending
     * @param {String} idOrName numeric project id or project name
     * @param {Object} opts Optional parameters
     * @param {Array.<module:OSDN/OSDN\Model/String>} opts.status Tickets are assigned to these type_ids
     * @param {Array.<Integer>} opts.typeId Listing tickets are assigned to these type_ids
     * @param {Array.<Integer>} opts.notTypeId Listing tickets are NOT assigned to these type_ids
     * @param {Array.<Integer>} opts.componentId Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0)
     * @param {Array.<Integer>} opts.notComponentId Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id &#x3D; 0)
     * @param {Array.<Integer>} opts.milestoneId Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id &#x3D; 0)
     * @param {Array.<Integer>} opts.notMilestoneId Listing tickets are NOT assigned to these milestone_ids (milestone_id &#x3D; 0 means milestone not assigned)
     * @param {Integer} opts.maxPriority Listing equal or lower priority tickets
     * @param {Integer} opts.minPriority Listing equal or higher priority tickets
     * @param {Integer} opts.priority Listing tickets have this priority
     * @param {Integer} opts.maxSeverity Listing equal or lower severity tickets
     * @param {Integer} opts.minSeverity Listing equal or higher severity tickets
     * @param {Integer} opts.severity Listing tickets have this severity
     * @param {Array.<Integer>} opts.owner Listing tickets assigned to these owners (owner &#x3D; 100 means owner is not assigned)
     * @param {Array.<Integer>} opts.notOwner Listing tickets NOT assigned to these owners (owner &#x3D; 100 means owner is not assigned)
     * @param {Array.<Integer>} opts.reporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user)
     * @param {Array.<Integer>} opts.notReporter Listing tickets reported by these users (report &#x3D; 100 means reported by non login user)
     * @param {String} opts.text Listing tickets title or description or comment include the text
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketItem>}
     */
    this.listProjectTicket = function(idOrName, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicket";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
        'status': this.apiClient.buildCollectionParam(opts['status'], 'csv'),
        'type_id': this.apiClient.buildCollectionParam(opts['typeId'], 'csv'),
        'not_type_id': this.apiClient.buildCollectionParam(opts['notTypeId'], 'csv'),
        'component_id': this.apiClient.buildCollectionParam(opts['componentId'], 'csv'),
        'not_component_id': this.apiClient.buildCollectionParam(opts['notComponentId'], 'csv'),
        'milestone_id': this.apiClient.buildCollectionParam(opts['milestoneId'], 'csv'),
        'not_milestone_id': this.apiClient.buildCollectionParam(opts['notMilestoneId'], 'csv'),
        'max_priority': opts['maxPriority'],
        'min_priority': opts['minPriority'],
        'priority': opts['priority'],
        'max_severity': opts['maxSeverity'],
        'min_severity': opts['minSeverity'],
        'severity': opts['severity'],
        'owner': this.apiClient.buildCollectionParam(opts['owner'], 'csv'),
        'not_owner': this.apiClient.buildCollectionParam(opts['notOwner'], 'csv'),
        'reporter': this.apiClient.buildCollectionParam(opts['reporter'], 'csv'),
        'not_reporter': this.apiClient.buildCollectionParam(opts['notReporter'], 'csv'),
        'text': opts['text']
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketItem];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketComment operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketCommentCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketComment>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket comment list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketCommentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketComment>}
     */
    this.listProjectTicketComment = function(idOrName, ticketId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketComment";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling listProjectTicketComment";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketComment];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}/comment', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketComponent>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket component list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketComponent>}
     */
    this.listProjectTicketComponent = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketComponent];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketMilestone>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket milestone list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketMilestone>}
     */
    this.listProjectTicketMilestone = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketMilestone];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:OSDN/OSDN\Model/ProjectTicketType>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket type list of spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {Array.<module:OSDN/OSDN\Model/ProjectTicketType>}
     */
    this.listProjectTicketType = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = [ProjectTicketType];

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the listProjectTicketTypeInstruction operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketTypeInstructionCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketTypeInstructions} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket type instructions
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~listProjectTicketTypeInstructionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketTypeInstructions}
     */
    this.listProjectTicketTypeInstruction = function(idOrName, typeId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling listProjectTicketTypeInstruction";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling listProjectTicketTypeInstruction";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketTypeInstructions;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}/instruction', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the showProjectTicketAdminprefs operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~showProjectTicketAdminprefsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketPrefs} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket admin preferences.
     * @param {String} idOrName numeric project id or project name
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~showProjectTicketAdminprefsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketPrefs}
     */
    this.showProjectTicketAdminprefs = function(idOrName, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling showProjectTicketAdminprefs";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketPrefs;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/admin', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the showProjectTicketComment operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~showProjectTicketCommentCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComment} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get project ticket comment spscified project.
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {Integer} commentId numeric project ticket comment id
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~showProjectTicketCommentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComment}
     */
    this.showProjectTicketComment = function(idOrName, ticketId, commentId, callback) {
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling showProjectTicketComment";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling showProjectTicketComment";
      }

      // verify the required parameter 'commentId' is set
      if (commentId == undefined || commentId == null) {
        throw "Missing the required parameter 'commentId' when calling showProjectTicketComment";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId,
        'comment_id': commentId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComment;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicket operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketItem} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} ticketId numeric project ticket id
     * @param {Object} opts Optional parameters
     * @param {String} opts.name Project ticket name (title)
     * @param {String} opts.description Project ticket description details
     * @param {Integer} opts.typeId numeric project ticket type id
     * @param {Integer} opts.milestoneId numeric project ticket milestone id
     * @param {Integer} opts.componentId numeric project ticket component id
     * @param {Integer} opts.priority project ticket priority (min &#x3D; 1 and max &#x3D; 9)
     * @param {Integer} opts.severity project ticket severity (min &#x3D; 1 and max &#x3D; 9)
     * @param {Integer} opts.owner numeric project ticket owner user id
     * @param {module:OSDN/OSDN\Model/String} opts.resolution project ticket resolution text
     * @param {module:OSDN/OSDN\Model/String} opts.status project ticket status (open or close)
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketItem}
     */
    this.updateProjectTicket = function(idOrName, ticketId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicket";
      }

      // verify the required parameter 'ticketId' is set
      if (ticketId == undefined || ticketId == null) {
        throw "Missing the required parameter 'ticketId' when calling updateProjectTicket";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'ticket_id': ticketId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'description': opts['description'],
        'type_id': opts['typeId'],
        'milestone_id': opts['milestoneId'],
        'component_id': opts['componentId'],
        'priority': opts['priority'],
        'severity': opts['severity'],
        'owner': opts['owner'],
        'resolution': opts['resolution'],
        'status': opts['status']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketItem;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/{ticket_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicketAdminprefs operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketAdminprefsCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketPrefs} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket admin preferences.
     * @param {String} idOrName numeric project id or project name
     * @param {Object} opts Optional parameters
     * @param {Boolean} opts.allowAnonymouse Non login user allows to post new ticket/comment
     * @param {module:OSDN/OSDN\Model/String} opts.frsAutosync Componet File release autosync type &#39;Disabled&#39;, &#39;Package&#39;, &#39;Release&#39;, &#39;Package and Release&#39;
     * @param {module:OSDN/OSDN\Model/String} opts.mailsendType Ticket update mail destination type &#39;None&#39;, &#39;Ticket Technician&#39;, &#39;Ticket Administrator&#39;, &#39;Ticket Administrator and Technician&#39;, &#39;All project members&#39;, &#39;Mailing List&#39;
     * @param {Integer} opts.mailingListId Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list)
     * @param {module:OSDN/OSDN\Model/String} opts.mailLang Ticket update mail language
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketAdminprefsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketPrefs}
     */
    this.updateProjectTicketAdminprefs = function(idOrName, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicketAdminprefs";
      }


      var pathParams = {
        'id_or_name': idOrName
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'allow_anonymouse': opts['allowAnonymouse'],
        'frs_autosync': opts['frsAutosync'],
        'mailsend_type': opts['mailsendType'],
        'mailing_list_id': opts['mailingListId'],
        'mail_lang': opts['mailLang']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketPrefs;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/admin', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicketComponent operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketComponentCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComponent} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket component
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} componentId numeric project ticket component id
     * @param {Object} opts Optional parameters
     * @param {String} opts.name Ticket component name
     * @param {String} opts.description Ticket component description
     * @param {Integer} opts.owner Ticket componet owner user_id
     * @param {Boolean} opts.active Ticket componet will be shown the component select list when this parameter is true
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketComponentCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComponent}
     */
    this.updateProjectTicketComponent = function(idOrName, componentId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicketComponent";
      }

      // verify the required parameter 'componentId' is set
      if (componentId == undefined || componentId == null) {
        throw "Missing the required parameter 'componentId' when calling updateProjectTicketComponent";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'component_id': componentId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'description': opts['description'],
        'owner': opts['owner'],
        'active': opts['active']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComponent;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/component/{component_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicketMilestone operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketMilestoneCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketComponent} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket milestone
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} milestoneId numeric project ticket milestone id
     * @param {Object} opts Optional parameters
     * @param {String} opts.name Ticket milestone name
     * @param {String} opts.description Ticket milestone description
     * @param {Date} opts.start Ticket milestone start date
     * @param {Date} opts.end Ticket milestone due date
     * @param {String} opts.forceStatus If you want to force close the milestone set to &#39;close&#39; or reopen it set to &#39;reopen&#39;
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketMilestoneCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketComponent}
     */
    this.updateProjectTicketMilestone = function(idOrName, milestoneId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicketMilestone";
      }

      // verify the required parameter 'milestoneId' is set
      if (milestoneId == undefined || milestoneId == null) {
        throw "Missing the required parameter 'milestoneId' when calling updateProjectTicketMilestone";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'milestone_id': milestoneId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'description': opts['description'],
        'start': opts['start'],
        'end': opts['end'],
        'force_status': opts['forceStatus']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketComponent;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/milestone/{milestone_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }

    /**
     * Callback function to receive the result of the updateProjectTicketType operation.
     * @callback module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketTypeCallback
     * @param {String} error Error message, if any.
     * @param {module:OSDN/OSDN\Model/ProjectTicketType} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update project ticket type
     * @param {String} idOrName numeric project id or project name
     * @param {Integer} typeId numeric project ticket type id
     * @param {Object} opts Optional parameters
     * @param {String} opts.name Ticket type name
     * @param {String} opts.description Ticket type description
     * @param {Boolean} opts.isPublic if set as false, this type will be shown to project members only.
     * @param {module:OSDN/OSDN\Api/ProjectTicketApi~updateProjectTicketTypeCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {module:OSDN/OSDN\Model/ProjectTicketType}
     */
    this.updateProjectTicketType = function(idOrName, typeId, opts, callback) {
      opts = opts || {};
      var postBody = null;

      // verify the required parameter 'idOrName' is set
      if (idOrName == undefined || idOrName == null) {
        throw "Missing the required parameter 'idOrName' when calling updateProjectTicketType";
      }

      // verify the required parameter 'typeId' is set
      if (typeId == undefined || typeId == null) {
        throw "Missing the required parameter 'typeId' when calling updateProjectTicketType";
      }


      var pathParams = {
        'id_or_name': idOrName,
        'type_id': typeId
      };
      var queryParams = {
      };
      var headerParams = {
      };
      var formParams = {
        'name': opts['name'],
        'description': opts['description'],
        'is_public': opts['isPublic']
      };

      var authNames = ['oauth2-code', 'oauth2-implicit'];
      var contentTypes = ['application/x-www-form-urlencoded'];
      var accepts = [];
      var returnType = ProjectTicketType;

      return this.apiClient.callApi(
        '/project/{id_or_name}/ticket/type/{type_id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, callback
      );
    }
  };

  return exports;
}));
