/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/ProjectTicketComment', 'OSDN/OSDN\Model/ProjectTicketHistory'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./ProjectTicketComment'), require('./ProjectTicketHistory'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.ProjectTicketItem = factory(root.OSDNClient.ApiClient, root.OSDNClient.ProjectTicketComment, root.OSDNClient.ProjectTicketHistory);
  }
}(this, function(ApiClient, ProjectTicketComment, ProjectTicketHistory) {
  'use strict';




  /**
   * The ProjectTicketItem model module.
   * @module OSDN/OSDN\Model/ProjectTicketItem
   * @version 0.0.20171120
   */

  /**
   * Constructs a new <code>ProjectTicketItem</code>.
   * @alias module:OSDN/OSDN\Model/ProjectTicketItem
   * @class
   */
  var exports = function() {
    var _this = this;



















  };

  /**
   * Constructs a <code>ProjectTicketItem</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:OSDN/OSDN\Model/ProjectTicketItem} obj Optional instance to populate.
   * @return {module:OSDN/OSDN\Model/ProjectTicketItem} The populated <code>ProjectTicketItem</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('id')) {
        obj['id'] = ApiClient.convertToType(data['id'], 'Integer');
      }
      if (data.hasOwnProperty('name')) {
        obj['name'] = ApiClient.convertToType(data['name'], 'String');
      }
      if (data.hasOwnProperty('description')) {
        obj['description'] = ApiClient.convertToType(data['description'], 'String');
      }
      if (data.hasOwnProperty('description_html')) {
        obj['description_html'] = ApiClient.convertToType(data['description_html'], 'String');
      }
      if (data.hasOwnProperty('opned_at')) {
        obj['opned_at'] = ApiClient.convertToType(data['opned_at'], 'Date');
      }
      if (data.hasOwnProperty('closed_at')) {
        obj['closed_at'] = ApiClient.convertToType(data['closed_at'], 'Date');
      }
      if (data.hasOwnProperty('status')) {
        obj['status'] = ApiClient.convertToType(data['status'], 'String');
      }
      if (data.hasOwnProperty('type_id')) {
        obj['type_id'] = ApiClient.convertToType(data['type_id'], 'Integer');
      }
      if (data.hasOwnProperty('component_id')) {
        obj['component_id'] = ApiClient.convertToType(data['component_id'], 'Integer');
      }
      if (data.hasOwnProperty('milestone_id')) {
        obj['milestone_id'] = ApiClient.convertToType(data['milestone_id'], 'Integer');
      }
      if (data.hasOwnProperty('priority')) {
        obj['priority'] = ApiClient.convertToType(data['priority'], 'Integer');
      }
      if (data.hasOwnProperty('severity')) {
        obj['severity'] = ApiClient.convertToType(data['severity'], 'Integer');
      }
      if (data.hasOwnProperty('resolution')) {
        obj['resolution'] = ApiClient.convertToType(data['resolution'], 'String');
      }
      if (data.hasOwnProperty('reporter')) {
        obj['reporter'] = ApiClient.convertToType(data['reporter'], 'Integer');
      }
      if (data.hasOwnProperty('owner')) {
        obj['owner'] = ApiClient.convertToType(data['owner'], 'Integer');
      }
      if (data.hasOwnProperty('last_update')) {
        obj['last_update'] = ApiClient.convertToType(data['last_update'], 'Date');
      }
      if (data.hasOwnProperty('comment')) {
        obj['comment'] = ApiClient.convertToType(data['comment'], [ProjectTicketComment]);
      }
      if (data.hasOwnProperty('history')) {
        obj['history'] = ApiClient.convertToType(data['history'], [ProjectTicketHistory]);
      }
    }
    return obj;
  }

  /**
   * @member {Integer} id
   */
  exports.prototype['id'] = undefined;
  /**
   * @member {String} name
   */
  exports.prototype['name'] = undefined;
  /**
   * @member {String} description
   */
  exports.prototype['description'] = undefined;
  /**
   * @member {String} description_html
   */
  exports.prototype['description_html'] = undefined;
  /**
   * @member {Date} opned_at
   */
  exports.prototype['opned_at'] = undefined;
  /**
   * @member {Date} closed_at
   */
  exports.prototype['closed_at'] = undefined;
  /**
   * @member {String} status
   */
  exports.prototype['status'] = undefined;
  /**
   * @member {Integer} type_id
   */
  exports.prototype['type_id'] = undefined;
  /**
   * @member {Integer} component_id
   */
  exports.prototype['component_id'] = undefined;
  /**
   * @member {Integer} milestone_id
   */
  exports.prototype['milestone_id'] = undefined;
  /**
   * @member {Integer} priority
   */
  exports.prototype['priority'] = undefined;
  /**
   * @member {Integer} severity
   */
  exports.prototype['severity'] = undefined;
  /**
   * @member {String} resolution
   */
  exports.prototype['resolution'] = undefined;
  /**
   * @member {Integer} reporter
   */
  exports.prototype['reporter'] = undefined;
  /**
   * @member {Integer} owner
   */
  exports.prototype['owner'] = undefined;
  /**
   * @member {Date} last_update
   */
  exports.prototype['last_update'] = undefined;
  /**
   * @member {Array.<module:OSDN/OSDN\Model/ProjectTicketComment>} comment
   */
  exports.prototype['comment'] = undefined;
  /**
   * @member {Array.<module:OSDN/OSDN\Model/ProjectTicketHistory>} history
   */
  exports.prototype['history'] = undefined;



  return exports;
}));


