/**
 * OSDN REST API v0 beta
 * OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 
 *
 * OpenAPI spec version: 0.0.20171120
 * Contact: admin@osdn.net
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['OSDN/ApiClient', 'OSDN/OSDN\Model/SimpleChamber', 'OSDN/OSDN\Model/SimpleGroup', 'OSDN/OSDN\Model/Skill', 'OSDN/OSDN\Model/UserImages'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // CommonJS-like environments that support module.exports, like Node.
    module.exports = factory(require('../ApiClient'), require('./SimpleChamber'), require('./SimpleGroup'), require('./Skill'), require('./UserImages'));
  } else {
    // Browser globals (root is window)
    if (!root.OSDNClient) {
      root.OSDNClient = {};
    }
    root.OSDNClient.User = factory(root.OSDNClient.ApiClient, root.OSDNClient.SimpleChamber, root.OSDNClient.SimpleGroup, root.OSDNClient.Skill, root.OSDNClient.UserImages);
  }
}(this, function(ApiClient, SimpleChamber, SimpleGroup, Skill, UserImages) {
  'use strict';




  /**
   * The User model module.
   * @module OSDN/OSDN\Model/User
   * @version 0.0.20171120
   */

  /**
   * Constructs a new <code>User</code>.
   * @alias module:OSDN/OSDN\Model/User
   * @class
   */
  var exports = function() {
    var _this = this;
















  };

  /**
   * Constructs a <code>User</code> from a plain JavaScript object, optionally creating a new instance.
   * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
   * @param {Object} data The plain JavaScript object bearing properties of interest.
   * @param {module:OSDN/OSDN\Model/User} obj Optional instance to populate.
   * @return {module:OSDN/OSDN\Model/User} The populated <code>User</code> instance.
   */
  exports.constructFromObject = function(data, obj) {
    if (data) {
      obj = obj || new exports();

      if (data.hasOwnProperty('id')) {
        obj['id'] = ApiClient.convertToType(data['id'], 'Integer');
      }
      if (data.hasOwnProperty('name')) {
        obj['name'] = ApiClient.convertToType(data['name'], 'String');
      }
      if (data.hasOwnProperty('display_name')) {
        obj['display_name'] = ApiClient.convertToType(data['display_name'], 'String');
      }
      if (data.hasOwnProperty('authorized_keys')) {
        obj['authorized_keys'] = ApiClient.convertToType(data['authorized_keys'], ['String']);
      }
      if (data.hasOwnProperty('email')) {
        obj['email'] = ApiClient.convertToType(data['email'], 'String');
      }
      if (data.hasOwnProperty('ranking')) {
        obj['ranking'] = ApiClient.convertToType(data['ranking'], 'Integer');
      }
      if (data.hasOwnProperty('blog')) {
        obj['blog'] = ApiClient.convertToType(data['blog'], 'String');
      }
      if (data.hasOwnProperty('timezone')) {
        obj['timezone'] = ApiClient.convertToType(data['timezone'], 'String');
      }
      if (data.hasOwnProperty('last_update')) {
        obj['last_update'] = ApiClient.convertToType(data['last_update'], 'Date');
      }
      if (data.hasOwnProperty('add_date')) {
        obj['add_date'] = ApiClient.convertToType(data['add_date'], 'Date');
      }
      if (data.hasOwnProperty('language')) {
        obj['language'] = ApiClient.convertToType(data['language'], 'String');
      }
      if (data.hasOwnProperty('images')) {
        obj['images'] = UserImages.constructFromObject(data['images']);
      }
      if (data.hasOwnProperty('groups')) {
        obj['groups'] = ApiClient.convertToType(data['groups'], [SimpleGroup]);
      }
      if (data.hasOwnProperty('chambers')) {
        obj['chambers'] = ApiClient.convertToType(data['chambers'], [SimpleChamber]);
      }
      if (data.hasOwnProperty('skills')) {
        obj['skills'] = ApiClient.convertToType(data['skills'], [Skill]);
      }
    }
    return obj;
  }

  /**
   * @member {Integer} id
   */
  exports.prototype['id'] = undefined;
  /**
   * @member {String} name
   */
  exports.prototype['name'] = undefined;
  /**
   * @member {String} display_name
   */
  exports.prototype['display_name'] = undefined;
  /**
   * @member {Array.<String>} authorized_keys
   */
  exports.prototype['authorized_keys'] = undefined;
  /**
   * @member {String} email
   */
  exports.prototype['email'] = undefined;
  /**
   * @member {Integer} ranking
   */
  exports.prototype['ranking'] = undefined;
  /**
   * @member {String} blog
   */
  exports.prototype['blog'] = undefined;
  /**
   * @member {String} timezone
   */
  exports.prototype['timezone'] = undefined;
  /**
   * @member {Date} last_update
   */
  exports.prototype['last_update'] = undefined;
  /**
   * @member {Date} add_date
   */
  exports.prototype['add_date'] = undefined;
  /**
   * @member {String} language
   */
  exports.prototype['language'] = undefined;
  /**
   * @member {module:OSDN/OSDN\Model/UserImages} images
   */
  exports.prototype['images'] = undefined;
  /**
   * @member {Array.<module:OSDN/OSDN\Model/SimpleGroup>} groups
   */
  exports.prototype['groups'] = undefined;
  /**
   * @member {Array.<module:OSDN/OSDN\Model/SimpleChamber>} chambers
   */
  exports.prototype['chambers'] = undefined;
  /**
   * @member {Array.<module:OSDN/OSDN\Model/Skill>} skills
   */
  exports.prototype['skills'] = undefined;



  return exports;
}));


