# OSDNClient
OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 .

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.0.20171120
- Package version: 0.0.20171120
- Build date: 2019-12-23T17:21:51.525+09:00
- Build package: class io.swagger.codegen.languages.PhpClientCodegen
For more information, please visit [https://osdn.net/projects/osdn-codes/wiki/APIGuide](https://osdn.net/projects/osdn-codes/wiki/APIGuide)

## Requirements

PHP 5.4.0 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/OSDN/Client.git"
    }
  ],
  "require": {
    "OSDN/Client": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/OSDNClient/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit lib/Tests
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\DefaultApi();

try {
    $result = $api_instance->ping();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->ping: ', $e->getMessage(), PHP_EOL;
}

?>
```

## Documentation for API Endpoints

All URIs are relative to *https://osdn.net/api/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**ping**](docs/Api/DefaultApi.md#ping) | **GET** /ping | 
*DefaultApi* | [**token**](docs/Api/DefaultApi.md#token) | **POST** /token | 
*ProjectApi* | [**createNews**](docs/Api/ProjectApi.md#createnews) | **POST** /news | 
*ProjectApi* | [**createNews_0**](docs/Api/ProjectApi.md#createnews_0) | **POST** /project/{id_or_name}/news | 
*ProjectApi* | [**createPackage**](docs/Api/ProjectApi.md#createpackage) | **POST** /project/{id_or_name}/frs | 
*ProjectApi* | [**createProjectBzr**](docs/Api/ProjectApi.md#createprojectbzr) | **POST** /project/{id_or_name}/bzr | 
*ProjectApi* | [**createProjectGit**](docs/Api/ProjectApi.md#createprojectgit) | **POST** /project/{id_or_name}/git | 
*ProjectApi* | [**createProjectGitHook**](docs/Api/ProjectApi.md#createprojectgithook) | **POST** /project/{id_or_name}/git/{repo_id}/hooks | 
*ProjectApi* | [**createProjectHg**](docs/Api/ProjectApi.md#createprojecthg) | **POST** /project/{id_or_name}/hg | 
*ProjectApi* | [**createProjectProfile**](docs/Api/ProjectApi.md#createprojectprofile) | **POST** /project/{id_or_name}/admin/profile | 
*ProjectApi* | [**createProjectTicket**](docs/Api/ProjectApi.md#createprojectticket) | **POST** /project/{id_or_name}/ticket | 
*ProjectApi* | [**createProjectTicketComment**](docs/Api/ProjectApi.md#createprojectticketcomment) | **POST** /project/{id_or_name}/ticket/{ticket_id}/comment | 
*ProjectApi* | [**createProjectTicketComponent**](docs/Api/ProjectApi.md#createprojectticketcomponent) | **POST** /project/{id_or_name}/ticket/component | 
*ProjectApi* | [**createProjectTicketMilestone**](docs/Api/ProjectApi.md#createprojectticketmilestone) | **POST** /project/{id_or_name}/ticket/milestone | 
*ProjectApi* | [**createProjectTicketType**](docs/Api/ProjectApi.md#createprojecttickettype) | **POST** /project/{id_or_name}/ticket/type | 
*ProjectApi* | [**createProjectTicketTypeInstruction**](docs/Api/ProjectApi.md#createprojecttickettypeinstruction) | **POST** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
*ProjectApi* | [**createRelease**](docs/Api/ProjectApi.md#createrelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
*ProjectApi* | [**createReleaseFile**](docs/Api/ProjectApi.md#createreleasefile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectApi* | [**deleteNews**](docs/Api/ProjectApi.md#deletenews) | **DELETE** /news/{news_id} | 
*ProjectApi* | [**deleteNews_0**](docs/Api/ProjectApi.md#deletenews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
*ProjectApi* | [**deletePackage**](docs/Api/ProjectApi.md#deletepackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
*ProjectApi* | [**deleteProjectAdminProjectweb**](docs/Api/ProjectApi.md#deleteprojectadminprojectweb) | **DELETE** /project/{id_or_name}/admin/project_web | 
*ProjectApi* | [**deleteProjectGitHook**](docs/Api/ProjectApi.md#deleteprojectgithook) | **DELETE** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
*ProjectApi* | [**deleteProjectProfile**](docs/Api/ProjectApi.md#deleteprojectprofile) | **DELETE** /project/{id_or_name}/admin/profile/{language_code} | 
*ProjectApi* | [**deleteProjectTicketComponent**](docs/Api/ProjectApi.md#deleteprojectticketcomponent) | **DELETE** /project/{id_or_name}/ticket/component/{component_id} | 
*ProjectApi* | [**deleteProjectTicketMilestone**](docs/Api/ProjectApi.md#deleteprojectticketmilestone) | **DELETE** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*ProjectApi* | [**deleteProjectTicketType**](docs/Api/ProjectApi.md#deleteprojecttickettype) | **DELETE** /project/{id_or_name}/ticket/type/{type_id} | 
*ProjectApi* | [**deleteProjectTicketTypeInstruction**](docs/Api/ProjectApi.md#deleteprojecttickettypeinstruction) | **DELETE** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*ProjectApi* | [**deleteRelease**](docs/Api/ProjectApi.md#deleterelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectApi* | [**deleteReleaseFile**](docs/Api/ProjectApi.md#deletereleasefile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectApi* | [**disableProjectBzr**](docs/Api/ProjectApi.md#disableprojectbzr) | **DELETE** /project/{id_or_name}/bzr/{repo_id} | 
*ProjectApi* | [**disableProjectGit**](docs/Api/ProjectApi.md#disableprojectgit) | **DELETE** /project/{id_or_name}/git/{repo_id} | 
*ProjectApi* | [**disableProjectHg**](docs/Api/ProjectApi.md#disableprojecthg) | **DELETE** /project/{id_or_name}/hg/{repo_id} | 
*ProjectApi* | [**draftRelease**](docs/Api/ProjectApi.md#draftrelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
*ProjectApi* | [**getFrsAdminprefs**](docs/Api/ProjectApi.md#getfrsadminprefs) | **GET** /project/{id_or_name}/frs/admin | 
*ProjectApi* | [**getNews**](docs/Api/ProjectApi.md#getnews) | **GET** /news/{news_id} | 
*ProjectApi* | [**getNews_0**](docs/Api/ProjectApi.md#getnews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
*ProjectApi* | [**getPackage**](docs/Api/ProjectApi.md#getpackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
*ProjectApi* | [**getProject**](docs/Api/ProjectApi.md#getproject) | **GET** /project/{id_or_name} | 
*ProjectApi* | [**getProjectAdminProjectweb**](docs/Api/ProjectApi.md#getprojectadminprojectweb) | **GET** /project/{id_or_name}/admin/project_web | 
*ProjectApi* | [**getProjectBzr**](docs/Api/ProjectApi.md#getprojectbzr) | **GET** /project/{id_or_name}/bzr/{repo_id} | 
*ProjectApi* | [**getProjectGit**](docs/Api/ProjectApi.md#getprojectgit) | **GET** /project/{id_or_name}/git/{repo_id} | 
*ProjectApi* | [**getProjectGitHook**](docs/Api/ProjectApi.md#getprojectgithook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
*ProjectApi* | [**getProjectHg**](docs/Api/ProjectApi.md#getprojecthg) | **GET** /project/{id_or_name}/hg/{repo_id} | 
*ProjectApi* | [**getProjectHistories**](docs/Api/ProjectApi.md#getprojecthistories) | **GET** /project/{id_or_name}/history | 
*ProjectApi* | [**getProjectProfile**](docs/Api/ProjectApi.md#getprojectprofile) | **GET** /project/{id_or_name}/admin/profile/{language_code} | 
*ProjectApi* | [**getProjectProfileList**](docs/Api/ProjectApi.md#getprojectprofilelist) | **GET** /project/{id_or_name}/admin/profile | 
*ProjectApi* | [**getProjectSvn**](docs/Api/ProjectApi.md#getprojectsvn) | **GET** /project/{id_or_name}/svn | 
*ProjectApi* | [**getProjectTicket**](docs/Api/ProjectApi.md#getprojectticket) | **GET** /project/{id_or_name}/ticket/{ticket_id} | 
*ProjectApi* | [**getProjectTicketComponent**](docs/Api/ProjectApi.md#getprojectticketcomponent) | **GET** /project/{id_or_name}/ticket/component/{component_id} | 
*ProjectApi* | [**getProjectTicketMilestone**](docs/Api/ProjectApi.md#getprojectticketmilestone) | **GET** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*ProjectApi* | [**getProjectTicketType**](docs/Api/ProjectApi.md#getprojecttickettype) | **GET** /project/{id_or_name}/ticket/type/{type_id} | 
*ProjectApi* | [**getProjectTicketTypeInstruction**](docs/Api/ProjectApi.md#getprojecttickettypeinstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*ProjectApi* | [**getProjectTicketTypeInstruction_0**](docs/Api/ProjectApi.md#getprojecttickettypeinstruction_0) | **PATCH** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*ProjectApi* | [**getProjectTools**](docs/Api/ProjectApi.md#getprojecttools) | **GET** /project/{id_or_name}/admin/tools | 
*ProjectApi* | [**getRelease**](docs/Api/ProjectApi.md#getrelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectApi* | [**getReleaseFile**](docs/Api/ProjectApi.md#getreleasefile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectApi* | [**listNews**](docs/Api/ProjectApi.md#listnews) | **GET** /news | 
*ProjectApi* | [**listNews_0**](docs/Api/ProjectApi.md#listnews_0) | **GET** /project/{id_or_name}/news | 
*ProjectApi* | [**listPackages**](docs/Api/ProjectApi.md#listpackages) | **GET** /project/{id_or_name}/frs | 
*ProjectApi* | [**listProjectBzr**](docs/Api/ProjectApi.md#listprojectbzr) | **GET** /project/{id_or_name}/bzr | 
*ProjectApi* | [**listProjectGit**](docs/Api/ProjectApi.md#listprojectgit) | **GET** /project/{id_or_name}/git | 
*ProjectApi* | [**listProjectGitHook**](docs/Api/ProjectApi.md#listprojectgithook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks | 
*ProjectApi* | [**listProjectHg**](docs/Api/ProjectApi.md#listprojecthg) | **GET** /project/{id_or_name}/hg | 
*ProjectApi* | [**listProjectTicket**](docs/Api/ProjectApi.md#listprojectticket) | **GET** /project/{id_or_name}/ticket | 
*ProjectApi* | [**listProjectTicketComment**](docs/Api/ProjectApi.md#listprojectticketcomment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment | 
*ProjectApi* | [**listProjectTicketComponent**](docs/Api/ProjectApi.md#listprojectticketcomponent) | **GET** /project/{id_or_name}/ticket/component | 
*ProjectApi* | [**listProjectTicketMilestone**](docs/Api/ProjectApi.md#listprojectticketmilestone) | **GET** /project/{id_or_name}/ticket/milestone | 
*ProjectApi* | [**listProjectTicketType**](docs/Api/ProjectApi.md#listprojecttickettype) | **GET** /project/{id_or_name}/ticket/type | 
*ProjectApi* | [**listProjectTicketTypeInstruction**](docs/Api/ProjectApi.md#listprojecttickettypeinstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
*ProjectApi* | [**showProjectTicketAdminprefs**](docs/Api/ProjectApi.md#showprojectticketadminprefs) | **GET** /project/{id_or_name}/ticket/admin | 
*ProjectApi* | [**showProjectTicketComment**](docs/Api/ProjectApi.md#showprojectticketcomment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id} | 
*ProjectApi* | [**updateFrsAdminprefs**](docs/Api/ProjectApi.md#updatefrsadminprefs) | **PATCH** /project/{id_or_name}/frs/admin | 
*ProjectApi* | [**updateNews**](docs/Api/ProjectApi.md#updatenews) | **PATCH** /news/{news_id} | 
*ProjectApi* | [**updateNews_0**](docs/Api/ProjectApi.md#updatenews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
*ProjectApi* | [**updatePackage**](docs/Api/ProjectApi.md#updatepackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
*ProjectApi* | [**updateProjectAdminProjectweb**](docs/Api/ProjectApi.md#updateprojectadminprojectweb) | **PATCH** /project/{id_or_name}/admin/project_web | 
*ProjectApi* | [**updateProjectBzr**](docs/Api/ProjectApi.md#updateprojectbzr) | **PATCH** /project/{id_or_name}/bzr/{repo_id} | 
*ProjectApi* | [**updateProjectGit**](docs/Api/ProjectApi.md#updateprojectgit) | **PATCH** /project/{id_or_name}/git/{repo_id} | 
*ProjectApi* | [**updateProjectHg**](docs/Api/ProjectApi.md#updateprojecthg) | **PATCH** /project/{id_or_name}/hg/{repo_id} | 
*ProjectApi* | [**updateProjectProfile**](docs/Api/ProjectApi.md#updateprojectprofile) | **PATCH** /project/{id_or_name}/admin/profile/{language_code} | 
*ProjectApi* | [**updateProjectTicket**](docs/Api/ProjectApi.md#updateprojectticket) | **PATCH** /project/{id_or_name}/ticket/{ticket_id} | 
*ProjectApi* | [**updateProjectTicketAdminprefs**](docs/Api/ProjectApi.md#updateprojectticketadminprefs) | **PATCH** /project/{id_or_name}/ticket/admin | 
*ProjectApi* | [**updateProjectTicketComponent**](docs/Api/ProjectApi.md#updateprojectticketcomponent) | **PATCH** /project/{id_or_name}/ticket/component/{component_id} | 
*ProjectApi* | [**updateProjectTicketMilestone**](docs/Api/ProjectApi.md#updateprojectticketmilestone) | **PATCH** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*ProjectApi* | [**updateProjectTicketType**](docs/Api/ProjectApi.md#updateprojecttickettype) | **PATCH** /project/{id_or_name}/ticket/type/{type_id} | 
*ProjectApi* | [**updateProjectTools**](docs/Api/ProjectApi.md#updateprojecttools) | **PATCH** /project/{id_or_name}/admin/tools | 
*ProjectApi* | [**updateRelease**](docs/Api/ProjectApi.md#updaterelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectApi* | [**updateReleaseFile**](docs/Api/ProjectApi.md#updatereleasefile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectFrsApi* | [**createPackage**](docs/Api/ProjectFrsApi.md#createpackage) | **POST** /project/{id_or_name}/frs | 
*ProjectFrsApi* | [**createRelease**](docs/Api/ProjectFrsApi.md#createrelease) | **POST** /project/{id_or_name}/frs/{package_id} | 
*ProjectFrsApi* | [**createReleaseFile**](docs/Api/ProjectFrsApi.md#createreleasefile) | **POST** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectFrsApi* | [**deletePackage**](docs/Api/ProjectFrsApi.md#deletepackage) | **DELETE** /project/{id_or_name}/frs/{package_id} | 
*ProjectFrsApi* | [**deleteRelease**](docs/Api/ProjectFrsApi.md#deleterelease) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectFrsApi* | [**deleteReleaseFile**](docs/Api/ProjectFrsApi.md#deletereleasefile) | **DELETE** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectFrsApi* | [**draftRelease**](docs/Api/ProjectFrsApi.md#draftrelease) | **GET** /project/{id_or_name}/frs/{package_id}/draft | 
*ProjectFrsApi* | [**getFrsAdminprefs**](docs/Api/ProjectFrsApi.md#getfrsadminprefs) | **GET** /project/{id_or_name}/frs/admin | 
*ProjectFrsApi* | [**getPackage**](docs/Api/ProjectFrsApi.md#getpackage) | **GET** /project/{id_or_name}/frs/{package_id} | 
*ProjectFrsApi* | [**getRelease**](docs/Api/ProjectFrsApi.md#getrelease) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectFrsApi* | [**getReleaseFile**](docs/Api/ProjectFrsApi.md#getreleasefile) | **GET** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectFrsApi* | [**listPackages**](docs/Api/ProjectFrsApi.md#listpackages) | **GET** /project/{id_or_name}/frs | 
*ProjectFrsApi* | [**updateFrsAdminprefs**](docs/Api/ProjectFrsApi.md#updatefrsadminprefs) | **PATCH** /project/{id_or_name}/frs/admin | 
*ProjectFrsApi* | [**updatePackage**](docs/Api/ProjectFrsApi.md#updatepackage) | **PATCH** /project/{id_or_name}/frs/{package_id} | 
*ProjectFrsApi* | [**updateRelease**](docs/Api/ProjectFrsApi.md#updaterelease) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id} | 
*ProjectFrsApi* | [**updateReleaseFile**](docs/Api/ProjectFrsApi.md#updatereleasefile) | **PATCH** /project/{id_or_name}/frs/{package_id}/{release_id}/{file_id} | 
*ProjectNewsApi* | [**createNews**](docs/Api/ProjectNewsApi.md#createnews) | **POST** /news | 
*ProjectNewsApi* | [**createNews_0**](docs/Api/ProjectNewsApi.md#createnews_0) | **POST** /project/{id_or_name}/news | 
*ProjectNewsApi* | [**deleteNews**](docs/Api/ProjectNewsApi.md#deletenews) | **DELETE** /news/{news_id} | 
*ProjectNewsApi* | [**deleteNews_0**](docs/Api/ProjectNewsApi.md#deletenews_0) | **DELETE** /project/{id_or_name}/news/{news_id} | 
*ProjectNewsApi* | [**getNews**](docs/Api/ProjectNewsApi.md#getnews) | **GET** /news/{news_id} | 
*ProjectNewsApi* | [**getNews_0**](docs/Api/ProjectNewsApi.md#getnews_0) | **GET** /project/{id_or_name}/news/{news_id} | 
*ProjectNewsApi* | [**listNews**](docs/Api/ProjectNewsApi.md#listnews) | **GET** /news | 
*ProjectNewsApi* | [**listNews_0**](docs/Api/ProjectNewsApi.md#listnews_0) | **GET** /project/{id_or_name}/news | 
*ProjectNewsApi* | [**updateNews**](docs/Api/ProjectNewsApi.md#updatenews) | **PATCH** /news/{news_id} | 
*ProjectNewsApi* | [**updateNews_0**](docs/Api/ProjectNewsApi.md#updatenews_0) | **PATCH** /project/{id_or_name}/news/{news_id} | 
*ProjectSCMApi* | [**createProjectBzr**](docs/Api/ProjectSCMApi.md#createprojectbzr) | **POST** /project/{id_or_name}/bzr | 
*ProjectSCMApi* | [**createProjectGit**](docs/Api/ProjectSCMApi.md#createprojectgit) | **POST** /project/{id_or_name}/git | 
*ProjectSCMApi* | [**createProjectGitHook**](docs/Api/ProjectSCMApi.md#createprojectgithook) | **POST** /project/{id_or_name}/git/{repo_id}/hooks | 
*ProjectSCMApi* | [**createProjectHg**](docs/Api/ProjectSCMApi.md#createprojecthg) | **POST** /project/{id_or_name}/hg | 
*ProjectSCMApi* | [**deleteProjectGitHook**](docs/Api/ProjectSCMApi.md#deleteprojectgithook) | **DELETE** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
*ProjectSCMApi* | [**disableProjectBzr**](docs/Api/ProjectSCMApi.md#disableprojectbzr) | **DELETE** /project/{id_or_name}/bzr/{repo_id} | 
*ProjectSCMApi* | [**disableProjectGit**](docs/Api/ProjectSCMApi.md#disableprojectgit) | **DELETE** /project/{id_or_name}/git/{repo_id} | 
*ProjectSCMApi* | [**disableProjectHg**](docs/Api/ProjectSCMApi.md#disableprojecthg) | **DELETE** /project/{id_or_name}/hg/{repo_id} | 
*ProjectSCMApi* | [**getProjectBzr**](docs/Api/ProjectSCMApi.md#getprojectbzr) | **GET** /project/{id_or_name}/bzr/{repo_id} | 
*ProjectSCMApi* | [**getProjectGit**](docs/Api/ProjectSCMApi.md#getprojectgit) | **GET** /project/{id_or_name}/git/{repo_id} | 
*ProjectSCMApi* | [**getProjectGitHook**](docs/Api/ProjectSCMApi.md#getprojectgithook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks/{hook_id} | 
*ProjectSCMApi* | [**getProjectHg**](docs/Api/ProjectSCMApi.md#getprojecthg) | **GET** /project/{id_or_name}/hg/{repo_id} | 
*ProjectSCMApi* | [**getProjectSvn**](docs/Api/ProjectSCMApi.md#getprojectsvn) | **GET** /project/{id_or_name}/svn | 
*ProjectSCMApi* | [**listProjectBzr**](docs/Api/ProjectSCMApi.md#listprojectbzr) | **GET** /project/{id_or_name}/bzr | 
*ProjectSCMApi* | [**listProjectGit**](docs/Api/ProjectSCMApi.md#listprojectgit) | **GET** /project/{id_or_name}/git | 
*ProjectSCMApi* | [**listProjectGitHook**](docs/Api/ProjectSCMApi.md#listprojectgithook) | **GET** /project/{id_or_name}/git/{repo_id}/hooks | 
*ProjectSCMApi* | [**listProjectHg**](docs/Api/ProjectSCMApi.md#listprojecthg) | **GET** /project/{id_or_name}/hg | 
*ProjectSCMApi* | [**updateProjectBzr**](docs/Api/ProjectSCMApi.md#updateprojectbzr) | **PATCH** /project/{id_or_name}/bzr/{repo_id} | 
*ProjectSCMApi* | [**updateProjectGit**](docs/Api/ProjectSCMApi.md#updateprojectgit) | **PATCH** /project/{id_or_name}/git/{repo_id} | 
*ProjectSCMApi* | [**updateProjectHg**](docs/Api/ProjectSCMApi.md#updateprojecthg) | **PATCH** /project/{id_or_name}/hg/{repo_id} | 
*ProjectTicketApi* | [**createProjectTicket**](docs/Api/ProjectTicketApi.md#createprojectticket) | **POST** /project/{id_or_name}/ticket | 
*ProjectTicketApi* | [**createProjectTicketComment**](docs/Api/ProjectTicketApi.md#createprojectticketcomment) | **POST** /project/{id_or_name}/ticket/{ticket_id}/comment | 
*ProjectTicketApi* | [**createProjectTicketComponent**](docs/Api/ProjectTicketApi.md#createprojectticketcomponent) | **POST** /project/{id_or_name}/ticket/component | 
*ProjectTicketApi* | [**createProjectTicketMilestone**](docs/Api/ProjectTicketApi.md#createprojectticketmilestone) | **POST** /project/{id_or_name}/ticket/milestone | 
*ProjectTicketApi* | [**createProjectTicketType**](docs/Api/ProjectTicketApi.md#createprojecttickettype) | **POST** /project/{id_or_name}/ticket/type | 
*ProjectTicketApi* | [**createProjectTicketTypeInstruction**](docs/Api/ProjectTicketApi.md#createprojecttickettypeinstruction) | **POST** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
*ProjectTicketApi* | [**deleteProjectTicketComponent**](docs/Api/ProjectTicketApi.md#deleteprojectticketcomponent) | **DELETE** /project/{id_or_name}/ticket/component/{component_id} | 
*ProjectTicketApi* | [**deleteProjectTicketMilestone**](docs/Api/ProjectTicketApi.md#deleteprojectticketmilestone) | **DELETE** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*ProjectTicketApi* | [**deleteProjectTicketType**](docs/Api/ProjectTicketApi.md#deleteprojecttickettype) | **DELETE** /project/{id_or_name}/ticket/type/{type_id} | 
*ProjectTicketApi* | [**deleteProjectTicketTypeInstruction**](docs/Api/ProjectTicketApi.md#deleteprojecttickettypeinstruction) | **DELETE** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*ProjectTicketApi* | [**getProjectTicket**](docs/Api/ProjectTicketApi.md#getprojectticket) | **GET** /project/{id_or_name}/ticket/{ticket_id} | 
*ProjectTicketApi* | [**getProjectTicketComponent**](docs/Api/ProjectTicketApi.md#getprojectticketcomponent) | **GET** /project/{id_or_name}/ticket/component/{component_id} | 
*ProjectTicketApi* | [**getProjectTicketMilestone**](docs/Api/ProjectTicketApi.md#getprojectticketmilestone) | **GET** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*ProjectTicketApi* | [**getProjectTicketType**](docs/Api/ProjectTicketApi.md#getprojecttickettype) | **GET** /project/{id_or_name}/ticket/type/{type_id} | 
*ProjectTicketApi* | [**getProjectTicketTypeInstruction**](docs/Api/ProjectTicketApi.md#getprojecttickettypeinstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*ProjectTicketApi* | [**getProjectTicketTypeInstruction_0**](docs/Api/ProjectTicketApi.md#getprojecttickettypeinstruction_0) | **PATCH** /project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code} | 
*ProjectTicketApi* | [**listProjectTicket**](docs/Api/ProjectTicketApi.md#listprojectticket) | **GET** /project/{id_or_name}/ticket | 
*ProjectTicketApi* | [**listProjectTicketComment**](docs/Api/ProjectTicketApi.md#listprojectticketcomment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment | 
*ProjectTicketApi* | [**listProjectTicketComponent**](docs/Api/ProjectTicketApi.md#listprojectticketcomponent) | **GET** /project/{id_or_name}/ticket/component | 
*ProjectTicketApi* | [**listProjectTicketMilestone**](docs/Api/ProjectTicketApi.md#listprojectticketmilestone) | **GET** /project/{id_or_name}/ticket/milestone | 
*ProjectTicketApi* | [**listProjectTicketType**](docs/Api/ProjectTicketApi.md#listprojecttickettype) | **GET** /project/{id_or_name}/ticket/type | 
*ProjectTicketApi* | [**listProjectTicketTypeInstruction**](docs/Api/ProjectTicketApi.md#listprojecttickettypeinstruction) | **GET** /project/{id_or_name}/ticket/type/{type_id}/instruction | 
*ProjectTicketApi* | [**showProjectTicketAdminprefs**](docs/Api/ProjectTicketApi.md#showprojectticketadminprefs) | **GET** /project/{id_or_name}/ticket/admin | 
*ProjectTicketApi* | [**showProjectTicketComment**](docs/Api/ProjectTicketApi.md#showprojectticketcomment) | **GET** /project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id} | 
*ProjectTicketApi* | [**updateProjectTicket**](docs/Api/ProjectTicketApi.md#updateprojectticket) | **PATCH** /project/{id_or_name}/ticket/{ticket_id} | 
*ProjectTicketApi* | [**updateProjectTicketAdminprefs**](docs/Api/ProjectTicketApi.md#updateprojectticketadminprefs) | **PATCH** /project/{id_or_name}/ticket/admin | 
*ProjectTicketApi* | [**updateProjectTicketComponent**](docs/Api/ProjectTicketApi.md#updateprojectticketcomponent) | **PATCH** /project/{id_or_name}/ticket/component/{component_id} | 
*ProjectTicketApi* | [**updateProjectTicketMilestone**](docs/Api/ProjectTicketApi.md#updateprojectticketmilestone) | **PATCH** /project/{id_or_name}/ticket/milestone/{milestone_id} | 
*ProjectTicketApi* | [**updateProjectTicketType**](docs/Api/ProjectTicketApi.md#updateprojecttickettype) | **PATCH** /project/{id_or_name}/ticket/type/{type_id} | 
*UserApi* | [**getUser**](docs/Api/UserApi.md#getuser) | **GET** /user/{id_or_name} | 
*UserApi* | [**getUserHistory**](docs/Api/UserApi.md#getuserhistory) | **GET** /user/{id_or_name}/history | 
*UserApi* | [**getUserStatsDaily**](docs/Api/UserApi.md#getuserstatsdaily) | **GET** /user/{id_or_name}/stats/daily | 
*UserApi* | [**getUserStatsMonthly**](docs/Api/UserApi.md#getuserstatsmonthly) | **GET** /user/{id_or_name}/stats/monthly | 
*UserApi* | [**updateUserIcon**](docs/Api/UserApi.md#updateusericon) | **POST** /user/{id_or_name}/icon | 
*UserApi* | [**updateUserPhoto**](docs/Api/UserApi.md#updateuserphoto) | **POST** /user/{id_or_name}/photo | 


## Documentation For Models

 - [FrsAdminPrefs](docs/Model/FrsAdminPrefs.md)
 - [Group](docs/Model/Group.md)
 - [GroupProfile](docs/Model/GroupProfile.md)
 - [GroupProfilePerLanguage](docs/Model/GroupProfilePerLanguage.md)
 - [GroupToolFlags](docs/Model/GroupToolFlags.md)
 - [History](docs/Model/History.md)
 - [I18NText](docs/Model/I18NText.md)
 - [News](docs/Model/News.md)
 - [Package](docs/Model/Package.md)
 - [Pong](docs/Model/Pong.md)
 - [ProjectBzr](docs/Model/ProjectBzr.md)
 - [ProjectGit](docs/Model/ProjectGit.md)
 - [ProjectHg](docs/Model/ProjectHg.md)
 - [ProjectSCM](docs/Model/ProjectSCM.md)
 - [ProjectSCMLastCommit](docs/Model/ProjectSCMLastCommit.md)
 - [ProjectSvn](docs/Model/ProjectSvn.md)
 - [ProjectTicketComment](docs/Model/ProjectTicketComment.md)
 - [ProjectTicketComponent](docs/Model/ProjectTicketComponent.md)
 - [ProjectTicketComponentSummary](docs/Model/ProjectTicketComponentSummary.md)
 - [ProjectTicketComponentSummarySummarizedBy](docs/Model/ProjectTicketComponentSummarySummarizedBy.md)
 - [ProjectTicketHistory](docs/Model/ProjectTicketHistory.md)
 - [ProjectTicketItem](docs/Model/ProjectTicketItem.md)
 - [ProjectTicketMilestone](docs/Model/ProjectTicketMilestone.md)
 - [ProjectTicketMilestoneSummary](docs/Model/ProjectTicketMilestoneSummary.md)
 - [ProjectTicketMilestoneSummarySummarizedBy](docs/Model/ProjectTicketMilestoneSummarySummarizedBy.md)
 - [ProjectTicketPrefs](docs/Model/ProjectTicketPrefs.md)
 - [ProjectTicketType](docs/Model/ProjectTicketType.md)
 - [ProjectTicketTypeInstructionPerLanguage](docs/Model/ProjectTicketTypeInstructionPerLanguage.md)
 - [ProjectTicketTypeInstructions](docs/Model/ProjectTicketTypeInstructions.md)
 - [ProjectTicketTypeSummary](docs/Model/ProjectTicketTypeSummary.md)
 - [ProjectTicketTypeSummarySummarizedBy](docs/Model/ProjectTicketTypeSummarySummarizedBy.md)
 - [ProjectWeb](docs/Model/ProjectWeb.md)
 - [RelFile](docs/Model/RelFile.md)
 - [Release](docs/Model/Release.md)
 - [ScmHook](docs/Model/ScmHook.md)
 - [SimpleChamber](docs/Model/SimpleChamber.md)
 - [SimpleGroup](docs/Model/SimpleGroup.md)
 - [SimpleUser](docs/Model/SimpleUser.md)
 - [Skill](docs/Model/Skill.md)
 - [SummariadByComponent](docs/Model/SummariadByComponent.md)
 - [SummariadByComponentInner](docs/Model/SummariadByComponentInner.md)
 - [SummariadByMilestone](docs/Model/SummariadByMilestone.md)
 - [SummariadByMilestoneInner](docs/Model/SummariadByMilestoneInner.md)
 - [SummariadByOwner](docs/Model/SummariadByOwner.md)
 - [SummariadByOwnerInner](docs/Model/SummariadByOwnerInner.md)
 - [SummariadByPriority](docs/Model/SummariadByPriority.md)
 - [SummariadByPriorityInner](docs/Model/SummariadByPriorityInner.md)
 - [SummariadBySeverity](docs/Model/SummariadBySeverity.md)
 - [SummariadBySeverityInner](docs/Model/SummariadBySeverityInner.md)
 - [SummariadByType](docs/Model/SummariadByType.md)
 - [SummariadByTypeInner](docs/Model/SummariadByTypeInner.md)
 - [Token](docs/Model/Token.md)
 - [User](docs/Model/User.md)
 - [UserImages](docs/Model/UserImages.md)
 - [UserStats](docs/Model/UserStats.md)


## Documentation For Authorization


## oauth2-code

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://osdn.net/account/oauth2ui/authorize
- **Scopes**: 
 - **profile**: Read basic user profile
 - **profile_write**: Write basic user profile
 - **group**: read access to group data
 - **group_write**: write access to group data
 - **chamber**: read access to chamber data
 - **chamber_write**: write access to chamber data

## oauth2-implicit

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://osdn.net/account/oauth2ui/authorize
- **Scopes**: 
 - **profile**: Read basic user profile
 - **profile_write**: Write basic user profile
 - **group**: read access to group data
 - **group_write**: write access to group data
 - **chamber**: read access to chamber data
 - **chamber_write**: write access to chamber data


## Author

admin@osdn.net


