# OSDN\DefaultApi

All URIs are relative to *https://osdn.net/api/v0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ping**](DefaultApi.md#ping) | **GET** /ping | 
[**token**](DefaultApi.md#token) | **POST** /token | 


# **ping**
> \OSDN\Model\Pong ping()



return pong for test

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: oauth2-code
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');
// Configure OAuth2 access token for authorization: oauth2-implicit
OSDN\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new OSDN\Api\DefaultApi();

try {
    $result = $api_instance->ping();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->ping: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\OSDN\Model\Pong**](../Model/Pong.md)

### Authorization

[oauth2-code](../../README.md#oauth2-code), [oauth2-implicit](../../README.md#oauth2-implicit)

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **token**
> \OSDN\Model\Token token($client_id, $client_secret, $grant_type, $code, $refresh_token)



Get access token by access code.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$api_instance = new OSDN\Api\DefaultApi();
$client_id = "client_id_example"; // string | Your application ID
$client_secret = "client_secret_example"; // string | Your application secret (key)
$grant_type = "authorization_code"; // string | \"authorization_code\" or \"refresh_token\"
$code = "code_example"; // string | Set auth code issued by https://osdn.net/account/oauth2ui/authorize for grant_type=authorization_code
$refresh_token = "refresh_token_example"; // string | Set refresh token to update access token.

try {
    $result = $api_instance->token($client_id, $client_secret, $grant_type, $code, $refresh_token);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DefaultApi->token: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **client_id** | **string**| Your application ID |
 **client_secret** | **string**| Your application secret (key) |
 **grant_type** | **string**| \&quot;authorization_code\&quot; or \&quot;refresh_token\&quot; | [optional] [default to authorization_code]
 **code** | **string**| Set auth code issued by https://osdn.net/account/oauth2ui/authorize for grant_type&#x3D;authorization_code | [optional]
 **refresh_token** | **string**| Set refresh token to update access token. | [optional]

### Return type

[**\OSDN\Model\Token**](../Model/Token.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/x-www-form-urlencoded
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

