# coding: utf-8

"""
    OSDN REST API v0 beta

    OSDN REST API. Currently this API is experimental release. Pelase refer documentation on https://osdn.net/projects/osdn-codes/wiki/APIGuide and you can get client libraries from https://osdn.net/projects/osdn-codes/releases/p14859 . 

    OpenAPI spec version: 0.0.20171120
    Contact: admin@osdn.net
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ProjectApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_news(self, title, body, group_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news(title, body, group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :param int group_id: group_id the news created in (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_news_with_http_info(title, body, group_id, **kwargs)
        else:
            (data) = self.create_news_with_http_info(title, body, group_id, **kwargs)
            return data

    def create_news_with_http_info(self, title, body, group_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_with_http_info(title, body, group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :param int group_id: group_id the news created in (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['title', 'body', 'group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_news`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_news`")
        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `create_news`")

        resource_path = '/news'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'group_id' in params:
            query_params['group_id'] = params['group_id']

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_news_0(self, id_or_name, title, body, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_0(id_or_name, title, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_news_0_with_http_info(id_or_name, title, body, **kwargs)
        else:
            (data) = self.create_news_0_with_http_info(id_or_name, title, body, **kwargs)
            return data

    def create_news_0_with_http_info(self, id_or_name, title, body, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_news_0_with_http_info(id_or_name, title, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title (required)
        :param str body: news body in OSDN Wiki format. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'title', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_news_0`")
        # verify the required parameter 'title' is set
        if ('title' not in params) or (params['title'] is None):
            raise ValueError("Missing the required parameter `title` when calling `create_news_0`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_news_0`")

        resource_path = '/project/{id_or_name}/news'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_package(self, id_or_name, name, **kwargs):
        """
        
        Create a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_package(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: package name (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_package_with_http_info(id_or_name, name, **kwargs)
        else:
            (data) = self.create_package_with_http_info(id_or_name, name, **kwargs)
            return data

    def create_package_with_http_info(self, id_or_name, name, **kwargs):
        """
        
        Create a package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_package_with_http_info(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: package name (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'visibility']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_package`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_package`")

        resource_path = '/project/{id_or_name}/frs'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Package',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_bzr(self, id_or_name, name, **kwargs):
        """
        
        Create a new bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_bzr(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_bzr_with_http_info(id_or_name, name, **kwargs)
        else:
            (data) = self.create_project_bzr_with_http_info(id_or_name, name, **kwargs)
            return data

    def create_project_bzr_with_http_info(self, id_or_name, name, **kwargs):
        """
        
        Create a new bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_bzr_with_http_info(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_bzr`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectBzr',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_git(self, id_or_name, name, **kwargs):
        """
        
        Create a new git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_git(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :param bool mail_enabled: 
        :param str mail_recipients: 
        :param bool allow_non_fast_forward: 
        :param str default_branch: 
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_git_with_http_info(id_or_name, name, **kwargs)
        else:
            (data) = self.create_project_git_with_http_info(id_or_name, name, **kwargs)
            return data

    def create_project_git_with_http_info(self, id_or_name, name, **kwargs):
        """
        
        Create a new git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_git_with_http_info(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :param bool mail_enabled: 
        :param str mail_recipients: 
        :param bool allow_non_fast_forward: 
        :param str default_branch: 
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description', 'mail_enabled', 'mail_recipients', 'allow_non_fast_forward', 'default_branch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_git`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_git`")

        resource_path = '/project/{id_or_name}/git'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'mail_enabled' in params:
            form_params.append(('mail_enabled', params['mail_enabled']))
        if 'mail_recipients' in params:
            form_params.append(('mail_recipients', params['mail_recipients']))
        if 'allow_non_fast_forward' in params:
            form_params.append(('allow_non_fast_forward', params['allow_non_fast_forward']))
        if 'default_branch' in params:
            form_params.append(('default_branch', params['default_branch']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectGit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_git_hook(self, id_or_name, repo_id, target_url, **kwargs):
        """
        
        Create a new hook for project git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_git_hook(id_or_name, repo_id, target_url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str target_url:  (required)
        :return: ScmHook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_git_hook_with_http_info(id_or_name, repo_id, target_url, **kwargs)
        else:
            (data) = self.create_project_git_hook_with_http_info(id_or_name, repo_id, target_url, **kwargs)
            return data

    def create_project_git_hook_with_http_info(self, id_or_name, repo_id, target_url, **kwargs):
        """
        
        Create a new hook for project git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_git_hook_with_http_info(id_or_name, repo_id, target_url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str target_url:  (required)
        :return: ScmHook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'target_url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_git_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_git_hook`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `create_project_git_hook`")
        # verify the required parameter 'target_url' is set
        if ('target_url' not in params) or (params['target_url'] is None):
            raise ValueError("Missing the required parameter `target_url` when calling `create_project_git_hook`")

        resource_path = '/project/{id_or_name}/git/{repo_id}/hooks'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'target_url' in params:
            form_params.append(('target_url', params['target_url']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScmHook',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_hg(self, id_or_name, name, **kwargs):
        """
        
        Create a new hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_hg(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :param str mail_recipients: 
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_hg_with_http_info(id_or_name, name, **kwargs)
        else:
            (data) = self.create_project_hg_with_http_info(id_or_name, name, **kwargs)
            return data

    def create_project_hg_with_http_info(self, id_or_name, name, **kwargs):
        """
        
        Create a new hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_hg_with_http_info(id_or_name, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name:  (required)
        :param str description: 
        :param str mail_recipients: 
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description', 'mail_recipients']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_hg`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_hg`")

        resource_path = '/project/{id_or_name}/hg'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'mail_recipients' in params:
            form_params.append(('mail_recipients', params['mail_recipients']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectHg',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_profile(self, id_or_name, language_code, display_name, description, **kwargs):
        """
        
        Create project profile for the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_profile(id_or_name, language_code, display_name, description, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :param str display_name: Project display name (required)
        :param str description: Project description (required)
        :return: GroupProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_profile_with_http_info(id_or_name, language_code, display_name, description, **kwargs)
        else:
            (data) = self.create_project_profile_with_http_info(id_or_name, language_code, display_name, description, **kwargs)
            return data

    def create_project_profile_with_http_info(self, id_or_name, language_code, display_name, description, **kwargs):
        """
        
        Create project profile for the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_profile_with_http_info(id_or_name, language_code, display_name, description, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :param str display_name: Project display name (required)
        :param str description: Project description (required)
        :return: GroupProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'language_code', 'display_name', 'description']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_profile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_profile`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `create_project_profile`")
        # verify the required parameter 'display_name' is set
        if ('display_name' not in params) or (params['display_name'] is None):
            raise ValueError("Missing the required parameter `display_name` when calling `create_project_profile`")
        # verify the required parameter 'description' is set
        if ('description' not in params) or (params['description'] is None):
            raise ValueError("Missing the required parameter `description` when calling `create_project_profile`")

        resource_path = '/project/{id_or_name}/admin/profile'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'language_code' in params:
            form_params.append(('language_code', params['language_code']))
        if 'display_name' in params:
            form_params.append(('display_name', params['display_name']))
        if 'description' in params:
            form_params.append(('description', params['description']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_ticket(self, id_or_name, name, description, type_id, **kwargs):
        """
        
        Create project ticket

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket(id_or_name, name, description, type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: Project ticket name (title) (required)
        :param str description: Project ticket description details (required)
        :param int type_id: numeric project ticket type id (required)
        :param int milestone_id: numeric project ticket milestone id
        :param int component_id: numeric project ticket component id
        :param int priority: project ticket priority (min = 1 and max = 9)
        :param int severity: project ticket severity (min = 1 and max = 9)
        :param int owner: numeric project ticket owner user id
        :return: ProjectTicketItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_ticket_with_http_info(id_or_name, name, description, type_id, **kwargs)
        else:
            (data) = self.create_project_ticket_with_http_info(id_or_name, name, description, type_id, **kwargs)
            return data

    def create_project_ticket_with_http_info(self, id_or_name, name, description, type_id, **kwargs):
        """
        
        Create project ticket

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_with_http_info(id_or_name, name, description, type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: Project ticket name (title) (required)
        :param str description: Project ticket description details (required)
        :param int type_id: numeric project ticket type id (required)
        :param int milestone_id: numeric project ticket milestone id
        :param int component_id: numeric project ticket component id
        :param int priority: project ticket priority (min = 1 and max = 9)
        :param int severity: project ticket severity (min = 1 and max = 9)
        :param int owner: numeric project ticket owner user id
        :return: ProjectTicketItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description', 'type_id', 'milestone_id', 'component_id', 'priority', 'severity', 'owner']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_ticket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_ticket`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_ticket`")
        # verify the required parameter 'description' is set
        if ('description' not in params) or (params['description'] is None):
            raise ValueError("Missing the required parameter `description` when calling `create_project_ticket`")
        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `create_project_ticket`")

        if 'priority' in params and params['priority'] > 9.0:
            raise ValueError("Invalid value for parameter `priority` when calling `create_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'priority' in params and params['priority'] < 1.0:
            raise ValueError("Invalid value for parameter `priority` when calling `create_project_ticket`, must be a value greater than or equal to `1.0`")
        if 'severity' in params and params['severity'] > 9.0:
            raise ValueError("Invalid value for parameter `severity` when calling `create_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'severity' in params and params['severity'] < 1.0:
            raise ValueError("Invalid value for parameter `severity` when calling `create_project_ticket`, must be a value greater than or equal to `1.0`")
        if 'owner' in params and params['owner'] < 101.0:
            raise ValueError("Invalid value for parameter `owner` when calling `create_project_ticket`, must be a value greater than or equal to `101.0`")
        resource_path = '/project/{id_or_name}/ticket'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'type_id' in params:
            form_params.append(('type_id', params['type_id']))
        if 'milestone_id' in params:
            form_params.append(('milestone_id', params['milestone_id']))
        if 'component_id' in params:
            form_params.append(('component_id', params['component_id']))
        if 'priority' in params:
            form_params.append(('priority', params['priority']))
        if 'severity' in params:
            form_params.append(('severity', params['severity']))
        if 'owner' in params:
            form_params.append(('owner', params['owner']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketItem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_ticket_comment(self, id_or_name, ticket_id, comment, **kwargs):
        """
        
        Create new project ticket comment of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_comment(id_or_name, ticket_id, comment, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :param str comment: Ticket comment text (required)
        :return: ProjectTicketComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_ticket_comment_with_http_info(id_or_name, ticket_id, comment, **kwargs)
        else:
            (data) = self.create_project_ticket_comment_with_http_info(id_or_name, ticket_id, comment, **kwargs)
            return data

    def create_project_ticket_comment_with_http_info(self, id_or_name, ticket_id, comment, **kwargs):
        """
        
        Create new project ticket comment of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_comment_with_http_info(id_or_name, ticket_id, comment, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :param str comment: Ticket comment text (required)
        :return: ProjectTicketComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'ticket_id', 'comment']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_ticket_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_ticket_comment`")
        # verify the required parameter 'ticket_id' is set
        if ('ticket_id' not in params) or (params['ticket_id'] is None):
            raise ValueError("Missing the required parameter `ticket_id` when calling `create_project_ticket_comment`")
        # verify the required parameter 'comment' is set
        if ('comment' not in params) or (params['comment'] is None):
            raise ValueError("Missing the required parameter `comment` when calling `create_project_ticket_comment`")

        resource_path = '/project/{id_or_name}/ticket/{ticket_id}/comment'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'ticket_id' in params:
            path_params['ticket_id'] = params['ticket_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'comment' in params:
            form_params.append(('comment', params['comment']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketComment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_ticket_component(self, id_or_name, name, description, **kwargs):
        """
        
        Create new project ticket component of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_component(id_or_name, name, description, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: Ticket component name (required)
        :param str description: Ticket component description (required)
        :param int owner: Ticket componet owner user_id
        :param bool active: Ticket componet will be shown the component select list when this parameter is true
        :return: list[ProjectTicketComponent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_ticket_component_with_http_info(id_or_name, name, description, **kwargs)
        else:
            (data) = self.create_project_ticket_component_with_http_info(id_or_name, name, description, **kwargs)
            return data

    def create_project_ticket_component_with_http_info(self, id_or_name, name, description, **kwargs):
        """
        
        Create new project ticket component of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_component_with_http_info(id_or_name, name, description, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: Ticket component name (required)
        :param str description: Ticket component description (required)
        :param int owner: Ticket componet owner user_id
        :param bool active: Ticket componet will be shown the component select list when this parameter is true
        :return: list[ProjectTicketComponent]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description', 'owner', 'active']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_ticket_component" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_ticket_component`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_ticket_component`")
        # verify the required parameter 'description' is set
        if ('description' not in params) or (params['description'] is None):
            raise ValueError("Missing the required parameter `description` when calling `create_project_ticket_component`")

        resource_path = '/project/{id_or_name}/ticket/component'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'owner' in params:
            form_params.append(('owner', params['owner']))
        if 'active' in params:
            form_params.append(('active', params['active']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectTicketComponent]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_ticket_milestone(self, id_or_name, name, description, **kwargs):
        """
        
        Create new project ticket milestone of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_milestone(id_or_name, name, description, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: Ticket milestone name (required)
        :param str description: Ticket milestone description (required)
        :param datetime start: Ticket milestone start date
        :param datetime end: Ticket milestone due date
        :return: ProjectTicketMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_ticket_milestone_with_http_info(id_or_name, name, description, **kwargs)
        else:
            (data) = self.create_project_ticket_milestone_with_http_info(id_or_name, name, description, **kwargs)
            return data

    def create_project_ticket_milestone_with_http_info(self, id_or_name, name, description, **kwargs):
        """
        
        Create new project ticket milestone of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_milestone_with_http_info(id_or_name, name, description, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: Ticket milestone name (required)
        :param str description: Ticket milestone description (required)
        :param datetime start: Ticket milestone start date
        :param datetime end: Ticket milestone due date
        :return: ProjectTicketMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description', 'start', 'end']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_ticket_milestone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_ticket_milestone`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_ticket_milestone`")
        # verify the required parameter 'description' is set
        if ('description' not in params) or (params['description'] is None):
            raise ValueError("Missing the required parameter `description` when calling `create_project_ticket_milestone`")

        resource_path = '/project/{id_or_name}/ticket/milestone'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'start' in params:
            form_params.append(('start', params['start']))
        if 'end' in params:
            form_params.append(('end', params['end']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketMilestone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_ticket_type(self, id_or_name, name, description, **kwargs):
        """
        
        Create new project ticket type of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_type(id_or_name, name, description, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: Ticket type name (required)
        :param str description: Ticket type description (required)
        :param bool is_public: if set as false, this type will be shown to project members only.
        :return: ProjectTicketType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_ticket_type_with_http_info(id_or_name, name, description, **kwargs)
        else:
            (data) = self.create_project_ticket_type_with_http_info(id_or_name, name, description, **kwargs)
            return data

    def create_project_ticket_type_with_http_info(self, id_or_name, name, description, **kwargs):
        """
        
        Create new project ticket type of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_type_with_http_info(id_or_name, name, description, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str name: Ticket type name (required)
        :param str description: Ticket type description (required)
        :param bool is_public: if set as false, this type will be shown to project members only.
        :return: ProjectTicketType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'name', 'description', 'is_public']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_ticket_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_ticket_type`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_project_ticket_type`")
        # verify the required parameter 'description' is set
        if ('description' not in params) or (params['description'] is None):
            raise ValueError("Missing the required parameter `description` when calling `create_project_ticket_type`")

        resource_path = '/project/{id_or_name}/ticket/type'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'is_public' in params:
            form_params.append(('is_public', params['is_public']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketType',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_project_ticket_type_instruction(self, id_or_name, type_id, language_code, instruction, **kwargs):
        """
        
        Create project ticket type instructions for the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_type_instruction(id_or_name, type_id, language_code, instruction, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :param str instruction: Ticket submit instruction for the type (required)
        :return: ProjectTicketTypeInstructionPerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_project_ticket_type_instruction_with_http_info(id_or_name, type_id, language_code, instruction, **kwargs)
        else:
            (data) = self.create_project_ticket_type_instruction_with_http_info(id_or_name, type_id, language_code, instruction, **kwargs)
            return data

    def create_project_ticket_type_instruction_with_http_info(self, id_or_name, type_id, language_code, instruction, **kwargs):
        """
        
        Create project ticket type instructions for the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_project_ticket_type_instruction_with_http_info(id_or_name, type_id, language_code, instruction, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :param str instruction: Ticket submit instruction for the type (required)
        :return: ProjectTicketTypeInstructionPerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'type_id', 'language_code', 'instruction']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_ticket_type_instruction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_project_ticket_type_instruction`")
        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `create_project_ticket_type_instruction`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `create_project_ticket_type_instruction`")
        # verify the required parameter 'instruction' is set
        if ('instruction' not in params) or (params['instruction'] is None):
            raise ValueError("Missing the required parameter `instruction` when calling `create_project_ticket_type_instruction`")

        resource_path = '/project/{id_or_name}/ticket/type/{type_id}/instruction'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'type_id' in params:
            path_params['type_id'] = params['type_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'language_code' in params:
            form_params.append(('language_code', params['language_code']))
        if 'instruction' in params:
            form_params.append(('instruction', params['instruction']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketTypeInstructionPerLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_release(self, id_or_name, package_id, name, **kwargs):
        """
        
        Create new release in specified package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_release(id_or_name, package_id, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param str name: Release name (required)
        :param str visibility: visibility status (public, hidden or private)
        :param datetime time: Release datetime. If you set future time, the release hide until specified time.
        :param str release_note: Release note body text.
        :param str change_log: Changelog body text.
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_release_with_http_info(id_or_name, package_id, name, **kwargs)
        else:
            (data) = self.create_release_with_http_info(id_or_name, package_id, name, **kwargs)
            return data

    def create_release_with_http_info(self, id_or_name, package_id, name, **kwargs):
        """
        
        Create new release in specified package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_release_with_http_info(id_or_name, package_id, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param str name: Release name (required)
        :param str visibility: visibility status (public, hidden or private)
        :param datetime time: Release datetime. If you set future time, the release hide until specified time.
        :param str release_note: Release note body text.
        :param str change_log: Changelog body text.
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'name', 'visibility', 'time', 'release_note', 'change_log']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `create_release`")
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'time' in params:
            form_params.append(('time', params['time']))
        if 'release_note' in params:
            form_params.append(('release_note', params['release_note']))
        if 'change_log' in params:
            form_params.append(('change_log', params['change_log']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Release',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def create_release_file(self, id_or_name, package_id, release_id, file, **kwargs):
        """
        
        Create new file in target release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_release_file(id_or_name, package_id, release_id, file, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param file file: Upload file in \"multipart/form-data\". (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_release_file_with_http_info(id_or_name, package_id, release_id, file, **kwargs)
        else:
            (data) = self.create_release_file_with_http_info(id_or_name, package_id, release_id, file, **kwargs)
            return data

    def create_release_file_with_http_info(self, id_or_name, package_id, release_id, file, **kwargs):
        """
        
        Create new file in target release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_release_file_with_http_info(id_or_name, package_id, release_id, file, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param file file: Upload file in \"multipart/form-data\". (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'file', 'visibility']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_release_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `create_release_file`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `create_release_file`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `create_release_file`")
        # verify the required parameter 'file' is set
        if ('file' not in params) or (params['file'] is None):
            raise ValueError("Missing the required parameter `file` when calling `create_release_file`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))
        if 'file' in params:
            local_var_files['file'] = params['file']

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['multipart/form-data'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RelFile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_news(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_news_with_http_info(news_id, **kwargs)
        else:
            (data) = self.delete_news_with_http_info(news_id, **kwargs)
            return data

    def delete_news_with_http_info(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_with_http_info(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `delete_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_news_0(self, id_or_name, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_0(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_news_0_with_http_info(id_or_name, news_id, **kwargs)
        else:
            (data) = self.delete_news_0_with_http_info(id_or_name, news_id, **kwargs)
            return data

    def delete_news_0_with_http_info(self, id_or_name, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_news_0_with_http_info(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_news_0`")
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `delete_news_0`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_package(self, id_or_name, package_id, **kwargs):
        """
        
        Delete taret package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_package(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_package_with_http_info(id_or_name, package_id, **kwargs)
        else:
            (data) = self.delete_package_with_http_info(id_or_name, package_id, **kwargs)
            return data

    def delete_package_with_http_info(self, id_or_name, package_id, **kwargs):
        """
        
        Delete taret package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_package_with_http_info(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_package`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `delete_package`")

        resource_path = '/project/{id_or_name}/frs/{package_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_project_admin_projectweb(self, id_or_name, **kwargs):
        """
        
        Delete project homepage url

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_admin_projectweb(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_project_admin_projectweb_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.delete_project_admin_projectweb_with_http_info(id_or_name, **kwargs)
            return data

    def delete_project_admin_projectweb_with_http_info(self, id_or_name, **kwargs):
        """
        
        Delete project homepage url

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_admin_projectweb_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_admin_projectweb" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_project_admin_projectweb`")

        resource_path = '/project/{id_or_name}/admin/project_web'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_project_git_hook(self, id_or_name, repo_id, hook_id, **kwargs):
        """
        
        Delete a Git repository hook

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_git_hook(id_or_name, repo_id, hook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param int hook_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, **kwargs)
        else:
            (data) = self.delete_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, **kwargs)
            return data

    def delete_project_git_hook_with_http_info(self, id_or_name, repo_id, hook_id, **kwargs):
        """
        
        Delete a Git repository hook

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param int hook_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'hook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_git_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_project_git_hook`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `delete_project_git_hook`")
        # verify the required parameter 'hook_id' is set
        if ('hook_id' not in params) or (params['hook_id'] is None):
            raise ValueError("Missing the required parameter `hook_id` when calling `delete_project_git_hook`")

        resource_path = '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']
        if 'hook_id' in params:
            path_params['hook_id'] = params['hook_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_project_profile(self, id_or_name, language_code, **kwargs):
        """
        
        Delete project profile for the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_profile(id_or_name, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_project_profile_with_http_info(id_or_name, language_code, **kwargs)
        else:
            (data) = self.delete_project_profile_with_http_info(id_or_name, language_code, **kwargs)
            return data

    def delete_project_profile_with_http_info(self, id_or_name, language_code, **kwargs):
        """
        
        Delete project profile for the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_profile_with_http_info(id_or_name, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'language_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_profile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_project_profile`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_project_profile`")

        resource_path = '/project/{id_or_name}/admin/profile/{language_code}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'language_code' in params:
            path_params['language_code'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_project_ticket_component(self, id_or_name, component_id, migrate_to, **kwargs):
        """
        
        Delete project ticket component

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_ticket_component(id_or_name, component_id, migrate_to, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int component_id: numeric project ticket component id (required)
        :param int migrate_to: Tickets that assigned to delete target will be migrate to the ticket component_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_project_ticket_component_with_http_info(id_or_name, component_id, migrate_to, **kwargs)
        else:
            (data) = self.delete_project_ticket_component_with_http_info(id_or_name, component_id, migrate_to, **kwargs)
            return data

    def delete_project_ticket_component_with_http_info(self, id_or_name, component_id, migrate_to, **kwargs):
        """
        
        Delete project ticket component

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_ticket_component_with_http_info(id_or_name, component_id, migrate_to, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int component_id: numeric project ticket component id (required)
        :param int migrate_to: Tickets that assigned to delete target will be migrate to the ticket component_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'component_id', 'migrate_to']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_ticket_component" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_project_ticket_component`")
        # verify the required parameter 'component_id' is set
        if ('component_id' not in params) or (params['component_id'] is None):
            raise ValueError("Missing the required parameter `component_id` when calling `delete_project_ticket_component`")
        # verify the required parameter 'migrate_to' is set
        if ('migrate_to' not in params) or (params['migrate_to'] is None):
            raise ValueError("Missing the required parameter `migrate_to` when calling `delete_project_ticket_component`")

        resource_path = '/project/{id_or_name}/ticket/component/{component_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'component_id' in params:
            path_params['component_id'] = params['component_id']

        query_params = {}
        if 'migrate_to' in params:
            query_params['migrate_to'] = params['migrate_to']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_project_ticket_milestone(self, id_or_name, milestone_id, **kwargs):
        """
        
        Delete project ticket milestone

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_ticket_milestone(id_or_name, milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int milestone_id: numeric project ticket milestone id (required)
        :param int migrate_to: Tickets that assigned to delete target will be migrate to the ticket milestone_id
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_project_ticket_milestone_with_http_info(id_or_name, milestone_id, **kwargs)
        else:
            (data) = self.delete_project_ticket_milestone_with_http_info(id_or_name, milestone_id, **kwargs)
            return data

    def delete_project_ticket_milestone_with_http_info(self, id_or_name, milestone_id, **kwargs):
        """
        
        Delete project ticket milestone

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_ticket_milestone_with_http_info(id_or_name, milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int milestone_id: numeric project ticket milestone id (required)
        :param int migrate_to: Tickets that assigned to delete target will be migrate to the ticket milestone_id
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'milestone_id', 'migrate_to']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_ticket_milestone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_project_ticket_milestone`")
        # verify the required parameter 'milestone_id' is set
        if ('milestone_id' not in params) or (params['milestone_id'] is None):
            raise ValueError("Missing the required parameter `milestone_id` when calling `delete_project_ticket_milestone`")

        resource_path = '/project/{id_or_name}/ticket/milestone/{milestone_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'milestone_id' in params:
            path_params['milestone_id'] = params['milestone_id']

        query_params = {}
        if 'migrate_to' in params:
            query_params['migrate_to'] = params['migrate_to']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_project_ticket_type(self, id_or_name, type_id, migrate_to, **kwargs):
        """
        
        Delete project ticket type

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_ticket_type(id_or_name, type_id, migrate_to, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param int migrate_to: Tickets that assigned to delete target will be migrate to the ticket type_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_project_ticket_type_with_http_info(id_or_name, type_id, migrate_to, **kwargs)
        else:
            (data) = self.delete_project_ticket_type_with_http_info(id_or_name, type_id, migrate_to, **kwargs)
            return data

    def delete_project_ticket_type_with_http_info(self, id_or_name, type_id, migrate_to, **kwargs):
        """
        
        Delete project ticket type

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_ticket_type_with_http_info(id_or_name, type_id, migrate_to, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param int migrate_to: Tickets that assigned to delete target will be migrate to the ticket type_id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'type_id', 'migrate_to']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_ticket_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_project_ticket_type`")
        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `delete_project_ticket_type`")
        # verify the required parameter 'migrate_to' is set
        if ('migrate_to' not in params) or (params['migrate_to'] is None):
            raise ValueError("Missing the required parameter `migrate_to` when calling `delete_project_ticket_type`")

        resource_path = '/project/{id_or_name}/ticket/type/{type_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'type_id' in params:
            path_params['type_id'] = params['type_id']

        query_params = {}
        if 'migrate_to' in params:
            query_params['migrate_to'] = params['migrate_to']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_project_ticket_type_instruction(self, id_or_name, type_id, language_code, **kwargs):
        """
        
        Delete project ticket type instructions on the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_ticket_type_instruction(id_or_name, type_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_project_ticket_type_instruction_with_http_info(id_or_name, type_id, language_code, **kwargs)
        else:
            (data) = self.delete_project_ticket_type_instruction_with_http_info(id_or_name, type_id, language_code, **kwargs)
            return data

    def delete_project_ticket_type_instruction_with_http_info(self, id_or_name, type_id, language_code, **kwargs):
        """
        
        Delete project ticket type instructions on the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_project_ticket_type_instruction_with_http_info(id_or_name, type_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'type_id', 'language_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_ticket_type_instruction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_project_ticket_type_instruction`")
        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `delete_project_ticket_type_instruction`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_project_ticket_type_instruction`")

        resource_path = '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'type_id' in params:
            path_params['type_id'] = params['type_id']
        if 'language_code' in params:
            path_params['language_code'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_release(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Delete target release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_release(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
        else:
            (data) = self.delete_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
            return data

    def delete_release_with_http_info(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Delete target release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_release_with_http_info(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `delete_release`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `delete_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def delete_release_file(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Delete target file.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_release_file(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
        else:
            (data) = self.delete_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
            return data

    def delete_release_file_with_http_info(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Delete target file.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_release_file_with_http_info(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'file_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_release_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `delete_release_file`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `delete_release_file`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `delete_release_file`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `delete_release_file`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']
        if 'file_id' in params:
            path_params['file_id'] = params['file_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def disable_project_bzr(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a bzr repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_bzr(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.disable_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def disable_project_bzr_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a bzr repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_bzr_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `disable_project_bzr`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `disable_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectBzr',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def disable_project_git(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a git repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_git(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_project_git_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.disable_project_git_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def disable_project_git_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a git repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_git_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `disable_project_git`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `disable_project_git`")

        resource_path = '/project/{id_or_name}/git/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectGit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def disable_project_hg(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a hg repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_hg(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.disable_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.disable_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def disable_project_hg_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Disable a hg repository (not an actual delete, just a shorthand for updating with active=false)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.disable_project_hg_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method disable_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `disable_project_hg`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `disable_project_hg`")

        resource_path = '/project/{id_or_name}/hg/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectHg',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def draft_release(self, id_or_name, package_id, **kwargs):
        """
        
        Get release draft in specified package. If draft is not exist, it will be created automatically.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.draft_release(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.draft_release_with_http_info(id_or_name, package_id, **kwargs)
        else:
            (data) = self.draft_release_with_http_info(id_or_name, package_id, **kwargs)
            return data

    def draft_release_with_http_info(self, id_or_name, package_id, **kwargs):
        """
        
        Get release draft in specified package. If draft is not exist, it will be created automatically.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.draft_release_with_http_info(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method draft_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `draft_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `draft_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/draft'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Release',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_frs_adminprefs(self, id_or_name, **kwargs):
        """
        
        Get project frs admin preferences.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_frs_adminprefs(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: FrsAdminPrefs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_frs_adminprefs_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_frs_adminprefs_with_http_info(id_or_name, **kwargs)
            return data

    def get_frs_adminprefs_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project frs admin preferences.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_frs_adminprefs_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: FrsAdminPrefs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_frs_adminprefs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_frs_adminprefs`")

        resource_path = '/project/{id_or_name}/frs/admin'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FrsAdminPrefs',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_news(self, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_news_with_http_info(news_id, **kwargs)
        else:
            (data) = self.get_news_with_http_info(news_id, **kwargs)
            return data

    def get_news_with_http_info(self, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_with_http_info(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `get_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_news_0(self, id_or_name, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_0(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_news_0_with_http_info(id_or_name, news_id, **kwargs)
        else:
            (data) = self.get_news_0_with_http_info(id_or_name, news_id, **kwargs)
            return data

    def get_news_0_with_http_info(self, id_or_name, news_id, **kwargs):
        """
        
        Get single news object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_news_0_with_http_info(id_or_name, news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int news_id:  (required)
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'news_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_news_0`")
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `get_news_0`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_package(self, id_or_name, package_id, **kwargs):
        """
        
        Get specified package info and release list of the package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_package_with_http_info(id_or_name, package_id, **kwargs)
        else:
            (data) = self.get_package_with_http_info(id_or_name, package_id, **kwargs)
            return data

    def get_package_with_http_info(self, id_or_name, package_id, **kwargs):
        """
        
        Get specified package info and release list of the package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_package_with_http_info(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_package`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `get_package`")

        resource_path = '/project/{id_or_name}/frs/{package_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Package',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project(self, id_or_name, **kwargs):
        """
        
        Get project info.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_project_with_http_info(id_or_name, **kwargs)
            return data

    def get_project_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project info.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project`")

        resource_path = '/project/{id_or_name}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Group',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_admin_projectweb(self, id_or_name, **kwargs):
        """
        
        Get project homepage url

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_admin_projectweb(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: ProjectWeb
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_admin_projectweb_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_project_admin_projectweb_with_http_info(id_or_name, **kwargs)
            return data

    def get_project_admin_projectweb_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project homepage url

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_admin_projectweb_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: ProjectWeb
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_admin_projectweb" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_admin_projectweb`")

        resource_path = '/project/{id_or_name}/admin/project_web'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectWeb',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_bzr(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_bzr(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.get_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def get_project_bzr_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_bzr_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_bzr`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectBzr',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_git(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_git(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_git_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.get_project_git_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def get_project_git_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_git_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_git`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_project_git`")

        resource_path = '/project/{id_or_name}/git/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectGit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_git_hook(self, id_or_name, repo_id, hook_id, **kwargs):
        """
        
        Get a repository hook

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_git_hook(id_or_name, repo_id, hook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param int hook_id:  (required)
        :return: ScmHook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, **kwargs)
        else:
            (data) = self.get_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, **kwargs)
            return data

    def get_project_git_hook_with_http_info(self, id_or_name, repo_id, hook_id, **kwargs):
        """
        
        Get a repository hook

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_git_hook_with_http_info(id_or_name, repo_id, hook_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param int hook_id:  (required)
        :return: ScmHook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'hook_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_git_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_git_hook`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_project_git_hook`")
        # verify the required parameter 'hook_id' is set
        if ('hook_id' not in params) or (params['hook_id'] is None):
            raise ValueError("Missing the required parameter `hook_id` when calling `get_project_git_hook`")

        resource_path = '/project/{id_or_name}/git/{repo_id}/hooks/{hook_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']
        if 'hook_id' in params:
            path_params['hook_id'] = params['hook_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScmHook',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_hg(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_hg(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.get_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def get_project_hg_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Get a hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_hg_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_hg`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `get_project_hg`")

        resource_path = '/project/{id_or_name}/hg/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectHg',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_histories(self, id_or_name, **kwargs):
        """
        
        Get project histories.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_histories(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[History]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_histories_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_project_histories_with_http_info(id_or_name, **kwargs)
            return data

    def get_project_histories_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project histories.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_histories_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[History]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_histories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_histories`")

        resource_path = '/project/{id_or_name}/history'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[History]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_profile(self, id_or_name, language_code, **kwargs):
        """
        
        Get project profile on the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_profile(id_or_name, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :return: GroupProfilePerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_profile_with_http_info(id_or_name, language_code, **kwargs)
        else:
            (data) = self.get_project_profile_with_http_info(id_or_name, language_code, **kwargs)
            return data

    def get_project_profile_with_http_info(self, id_or_name, language_code, **kwargs):
        """
        
        Get project profile on the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_profile_with_http_info(id_or_name, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :return: GroupProfilePerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'language_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_profile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_profile`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_project_profile`")

        resource_path = '/project/{id_or_name}/admin/profile/{language_code}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'language_code' in params:
            path_params['language_code'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupProfilePerLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_profile_list(self, id_or_name, **kwargs):
        """
        
        Get project profile in all languages

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_profile_list(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: GroupProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_profile_list_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_project_profile_list_with_http_info(id_or_name, **kwargs)
            return data

    def get_project_profile_list_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project profile in all languages

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_profile_list_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: GroupProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_profile_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_profile_list`")

        resource_path = '/project/{id_or_name}/admin/profile'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_svn(self, id_or_name, **kwargs):
        """
        
        Get Subversion repository of the project

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_svn(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: ProjectSvn
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_svn_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_project_svn_with_http_info(id_or_name, **kwargs)
            return data

    def get_project_svn_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get Subversion repository of the project

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_svn_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: ProjectSvn
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_svn" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_svn`")

        resource_path = '/project/{id_or_name}/svn'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectSvn',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_ticket(self, id_or_name, ticket_id, **kwargs):
        """
        
        Get project ticket

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket(id_or_name, ticket_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :return: ProjectTicketItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_ticket_with_http_info(id_or_name, ticket_id, **kwargs)
        else:
            (data) = self.get_project_ticket_with_http_info(id_or_name, ticket_id, **kwargs)
            return data

    def get_project_ticket_with_http_info(self, id_or_name, ticket_id, **kwargs):
        """
        
        Get project ticket

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_with_http_info(id_or_name, ticket_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :return: ProjectTicketItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'ticket_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_ticket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_ticket`")
        # verify the required parameter 'ticket_id' is set
        if ('ticket_id' not in params) or (params['ticket_id'] is None):
            raise ValueError("Missing the required parameter `ticket_id` when calling `get_project_ticket`")

        resource_path = '/project/{id_or_name}/ticket/{ticket_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'ticket_id' in params:
            path_params['ticket_id'] = params['ticket_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketItem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_ticket_component(self, id_or_name, component_id, **kwargs):
        """
        
        Get project ticket component

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_component(id_or_name, component_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int component_id: numeric project ticket component id (required)
        :return: ProjectTicketComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_ticket_component_with_http_info(id_or_name, component_id, **kwargs)
        else:
            (data) = self.get_project_ticket_component_with_http_info(id_or_name, component_id, **kwargs)
            return data

    def get_project_ticket_component_with_http_info(self, id_or_name, component_id, **kwargs):
        """
        
        Get project ticket component

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_component_with_http_info(id_or_name, component_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int component_id: numeric project ticket component id (required)
        :return: ProjectTicketComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'component_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_ticket_component" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_ticket_component`")
        # verify the required parameter 'component_id' is set
        if ('component_id' not in params) or (params['component_id'] is None):
            raise ValueError("Missing the required parameter `component_id` when calling `get_project_ticket_component`")

        resource_path = '/project/{id_or_name}/ticket/component/{component_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'component_id' in params:
            path_params['component_id'] = params['component_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketComponent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_ticket_milestone(self, id_or_name, milestone_id, **kwargs):
        """
        
        Get project ticket milestone of spscified milestone_id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_milestone(id_or_name, milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int milestone_id: numeric project ticket milestone id (required)
        :return: ProjectTicketMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_ticket_milestone_with_http_info(id_or_name, milestone_id, **kwargs)
        else:
            (data) = self.get_project_ticket_milestone_with_http_info(id_or_name, milestone_id, **kwargs)
            return data

    def get_project_ticket_milestone_with_http_info(self, id_or_name, milestone_id, **kwargs):
        """
        
        Get project ticket milestone of spscified milestone_id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_milestone_with_http_info(id_or_name, milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int milestone_id: numeric project ticket milestone id (required)
        :return: ProjectTicketMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'milestone_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_ticket_milestone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_ticket_milestone`")
        # verify the required parameter 'milestone_id' is set
        if ('milestone_id' not in params) or (params['milestone_id'] is None):
            raise ValueError("Missing the required parameter `milestone_id` when calling `get_project_ticket_milestone`")

        resource_path = '/project/{id_or_name}/ticket/milestone/{milestone_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'milestone_id' in params:
            path_params['milestone_id'] = params['milestone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketMilestone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_ticket_type(self, id_or_name, type_id, **kwargs):
        """
        
        Get project ticket type

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_type(id_or_name, type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :return: ProjectTicketType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_ticket_type_with_http_info(id_or_name, type_id, **kwargs)
        else:
            (data) = self.get_project_ticket_type_with_http_info(id_or_name, type_id, **kwargs)
            return data

    def get_project_ticket_type_with_http_info(self, id_or_name, type_id, **kwargs):
        """
        
        Get project ticket type

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_type_with_http_info(id_or_name, type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :return: ProjectTicketType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'type_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_ticket_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_ticket_type`")
        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `get_project_ticket_type`")

        resource_path = '/project/{id_or_name}/ticket/type/{type_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'type_id' in params:
            path_params['type_id'] = params['type_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketType',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_ticket_type_instruction(self, id_or_name, type_id, language_code, **kwargs):
        """
        
        Get project ticket type instructions on the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_type_instruction(id_or_name, type_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :return: ProjectTicketTypeInstructionPerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_ticket_type_instruction_with_http_info(id_or_name, type_id, language_code, **kwargs)
        else:
            (data) = self.get_project_ticket_type_instruction_with_http_info(id_or_name, type_id, language_code, **kwargs)
            return data

    def get_project_ticket_type_instruction_with_http_info(self, id_or_name, type_id, language_code, **kwargs):
        """
        
        Get project ticket type instructions on the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_type_instruction_with_http_info(id_or_name, type_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :return: ProjectTicketTypeInstructionPerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'type_id', 'language_code']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_ticket_type_instruction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_ticket_type_instruction`")
        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `get_project_ticket_type_instruction`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_project_ticket_type_instruction`")

        resource_path = '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'type_id' in params:
            path_params['type_id'] = params['type_id']
        if 'language_code' in params:
            path_params['language_code'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketTypeInstructionPerLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_ticket_type_instruction_0(self, id_or_name, type_id, language_code, instruction, **kwargs):
        """
        
        Update project ticket type instructions on the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_type_instruction_0(id_or_name, type_id, language_code, instruction, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :param str instruction: Ticket submit instruction for the type (required)
        :return: ProjectTicketTypeInstructionPerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_ticket_type_instruction_0_with_http_info(id_or_name, type_id, language_code, instruction, **kwargs)
        else:
            (data) = self.get_project_ticket_type_instruction_0_with_http_info(id_or_name, type_id, language_code, instruction, **kwargs)
            return data

    def get_project_ticket_type_instruction_0_with_http_info(self, id_or_name, type_id, language_code, instruction, **kwargs):
        """
        
        Update project ticket type instructions on the language

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_ticket_type_instruction_0_with_http_info(id_or_name, type_id, language_code, instruction, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :param str instruction: Ticket submit instruction for the type (required)
        :return: ProjectTicketTypeInstructionPerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'type_id', 'language_code', 'instruction']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_ticket_type_instruction_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_ticket_type_instruction_0`")
        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `get_project_ticket_type_instruction_0`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_project_ticket_type_instruction_0`")
        # verify the required parameter 'instruction' is set
        if ('instruction' not in params) or (params['instruction'] is None):
            raise ValueError("Missing the required parameter `instruction` when calling `get_project_ticket_type_instruction_0`")

        resource_path = '/project/{id_or_name}/ticket/type/{type_id}/instruction/{language_code}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'type_id' in params:
            path_params['type_id'] = params['type_id']
        if 'language_code' in params:
            path_params['language_code'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'instruction' in params:
            form_params.append(('instruction', params['instruction']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketTypeInstructionPerLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_project_tools(self, id_or_name, **kwargs):
        """
        
        Get project tools info.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_tools(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: GroupToolFlags
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_project_tools_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.get_project_tools_with_http_info(id_or_name, **kwargs)
            return data

    def get_project_tools_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project tools info.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_project_tools_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: GroupToolFlags
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_tools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_project_tools`")

        resource_path = '/project/{id_or_name}/admin/tools'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupToolFlags',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_release(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Get specified release info and file list of the release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_release(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
        else:
            (data) = self.get_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
            return data

    def get_release_with_http_info(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Get specified release info and file list of the release.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_release_with_http_info(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `get_release`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `get_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Release',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def get_release_file(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Get single file object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_release_file(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
        else:
            (data) = self.get_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
            return data

    def get_release_file_with_http_info(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Get single file object.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_release_file_with_http_info(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'file_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_release_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `get_release_file`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `get_release_file`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `get_release_file`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `get_release_file`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']
        if 'file_id' in params:
            path_params['file_id'] = params['file_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RelFile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_news(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int group_id: filter by group ID
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_news_with_http_info(**kwargs)
        else:
            (data) = self.list_news_with_http_info(**kwargs)
            return data

    def list_news_with_http_info(self, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int group_id: filter by group ID
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_news" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/news'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'group_id' in params:
            query_params['group_id'] = params['group_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[News]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_news_0(self, id_or_name, **kwargs):
        """
        
        Get news list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_0(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_news_0_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_news_0_with_http_info(id_or_name, **kwargs)
            return data

    def list_news_0_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get news list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_news_0_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_news_0`")

        resource_path = '/project/{id_or_name}/news'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[News]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_packages(self, id_or_name, **kwargs):
        """
        
        Get package list of specified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_packages(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[Package]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_packages_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_packages_with_http_info(id_or_name, **kwargs)
            return data

    def list_packages_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get package list of specified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_packages_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[Package]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_packages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_packages`")

        resource_path = '/project/{id_or_name}/frs'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Package]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_bzr(self, id_or_name, **kwargs):
        """
        
        Get Bazzar repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_bzr(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectBzr]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_bzr_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_bzr_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_bzr_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get Bazzar repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_bzr_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectBzr]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectBzr]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_git(self, id_or_name, **kwargs):
        """
        
        Get git repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_git(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectGit]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_git_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_git_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_git_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get git repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_git_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectGit]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_git`")

        resource_path = '/project/{id_or_name}/git'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectGit]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_git_hook(self, id_or_name, repo_id, **kwargs):
        """
        
        Get Git repository hook list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_git_hook(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: list[ScmHook]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_git_hook_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.list_project_git_hook_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def list_project_git_hook_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Get Git repository hook list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_git_hook_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :return: list[ScmHook]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_git_hook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_git_hook`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `list_project_git_hook`")

        resource_path = '/project/{id_or_name}/git/{repo_id}/hooks'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ScmHook]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_hg(self, id_or_name, **kwargs):
        """
        
        Get Mercurial repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_hg(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectHg]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_hg_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_hg_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_hg_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get Mercurial repository list

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_hg_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectHg]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_hg`")

        resource_path = '/project/{id_or_name}/hg'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectHg]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_ticket(self, id_or_name, **kwargs):
        """
        
        List project ticket order by submit date descending

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param list[str] status: Tickets are assigned to these type_ids
        :param list[int] type_id: Listing tickets are assigned to these type_ids
        :param list[int] not_type_id: Listing tickets are NOT assigned to these type_ids
        :param list[int] component_id: Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
        :param list[int] not_component_id: Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
        :param list[int] milestone_id: Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id = 0)
        :param list[int] not_milestone_id: Listing tickets are NOT assigned to these milestone_ids (milestone_id = 0 means milestone not assigned)
        :param int max_priority: Listing equal or lower priority tickets
        :param int min_priority: Listing equal or higher priority tickets
        :param int priority: Listing tickets have this priority
        :param int max_severity: Listing equal or lower severity tickets
        :param int min_severity: Listing equal or higher severity tickets
        :param int severity: Listing tickets have this severity
        :param list[int] owner: Listing tickets assigned to these owners (owner = 100 means owner is not assigned)
        :param list[int] not_owner: Listing tickets NOT assigned to these owners (owner = 100 means owner is not assigned)
        :param list[int] reporter: Listing tickets reported by these users (report = 100 means reported by non login user)
        :param list[int] not_reporter: Listing tickets reported by these users (report = 100 means reported by non login user)
        :param str text: Listing tickets title or description or comment include the text
        :return: list[ProjectTicketItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_ticket_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_ticket_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_ticket_with_http_info(self, id_or_name, **kwargs):
        """
        
        List project ticket order by submit date descending

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param list[str] status: Tickets are assigned to these type_ids
        :param list[int] type_id: Listing tickets are assigned to these type_ids
        :param list[int] not_type_id: Listing tickets are NOT assigned to these type_ids
        :param list[int] component_id: Listing tickets are assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
        :param list[int] not_component_id: Listing tickets are NOT assigned to these component_ids (If you want to indicate component is not assigned, please use component_id = 0)
        :param list[int] milestone_id: Listing tickets are assigned to these milestone_ids (If you want to indicate milestone is not assigned, please use milestone_id = 0)
        :param list[int] not_milestone_id: Listing tickets are NOT assigned to these milestone_ids (milestone_id = 0 means milestone not assigned)
        :param int max_priority: Listing equal or lower priority tickets
        :param int min_priority: Listing equal or higher priority tickets
        :param int priority: Listing tickets have this priority
        :param int max_severity: Listing equal or lower severity tickets
        :param int min_severity: Listing equal or higher severity tickets
        :param int severity: Listing tickets have this severity
        :param list[int] owner: Listing tickets assigned to these owners (owner = 100 means owner is not assigned)
        :param list[int] not_owner: Listing tickets NOT assigned to these owners (owner = 100 means owner is not assigned)
        :param list[int] reporter: Listing tickets reported by these users (report = 100 means reported by non login user)
        :param list[int] not_reporter: Listing tickets reported by these users (report = 100 means reported by non login user)
        :param str text: Listing tickets title or description or comment include the text
        :return: list[ProjectTicketItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'status', 'type_id', 'not_type_id', 'component_id', 'not_component_id', 'milestone_id', 'not_milestone_id', 'max_priority', 'min_priority', 'priority', 'max_severity', 'min_severity', 'severity', 'owner', 'not_owner', 'reporter', 'not_reporter', 'text']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_ticket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_ticket`")

        if 'max_priority' in params and params['max_priority'] > 9.0:
            raise ValueError("Invalid value for parameter `max_priority` when calling `list_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'max_priority' in params and params['max_priority'] < 1.0:
            raise ValueError("Invalid value for parameter `max_priority` when calling `list_project_ticket`, must be a value greater than or equal to `1.0`")
        if 'min_priority' in params and params['min_priority'] > 9.0:
            raise ValueError("Invalid value for parameter `min_priority` when calling `list_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'min_priority' in params and params['min_priority'] < 1.0:
            raise ValueError("Invalid value for parameter `min_priority` when calling `list_project_ticket`, must be a value greater than or equal to `1.0`")
        if 'priority' in params and params['priority'] > 9.0:
            raise ValueError("Invalid value for parameter `priority` when calling `list_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'priority' in params and params['priority'] < 1.0:
            raise ValueError("Invalid value for parameter `priority` when calling `list_project_ticket`, must be a value greater than or equal to `1.0`")
        if 'max_severity' in params and params['max_severity'] > 9.0:
            raise ValueError("Invalid value for parameter `max_severity` when calling `list_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'max_severity' in params and params['max_severity'] < 1.0:
            raise ValueError("Invalid value for parameter `max_severity` when calling `list_project_ticket`, must be a value greater than or equal to `1.0`")
        if 'min_severity' in params and params['min_severity'] > 9.0:
            raise ValueError("Invalid value for parameter `min_severity` when calling `list_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'min_severity' in params and params['min_severity'] < 1.0:
            raise ValueError("Invalid value for parameter `min_severity` when calling `list_project_ticket`, must be a value greater than or equal to `1.0`")
        if 'severity' in params and params['severity'] > 9.0:
            raise ValueError("Invalid value for parameter `severity` when calling `list_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'severity' in params and params['severity'] < 1.0:
            raise ValueError("Invalid value for parameter `severity` when calling `list_project_ticket`, must be a value greater than or equal to `1.0`")
        resource_path = '/project/{id_or_name}/ticket'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}
        if 'status' in params:
            query_params['status'] = params['status']
        if 'type_id' in params:
            query_params['type_id'] = params['type_id']
        if 'not_type_id' in params:
            query_params['not_type_id'] = params['not_type_id']
        if 'component_id' in params:
            query_params['component_id'] = params['component_id']
        if 'not_component_id' in params:
            query_params['not_component_id'] = params['not_component_id']
        if 'milestone_id' in params:
            query_params['milestone_id'] = params['milestone_id']
        if 'not_milestone_id' in params:
            query_params['not_milestone_id'] = params['not_milestone_id']
        if 'max_priority' in params:
            query_params['max_priority'] = params['max_priority']
        if 'min_priority' in params:
            query_params['min_priority'] = params['min_priority']
        if 'priority' in params:
            query_params['priority'] = params['priority']
        if 'max_severity' in params:
            query_params['max_severity'] = params['max_severity']
        if 'min_severity' in params:
            query_params['min_severity'] = params['min_severity']
        if 'severity' in params:
            query_params['severity'] = params['severity']
        if 'owner' in params:
            query_params['owner'] = params['owner']
        if 'not_owner' in params:
            query_params['not_owner'] = params['not_owner']
        if 'reporter' in params:
            query_params['reporter'] = params['reporter']
        if 'not_reporter' in params:
            query_params['not_reporter'] = params['not_reporter']
        if 'text' in params:
            query_params['text'] = params['text']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectTicketItem]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_ticket_comment(self, id_or_name, ticket_id, **kwargs):
        """
        
        Get project ticket comment list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_comment(id_or_name, ticket_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :return: list[ProjectTicketComment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_ticket_comment_with_http_info(id_or_name, ticket_id, **kwargs)
        else:
            (data) = self.list_project_ticket_comment_with_http_info(id_or_name, ticket_id, **kwargs)
            return data

    def list_project_ticket_comment_with_http_info(self, id_or_name, ticket_id, **kwargs):
        """
        
        Get project ticket comment list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_comment_with_http_info(id_or_name, ticket_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :return: list[ProjectTicketComment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'ticket_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_ticket_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_ticket_comment`")
        # verify the required parameter 'ticket_id' is set
        if ('ticket_id' not in params) or (params['ticket_id'] is None):
            raise ValueError("Missing the required parameter `ticket_id` when calling `list_project_ticket_comment`")

        resource_path = '/project/{id_or_name}/ticket/{ticket_id}/comment'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'ticket_id' in params:
            path_params['ticket_id'] = params['ticket_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectTicketComment]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_ticket_component(self, id_or_name, **kwargs):
        """
        
        Get project ticket component list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_component(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectTicketComponent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_ticket_component_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_ticket_component_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_ticket_component_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project ticket component list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_component_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectTicketComponent]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_ticket_component" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_ticket_component`")

        resource_path = '/project/{id_or_name}/ticket/component'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectTicketComponent]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_ticket_milestone(self, id_or_name, **kwargs):
        """
        
        Get project ticket milestone list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_milestone(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectTicketMilestone]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_ticket_milestone_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_ticket_milestone_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_ticket_milestone_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project ticket milestone list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_milestone_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectTicketMilestone]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_ticket_milestone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_ticket_milestone`")

        resource_path = '/project/{id_or_name}/ticket/milestone'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectTicketMilestone]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_ticket_type(self, id_or_name, **kwargs):
        """
        
        Get project ticket type list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_type(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectTicketType]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_ticket_type_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.list_project_ticket_type_with_http_info(id_or_name, **kwargs)
            return data

    def list_project_ticket_type_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project ticket type list of spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_type_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: list[ProjectTicketType]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_ticket_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_ticket_type`")

        resource_path = '/project/{id_or_name}/ticket/type'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[ProjectTicketType]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def list_project_ticket_type_instruction(self, id_or_name, type_id, **kwargs):
        """
        
        Get project ticket type instructions

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_type_instruction(id_or_name, type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :return: ProjectTicketTypeInstructions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_project_ticket_type_instruction_with_http_info(id_or_name, type_id, **kwargs)
        else:
            (data) = self.list_project_ticket_type_instruction_with_http_info(id_or_name, type_id, **kwargs)
            return data

    def list_project_ticket_type_instruction_with_http_info(self, id_or_name, type_id, **kwargs):
        """
        
        Get project ticket type instructions

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_project_ticket_type_instruction_with_http_info(id_or_name, type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :return: ProjectTicketTypeInstructions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'type_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_project_ticket_type_instruction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `list_project_ticket_type_instruction`")
        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `list_project_ticket_type_instruction`")

        resource_path = '/project/{id_or_name}/ticket/type/{type_id}/instruction'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'type_id' in params:
            path_params['type_id'] = params['type_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketTypeInstructions',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def show_project_ticket_adminprefs(self, id_or_name, **kwargs):
        """
        
        Get project ticket admin preferences.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_project_ticket_adminprefs(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: ProjectTicketPrefs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.show_project_ticket_adminprefs_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.show_project_ticket_adminprefs_with_http_info(id_or_name, **kwargs)
            return data

    def show_project_ticket_adminprefs_with_http_info(self, id_or_name, **kwargs):
        """
        
        Get project ticket admin preferences.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_project_ticket_adminprefs_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :return: ProjectTicketPrefs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_project_ticket_adminprefs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `show_project_ticket_adminprefs`")

        resource_path = '/project/{id_or_name}/ticket/admin'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketPrefs',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def show_project_ticket_comment(self, id_or_name, ticket_id, comment_id, **kwargs):
        """
        
        Get project ticket comment spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_project_ticket_comment(id_or_name, ticket_id, comment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :param int comment_id: numeric project ticket comment id (required)
        :return: ProjectTicketComment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.show_project_ticket_comment_with_http_info(id_or_name, ticket_id, comment_id, **kwargs)
        else:
            (data) = self.show_project_ticket_comment_with_http_info(id_or_name, ticket_id, comment_id, **kwargs)
            return data

    def show_project_ticket_comment_with_http_info(self, id_or_name, ticket_id, comment_id, **kwargs):
        """
        
        Get project ticket comment spscified project.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.show_project_ticket_comment_with_http_info(id_or_name, ticket_id, comment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :param int comment_id: numeric project ticket comment id (required)
        :return: ProjectTicketComment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'ticket_id', 'comment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method show_project_ticket_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `show_project_ticket_comment`")
        # verify the required parameter 'ticket_id' is set
        if ('ticket_id' not in params) or (params['ticket_id'] is None):
            raise ValueError("Missing the required parameter `ticket_id` when calling `show_project_ticket_comment`")
        # verify the required parameter 'comment_id' is set
        if ('comment_id' not in params) or (params['comment_id'] is None):
            raise ValueError("Missing the required parameter `comment_id` when calling `show_project_ticket_comment`")

        resource_path = '/project/{id_or_name}/ticket/{ticket_id}/comment/{comment_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'ticket_id' in params:
            path_params['ticket_id'] = params['ticket_id']
        if 'comment_id' in params:
            path_params['comment_id'] = params['comment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketComment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_frs_adminprefs(self, id_or_name, **kwargs):
        """
        
        Update project frs admin preferences.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_frs_adminprefs(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param bool allow_overwrite: Allow overwrite files when filenames are conflict
        :return: FrsAdminPrefs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_frs_adminprefs_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.update_frs_adminprefs_with_http_info(id_or_name, **kwargs)
            return data

    def update_frs_adminprefs_with_http_info(self, id_or_name, **kwargs):
        """
        
        Update project frs admin preferences.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_frs_adminprefs_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param bool allow_overwrite: Allow overwrite files when filenames are conflict
        :return: FrsAdminPrefs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'allow_overwrite']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_frs_adminprefs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_frs_adminprefs`")

        resource_path = '/project/{id_or_name}/frs/admin'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'allow_overwrite' in params:
            form_params.append(('allow_overwrite', params['allow_overwrite']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FrsAdminPrefs',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_news(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_news_with_http_info(news_id, **kwargs)
        else:
            (data) = self.update_news_with_http_info(news_id, **kwargs)
            return data

    def update_news_with_http_info(self, news_id, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_with_http_info(news_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id', 'title', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `update_news`")

        resource_path = '/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_news_0(self, news_id, id_or_name, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_0(news_id, id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_news_0_with_http_info(news_id, id_or_name, **kwargs)
        else:
            (data) = self.update_news_0_with_http_info(news_id, id_or_name, **kwargs)
            return data

    def update_news_0_with_http_info(self, news_id, id_or_name, **kwargs):
        """
        
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_news_0_with_http_info(news_id, id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int news_id:  (required)
        :param str id_or_name: numeric project id or project name (required)
        :param str title: news title
        :param str body: news body in OSDN Wiki format.
        :return: News
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['news_id', 'id_or_name', 'title', 'body']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_news_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'news_id' is set
        if ('news_id' not in params) or (params['news_id'] is None):
            raise ValueError("Missing the required parameter `news_id` when calling `update_news_0`")
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_news_0`")

        resource_path = '/project/{id_or_name}/news/{news_id}'.replace('{format}', 'json')
        path_params = {}
        if 'news_id' in params:
            path_params['news_id'] = params['news_id']
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'title' in params:
            form_params.append(('title', params['title']))
        if 'body' in params:
            form_params.append(('body', params['body']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='News',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_package(self, id_or_name, package_id, **kwargs):
        """
        
        Update tagret package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_package(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param str name: package name
        :param str visibility: visibility status (public, hidden or private)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_package_with_http_info(id_or_name, package_id, **kwargs)
        else:
            (data) = self.update_package_with_http_info(id_or_name, package_id, **kwargs)
            return data

    def update_package_with_http_info(self, id_or_name, package_id, **kwargs):
        """
        
        Update tagret package.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_package_with_http_info(id_or_name, package_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param str name: package name
        :param str visibility: visibility status (public, hidden or private)
        :return: Package
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'name', 'visibility']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_package" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_package`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `update_package`")

        resource_path = '/project/{id_or_name}/frs/{package_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Package',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_admin_projectweb(self, id_or_name, **kwargs):
        """
        
        Update project homepage url

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_admin_projectweb(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str homepage: Project home page full URL (should start with http:// or https://). If reset param is true, this url will be ignored (URL will be reset to default url)
        :param bool reset: Project home page URL reset to default value
        :return: ProjectWeb
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_admin_projectweb_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.update_project_admin_projectweb_with_http_info(id_or_name, **kwargs)
            return data

    def update_project_admin_projectweb_with_http_info(self, id_or_name, **kwargs):
        """
        
        Update project homepage url

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_admin_projectweb_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str homepage: Project home page full URL (should start with http:// or https://). If reset param is true, this url will be ignored (URL will be reset to default url)
        :param bool reset: Project home page URL reset to default value
        :return: ProjectWeb
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'homepage', 'reset']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_admin_projectweb" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_admin_projectweb`")

        resource_path = '/project/{id_or_name}/admin/project_web'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'homepage' in params:
            form_params.append(('homepage', params['homepage']))
        if 'reset' in params:
            form_params.append(('reset', params['reset']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectWeb',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_bzr(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_bzr(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param bool active: 
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.update_project_bzr_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def update_project_bzr_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a bzr repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_bzr_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param bool active: 
        :return: ProjectBzr
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'description', 'active']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_bzr" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_bzr`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `update_project_bzr`")

        resource_path = '/project/{id_or_name}/bzr/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'active' in params:
            form_params.append(('active', params['active']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectBzr',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_git(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_git(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param bool mail_enabled: 
        :param str mail_recipients: 
        :param bool allow_non_fast_forward: 
        :param str default_branch: 
        :param bool active: 
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_git_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.update_project_git_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def update_project_git_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a git repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_git_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param bool mail_enabled: 
        :param str mail_recipients: 
        :param bool allow_non_fast_forward: 
        :param str default_branch: 
        :param bool active: 
        :return: ProjectGit
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'description', 'mail_enabled', 'mail_recipients', 'allow_non_fast_forward', 'default_branch', 'active']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_git" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_git`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `update_project_git`")

        resource_path = '/project/{id_or_name}/git/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'mail_enabled' in params:
            form_params.append(('mail_enabled', params['mail_enabled']))
        if 'mail_recipients' in params:
            form_params.append(('mail_recipients', params['mail_recipients']))
        if 'allow_non_fast_forward' in params:
            form_params.append(('allow_non_fast_forward', params['allow_non_fast_forward']))
        if 'default_branch' in params:
            form_params.append(('default_branch', params['default_branch']))
        if 'active' in params:
            form_params.append(('active', params['active']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectGit',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_hg(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_hg(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param str mail_recipients: 
        :param bool active: 
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
        else:
            (data) = self.update_project_hg_with_http_info(id_or_name, repo_id, **kwargs)
            return data

    def update_project_hg_with_http_info(self, id_or_name, repo_id, **kwargs):
        """
        
        Update a hg repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_hg_with_http_info(id_or_name, repo_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int repo_id:  (required)
        :param str description: 
        :param str mail_recipients: 
        :param bool active: 
        :return: ProjectHg
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'repo_id', 'description', 'mail_recipients', 'active']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_hg" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_hg`")
        # verify the required parameter 'repo_id' is set
        if ('repo_id' not in params) or (params['repo_id'] is None):
            raise ValueError("Missing the required parameter `repo_id` when calling `update_project_hg`")

        resource_path = '/project/{id_or_name}/hg/{repo_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'repo_id' in params:
            path_params['repo_id'] = params['repo_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'mail_recipients' in params:
            form_params.append(('mail_recipients', params['mail_recipients']))
        if 'active' in params:
            form_params.append(('active', params['active']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectHg',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_profile(self, id_or_name, language_code, **kwargs):
        """
        
        Update project profile.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_profile(id_or_name, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :param str display_name: Project display name
        :param str description: Project description
        :return: GroupProfilePerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_profile_with_http_info(id_or_name, language_code, **kwargs)
        else:
            (data) = self.update_project_profile_with_http_info(id_or_name, language_code, **kwargs)
            return data

    def update_project_profile_with_http_info(self, id_or_name, language_code, **kwargs):
        """
        
        Update project profile.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_profile_with_http_info(id_or_name, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param str language_code: Language code for display name and description (example en, ja, zh-TW) (required)
        :param str display_name: Project display name
        :param str description: Project description
        :return: GroupProfilePerLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'language_code', 'display_name', 'description']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_profile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_profile`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `update_project_profile`")

        resource_path = '/project/{id_or_name}/admin/profile/{language_code}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'language_code' in params:
            path_params['language_code'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'display_name' in params:
            form_params.append(('display_name', params['display_name']))
        if 'description' in params:
            form_params.append(('description', params['description']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupProfilePerLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_ticket(self, id_or_name, ticket_id, **kwargs):
        """
        
        Update project ticket

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket(id_or_name, ticket_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :param str name: Project ticket name (title)
        :param str description: Project ticket description details
        :param int type_id: numeric project ticket type id
        :param int milestone_id: numeric project ticket milestone id
        :param int component_id: numeric project ticket component id
        :param int priority: project ticket priority (min = 1 and max = 9)
        :param int severity: project ticket severity (min = 1 and max = 9)
        :param int owner: numeric project ticket owner user id
        :param str resolution: project ticket resolution text
        :param str status: project ticket status (open or close)
        :return: ProjectTicketItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_ticket_with_http_info(id_or_name, ticket_id, **kwargs)
        else:
            (data) = self.update_project_ticket_with_http_info(id_or_name, ticket_id, **kwargs)
            return data

    def update_project_ticket_with_http_info(self, id_or_name, ticket_id, **kwargs):
        """
        
        Update project ticket

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket_with_http_info(id_or_name, ticket_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int ticket_id: numeric project ticket id (required)
        :param str name: Project ticket name (title)
        :param str description: Project ticket description details
        :param int type_id: numeric project ticket type id
        :param int milestone_id: numeric project ticket milestone id
        :param int component_id: numeric project ticket component id
        :param int priority: project ticket priority (min = 1 and max = 9)
        :param int severity: project ticket severity (min = 1 and max = 9)
        :param int owner: numeric project ticket owner user id
        :param str resolution: project ticket resolution text
        :param str status: project ticket status (open or close)
        :return: ProjectTicketItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'ticket_id', 'name', 'description', 'type_id', 'milestone_id', 'component_id', 'priority', 'severity', 'owner', 'resolution', 'status']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_ticket" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_ticket`")
        # verify the required parameter 'ticket_id' is set
        if ('ticket_id' not in params) or (params['ticket_id'] is None):
            raise ValueError("Missing the required parameter `ticket_id` when calling `update_project_ticket`")

        if 'priority' in params and params['priority'] > 9.0:
            raise ValueError("Invalid value for parameter `priority` when calling `update_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'priority' in params and params['priority'] < 1.0:
            raise ValueError("Invalid value for parameter `priority` when calling `update_project_ticket`, must be a value greater than or equal to `1.0`")
        if 'severity' in params and params['severity'] > 9.0:
            raise ValueError("Invalid value for parameter `severity` when calling `update_project_ticket`, must be a value less than or equal to  `9.0`")
        if 'severity' in params and params['severity'] < 1.0:
            raise ValueError("Invalid value for parameter `severity` when calling `update_project_ticket`, must be a value greater than or equal to `1.0`")
        if 'owner' in params and params['owner'] < 101.0:
            raise ValueError("Invalid value for parameter `owner` when calling `update_project_ticket`, must be a value greater than or equal to `101.0`")
        resource_path = '/project/{id_or_name}/ticket/{ticket_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'ticket_id' in params:
            path_params['ticket_id'] = params['ticket_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'type_id' in params:
            form_params.append(('type_id', params['type_id']))
        if 'milestone_id' in params:
            form_params.append(('milestone_id', params['milestone_id']))
        if 'component_id' in params:
            form_params.append(('component_id', params['component_id']))
        if 'priority' in params:
            form_params.append(('priority', params['priority']))
        if 'severity' in params:
            form_params.append(('severity', params['severity']))
        if 'owner' in params:
            form_params.append(('owner', params['owner']))
        if 'resolution' in params:
            form_params.append(('resolution', params['resolution']))
        if 'status' in params:
            form_params.append(('status', params['status']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketItem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_ticket_adminprefs(self, id_or_name, **kwargs):
        """
        
        Update project ticket admin preferences.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket_adminprefs(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param bool allow_anonymouse: Non login user allows to post new ticket/comment
        :param str frs_autosync: Componet File release autosync type 'Disabled', 'Package', 'Release', 'Package and Release'
        :param str mailsend_type: Ticket update mail destination type 'None', 'Ticket Technician', 'Ticket Administrator', 'Ticket Administrator and Technician', 'All project members', 'Mailing List'
        :param int mailing_list_id: Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list)
        :param str mail_lang: Ticket update mail language
        :return: ProjectTicketPrefs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_ticket_adminprefs_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.update_project_ticket_adminprefs_with_http_info(id_or_name, **kwargs)
            return data

    def update_project_ticket_adminprefs_with_http_info(self, id_or_name, **kwargs):
        """
        
        Update project ticket admin preferences.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket_adminprefs_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param bool allow_anonymouse: Non login user allows to post new ticket/comment
        :param str frs_autosync: Componet File release autosync type 'Disabled', 'Package', 'Release', 'Package and Release'
        :param str mailsend_type: Ticket update mail destination type 'None', 'Ticket Technician', 'Ticket Administrator', 'Ticket Administrator and Technician', 'All project members', 'Mailing List'
        :param int mailing_list_id: Ticket update mail destination mail list id (it is only used when mailsend_type is mailing list)
        :param str mail_lang: Ticket update mail language
        :return: ProjectTicketPrefs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'allow_anonymouse', 'frs_autosync', 'mailsend_type', 'mailing_list_id', 'mail_lang']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_ticket_adminprefs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_ticket_adminprefs`")

        resource_path = '/project/{id_or_name}/ticket/admin'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'allow_anonymouse' in params:
            form_params.append(('allow_anonymouse', params['allow_anonymouse']))
        if 'frs_autosync' in params:
            form_params.append(('frs_autosync', params['frs_autosync']))
        if 'mailsend_type' in params:
            form_params.append(('mailsend_type', params['mailsend_type']))
        if 'mailing_list_id' in params:
            form_params.append(('mailing_list_id', params['mailing_list_id']))
        if 'mail_lang' in params:
            form_params.append(('mail_lang', params['mail_lang']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketPrefs',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_ticket_component(self, id_or_name, component_id, **kwargs):
        """
        
        Update project ticket component

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket_component(id_or_name, component_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int component_id: numeric project ticket component id (required)
        :param str name: Ticket component name
        :param str description: Ticket component description
        :param int owner: Ticket componet owner user_id
        :param bool active: Ticket componet will be shown the component select list when this parameter is true
        :return: ProjectTicketComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_ticket_component_with_http_info(id_or_name, component_id, **kwargs)
        else:
            (data) = self.update_project_ticket_component_with_http_info(id_or_name, component_id, **kwargs)
            return data

    def update_project_ticket_component_with_http_info(self, id_or_name, component_id, **kwargs):
        """
        
        Update project ticket component

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket_component_with_http_info(id_or_name, component_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int component_id: numeric project ticket component id (required)
        :param str name: Ticket component name
        :param str description: Ticket component description
        :param int owner: Ticket componet owner user_id
        :param bool active: Ticket componet will be shown the component select list when this parameter is true
        :return: ProjectTicketComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'component_id', 'name', 'description', 'owner', 'active']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_ticket_component" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_ticket_component`")
        # verify the required parameter 'component_id' is set
        if ('component_id' not in params) or (params['component_id'] is None):
            raise ValueError("Missing the required parameter `component_id` when calling `update_project_ticket_component`")

        resource_path = '/project/{id_or_name}/ticket/component/{component_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'component_id' in params:
            path_params['component_id'] = params['component_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'owner' in params:
            form_params.append(('owner', params['owner']))
        if 'active' in params:
            form_params.append(('active', params['active']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketComponent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_ticket_milestone(self, id_or_name, milestone_id, **kwargs):
        """
        
        Update project ticket milestone

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket_milestone(id_or_name, milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int milestone_id: numeric project ticket milestone id (required)
        :param str name: Ticket milestone name
        :param str description: Ticket milestone description
        :param datetime start: Ticket milestone start date
        :param datetime end: Ticket milestone due date
        :param str force_status: If you want to force close the milestone set to 'close' or reopen it set to 'reopen'
        :return: ProjectTicketComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_ticket_milestone_with_http_info(id_or_name, milestone_id, **kwargs)
        else:
            (data) = self.update_project_ticket_milestone_with_http_info(id_or_name, milestone_id, **kwargs)
            return data

    def update_project_ticket_milestone_with_http_info(self, id_or_name, milestone_id, **kwargs):
        """
        
        Update project ticket milestone

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket_milestone_with_http_info(id_or_name, milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int milestone_id: numeric project ticket milestone id (required)
        :param str name: Ticket milestone name
        :param str description: Ticket milestone description
        :param datetime start: Ticket milestone start date
        :param datetime end: Ticket milestone due date
        :param str force_status: If you want to force close the milestone set to 'close' or reopen it set to 'reopen'
        :return: ProjectTicketComponent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'milestone_id', 'name', 'description', 'start', 'end', 'force_status']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_ticket_milestone" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_ticket_milestone`")
        # verify the required parameter 'milestone_id' is set
        if ('milestone_id' not in params) or (params['milestone_id'] is None):
            raise ValueError("Missing the required parameter `milestone_id` when calling `update_project_ticket_milestone`")

        resource_path = '/project/{id_or_name}/ticket/milestone/{milestone_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'milestone_id' in params:
            path_params['milestone_id'] = params['milestone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'start' in params:
            form_params.append(('start', params['start']))
        if 'end' in params:
            form_params.append(('end', params['end']))
        if 'force_status' in params:
            form_params.append(('force_status', params['force_status']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketComponent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_ticket_type(self, id_or_name, type_id, **kwargs):
        """
        
        Update project ticket type

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket_type(id_or_name, type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str name: Ticket type name
        :param str description: Ticket type description
        :param bool is_public: if set as false, this type will be shown to project members only.
        :return: ProjectTicketType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_ticket_type_with_http_info(id_or_name, type_id, **kwargs)
        else:
            (data) = self.update_project_ticket_type_with_http_info(id_or_name, type_id, **kwargs)
            return data

    def update_project_ticket_type_with_http_info(self, id_or_name, type_id, **kwargs):
        """
        
        Update project ticket type

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_ticket_type_with_http_info(id_or_name, type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int type_id: numeric project ticket type id (required)
        :param str name: Ticket type name
        :param str description: Ticket type description
        :param bool is_public: if set as false, this type will be shown to project members only.
        :return: ProjectTicketType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'type_id', 'name', 'description', 'is_public']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_ticket_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_ticket_type`")
        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `update_project_ticket_type`")

        resource_path = '/project/{id_or_name}/ticket/type/{type_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'type_id' in params:
            path_params['type_id'] = params['type_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'description' in params:
            form_params.append(('description', params['description']))
        if 'is_public' in params:
            form_params.append(('is_public', params['is_public']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProjectTicketType',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_project_tools(self, id_or_name, **kwargs):
        """
        
        Update project tools info.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_tools(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param bool git: use git flag
        :param bool svn: use Subversion flag
        :param bool hg: use Mercurial(Hg) flag
        :param bool bzr: use Bazaar flag
        :param bool frs: use File Release flag
        :param bool ticket: use Ticket flag
        :param bool wiki: use Wiki flag
        :param bool forum: use Forum flag
        :param bool ml: use Mailing List flag
        :return: GroupToolFlags
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_project_tools_with_http_info(id_or_name, **kwargs)
        else:
            (data) = self.update_project_tools_with_http_info(id_or_name, **kwargs)
            return data

    def update_project_tools_with_http_info(self, id_or_name, **kwargs):
        """
        
        Update project tools info.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_project_tools_with_http_info(id_or_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param bool git: use git flag
        :param bool svn: use Subversion flag
        :param bool hg: use Mercurial(Hg) flag
        :param bool bzr: use Bazaar flag
        :param bool frs: use File Release flag
        :param bool ticket: use Ticket flag
        :param bool wiki: use Wiki flag
        :param bool forum: use Forum flag
        :param bool ml: use Mailing List flag
        :return: GroupToolFlags
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'git', 'svn', 'hg', 'bzr', 'frs', 'ticket', 'wiki', 'forum', 'ml']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_tools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_project_tools`")

        resource_path = '/project/{id_or_name}/admin/tools'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'git' in params:
            form_params.append(('git', params['git']))
        if 'svn' in params:
            form_params.append(('svn', params['svn']))
        if 'hg' in params:
            form_params.append(('hg', params['hg']))
        if 'bzr' in params:
            form_params.append(('bzr', params['bzr']))
        if 'frs' in params:
            form_params.append(('frs', params['frs']))
        if 'ticket' in params:
            form_params.append(('ticket', params['ticket']))
        if 'wiki' in params:
            form_params.append(('wiki', params['wiki']))
        if 'forum' in params:
            form_params.append(('forum', params['forum']))
        if 'ml' in params:
            form_params.append(('ml', params['ml']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GroupToolFlags',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_release(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Update target release. (Note: If you update draft release, the release will be public automatically.) 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_release(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param str visibility: visibility status (public, hidden or private)
        :param str name: Release name
        :param datetime time: Release datetime. If you set future time, the release hide until specified time.
        :param int move_to_package_id: If this parameter is specified, the release move to another package.
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
        else:
            (data) = self.update_release_with_http_info(id_or_name, package_id, release_id, **kwargs)
            return data

    def update_release_with_http_info(self, id_or_name, package_id, release_id, **kwargs):
        """
        
        Update target release. (Note: If you update draft release, the release will be public automatically.) 

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_release_with_http_info(id_or_name, package_id, release_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param str visibility: visibility status (public, hidden or private)
        :param str name: Release name
        :param datetime time: Release datetime. If you set future time, the release hide until specified time.
        :param int move_to_package_id: If this parameter is specified, the release move to another package.
        :return: Release
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'visibility', 'name', 'time', 'move_to_package_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_release" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_release`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `update_release`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `update_release`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))
        if 'name' in params:
            form_params.append(('name', params['name']))
        if 'time' in params:
            form_params.append(('time', params['time']))
        if 'move_to_package_id' in params:
            form_params.append(('move_to_package_id', params['move_to_package_id']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Release',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def update_release_file(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Change visibility of target file.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_release_file(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
        else:
            (data) = self.update_release_file_with_http_info(id_or_name, package_id, release_id, file_id, **kwargs)
            return data

    def update_release_file_with_http_info(self, id_or_name, package_id, release_id, file_id, **kwargs):
        """
        
        Change visibility of target file.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_release_file_with_http_info(id_or_name, package_id, release_id, file_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id_or_name: numeric project id or project name (required)
        :param int package_id:  (required)
        :param int release_id:  (required)
        :param int file_id:  (required)
        :param str visibility: visibility status (public, hidden or private)
        :return: RelFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_or_name', 'package_id', 'release_id', 'file_id', 'visibility']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_release_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_or_name' is set
        if ('id_or_name' not in params) or (params['id_or_name'] is None):
            raise ValueError("Missing the required parameter `id_or_name` when calling `update_release_file`")
        # verify the required parameter 'package_id' is set
        if ('package_id' not in params) or (params['package_id'] is None):
            raise ValueError("Missing the required parameter `package_id` when calling `update_release_file`")
        # verify the required parameter 'release_id' is set
        if ('release_id' not in params) or (params['release_id'] is None):
            raise ValueError("Missing the required parameter `release_id` when calling `update_release_file`")
        # verify the required parameter 'file_id' is set
        if ('file_id' not in params) or (params['file_id'] is None):
            raise ValueError("Missing the required parameter `file_id` when calling `update_release_file`")

        resource_path = '/project/{id_or_name}/frs/{package_id}/{release_id}/{file_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id_or_name' in params:
            path_params['id_or_name'] = params['id_or_name']
        if 'package_id' in params:
            path_params['package_id'] = params['package_id']
        if 'release_id' in params:
            path_params['release_id'] = params['release_id']
        if 'file_id' in params:
            path_params['file_id'] = params['file_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'visibility' in params:
            form_params.append(('visibility', params['visibility']))

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/x-www-form-urlencoded'])

        # Authentication setting
        auth_settings = ['oauth2-code', 'oauth2-implicit']

        return self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RelFile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
