/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

abstract class PreloadingRepositoryHandler
extends AbstractHandler {
    Object LOAD_FAMILY = new Object();

    public Object execute(ExecutionEvent event) {
        try {
            final String profileId = ProvSDKUIActivator.getSelfProfileId();
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    PreloadingRepositoryHandler.this.doExecuteAndLoad(profileId, PreloadingRepositoryHandler.this.preloadRepositories());
                }
            });
        }
        catch (ProvisionException e) {
            MessageDialog.openInformation(null, (String)ProvSDKMessages.Handler_SDKUpdateUIMessageTitle, (String)ProvSDKMessages.Handler_CannotLaunchUI);
            ProvUI.handleException((Throwable)e, null, (int)1);
        }
        return null;
    }

    void doExecuteAndLoad(final String profileId, boolean preloadRepositories) {
        Job.getJobManager().cancel(this.LOAD_FAMILY);
        final QueryableMetadataRepositoryManager queryableManager = new QueryableMetadataRepositoryManager(Policy.getDefault().getQueryContext(), false);
        if (preloadRepositories) {
            Job loadJob = new Job(ProvSDKMessages.InstallNewSoftwareHandler_LoadRepositoryJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    queryableManager.loadAll(monitor);
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family == PreloadingRepositoryHandler.this.LOAD_FAMILY;
                }
            };
            this.setLoadJobProperties(loadJob);
            if (this.waitForPreload()) {
                loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (PlatformUI.isWorkbenchRunning() && event.getResult().isOK()) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this, profileId, queryableManager){
                                final /* synthetic */ 3 this$1;
                                private final /* synthetic */ String val$profileId;
                                private final /* synthetic */ QueryableMetadataRepositoryManager val$queryableManager;
                                {
                                    this.this$1 = var1_1;
                                    this.val$profileId = string;
                                    this.val$queryableManager = queryableMetadataRepositoryManager;
                                }

                                public void run() {
                                    3.access$0(this.this$1).doExecute(this.val$profileId, this.val$queryableManager);
                                }
                            });
                        }
                    }

                    static /* synthetic */ PreloadingRepositoryHandler access$0(3 var0) {
                        return var0.PreloadingRepositoryHandler.this;
                    }
                });
                loadJob.setUser(true);
                loadJob.schedule();
            } else {
                loadJob.setSystem(true);
                loadJob.setUser(false);
                loadJob.schedule();
                this.doExecute(profileId, queryableManager);
            }
        } else {
            this.doExecute(profileId, queryableManager);
        }
    }

    protected abstract void doExecute(String var1, QueryableMetadataRepositoryManager var2);

    protected boolean preloadRepositories() {
        return true;
    }

    protected boolean waitForPreload() {
        return true;
    }

    protected void setLoadJobProperties(Job loadJob) {
    }

    protected Shell getShell() {
        return ProvUI.getDefaultParentShell();
    }
}

