/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.tasks.TaskScanningScheduler;
import org.osgi.framework.BundleContext;

public class SSECorePlugin
extends Plugin {
    static SSECorePlugin instance = null;
    public static final String ID = "org.eclipse.wst.sse.core";

    public static SSECorePlugin getDefault() {
        return instance;
    }

    public SSECorePlugin() {
        instance = this;
    }

    protected void initializeDefaultPluginPreferences() {
        Preferences prefs = SSECorePlugin.getDefault().getPluginPreferences();
        prefs.setDefault("Use3ByteBOMWithUTF8", false);
        prefs.setDefault("task-tags", false);
        prefs.setDefault("task-tag-tags", "TODO,FIXME,XXX");
        prefs.setDefault("task-tag-priorities", "1,2,1");
    }

    public void stop(BundleContext context) throws Exception {
        this.savePluginPreferences();
        ((ModelManagerImpl)ModelManagerImpl.getInstance()).removePreferenceListener();
        TaskScanningScheduler.shutdown();
        FileBufferModelManager.shutdown();
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        FileBufferModelManager.startup();
        String scan = System.getProperty("org.eclipse.wst.sse.core.taskscanner");
        if (scan == null || !scan.equalsIgnoreCase("off")) {
            TaskScanningScheduler.startup();
        }
    }

    public ModelHandlerRegistry getModelHandlerRegistry() {
        return ModelHandlerRegistry.getInstance();
    }

    public IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }
}

