/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import java.util.Stack;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.wst.sse.core.internal.IExecutionDelegate;
import org.eclipse.wst.sse.core.internal.ILockable;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.IExecutionDelegatable;

public class JobSafeStructuredDocument
extends BasicStructuredDocument
implements IExecutionDelegatable,
ILockable {
    private Stack fExecutionDelegates = new Stack();
    private ILock fLockable = Job.getJobManager().newLock();

    public JobSafeStructuredDocument() {
    }

    public JobSafeStructuredDocument(RegionParser parser) {
        super(parser);
    }

    protected final void acquireLock() {
        this.getLockObject().acquire();
    }

    private IExecutionDelegate getExecutionDelegate() {
        if (!this.fExecutionDelegates.isEmpty()) {
            return (IExecutionDelegate)this.fExecutionDelegates.peek();
        }
        return null;
    }

    public ILock getLockObject() {
        return this.fLockable;
    }

    protected final void releaseLock() {
        this.getLockObject().release();
    }

    public void replace(final int offset, final int length, final String text) throws BadLocationException {
        IExecutionDelegate delegate = this.getExecutionDelegate();
        if (delegate == null) {
            super.replace(offset, length, text);
        } else {
            final Object[] resultSlot = new Object[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        JobSafeStructuredDocument.super.replace(offset, length, text);
                    }
                    catch (Throwable e) {
                        resultSlot[0] = e;
                    }
                }
            };
            delegate.execute(runnable);
        }
    }

    public void replace(final int offset, final int length, final String text, final long modificationStamp) throws BadLocationException {
        IExecutionDelegate delegate = this.getExecutionDelegate();
        if (delegate == null) {
            super.replace(offset, length, text, modificationStamp);
        } else {
            final Object[] resultSlot = new Object[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        JobSafeStructuredDocument.super.replace(offset, length, text, modificationStamp);
                    }
                    catch (Throwable e) {
                        resultSlot[0] = e;
                    }
                }
            };
            delegate.execute(runnable);
        }
    }

    public StructuredDocumentEvent replaceText(final Object requester, final int start, final int replacementLength, final String changes) {
        StructuredDocumentEvent event = null;
        IExecutionDelegate delegate = this.getExecutionDelegate();
        if (delegate == null) {
            event = super.replaceText(requester, start, replacementLength, changes);
        } else {
            final Object[] resultSlot = new Object[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        resultSlot[0] = JobSafeStructuredDocument.super.replaceText(requester, start, replacementLength, changes);
                    }
                    catch (Throwable e) {
                        resultSlot[0] = e;
                    }
                }
            };
            delegate.execute(runnable);
            if (resultSlot[0] instanceof Throwable) {
                throw new RuntimeException((Throwable)resultSlot[0]);
            }
            event = (StructuredDocumentEvent)((Object)resultSlot[0]);
        }
        return event;
    }

    public StructuredDocumentEvent replaceText(final Object requester, final int start, final int replacementLength, final String changes, final boolean ignoreReadOnlySettings) {
        StructuredDocumentEvent event = null;
        IExecutionDelegate delegate = this.getExecutionDelegate();
        if (delegate == null) {
            event = super.replaceText(requester, start, replacementLength, changes, ignoreReadOnlySettings);
        } else {
            final Object[] resultSlot = new Object[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        resultSlot[0] = JobSafeStructuredDocument.super.replaceText(requester, start, replacementLength, changes, ignoreReadOnlySettings);
                    }
                    catch (Throwable e) {
                        resultSlot[0] = e;
                    }
                }
            };
            delegate.execute(runnable);
            if (resultSlot[0] instanceof Throwable) {
                throw new RuntimeException((Throwable)resultSlot[0]);
            }
            event = (StructuredDocumentEvent)((Object)resultSlot[0]);
        }
        return event;
    }

    public void setExecutionDelegate(IExecutionDelegate delegate) {
        if (delegate != null) {
            this.fExecutionDelegates.push(delegate);
        } else if (!this.fExecutionDelegates.isEmpty()) {
            this.fExecutionDelegates.pop();
        }
    }

    public StructuredDocumentEvent setText(final Object requester, final String theString) {
        StructuredDocumentEvent event = null;
        IExecutionDelegate executionDelegate = this.getExecutionDelegate();
        if (executionDelegate == null) {
            event = super.setText(requester, theString);
        } else {
            final Object[] resultSlot = new Object[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        resultSlot[0] = JobSafeStructuredDocument.super.setText(requester, theString);
                    }
                    catch (Throwable e) {
                        resultSlot[0] = e;
                    }
                }
            };
            executionDelegate.execute(runnable);
            if (resultSlot[0] instanceof Throwable) {
                throw new RuntimeException((Throwable)resultSlot[0]);
            }
            event = (StructuredDocumentEvent)((Object)resultSlot[0]);
        }
        return event;
    }

    public DocumentRewriteSession startRewriteSession(DocumentRewriteSessionType sessionType) throws IllegalStateException {
        DocumentRewriteSession session = null;
        IExecutionDelegate executionDelegate = this.getExecutionDelegate();
        if (executionDelegate == null) {
            session = this.internalStartRewriteSession(sessionType);
        } else {
            final Object[] resultSlot = new Object[1];
            final DocumentRewriteSessionType finalSessionType = sessionType;
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        resultSlot[0] = JobSafeStructuredDocument.this.internalStartRewriteSession(finalSessionType);
                    }
                    catch (Throwable e) {
                        resultSlot[0] = e;
                    }
                }
            };
            executionDelegate.execute(runnable);
            if (resultSlot[0] instanceof Throwable) {
                throw new RuntimeException((Throwable)resultSlot[0]);
            }
            session = (DocumentRewriteSession)resultSlot[0];
        }
        return session;
    }

    public void stopRewriteSession(DocumentRewriteSession session) {
        IExecutionDelegate executionDelegate = this.getExecutionDelegate();
        if (executionDelegate == null) {
            this.internalStopRewriteSession(session);
        } else {
            final Object[] resultSlot = new Object[1];
            final DocumentRewriteSession finalSession = session;
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        JobSafeStructuredDocument.this.internalStopRewriteSession(finalSession);
                    }
                    catch (Throwable e) {
                        resultSlot[0] = e;
                    }
                }
            };
            executionDelegate.execute(runnable);
            if (resultSlot[0] instanceof Throwable) {
                throw new RuntimeException((Throwable)resultSlot[0]);
            }
        }
    }
}

