/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.validation;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneMarkupValidator {
    private static Map<ClassLoader, Map<String, StandaloneMarkupValidator>> validatorCacheByClassLoader = new WeakHashMap<ClassLoader, Map<String, StandaloneMarkupValidator>>();
    private List<ValidationRule> rules = new ArrayList<ValidationRule>();
    private ClassLoader classLoader;
    private boolean immutable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StandaloneMarkupValidator getValidator(String markupLanguage) {
        ClassLoader classLoader = StandaloneMarkupValidator.computeClassLoader();
        Class<StandaloneMarkupValidator> clazz = StandaloneMarkupValidator.class;
        synchronized (StandaloneMarkupValidator.class) {
            StandaloneMarkupValidator validator;
            Map<String, StandaloneMarkupValidator> validatorByMarkupLanguage = validatorCacheByClassLoader.get(classLoader);
            if (validatorByMarkupLanguage == null) {
                validatorByMarkupLanguage = new HashMap<String, StandaloneMarkupValidator>();
                validatorCacheByClassLoader.put(classLoader, validatorByMarkupLanguage);
            }
            if ((validator = validatorByMarkupLanguage.get(markupLanguage)) == null) {
                validator = new StandaloneMarkupValidator();
                validator.computeRules(markupLanguage);
                validator.setImmutable();
                validatorByMarkupLanguage.put(markupLanguage, validator);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return validator;
        }
    }

    private static ClassLoader computeClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        return StandaloneMarkupValidator.class.getClassLoader();
    }

    private void setImmutable() {
        if (!this.immutable) {
            this.immutable = true;
            this.rules = Collections.unmodifiableList(this.rules);
        }
    }

    public List<ValidationProblem> validate(String markup) {
        return this.validate(markup, 0, markup.length());
    }

    public List<ValidationProblem> validate(String markup, int offset, int length) {
        if (length == 0 || this.rules.isEmpty()) {
            return Collections.emptyList();
        }
        int end = offset + length;
        if (end > markup.length()) {
            end = markup.length();
        }
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        for (ValidationRule rule : this.rules) {
            problems.addAll(rule.findProblems(markup, offset, length));
        }
        if (!problems.isEmpty()) {
            Collections.sort(problems);
        }
        return problems;
    }

    public List<ValidationRule> getRules() {
        return this.rules;
    }

    public void computeRules(String markupLanguage) {
        try {
            Enumeration<URL> resources = this.getClassLoader().getResources("plugin.xml");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.computeRules(markupLanguage, url);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public void computeRules(String markupLanguage, URL url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void computeRules(String markupLanguage, Document pluginXml) {
        Node child = pluginXml.getDocumentElement().getFirstChild();
        while (child != null) {
            Element element;
            String point;
            if (child.getNodeType() == 1 && child.getLocalName().equals("extension") && "org.eclipse.mylyn.wikitext.core.markupValidationRule".equals(point = (element = (Element)child).getAttribute("point"))) {
                Node vrNode = child.getFirstChild();
                while (vrNode != null) {
                    Element rule;
                    if (vrNode.getNodeType() == 1 && vrNode.getLocalName().equals("rule") && markupLanguage.equals((rule = (Element)vrNode).getAttribute("markupLanguage"))) {
                        String className = rule.getAttribute("class");
                        try {
                            Class<?> validationRuleClass = Class.forName(className, true, this.getClassLoader());
                            this.rules.add((ValidationRule)validationRuleClass.newInstance());
                        }
                        catch (Exception exception) {}
                    }
                    vrNode = vrNode.getNextSibling();
                }
            }
            child = child.getNextSibling();
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return StandaloneMarkupValidator.computeClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (this.immutable) {
            throw new IllegalStateException();
        }
        this.classLoader = classLoader;
    }
}

