/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.search;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.KeywordsDialog;
import org.eclipse.mylyn.internal.bugzilla.ui.search.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.WebBrowserDialog;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaSearchPage
extends AbstractRepositoryQueryPage
implements Listener {
    private static final int HEIGHT_ATTRIBUTE_COMBO = 70;
    private static ArrayList<BugzillaSearchData> previousSummaryPatterns = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousEmailPatterns = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousEmailPatterns2 = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousCommentPatterns = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousKeywords = new ArrayList(20);
    private boolean firstTime = true;
    private IDialogSettings fDialogSettings;
    private static final String[] patternOperationText = new String[]{Messages.BugzillaSearchPage_all_words, Messages.BugzillaSearchPage_any_word, Messages.BugzillaSearchPage_regexp, Messages.BugzillaSearchPage_notregexp};
    private static final String[] patternOperationValues = new String[]{"allwordssubstr", "anywordssubstr", "regexp", "notregexp"};
    private static final String[] emailOperationText = new String[]{Messages.BugzillaSearchPage_substring, Messages.BugzillaSearchPage_exact, Messages.BugzillaSearchPage_regexp, Messages.BugzillaSearchPage_notregexp};
    private static final String[] emailOperationValues = new String[]{"substring", "exact", "regexp", "notregexp"};
    private static final String[] keywordOperationText = new String[]{Messages.BugzillaSearchPage_all, Messages.BugzillaSearchPage_any, Messages.BugzillaSearchPage_none};
    private static final String[] keywordOperationValues = new String[]{"allwords", "anywords", "nowords"};
    private static final String[] emailRoleValues = new String[]{"emailassigned_to1", "emailreporter1", "emailcc1", "emaillongdesc1", "emailqa_contact1"};
    private static final String[] emailRoleValues2 = new String[]{"emailassigned_to2", "emailreporter2", "emailcc2", "emaillongdesc2", "emailqa_contact2"};
    private static final String DIALOG_BOUNDS_KEY = "ResizableDialogBounds";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private IRepositoryQuery originalQuery = null;
    protected boolean restoring = false;
    private boolean restoreQueryOptions = true;
    protected Combo summaryPattern;
    protected Combo summaryOperation;
    protected org.eclipse.swt.widgets.List product;
    protected org.eclipse.swt.widgets.List os;
    protected org.eclipse.swt.widgets.List hardware;
    protected org.eclipse.swt.widgets.List priority;
    protected org.eclipse.swt.widgets.List severity;
    protected org.eclipse.swt.widgets.List resolution;
    protected org.eclipse.swt.widgets.List status;
    protected Combo commentOperation;
    protected Combo commentPattern;
    protected org.eclipse.swt.widgets.List component;
    protected org.eclipse.swt.widgets.List version;
    protected org.eclipse.swt.widgets.List target;
    protected Combo emailOperation;
    protected Combo emailOperation2;
    protected Combo emailPattern;
    protected Combo emailPattern2;
    protected Button[] emailButtons;
    protected Button[] emailButtons2;
    private Combo keywords;
    private Combo keywordsOperation;
    protected Text daysText;
    protected int selIndex;
    protected static final String PAGE_NAME = "BugzillaSearchPage";
    private static final String STORE_PRODUCT_ID = "BugzillaSearchPage.PRODUCT";
    private static final String STORE_COMPONENT_ID = "BugzillaSearchPage.COMPONENT";
    private static final String STORE_VERSION_ID = "BugzillaSearchPage.VERSION";
    private static final String STORE_MSTONE_ID = "BugzillaSearchPage.MILESTONE";
    private static final String STORE_STATUS_ID = "BugzillaSearchPage.STATUS";
    private static final String STORE_RESOLUTION_ID = "BugzillaSearchPage.RESOLUTION";
    private static final String STORE_SEVERITY_ID = "BugzillaSearchPage.SEVERITY";
    private static final String STORE_PRIORITY_ID = "BugzillaSearchPage.PRIORITY";
    private static final String STORE_HARDWARE_ID = "BugzillaSearchPage.HARDWARE";
    private static final String STORE_OS_ID = "BugzillaSearchPage.OS";
    private static final String STORE_SUMMARYMATCH_ID = "BugzillaSearchPage.SUMMARYMATCH";
    private static final String STORE_COMMENTMATCH_ID = "BugzillaSearchPage.COMMENTMATCH";
    private static final String STORE_EMAILMATCH_ID = "BugzillaSearchPage.EMAILMATCH";
    private static final String STORE_EMAIL2MATCH_ID = "BugzillaSearchPage.EMAIL2MATCH";
    private static final String STORE_EMAILBUTTON_ID = "BugzillaSearchPage.EMAILATTR";
    private static final String STORE_EMAIL2BUTTON_ID = "BugzillaSearchPage.EMAIL2ATTR";
    private static final String STORE_SUMMARYTEXT_ID = "BugzillaSearchPage.SUMMARYTEXT";
    private static final String STORE_COMMENTTEXT_ID = "BugzillaSearchPage.COMMENTTEXT";
    private static final String STORE_EMAILADDRESS_ID = "BugzillaSearchPage.EMAILADDRESS";
    private static final String STORE_EMAIL2ADDRESS_ID = "BugzillaSearchPage.EMAIL2ADDRESS";
    private static final String STORE_KEYWORDS_ID = "BugzillaSearchPage.KEYWORDS";
    private static final String STORE_KEYWORDSMATCH_ID = "BugzillaSearchPage.KEYWORDSMATCH";
    private RepositoryConfiguration repositoryConfiguration;
    private final SelectionAdapter updateActionSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (BugzillaSearchPage.this.isControlCreated()) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        }
    };
    private Text queryTitle;

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        if (this.getSearchContainer() != null) {
            this.getSearchContainer().setPerformActionEnabled(complete);
        }
    }

    public BugzillaSearchPage(TaskRepository repository) {
        super(Messages.BugzillaSearchPage_Bugzilla_Query, repository);
    }

    public BugzillaSearchPage(TaskRepository repository, IRepositoryQuery origQuery) {
        super(Messages.BugzillaSearchPage_Bugzilla_Query, repository, origQuery);
        this.originalQuery = origQuery;
        this.setDescription(Messages.BugzillaSearchPage_Select_the_Bugzilla_query_parameters);
    }

    public void createControl(Composite parent) {
        this.readConfiguration();
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        control.setLayout((Layout)layout);
        control.setLayoutData((Object)new GridData(1808));
        this.createOptionsGroup(control);
        this.createSearchGroup(control);
        Dialog.applyDialogFont((Control)control);
        this.setControl((Control)control);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)control, "org.eclipse.mylyn.bugzilla.ui.bugzillaSearchContext");
        this.restoreBounds();
    }

    protected void createOptionsGroup(Composite control) {
        GridLayout sashFormLayout = new GridLayout();
        sashFormLayout.numColumns = 4;
        sashFormLayout.marginHeight = 5;
        sashFormLayout.marginWidth = 5;
        sashFormLayout.horizontalSpacing = 5;
        Composite composite = new Composite(control, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 8;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 4;
        composite.setLayout((Layout)gridLayout);
        if (!this.inSearchContainer()) {
            Label queryTitleLabel = new Label(composite, 0);
            queryTitleLabel.setText(Messages.BugzillaSearchPage_Query_Title);
            this.queryTitle = new Text(composite, 2048);
            this.queryTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            if (this.originalQuery != null) {
                this.queryTitle.setText(this.originalQuery.getSummary());
            }
            this.queryTitle.addModifyListener((ModifyListener)new ModifyListenerImplementation());
            this.queryTitle.setFocus();
        }
        Label labelSummary = new Label(composite, 16384);
        labelSummary.setText(Messages.BugzillaSearchPage_Summary);
        this.summaryPattern = new Combo(composite, 2052);
        this.summaryPattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.summaryPattern.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.summaryPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.summaryPattern, BugzillaSearchPage.this.summaryOperation, previousSummaryPatterns);
            }
        });
        this.summaryOperation = new Combo(composite, 2060);
        this.summaryOperation.setItems(patternOperationText);
        this.summaryOperation.setText(patternOperationText[0]);
        this.summaryOperation.select(0);
        Label labelComment = new Label(composite, 16384);
        labelComment.setText(Messages.BugzillaSearchPage_Comment);
        this.commentPattern = new Combo(composite, 2052);
        this.commentPattern.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.commentPattern.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.commentPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.commentPattern, BugzillaSearchPage.this.commentOperation, previousCommentPatterns);
            }
        });
        this.commentOperation = new Combo(composite, 2060);
        this.commentOperation.setItems(patternOperationText);
        this.commentOperation.setText(patternOperationText[0]);
        this.commentOperation.select(0);
        Label labelEmail = new Label(composite, 16384);
        labelEmail.setText(Messages.BugzillaSearchPage_Email);
        this.emailPattern = new Combo(composite, 2052);
        this.emailPattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.emailPattern.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.emailPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.emailPattern, BugzillaSearchPage.this.emailOperation, previousEmailPatterns);
            }
        });
        IContentProposalProvider proposalProvider = TasksUi.getUiFactory().createPersonContentProposalProvider(this.getTaskRepository());
        ILabelProvider proposalLabelProvider = TasksUi.getUiFactory().createPersonContentProposalLabelProvider(this.getTaskRepository());
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)this.emailPattern, (IControlContentAdapter)new ComboContentAdapter(), proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        adapter.setLabelProvider(proposalLabelProvider);
        adapter.setProposalAcceptanceStyle(2);
        Composite emailComposite = new Composite(composite, 0);
        emailComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        GridLayout emailLayout = new GridLayout();
        emailLayout.marginWidth = 0;
        emailLayout.marginHeight = 0;
        emailLayout.horizontalSpacing = 2;
        emailLayout.numColumns = 5;
        emailComposite.setLayout((Layout)emailLayout);
        Button button0 = new Button(emailComposite, 32);
        button0.setText(Messages.BugzillaSearchPage_owner);
        Button button1 = new Button(emailComposite, 32);
        button1.setText(Messages.BugzillaSearchPage_reporter);
        Button button2 = new Button(emailComposite, 32);
        button2.setText(Messages.BugzillaSearchPage_cc);
        Button button3 = new Button(emailComposite, 32);
        button3.setText(Messages.BugzillaSearchPage_commenter);
        Button button4 = new Button(emailComposite, 32);
        button4.setText(Messages.BugzillaSearchPage_qacontact);
        this.emailButtons = new Button[]{button0, button1, button2, button3, button4};
        this.emailOperation = new Combo(composite, 2060);
        this.emailOperation.setItems(emailOperationText);
        this.emailOperation.setText(emailOperationText[0]);
        this.emailOperation.select(0);
        Label labelEmail2 = new Label(composite, 16384);
        labelEmail2.setText(Messages.BugzillaSearchPage_Email_2);
        this.emailPattern2 = new Combo(composite, 2052);
        this.emailPattern2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.emailPattern2.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.emailPattern2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.emailPattern2, BugzillaSearchPage.this.emailOperation2, previousEmailPatterns2);
            }
        });
        ContentAssistCommandAdapter adapter2 = new ContentAssistCommandAdapter((Control)this.emailPattern2, (IControlContentAdapter)new ComboContentAdapter(), proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        adapter.setLabelProvider(proposalLabelProvider);
        adapter2.setProposalAcceptanceStyle(2);
        Composite emailComposite2 = new Composite(composite, 0);
        emailComposite2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        GridLayout emailLayout2 = new GridLayout();
        emailLayout2.marginWidth = 0;
        emailLayout2.marginHeight = 0;
        emailLayout2.horizontalSpacing = 2;
        emailLayout2.numColumns = 5;
        emailComposite2.setLayout((Layout)emailLayout2);
        Button e2button0 = new Button(emailComposite2, 32);
        e2button0.setText(Messages.BugzillaSearchPage_owner);
        Button e2button1 = new Button(emailComposite2, 32);
        e2button1.setText(Messages.BugzillaSearchPage_reporter);
        Button e2button2 = new Button(emailComposite2, 32);
        e2button2.setText(Messages.BugzillaSearchPage_cc);
        Button e2button3 = new Button(emailComposite2, 32);
        e2button3.setText(Messages.BugzillaSearchPage_commenter);
        Button e2button4 = new Button(emailComposite2, 32);
        e2button4.setText(Messages.BugzillaSearchPage_qacontact);
        this.emailButtons2 = new Button[]{e2button0, e2button1, e2button2, e2button3, e2button4};
        this.emailOperation2 = new Combo(composite, 2060);
        this.emailOperation2.setItems(emailOperationText);
        this.emailOperation2.setText(emailOperationText[0]);
        this.emailOperation2.select(0);
        Label labelKeywords = new Label(composite, 0);
        labelKeywords.setText(Messages.BugzillaSearchPage_Keywords);
        Composite keywordsComposite = new Composite(composite, 0);
        keywordsComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        GridLayout keywordsLayout = new GridLayout();
        keywordsLayout.marginWidth = 0;
        keywordsLayout.marginHeight = 0;
        keywordsLayout.numColumns = 3;
        keywordsComposite.setLayout((Layout)keywordsLayout);
        this.keywordsOperation = new Combo(keywordsComposite, 8);
        this.keywordsOperation.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.keywordsOperation.setItems(keywordOperationText);
        this.keywordsOperation.setText(keywordOperationText[0]);
        this.keywordsOperation.select(0);
        this.keywords = new Combo(keywordsComposite, 0);
        this.keywords.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.keywords.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.keywords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.keywords, BugzillaSearchPage.this.keywordsOperation, previousKeywords);
            }
        });
        Button keywordsSelectButton = new Button(keywordsComposite, 0);
        keywordsSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeywordsDialog dialog;
                if (BugzillaSearchPage.this.repositoryConfiguration != null && BugzillaSearchPage.this.getShell() != null && (dialog = new KeywordsDialog(BugzillaSearchPage.this.getShell(), BugzillaSearchPage.this.keywords.getText(), BugzillaSearchPage.this.repositoryConfiguration.getKeywords())).open() == 0) {
                    BugzillaSearchPage.this.keywords.setText(dialog.getSelectedKeywordsString());
                }
            }
        });
        keywordsSelectButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        keywordsSelectButton.setText(Messages.BugzillaSearchPage_Select_);
        SashForm sashForm = new SashForm(control, 512);
        sashForm.setLayout((Layout)sashFormLayout);
        GridData gd_sashForm = new GridData(4, 4, true, true);
        gd_sashForm.widthHint = 500;
        sashForm.setLayoutData((Object)gd_sashForm);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 4;
        SashForm topForm = new SashForm((Composite)sashForm, 0);
        GridData topLayoutData = new GridData(4, 4, true, true, 3, 1);
        topLayoutData.widthHint = 500;
        topForm.setLayoutData((Object)topLayoutData);
        topForm.setLayout((Layout)topLayout);
        GridLayout productLayout = new GridLayout();
        productLayout.marginWidth = 0;
        productLayout.marginHeight = 0;
        productLayout.horizontalSpacing = 0;
        Composite productComposite = new Composite((Composite)topForm, 0);
        productComposite.setLayout((Layout)productLayout);
        Label productLabel = new Label(productComposite, 16384);
        productLabel.setText(Messages.BugzillaSearchPage_Product);
        productLabel.setLayoutData((Object)new GridData(768));
        GridData productLayoutData = new GridData(4, 4, true, true);
        productLayoutData.heightHint = 70;
        this.product = new org.eclipse.swt.widgets.List(productComposite, 2562);
        this.product.setLayoutData((Object)productLayoutData);
        this.product.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BugzillaSearchPage.this.product.getSelectionIndex() != -1) {
                    String[] selectedProducts = BugzillaSearchPage.this.product.getSelection();
                    BugzillaSearchPage.this.updateAttributesFromConfiguration(selectedProducts);
                } else {
                    BugzillaSearchPage.this.updateAttributesFromConfiguration(null);
                }
                if (BugzillaSearchPage.this.restoring) {
                    BugzillaSearchPage.this.restoring = false;
                    BugzillaSearchPage.this.restoreWidgetValues();
                }
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        GridLayout componentLayout = new GridLayout();
        componentLayout.marginWidth = 0;
        componentLayout.marginHeight = 0;
        componentLayout.horizontalSpacing = 0;
        Composite componentComposite = new Composite((Composite)topForm, 0);
        componentComposite.setLayout((Layout)componentLayout);
        Label componentLabel = new Label(componentComposite, 16384);
        componentLabel.setText(Messages.BugzillaSearchPage_Component);
        componentLabel.setLayoutData((Object)new GridData(768));
        this.component = new org.eclipse.swt.widgets.List(componentComposite, 2562);
        GridData componentLayoutData = new GridData(4, 4, true, true);
        componentLayoutData.heightHint = 70;
        this.component.setLayoutData((Object)componentLayoutData);
        this.component.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite versionComposite = new Composite((Composite)topForm, 0);
        GridLayout versionLayout = new GridLayout();
        versionLayout.marginWidth = 0;
        versionLayout.marginHeight = 0;
        versionLayout.horizontalSpacing = 0;
        versionComposite.setLayout((Layout)versionLayout);
        Label versionLabel = new Label(versionComposite, 16384);
        versionLabel.setText(Messages.BugzillaSearchPage_Version);
        versionLabel.setLayoutData((Object)new GridData(768));
        this.version = new org.eclipse.swt.widgets.List(versionComposite, 2562);
        GridData versionLayoutData = new GridData(4, 4, true, true);
        versionLayoutData.heightHint = 70;
        this.version.setLayoutData((Object)versionLayoutData);
        this.version.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite milestoneComposite = new Composite((Composite)topForm, 0);
        GridLayout milestoneLayout = new GridLayout();
        milestoneLayout.marginWidth = 0;
        milestoneLayout.marginHeight = 0;
        milestoneLayout.horizontalSpacing = 0;
        milestoneComposite.setLayout((Layout)milestoneLayout);
        Label milestoneLabel = new Label(milestoneComposite, 16384);
        milestoneLabel.setText(Messages.BugzillaSearchPage_Milestone);
        milestoneLabel.setLayoutData((Object)new GridData(768));
        this.target = new org.eclipse.swt.widgets.List(milestoneComposite, 2562);
        GridData targetLayoutData = new GridData(4, 4, true, true);
        targetLayoutData.heightHint = 70;
        this.target.setLayoutData((Object)targetLayoutData);
        this.target.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        SashForm bottomForm = new SashForm((Composite)sashForm, 0);
        GridLayout bottomLayout = new GridLayout();
        bottomLayout.numColumns = 6;
        bottomForm.setLayout((Layout)bottomLayout);
        GridData bottomLayoutData = new GridData(4, 4, true, true, 4, 1);
        bottomLayoutData.heightHint = 119;
        bottomLayoutData.widthHint = 400;
        bottomForm.setLayoutData((Object)bottomLayoutData);
        Composite statusComposite = new Composite((Composite)bottomForm, 0);
        GridLayout statusLayout = new GridLayout();
        statusLayout.marginTop = 7;
        statusLayout.marginWidth = 0;
        statusLayout.horizontalSpacing = 0;
        statusLayout.marginHeight = 0;
        statusComposite.setLayout((Layout)statusLayout);
        Label statusLabel = new Label(statusComposite, 16384);
        statusLabel.setText(Messages.BugzillaSearchPage_Status);
        statusLabel.setLayoutData((Object)new GridData(768));
        this.status = new org.eclipse.swt.widgets.List(statusComposite, 2562);
        GridData gd_status = new GridData(4, 4, true, true);
        gd_status.heightHint = 60;
        this.status.setLayoutData((Object)gd_status);
        this.status.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite resolutionComposite = new Composite((Composite)bottomForm, 0);
        GridLayout resolutionLayout = new GridLayout();
        resolutionLayout.marginTop = 7;
        resolutionLayout.marginWidth = 0;
        resolutionLayout.marginHeight = 0;
        resolutionLayout.horizontalSpacing = 0;
        resolutionComposite.setLayout((Layout)resolutionLayout);
        Label resolutionLabel = new Label(resolutionComposite, 16384);
        resolutionLabel.setText(Messages.BugzillaSearchPage_Resolution);
        resolutionLabel.setLayoutData((Object)new GridData(768));
        this.resolution = new org.eclipse.swt.widgets.List(resolutionComposite, 2562);
        GridData gd_resolution = new GridData(4, 4, true, true);
        gd_resolution.heightHint = 60;
        this.resolution.setLayoutData((Object)gd_resolution);
        this.resolution.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite priorityComposite = new Composite((Composite)bottomForm, 0);
        GridLayout priorityLayout = new GridLayout();
        priorityLayout.marginTop = 7;
        priorityLayout.marginWidth = 0;
        priorityLayout.marginHeight = 0;
        priorityLayout.horizontalSpacing = 0;
        priorityComposite.setLayout((Layout)priorityLayout);
        Label priorityLabel = new Label(priorityComposite, 16384);
        priorityLabel.setText(Messages.BugzillaSearchPage_PROORITY);
        priorityLabel.setLayoutData((Object)new GridData(768));
        this.priority = new org.eclipse.swt.widgets.List(priorityComposite, 2562);
        GridData gd_priority = new GridData(4, 4, true, true);
        gd_priority.heightHint = 60;
        this.priority.setLayoutData((Object)gd_priority);
        this.priority.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite severityComposite = new Composite((Composite)bottomForm, 0);
        GridLayout severityLayout = new GridLayout();
        severityLayout.marginTop = 7;
        severityLayout.marginWidth = 0;
        severityLayout.marginHeight = 0;
        severityLayout.horizontalSpacing = 0;
        severityComposite.setLayout((Layout)severityLayout);
        Label severityLabel = new Label(severityComposite, 16384);
        severityLabel.setText(Messages.BugzillaSearchPage_Severity);
        severityLabel.setLayoutData((Object)new GridData(768));
        this.severity = new org.eclipse.swt.widgets.List(severityComposite, 2562);
        GridData gd_severity = new GridData(4, 4, true, true);
        gd_severity.heightHint = 60;
        this.severity.setLayoutData((Object)gd_severity);
        this.severity.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite hardwareComposite = new Composite((Composite)bottomForm, 0);
        GridLayout hardwareLayout = new GridLayout();
        hardwareLayout.marginTop = 7;
        hardwareLayout.marginWidth = 0;
        hardwareLayout.marginHeight = 0;
        hardwareLayout.horizontalSpacing = 0;
        hardwareComposite.setLayout((Layout)hardwareLayout);
        Label hardwareLabel = new Label(hardwareComposite, 16384);
        hardwareLabel.setText(Messages.BugzillaSearchPage_Hardware);
        hardwareLabel.setLayoutData((Object)new GridData(768));
        this.hardware = new org.eclipse.swt.widgets.List(hardwareComposite, 2562);
        GridData gd_hardware = new GridData(4, 4, true, true);
        gd_hardware.heightHint = 60;
        this.hardware.setLayoutData((Object)gd_hardware);
        this.hardware.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite osComposite = new Composite((Composite)bottomForm, 0);
        GridLayout osLayout = new GridLayout();
        osLayout.marginTop = 7;
        osLayout.marginWidth = 0;
        osLayout.marginHeight = 0;
        osLayout.horizontalSpacing = 0;
        osComposite.setLayout((Layout)osLayout);
        Label osLabel = new Label(osComposite, 16384);
        osLabel.setText(Messages.BugzillaSearchPage_Operating_System);
        osLabel.setLayoutData((Object)new GridData(768));
        this.os = new org.eclipse.swt.widgets.List(osComposite, 2562);
        GridData gd_os = new GridData(4, 4, true, true);
        gd_os.heightHint = 60;
        this.os.setLayoutData((Object)gd_os);
        this.os.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        bottomForm.setWeights(new int[]{88, 90, 50, 77, 88, 85});
    }

    private void createSearchGroup(Composite control) {
        Composite composite = new Composite(control, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 7;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label changedInTheLabel = new Label(composite, 16384);
        changedInTheLabel.setLayoutData((Object)new GridData());
        changedInTheLabel.setText(Messages.BugzillaSearchPage_Changed_in);
        Composite updateComposite = new Composite(composite, 0);
        updateComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout updateLayout = new GridLayout(3, false);
        updateLayout.marginWidth = 0;
        updateLayout.horizontalSpacing = 0;
        updateLayout.marginHeight = 0;
        updateComposite.setLayout((Layout)updateLayout);
        this.daysText = new Text(updateComposite, 2048);
        this.daysText.setLayoutData((Object)new GridData(40, -1));
        this.daysText.setTextLimit(5);
        this.daysText.addListener(24, (Listener)this);
        Label label = new Label(updateComposite, 16384);
        label.setText(Messages.BugzillaSearchPage_days);
        Button updateButton = new Button(updateComposite, 8);
        updateButton.setText(Messages.BugzillaSearchPage_Update_Attributes_from_Repository);
        updateButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BugzillaSearchPage.this.getTaskRepository() != null) {
                    BugzillaSearchPage.this.updateConfiguration(true);
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)IBugzillaConstants.TITLE_MESSAGE_DIALOG, (String)Messages.BugzillaSearchPage_No_repository_available);
                }
            }
        });
    }

    protected Control createSaveQuery(Composite control) {
        Group group = new Group(control, 0);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(769);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        return group;
    }

    private void handleWidgetSelected(Combo widget, Combo operation, ArrayList<BugzillaSearchData> history) {
        if (widget.getSelectionIndex() < 0) {
            return;
        }
        int index = history.size() - 1 - widget.getSelectionIndex();
        BugzillaSearchData patternData = history.get(index);
        if (patternData == null || !widget.getText().equals(patternData.pattern)) {
            return;
        }
        widget.setText(patternData.pattern);
        operation.setText(operation.getItem(patternData.operation));
    }

    public boolean performSearch() {
        if (this.restoreQueryOptions) {
            this.saveState();
        }
        this.getPatternData(this.summaryPattern, this.summaryOperation, previousSummaryPatterns);
        this.getPatternData(this.commentPattern, this.commentOperation, previousCommentPatterns);
        this.getPatternData(this.emailPattern, this.emailOperation, previousEmailPatterns);
        this.getPatternData(this.emailPattern2, this.emailOperation2, previousEmailPatterns2);
        this.getPatternData(this.keywords, this.keywordsOperation, previousKeywords);
        String summaryText = this.summaryPattern.getText();
        BugzillaUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.bugzilla.query.last", summaryText);
        return super.performSearch();
    }

    public void setVisible(boolean visible) {
        if (visible && this.summaryPattern != null) {
            if (this.firstTime) {
                String email;
                this.firstTime = false;
                String[] stringArray = this.getPreviousPatterns(previousSummaryPatterns);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String searchPattern = stringArray[n2];
                    this.summaryPattern.add(searchPattern);
                    ++n2;
                }
                stringArray = this.getPreviousPatterns(previousCommentPatterns);
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String comment = stringArray[n2];
                    this.commentPattern.add(comment);
                    ++n2;
                }
                stringArray = this.getPreviousPatterns(previousEmailPatterns);
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    email = stringArray[n2];
                    this.emailPattern.add(email);
                    ++n2;
                }
                stringArray = this.getPreviousPatterns(previousEmailPatterns2);
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    email = stringArray[n2];
                    this.emailPattern2.add(email);
                    ++n2;
                }
                stringArray = this.getPreviousPatterns(previousKeywords);
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String keyword = stringArray[n2];
                    this.keywords.add(keyword);
                    ++n2;
                }
                if (this.getTaskRepository() != null) {
                    BugzillaRepositoryConnector connector = (BugzillaRepositoryConnector)TasksUi.getRepositoryConnector((String)this.getTaskRepository().getConnectorKind());
                    this.repositoryConfiguration = connector.getRepositoryConfiguration(this.getTaskRepository().getUrl());
                    this.updateAttributesFromConfiguration(null);
                    if (this.product.getItemCount() == 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (BugzillaSearchPage.this.getControl() != null && !BugzillaSearchPage.this.getControl().isDisposed()) {
                                    BugzillaSearchPage.this.updateConfiguration(true);
                                    BugzillaSearchPage.this.updateAttributesFromConfiguration(null);
                                }
                            }
                        });
                    }
                }
                if (this.originalQuery != null) {
                    try {
                        this.updateDefaults(this.originalQuery.getUrl());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
            }
            if (this.getTaskRepository() != null) {
                IDialogSettings settings = this.getDialogSettings();
                String repoId = "." + this.getTaskRepository().getRepositoryUrl();
                if (this.getWizard() == null && this.restoreQueryOptions && settings.getArray(STORE_PRODUCT_ID + repoId) != null && this.product != null) {
                    this.product.setSelection(this.nonNullArray(settings, STORE_PRODUCT_ID + repoId));
                    if (this.product.getSelection().length > 0) {
                        this.updateAttributesFromConfiguration(this.product.getSelection());
                    }
                    this.restoreWidgetValues();
                }
            }
            this.setPageComplete(this.isPageComplete());
            if (this.getWizard() == null) {
                this.summaryPattern.setFocus();
            }
        }
        super.setVisible(visible);
    }

    private boolean canQuery() {
        if (this.isControlCreated()) {
            return this.product.getSelectionCount() > 0 || this.component.getSelectionCount() > 0 || this.version.getSelectionCount() > 0 || this.target.getSelectionCount() > 0 || this.status.getSelectionCount() > 0 || this.resolution.getSelectionCount() > 0 || this.severity.getSelectionCount() > 0 || this.priority.getSelectionCount() > 0 || this.hardware.getSelectionCount() > 0 || this.os.getSelectionCount() > 0 || this.summaryPattern.getText().length() > 0 || this.commentPattern.getText().length() > 0 || this.emailPattern.getText().length() > 0 || this.emailPattern2.getText().length() > 0 || this.keywords.getText().length() > 0;
        }
        return false;
    }

    public boolean isPageComplete() {
        String days;
        if (this.daysText != null && (days = this.daysText.getText()).length() > 0) {
            try {
                if (Integer.parseInt(days) < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setMessage(NLS.bind((String)Messages.BugzillaSearchPage_Number_of_days_must_be_a_positive_integer, (Object)days), 3);
                return false;
            }
        }
        if (this.getWizard() == null) {
            return this.canQuery();
        }
        if (super.isPageComplete()) {
            if (this.canQuery()) {
                return true;
            }
            this.setMessage(Messages.BugzillaSearchPage_Enter_search_option);
        }
        return false;
    }

    private BugzillaSearchData getPatternData(Combo widget, Combo operation, ArrayList<BugzillaSearchData> previousSearchQueryData) {
        String pattern = widget.getText();
        if (pattern == null || pattern.trim().equals("")) {
            return null;
        }
        BugzillaSearchData match = null;
        int i = previousSearchQueryData.size() - 1;
        while (i >= 0) {
            match = previousSearchQueryData.get(i);
            if (pattern.equals(match.pattern)) break;
            --i;
        }
        if (i >= 0 && match != null) {
            match.operation = operation.getSelectionIndex();
            previousSearchQueryData.remove(match);
        } else {
            match = new BugzillaSearchData(widget.getText(), operation.getSelectionIndex());
        }
        previousSearchQueryData.add(match);
        return match;
    }

    private String[] getPreviousPatterns(ArrayList<BugzillaSearchData> patternHistory) {
        int size = patternHistory.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = patternHistory.get((int)(size - 1 - i)).pattern;
            ++i;
        }
        return patterns;
    }

    public String getSearchURL(TaskRepository repository) {
        return this.getQueryURL(repository, this.getQueryParameters());
    }

    protected String getQueryURL(TaskRepository repository, StringBuilder params) {
        StringBuilder url = new StringBuilder(this.getQueryURLStart(repository).toString());
        url.append((CharSequence)params);
        url.append("&order=Importance");
        return url.toString();
    }

    private StringBuilder getQueryURLStart(TaskRepository repository) {
        StringBuilder sb = new StringBuilder(repository.getRepositoryUrl());
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append("buglist.cgi?");
        return sb;
    }

    protected StringBuilder getQueryParameters() {
        Button[] buttonArray;
        boolean selectionMade;
        int element;
        int[] selected;
        StringBuilder sb = new StringBuilder();
        sb.append("short_desc_type=");
        sb.append(patternOperationValues[this.summaryOperation.getSelectionIndex()]);
        this.appendToBuffer(sb, "&short_desc=", this.summaryPattern.getText());
        int[] nArray = selected = this.product.getSelectionIndices();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&product=", this.product.getItem(element));
            ++n2;
        }
        nArray = selected = this.component.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&component=", this.component.getItem(element));
            ++n2;
        }
        nArray = selected = this.version.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&version=", this.version.getItem(element));
            ++n2;
        }
        nArray = selected = this.target.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&target_milestone=", this.target.getItem(element));
            ++n2;
        }
        sb.append("&long_desc_type=");
        sb.append(patternOperationValues[this.commentOperation.getSelectionIndex()]);
        this.appendToBuffer(sb, "&long_desc=", this.commentPattern.getText());
        nArray = selected = this.status.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&bug_status=", this.status.getItem(element));
            ++n2;
        }
        nArray = selected = this.resolution.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&resolution=", this.resolution.getItem(element));
            ++n2;
        }
        nArray = selected = this.severity.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&bug_severity=", this.severity.getItem(element));
            ++n2;
        }
        nArray = selected = this.priority.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&priority=", this.priority.getItem(element));
            ++n2;
        }
        nArray = selected = this.hardware.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&ref_platform=", this.hardware.getItem(element));
            ++n2;
        }
        nArray = selected = this.os.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&op_sys=", this.os.getItem(element));
            ++n2;
        }
        if (this.emailPattern.getText() != null && !this.emailPattern.getText().trim().equals("")) {
            selectionMade = false;
            buttonArray = this.emailButtons;
            int n3 = this.emailButtons.length;
            n = 0;
            while (n < n3) {
                Button button = buttonArray[n];
                if (button.getSelection()) {
                    selectionMade = true;
                    break;
                }
                ++n;
            }
            if (selectionMade) {
                int i = 0;
                while (i < this.emailButtons.length) {
                    if (this.emailButtons[i].getSelection()) {
                        sb.append("&");
                        sb.append(emailRoleValues[i]);
                        sb.append("=1");
                    }
                    ++i;
                }
                sb.append("&emailtype1=");
                sb.append(emailOperationValues[this.emailOperation.getSelectionIndex()]);
                this.appendToBuffer(sb, "&email1=", this.emailPattern.getText());
            }
        }
        if (this.emailPattern2.getText() != null && !this.emailPattern2.getText().trim().equals("")) {
            selectionMade = false;
            buttonArray = this.emailButtons2;
            int n4 = this.emailButtons2.length;
            n = 0;
            while (n < n4) {
                Button button = buttonArray[n];
                if (button.getSelection()) {
                    selectionMade = true;
                    break;
                }
                ++n;
            }
            if (selectionMade) {
                int i = 0;
                while (i < this.emailButtons2.length) {
                    if (this.emailButtons2[i].getSelection()) {
                        sb.append("&");
                        sb.append(emailRoleValues2[i]);
                        sb.append("=1");
                    }
                    ++i;
                }
                sb.append("&emailtype2=");
                sb.append(emailOperationValues[this.emailOperation2.getSelectionIndex()]);
                this.appendToBuffer(sb, "&email2=", this.emailPattern2.getText());
            }
        }
        if (this.daysText.getText() != null && !this.daysText.getText().equals("")) {
            try {
                Integer.parseInt(this.daysText.getText());
                this.appendToBuffer(sb, "&changedin=", this.daysText.getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.keywords.getText() != null && !this.keywords.getText().trim().equals("")) {
            sb.append("&keywords_type=");
            sb.append(keywordOperationValues[this.keywordsOperation.getSelectionIndex()]);
            this.appendToBuffer(sb, "&keywords=", this.keywords.getText().replace(',', ' '));
        }
        return sb;
    }

    private void appendToBuffer(StringBuilder sb, String key, String value) {
        sb.append(key);
        try {
            sb.append(URLEncoder.encode(value, this.getTaskRepository().getCharacterEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            sb.append(value);
        }
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = BugzillaUiPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        this.getDialogSettings();
    }

    private void updateAttributesFromConfiguration(String[] selectedProducts) {
        if (this.repositoryConfiguration != null) {
            String[] saved_product = this.product.getSelection();
            String[] saved_component = this.component.getSelection();
            String[] saved_version = this.version.getSelection();
            String[] saved_target = this.target.getSelection();
            String[] saved_status = this.status.getSelection();
            String[] saved_resolution = this.resolution.getSelection();
            String[] saved_severity = this.severity.getSelection();
            String[] saved_priority = this.priority.getSelection();
            String[] saved_hardware = this.hardware.getSelection();
            String[] saved_os = this.os.getSelection();
            if (selectedProducts == null) {
                List products = this.repositoryConfiguration.getProducts();
                String[] productsList = products.toArray(new String[products.size()]);
                Arrays.sort(productsList, String.CASE_INSENSITIVE_ORDER);
                this.product.setItems(productsList);
            }
            String[] componentsList = BugzillaUiPlugin.getQueryOptions("org.eclipse.mylyn.bugzilla.values.component", selectedProducts, this.repositoryConfiguration);
            Arrays.sort(componentsList, String.CASE_INSENSITIVE_ORDER);
            this.component.setItems(componentsList);
            this.version.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylyn.bugzilla.values.version", selectedProducts, this.repositoryConfiguration));
            this.target.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylyn.bugzilla.values.target", selectedProducts, this.repositoryConfiguration));
            this.status.setItems(this.convertStringListToArray(this.repositoryConfiguration.getStatusValues()));
            this.resolution.setItems(this.convertStringListToArray(this.repositoryConfiguration.getResolutions()));
            this.severity.setItems(this.convertStringListToArray(this.repositoryConfiguration.getSeverities()));
            this.priority.setItems(this.convertStringListToArray(this.repositoryConfiguration.getPriorities()));
            this.hardware.setItems(this.convertStringListToArray(this.repositoryConfiguration.getPlatforms()));
            this.os.setItems(this.convertStringListToArray(this.repositoryConfiguration.getOSs()));
            this.setSelection(this.product, saved_product);
            this.setSelection(this.component, saved_component);
            this.setSelection(this.version, saved_version);
            this.setSelection(this.target, saved_target);
            this.setSelection(this.status, saved_status);
            this.setSelection(this.resolution, saved_resolution);
            this.setSelection(this.severity, saved_severity);
            this.setSelection(this.priority, saved_priority);
            this.setSelection(this.hardware, saved_hardware);
            this.setSelection(this.os, saved_os);
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void handleEvent(Event event) {
        if (this.getWizard() != null) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    public void updateDefaults(String startingUrl) throws UnsupportedEncodingException {
        String[] options;
        startingUrl = startingUrl.substring(startingUrl.indexOf("?") + 1);
        String[] stringArray = options = startingUrl.split("&");
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            int endindex = option.indexOf("=");
            String key = endindex == -1 ? null : option.substring(0, option.indexOf("="));
            if (key != null) {
                List<String> selList;
                String item;
                int n3;
                int n4;
                String[] stringArray2;
                String value = URLDecoder.decode(option.substring(option.indexOf("=") + 1), this.getTaskRepository().getCharacterEncoding());
                if (key.equals("short_desc")) {
                    this.summaryPattern.setText(value);
                } else if (key.equals("short_desc_type")) {
                    if (value.equals("allwordssubstr")) {
                        value = "all words";
                    } else if (value.equals("anywordssubstr")) {
                        value = "any word";
                    }
                    int index = 0;
                    stringArray2 = this.summaryOperation.getItems();
                    n4 = stringArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        item = stringArray2[n3];
                        if (item.compareTo(value) == 0) break;
                        ++index;
                        ++n3;
                    }
                    if (index < this.summaryOperation.getItemCount()) {
                        this.summaryOperation.select(index);
                    }
                } else if (key.equals("product")) {
                    String[] sel = this.product.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.product.setSelection(selList.toArray(sel));
                    this.updateAttributesFromConfiguration(selList.toArray(sel));
                } else if (key.equals("component")) {
                    String[] sel = this.component.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.component.setSelection(selList.toArray(sel));
                } else if (key.equals("version")) {
                    String[] sel = this.version.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.version.setSelection(selList.toArray(sel));
                } else if (key.equals("target_milestone")) {
                    String[] sel = this.target.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.target.setSelection(selList.toArray(sel));
                } else if (key.equals("version")) {
                    String[] sel = this.version.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.version.setSelection(selList.toArray(sel));
                } else if (key.equals("long_desc_type")) {
                    if (value.equals("allwordssubstr")) {
                        value = "all words";
                    } else if (value.equals("anywordssubstr")) {
                        value = "any word";
                    }
                    int index = 0;
                    stringArray2 = this.commentOperation.getItems();
                    n4 = stringArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        item = stringArray2[n3];
                        if (item.compareTo(value) == 0) break;
                        ++index;
                        ++n3;
                    }
                    if (index < this.commentOperation.getItemCount()) {
                        this.commentOperation.select(index);
                    }
                } else if (key.equals("long_desc")) {
                    this.commentPattern.setText(value);
                } else if (key.equals("bug_status")) {
                    String[] sel = this.status.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.status.setSelection(selList.toArray(sel));
                } else if (key.equals("resolution")) {
                    String[] sel = this.resolution.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.resolution.setSelection(selList.toArray(sel));
                } else if (key.equals("bug_severity")) {
                    String[] sel = this.severity.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.severity.setSelection(selList.toArray(sel));
                } else if (key.equals("priority")) {
                    String[] sel = this.priority.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.priority.setSelection(selList.toArray(sel));
                } else if (key.equals("ref_platform")) {
                    String[] sel = this.hardware.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.hardware.setSelection(selList.toArray(sel));
                } else if (key.equals("op_sys")) {
                    String[] sel = this.os.getSelection();
                    selList = Arrays.asList(sel);
                    selList = new ArrayList<String>(selList);
                    selList.add(value);
                    sel = new String[selList.size()];
                    this.os.setSelection(selList.toArray(sel));
                } else if (key.equals("emailassigned_to1")) {
                    if (value.equals("1")) {
                        this.emailButtons[0].setSelection(true);
                    } else {
                        this.emailButtons[0].setSelection(false);
                    }
                } else if (key.equals("emailreporter1")) {
                    if (value.equals("1")) {
                        this.emailButtons[1].setSelection(true);
                    } else {
                        this.emailButtons[1].setSelection(false);
                    }
                } else if (key.equals("emailcc1")) {
                    if (value.equals("1")) {
                        this.emailButtons[2].setSelection(true);
                    } else {
                        this.emailButtons[2].setSelection(false);
                    }
                } else if (key.equals("emaillongdesc1")) {
                    if (value.equals("1")) {
                        this.emailButtons[3].setSelection(true);
                    } else {
                        this.emailButtons[3].setSelection(false);
                    }
                } else if (key.equals("emailqa_contact1")) {
                    if (value.equals("1")) {
                        this.emailButtons[4].setSelection(true);
                    } else {
                        this.emailButtons[4].setSelection(false);
                    }
                } else if (key.equals("emailtype1")) {
                    int index = 0;
                    stringArray2 = this.emailOperation.getItems();
                    n4 = stringArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        item = stringArray2[n3];
                        if (item.compareTo(value) == 0) break;
                        ++index;
                        ++n3;
                    }
                    if (index < this.emailOperation.getItemCount()) {
                        this.emailOperation.select(index);
                    }
                } else if (key.equals("email1")) {
                    this.emailPattern.setText(value);
                } else if (key.equals("emailassigned_to2")) {
                    if (value.equals("1")) {
                        this.emailButtons2[0].setSelection(true);
                    } else {
                        this.emailButtons2[0].setSelection(false);
                    }
                } else if (key.equals("emailreporter2")) {
                    if (value.equals("1")) {
                        this.emailButtons2[1].setSelection(true);
                    } else {
                        this.emailButtons2[1].setSelection(false);
                    }
                } else if (key.equals("emailcc2")) {
                    if (value.equals("1")) {
                        this.emailButtons2[2].setSelection(true);
                    } else {
                        this.emailButtons2[2].setSelection(false);
                    }
                } else if (key.equals("emaillongdesc2")) {
                    if (value.equals("1")) {
                        this.emailButtons2[3].setSelection(true);
                    } else {
                        this.emailButtons2[3].setSelection(false);
                    }
                } else if (key.equals("emailqa_contact2")) {
                    if (value.equals("1")) {
                        this.emailButtons2[4].setSelection(true);
                    } else {
                        this.emailButtons2[4].setSelection(false);
                    }
                } else if (key.equals("emailtype2")) {
                    int index = 0;
                    stringArray2 = this.emailOperation2.getItems();
                    n4 = stringArray2.length;
                    n3 = 0;
                    while (n3 < n4) {
                        item = stringArray2[n3];
                        if (item.compareTo(value) == 0) break;
                        ++index;
                        ++n3;
                    }
                    if (index < this.emailOperation2.getItemCount()) {
                        this.emailOperation2.select(index);
                    }
                } else if (key.equals("email2")) {
                    this.emailPattern2.setText(value);
                } else if (key.equals("changedin")) {
                    this.daysText.setText(value);
                } else if (key.equals("keywords")) {
                    this.keywords.setText(value.replace(' ', ','));
                } else if (key.equals("keywords_type")) {
                    int index = 0;
                    stringArray2 = keywordOperationValues;
                    n4 = keywordOperationValues.length;
                    n3 = 0;
                    while (n3 < n4) {
                        item = stringArray2[n3];
                        if (item.equals(value)) {
                            this.keywordsOperation.select(index);
                            break;
                        }
                        ++index;
                        ++n3;
                    }
                }
            }
            ++n2;
        }
    }

    private String[] nonNullArray(IDialogSettings settings, String id) {
        String[] value = settings.getArray(id);
        if (value == null) {
            return new String[0];
        }
        return value;
    }

    private void restoreWidgetValues() {
        try {
            IDialogSettings settings = this.getDialogSettings();
            String repoId = "." + this.getTaskRepository().getRepositoryUrl();
            if (!this.restoreQueryOptions || settings.getArray(STORE_PRODUCT_ID + repoId) == null || this.product == null) {
                return;
            }
            this.product.setSelection(this.nonNullArray(settings, STORE_PRODUCT_ID + repoId));
            this.component.setSelection(this.nonNullArray(settings, STORE_COMPONENT_ID + repoId));
            this.version.setSelection(this.nonNullArray(settings, STORE_VERSION_ID + repoId));
            this.target.setSelection(this.nonNullArray(settings, STORE_MSTONE_ID + repoId));
            this.status.setSelection(this.nonNullArray(settings, STORE_STATUS_ID + repoId));
            this.resolution.setSelection(this.nonNullArray(settings, STORE_RESOLUTION_ID + repoId));
            this.severity.setSelection(this.nonNullArray(settings, STORE_SEVERITY_ID + repoId));
            this.priority.setSelection(this.nonNullArray(settings, STORE_PRIORITY_ID + repoId));
            this.hardware.setSelection(this.nonNullArray(settings, STORE_HARDWARE_ID + repoId));
            this.os.setSelection(this.nonNullArray(settings, STORE_OS_ID + repoId));
            this.summaryOperation.select(settings.getInt(STORE_SUMMARYMATCH_ID + repoId));
            this.commentOperation.select(settings.getInt(STORE_COMMENTMATCH_ID + repoId));
            this.emailOperation.select(settings.getInt(STORE_EMAILMATCH_ID + repoId));
            int i = 0;
            while (i < this.emailButtons.length) {
                this.emailButtons[i].setSelection(settings.getBoolean(STORE_EMAILBUTTON_ID + i + repoId));
                ++i;
            }
            this.summaryPattern.setText(settings.get(STORE_SUMMARYTEXT_ID + repoId));
            this.commentPattern.setText(settings.get(STORE_COMMENTTEXT_ID + repoId));
            this.emailPattern.setText(settings.get(STORE_EMAILADDRESS_ID + repoId));
            try {
                this.emailOperation2.select(settings.getInt(STORE_EMAIL2MATCH_ID + repoId));
            }
            catch (Exception exception) {}
            i = 0;
            while (i < this.emailButtons2.length) {
                this.emailButtons2[i].setSelection(settings.getBoolean(STORE_EMAIL2BUTTON_ID + i + repoId));
                ++i;
            }
            this.emailPattern2.setText(settings.get(STORE_EMAIL2ADDRESS_ID + repoId));
            if (settings.get(STORE_KEYWORDS_ID + repoId) != null) {
                this.keywords.setText(settings.get(STORE_KEYWORDS_ID + repoId));
                this.keywordsOperation.select(settings.getInt(STORE_KEYWORDSMATCH_ID + repoId));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void saveState() {
        String repoId = "." + this.getTaskRepository().getRepositoryUrl();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_PRODUCT_ID + repoId, this.product.getSelection());
        settings.put(STORE_COMPONENT_ID + repoId, this.component.getSelection());
        settings.put(STORE_VERSION_ID + repoId, this.version.getSelection());
        settings.put(STORE_MSTONE_ID + repoId, this.target.getSelection());
        settings.put(STORE_STATUS_ID + repoId, this.status.getSelection());
        settings.put(STORE_RESOLUTION_ID + repoId, this.resolution.getSelection());
        settings.put(STORE_SEVERITY_ID + repoId, this.severity.getSelection());
        settings.put(STORE_PRIORITY_ID + repoId, this.priority.getSelection());
        settings.put(STORE_HARDWARE_ID + repoId, this.hardware.getSelection());
        settings.put(STORE_OS_ID + repoId, this.os.getSelection());
        settings.put(STORE_SUMMARYMATCH_ID + repoId, this.summaryOperation.getSelectionIndex());
        settings.put(STORE_COMMENTMATCH_ID + repoId, this.commentOperation.getSelectionIndex());
        settings.put(STORE_EMAILMATCH_ID + repoId, this.emailOperation.getSelectionIndex());
        int i = 0;
        while (i < this.emailButtons.length) {
            settings.put(STORE_EMAILBUTTON_ID + i + repoId, this.emailButtons[i].getSelection());
            ++i;
        }
        settings.put(STORE_SUMMARYTEXT_ID + repoId, this.summaryPattern.getText());
        settings.put(STORE_COMMENTTEXT_ID + repoId, this.commentPattern.getText());
        settings.put(STORE_EMAILADDRESS_ID + repoId, this.emailPattern.getText());
        settings.put(STORE_EMAIL2ADDRESS_ID + repoId, this.emailPattern2.getText());
        settings.put(STORE_EMAIL2MATCH_ID + repoId, this.emailOperation2.getSelectionIndex());
        i = 0;
        while (i < this.emailButtons2.length) {
            settings.put(STORE_EMAIL2BUTTON_ID + i + repoId, this.emailButtons2[i].getSelection());
            ++i;
        }
        settings.put(STORE_KEYWORDS_ID + repoId, this.keywords.getText());
        settings.put(STORE_KEYWORDSMATCH_ID + repoId, this.keywordsOperation.getSelectionIndex());
    }

    private void saveBounds(Rectangle bounds) {
        if (this.inSearchContainer()) {
            return;
        }
        IDialogSettings settings = this.getDialogSettings();
        IDialogSettings dialogBounds = settings.getSection(DIALOG_BOUNDS_KEY);
        if (dialogBounds == null) {
            dialogBounds = new DialogSettings(DIALOG_BOUNDS_KEY);
            settings.addSection(dialogBounds);
        }
        dialogBounds.put(X, bounds.x);
        dialogBounds.put(Y, bounds.y);
        dialogBounds.put(WIDTH, bounds.width);
        dialogBounds.put(HEIGHT, bounds.height);
    }

    private void restoreBounds() {
        Rectangle bounds;
        if (this.inSearchContainer()) {
            return;
        }
        IDialogSettings settings = this.getDialogSettings();
        IDialogSettings dialogBounds = settings.getSection(DIALOG_BOUNDS_KEY);
        Shell shell = this.getShell();
        if (shell != null && (bounds = shell.getBounds()) != null && dialogBounds != null) {
            try {
                bounds.x = dialogBounds.getInt(X);
                bounds.y = dialogBounds.getInt(Y);
                bounds.height = dialogBounds.getInt(HEIGHT);
                bounds.width = dialogBounds.getInt(WIDTH);
                shell.setBounds(bounds);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public int getProductCount() throws Exception {
        return this.product.getItemCount();
    }

    public boolean isRestoreQueryOptions() {
        return this.restoreQueryOptions;
    }

    public void setRestoreQueryOptions(boolean restoreQueryOptions) {
        this.restoreQueryOptions = restoreQueryOptions;
    }

    private String[] convertStringListToArray(List<String> stringList) {
        return stringList.toArray(new String[stringList.size()]);
    }

    private void updateConfiguration(final boolean force) {
        String[] selectedProducts = this.product.getSelection();
        if (selectedProducts != null && selectedProducts.length == 0) {
            selectedProducts = null;
        }
        if (this.getTaskRepository() != null) {
            IRunnableWithProgress updateRunnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        try {
                            monitor.beginTask(Messages.BugzillaSearchPage_Updating_search_options_, -1);
                            BugzillaRepositoryConnector connector = (BugzillaRepositoryConnector)TasksUi.getRepositoryConnector((String)BugzillaSearchPage.this.getTaskRepository().getConnectorKind());
                            BugzillaSearchPage.this.repositoryConfiguration = connector.getRepositoryConfiguration(BugzillaSearchPage.this.getTaskRepository(), force, monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                if (this.getContainer() != null) {
                    this.getContainer().run(true, true, updateRunnable);
                } else if (this.getSearchContainer() != null) {
                    this.getSearchContainer().getRunnableContext().run(true, true, updateRunnable);
                } else {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    service.busyCursorWhile(updateRunnable);
                }
            }
            catch (InvocationTargetException ex) {
                Shell shell = null;
                shell = this.getShell();
                if (ex.getCause() instanceof CoreException) {
                    CoreException cause = (CoreException)ex.getCause();
                    if (cause.getStatus() instanceof RepositoryStatus && ((RepositoryStatus)cause.getStatus()).isHtmlMessage()) {
                        if (shell != null) {
                            shell.setEnabled(false);
                        }
                        WebBrowserDialog dialog = new WebBrowserDialog(shell, Messages.BugzillaSearchPage_Error_updating_search_options, null, cause.getStatus().getMessage(), 0, new String[]{IDialogConstants.OK_LABEL}, 0, ((RepositoryStatus)cause.getStatus()).getHtmlMessage());
                        dialog.setBlockOnOpen(true);
                        dialog.open();
                        if (shell != null) {
                            shell.setEnabled(true);
                        }
                        return;
                    }
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla.ui", cause.getMessage(), (Throwable)cause));
                }
                if (ex.getCause() instanceof OperationCanceledException) {
                    return;
                }
                if (!CoreUtil.TEST_MODE) {
                    MessageDialog.openError((Shell)shell, (String)Messages.BugzillaSearchPage_Error_updating_search_options, (String)MessageFormat.format(Messages.BugzillaSearchPage_Error_was_X, ex.getCause().getMessage()));
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.updateAttributesFromConfiguration(selectedProducts);
        }
    }

    public Shell getShell() {
        Shell shell = null;
        if (this.getWizard() != null && this.getWizard().getContainer() != null) {
            shell = this.getWizard().getContainer().getShell();
        }
        if (shell == null && this.getControl() != null) {
            shell = this.getControl().getShell();
        }
        return shell;
    }

    public String getQueryTitle() {
        return this.queryTitle != null ? this.queryTitle.getText() : "";
    }

    private void setSelection(org.eclipse.swt.widgets.List listControl, String[] selection) {
        String[] stringArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            int index = listControl.indexOf(item);
            if (index > -1) {
                listControl.select(index);
            }
            ++n2;
        }
        if (listControl.getSelectionCount() > 0) {
            listControl.showSelection();
        } else {
            listControl.select(0);
            listControl.showSelection();
            listControl.deselectAll();
        }
    }

    public void applyTo(IRepositoryQuery query) {
        query.setUrl(this.getQueryURL(this.getTaskRepository(), this.getQueryParameters()));
        query.setSummary(this.getQueryTitle());
        Shell shell = this.getShell();
        if (shell != null) {
            this.saveBounds(shell.getBounds());
        }
    }

    private static class BugzillaSearchData {
        String pattern;
        int operation;

        BugzillaSearchData(String pattern, int operation) {
            this.pattern = pattern;
            this.operation = operation;
        }
    }

    private final class ModifyListenerImplementation
    implements ModifyListener {
        private ModifyListenerImplementation() {
        }

        public void modifyText(ModifyEvent e) {
            if (BugzillaSearchPage.this.isControlCreated()) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        }
    }
}

